/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DimensionAttributeOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DimensionAttributePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private DimensionAttributeOraclev9i attr;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTextField tfLevel;

    public DimensionAttributePropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.attr = (DimensionAttributeOraclev9i)storageObject;
        this.setHeight(300);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DimensionAttributePropertyDialogOraclev9i.LevelProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initLevel();
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initLevel() {
        JLabel jLabel = new JLabel(Messages.getString("DimensionAttributePropertyDialogOraclev9i.Level"));
        this.general.add(jLabel);
        this.tfLevel = new JTextField("", 26);
        this.tfLevel.setPreferredSize(this.tfName.getPreferredSize());
        this.tfLevel.setEnabled(false);
        this.general.add(this.tfLevel);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfLevel, 50);
        this.tfLevel.setEnabled(false);
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("DimensionAttributePropertyDialogOraclev9i.AllColumns"));
        this.general.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 94);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 112);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("DimensionAttributePropertyDialogOraclev9i.DeterminedColumns"));
        this.general.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 94);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 112);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("DimensionAttributePropertyDialogOraclev9i.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 135);
        this.bnRemove = new JButton(Messages.getString("DimensionAttributePropertyDialogOraclev9i.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 175);
        DimensionAttributePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.attr.getName());
        this.tfLevel.setText(this.attr.getLevel().getName());
        RelationalObjectProxy[] relationalObjectProxyArray = (RelationalObjectProxy[])this.getStorageDesign().getColumnProxySet().toArray();
        for (int i = 0; i < relationalObjectProxyArray.length; ++i) {
            ColumnProxyOraclev9i columnProxyOraclev9i = (ColumnProxyOraclev9i)relationalObjectProxyArray[i];
            if (this.attr.getColumnSet().contains(columnProxyOraclev9i.getObjectID())) {
                this.selectedColumnsModel.addElement(columnProxyOraclev9i);
                continue;
            }
            this.allColumnsModel.addElement(columnProxyOraclev9i);
        }
        this.tfName.setText(this.attr.getName());
    }

    @Override
    protected void setProperties() {
        if (this.attr != null) {
            this.attr.setName(this.tfName.getText());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.attr.clearColumns();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof ColumnProxyOracle)) continue;
                this.attr.setColumns(((ColumnProxyOracle)object).getObjectID());
            }
            this.attr.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (DimensionAttributePropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    DimensionAttributePropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                } else {
                    DimensionAttributePropertyDialogOraclev9i.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (DimensionAttributePropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    DimensionAttributePropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                } else {
                    DimensionAttributePropertyDialogOraclev9i.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DimensionAttributePropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = DimensionAttributePropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DimensionAttributePropertyDialogOraclev9i.this.allColumnsModel.contains(object)) continue;
                    DimensionAttributePropertyDialogOraclev9i.this.allColumnsModel.addElement(object);
                    DimensionAttributePropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DimensionAttributePropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = DimensionAttributePropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DimensionAttributePropertyDialogOraclev9i.this.selectedColumnsModel.contains(object)) continue;
                    DimensionAttributePropertyDialogOraclev9i.this.selectedColumnsModel.addElement(object);
                    DimensionAttributePropertyDialogOraclev9i.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }
}

