/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SnapshotPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TablePropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ClusterPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private ClusterOraclev9i cluster;
    private JComboBox cbUser;
    private JIntegerField ifSize;
    private JComboBox cbMeasureUnit;
    private JComboBox cbTableSpace;
    private JComboBox cbSegment;
    private JComboBox cbIndexed;
    private JComboBox cbSingleTable;
    private JIntegerField ifHashKeys;
    private JTextField tfHashExpression;
    private JComboBox cbParallel;
    private JComboBox cbCache;
    private JComboBox cbRowDependency;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel snapshots;
    private DefaultListModel snapshotListModel;
    private JList snapshotList;

    public ClusterPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.cluster = (ClusterOraclev9i)storageObject;
        this.setHeight(410);
        this.initCommentsView(170);
        this.initCommentsInRDBMS(170);
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ClusterPropertyDialogOraclev9i.ClusterProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initTableSpace();
        this.initSize();
        this.initSegment();
        this.initIndexed();
        this.initSingleTable();
        this.initHashKeys();
        this.initHashExpression();
        this.initParallel();
        this.initCache();
        this.initRowDependency();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.Size"));
        this.general.add(jLabel);
        this.ifSize = new JIntegerField(0, 16);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.ifSize, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.cbMeasureUnit = new JComboBox<Object>(ClusterOracle.getMeasureUnitValues().toArray());
        this.general.add(this.cbMeasureUnit);
        this.cbMeasureUnit.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbMeasureUnit, 110);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbSegment, 140);
    }

    private void initIndexed() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.Indexed"));
        this.general.add(jLabel);
        this.cbIndexed = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIndexed);
        this.cbIndexed.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexed);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbIndexed, 170);
    }

    private void initSingleTable() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.SingleTable"));
        this.general.add(jLabel);
        this.cbSingleTable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSingleTable);
        this.cbSingleTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSingleTable);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbSingleTable, 200);
    }

    private void initHashKeys() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.HashKeys"));
        this.general.add(jLabel);
        this.ifHashKeys = new JIntegerField(0, 26);
        this.general.add(this.ifHashKeys);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifHashKeys, 230);
    }

    private void initHashExpression() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.HashExpression"));
        this.general.add(jLabel);
        this.tfHashExpression = new JTextField("", 26);
        this.general.add(this.tfHashExpression);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfHashExpression, 260);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbParallel, 290);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.Cache"));
        this.general.add(jLabel);
        this.cbCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbCache, 320);
    }

    private void initRowDependency() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterPropertyDialogOraclev9i.ROWDEPENDENCY"));
        this.general.add(jLabel);
        this.cbRowDependency = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowDependency);
        this.cbRowDependency.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbRowDependency, 350);
    }

    @Override
    protected void addTabs() {
        this.initTablesView();
        this.initSnapshotsView();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ClusterPropertyDialogOraclev9i.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(395, 360));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTableLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initSnapshotsView() {
        this.snapshots = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ClusterPropertyDialogOraclev9i.Snapshots"), this.snapshots);
        this.initSnapshots();
    }

    private void initSnapshots() {
        this.snapshotListModel = new DefaultListModel();
        this.snapshotList = new JList(this.snapshotListModel);
        this.snapshotList.addMouseListener(new SnapshotListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.snapshotList);
        jScrollPane.setPreferredSize(new Dimension(395, 360));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.snapshots.add(jScrollPane);
        this.setObjectConstraints(this.getSnapshotLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSnapshotLayout() {
        return (SpringLayout)this.snapshots.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.cluster.getName());
        this.tfName.setText(this.cluster.getName());
        this.selectObject(this.cbUser, this.cluster.getUser());
        this.ifSize.setValue((long)this.cluster.getSize());
        this.cbMeasureUnit.setSelectedItem(this.cluster.getMeasureUnit());
        this.selectObject(this.cbTableSpace, this.cluster.getTableSpace());
        this.selectObject(this.cbSegment, this.cluster.getSegment());
        this.cbIndexed.setSelectedItem(ClusterPropertyDialogOraclev9i.translateYesNoForDisplay(this.cluster.getIndexed()));
        this.cbSingleTable.setSelectedItem(ClusterPropertyDialogOraclev9i.translateYesNoForDisplay(this.cluster.getSingleTable()));
        this.ifHashKeys.setValue((long)this.cluster.getHashKeys());
        this.tfHashExpression.setText(this.cluster.getHashExpression());
        this.cbParallel.setSelectedItem(ClusterPropertyDialogOraclev9i.translateYesNoForDisplay(this.cluster.getParallel()));
        this.cbCache.setSelectedItem(ClusterPropertyDialogOraclev9i.translateYesNoForDisplay(this.cluster.getCache()));
        this.cbRowDependency.setSelectedItem(ClusterPropertyDialogOraclev9i.translateYesNoForDisplay(this.cluster.getRowDependency()));
        Object[] objectArray = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((TableProxyOracle)objectArray[i]).getCluster() != this.cluster) continue;
            this.tableListModel.addElement(objectArray[i]);
        }
        Object[] objectArray2 = this.getStorageDesign().getSnapshotSet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((SnapshotOracle)objectArray2[i]).getCluster() != this.cluster) continue;
            this.snapshotListModel.addElement(objectArray2[i]);
        }
        this.getCommentsList().insert(this.cluster.getComment(), 0);
        this.taCommentsInRDBMS.setText(this.cluster.getCommentInRDBMS());
        this.taNotes.setText(this.cluster.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.cluster != null) {
            Object object = this.cbUser.getSelectedItem();
            if (object instanceof UserOracle) {
                this.cluster.setUser((UserOracle)object);
            } else {
                this.cluster.setUser(null);
            }
            this.cluster.setName(this.tfName.getText());
            this.cluster.setSize(this.ifSize.getIntValue());
            this.cluster.setMeasureUnit((String)this.cbMeasureUnit.getSelectedItem());
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.cluster.setTableSpace((TableSpaceOracle)object);
            } else {
                this.cluster.setTableSpace(null);
            }
            object = this.cbSegment.getSelectedItem();
            if (object instanceof SegmentOracle) {
                this.cluster.setSegment((SegmentOracle)object);
            } else {
                this.cluster.setSegment(null);
            }
            this.cluster.setIndexed(ClusterPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbIndexed.getSelectedItem()));
            this.cluster.setSingleTable(ClusterPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbSingleTable.getSelectedItem()));
            this.cluster.setHashKeys(this.ifHashKeys.getIntValue());
            this.cluster.setHashExpression(this.tfHashExpression.getText());
            this.cluster.setParallel(ClusterPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.cluster.setCache(ClusterPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.cluster.setRowDependency(ClusterPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
            this.cluster.setComment(this.getCommentsList().getText());
            this.cluster.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            this.cluster.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbUser.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class SnapshotListMouseListener
    extends MouseAdapter {
        private SnapshotListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SnapshotOraclev9i snapshotOraclev9i;
            if (mouseEvent.getClickCount() == 2 && (snapshotOraclev9i = (SnapshotOraclev9i)ClusterPropertyDialogOraclev9i.this.snapshotList.getSelectedValue()) != null && !snapshotOraclev9i.isDialogVisible()) {
                SnapshotPropertyDialogOraclev9i snapshotPropertyDialogOraclev9i = new SnapshotPropertyDialogOraclev9i(ClusterPropertyDialogOraclev9i.this.cluster.getDesign().getAppView(), ClusterPropertyDialogOraclev9i.this.getStorageDesign(), snapshotOraclev9i);
                snapshotPropertyDialogOraclev9i.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyOraclev9i tableProxyOraclev9i;
            if (mouseEvent.getClickCount() == 2 && (tableProxyOraclev9i = (TableProxyOraclev9i)ClusterPropertyDialogOraclev9i.this.tableList.getSelectedValue()) != null && !tableProxyOraclev9i.isDialogVisible()) {
                TablePropertyDialogOraclev9i tablePropertyDialogOraclev9i = new TablePropertyDialogOraclev9i(ClusterPropertyDialogOraclev9i.this.cluster.getDesign().getAppView(), ClusterPropertyDialogOraclev9i.this.getStorageDesign(), tableProxyOraclev9i);
                tablePropertyDialogOraclev9i.show();
            }
        }
    }
}

