/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ClusterIndexPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private ClusterIndexOracle index;
    private JComboBox cbUser;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JIntegerField ifCompress;
    private JComboBox cbParallel;
    private JTextField tfDegree;
    private JComboBox cbReverse;
    private JComboBox cbComputeStats;
    private JComboBox cbOnline;

    public ClusterIndexPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (ClusterIndexOracle)storageObject;
        this.setHeight(380);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ClusterIndexPropertyDialogOracle.ClusterIndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initParallel();
        this.initDegree();
        this.initReverse();
        this.initComputeStats();
        this.initOnline();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbLogging, 110);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbSegment, 140);
    }

    private void initCompress() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Compress"));
        this.general.add(jLabel);
        this.ifCompress = new JIntegerField(0, 26);
        this.general.add(this.ifCompress);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.ifCompress, 170);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbParallel, 200);
    }

    private void initDegree() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Degree"));
        this.general.add(jLabel);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDegree);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfDegree, 230);
    }

    private void initReverse() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Reverse"));
        this.general.add(jLabel);
        this.cbReverse = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReverse);
        this.cbReverse.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReverse);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbReverse, 260);
    }

    private void initComputeStats() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.ComputeStats"));
        this.general.add(jLabel);
        this.cbComputeStats = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStats);
        this.cbComputeStats.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbComputeStats);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbComputeStats, 290);
    }

    private void initOnline() {
        JLabel jLabel = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Online"));
        this.general.add(jLabel);
        this.cbOnline = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbOnline, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.selectObject(this.cbUser, this.index.getUser());
        this.selectObject(this.cbTableSpace, this.index.getTableSpace());
        this.cbLogging.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getLogging()));
        this.selectObject(this.cbSegment, this.index.getSegment());
        this.ifCompress.setValue((long)this.index.getCompress());
        this.cbParallel.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getParallel()));
        this.tfDegree.setText(this.index.getDegree());
        this.cbReverse.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getReverse()));
        this.cbComputeStats.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getComputeStatistics()));
        this.cbOnline.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getOnline()));
        this.getCommentsList().insert(this.index.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            Object object = this.cbUser.getSelectedItem();
            if (object instanceof UserOracle) {
                this.index.setUser((UserOracle)object);
            } else {
                this.index.setUser(null);
            }
            this.index.setName(this.tfName.getText());
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.index.setTableSpace((TableSpaceOracle)object);
            } else {
                this.index.setTableSpace(null);
            }
            this.index.setLogging(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object = this.cbSegment.getSelectedItem();
            if (object instanceof SegmentOracle) {
                this.index.setSegment((SegmentOracle)object);
            } else {
                this.index.setSegment(null);
            }
            this.index.setCompress(this.ifCompress.getIntValue());
            this.index.setParallel(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.index.setDegree(this.tfDegree.getText());
            this.index.setReverse(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReverse.getSelectedItem()));
            this.index.setComputeStatistics(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbComputeStats.getSelectedItem()));
            this.index.setOnline(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbOnline.getSelectedItem()));
            this.index.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbUser.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }
}

