/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ListPartitionPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ListPartitionPropertyDialogOraclev11g
extends ListPartitionPropertyDialogOraclev10g
implements ListSelectionListener {
    private ListPartitionOraclev11g listPartition;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel subPartOrderPanel;
    private JTable subPartitionsOrderTable;
    private List subPartitions;
    private DefaultListSelectionModel subPartSelectionModel;
    private SubPartitionsOrderModel subPartitionsOrderModel;
    private boolean subPartOrdered = false;

    public ListPartitionPropertyDialogOraclev11g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSubPartQuantity();
    }

    private void initSubPartQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.SubPartQuantity"));
        this.general.add(jLabel);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.general.add(this.ifSubPartQuantity);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifSubPartQuantity, 200);
    }

    @Override
    protected void addTabs() {
        this.initSubPartTSView();
        this.initSubPartOrderTab();
        super.addTabs();
    }

    private void initSubPartTSView() {
        this.subPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ListPartitionPropertyDialogOracle.SubPartitionTableSpaces"), this.subPartTS);
        this.initSubPartTS();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initAllSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(jLabel);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(jLabel);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(Messages.getString("ListPartitionPropertyDialogOracle.Add"));
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 160, 90);
        this.bnRemoveSubPartTS = new JButton(Messages.getString("ListPartitionPropertyDialogOracle.Remove"));
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 160, 120);
        ListPartitionPropertyDialogOraclev11g.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    private void initSubPartOrderTab() {
        JComponent jComponent;
        this.subPartOrderPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionsOrder"), this.subPartOrderPanel);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        jButton.addActionListener(new SubPartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new SubMoveUpAction());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            jButton2.addActionListener(new SubMoveDownAction());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.subPartOrderPanel.add(jPanel);
        this.setObjectConstraints(this.getSubPartOrderLayout(), jPanel, 10, 0);
        this.subPartitionsOrderModel = new SubPartitionsOrderModel();
        this.subPartSelectionModel = new DefaultListSelectionModel();
        this.subPartSelectionModel.setSelectionMode(2);
        this.subPartitionsOrderTable = new JTable(this.subPartitionsOrderModel);
        this.subPartitionsOrderTable.setSelectionModel(this.subPartSelectionModel);
        jComponent = new JScrollPane(this.subPartitionsOrderTable);
        jComponent.setPreferredSize(new Dimension(400, 180));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartOrderPanel.add(jComponent);
        this.setObjectConstraints(this.getSubPartOrderLayout(), jComponent, 6, 40);
    }

    private SpringLayout getSubPartOrderLayout() {
        return (SpringLayout)this.subPartOrderPanel.getLayout();
    }

    private StorageObjectCollection getSubPartitions() {
        PartitionListOracle partitionListOracle = this.listPartition.getPartitionList();
        if (partitionListOracle != null) {
            String string = partitionListOracle.getSubpartitionType();
            if (string.equals("HASH")) {
                return this.listPartition.getHashSubpartitions();
            }
            if (string.equals("LIST")) {
                return this.listPartition.getListSubpartitions();
            }
            if (string.equals("RANGE")) {
                return this.listPartition.getRangeSubpartitions();
            }
        }
        return null;
    }

    private boolean subMoveToIndex(Object object, int n) {
        if (this.subPartitions.contains(object) && this.subPartitions.size() > n && n >= 0) {
            this.subPartitions.remove(object);
            this.subPartitions.add(n, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel defaultListSelectionModel, int[] nArray) {
        defaultListSelectionModel.clearSelection();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                defaultListSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
            }
        }
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.listPartition = (ListPartitionOraclev11g)((ListPartitionPropertyDialogOraclev10g)this).listPartition;
        PartitionListOracle partitionListOracle = this.listPartition.getPartitionList();
        if (this.listPartition.hasSubPartitions() || !partitionListOracle.getSubpartitionType().equalsIgnoreCase("HASH")) {
            this.ifSubPartQuantity.setEnabled(false);
            int n = this.getPane().indexOfComponent(this.subPartTS);
            if (n > -1) {
                this.getPane().setEnabledAt(n, false);
            }
        } else {
            this.ifSubPartQuantity.setValue((long)this.listPartition.getSubPartitionsQuantity());
        }
        this.subPartitions = new ArrayList();
        StorageObjectCollection storageObjectCollection = this.getSubPartitions();
        if (storageObjectCollection != null) {
            storageObjectCollection.setForbiddenCreateElement(true);
            storageObjectCollection.addAllElementsTo(this.subPartitions);
        }
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (this.listPartition.getSubPartTSSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedSubPartTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allSubPartTSModel.addElement(tableSpaceOracle);
        }
    }

    @Override
    protected void setProperties() {
        StorageObjectCollection storageObjectCollection;
        int n;
        super.setProperties();
        this.listPartition.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
        this.listPartition.getSubPartTSSet().clear();
        Object[] objectArray = this.selectedSubPartTSModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof TableSpaceOraclev10g)) continue;
            this.listPartition.setSubPartitionsTableSpaces(((TableSpaceOraclev10g)object).getObjectID());
        }
        if (this.subPartOrdered && (n = (storageObjectCollection = this.getSubPartitions()).size()) == this.subPartitions.size()) {
            this.subPartOrdered = false;
            for (int i = 0; i < n; ++i) {
                storageObjectCollection.justRemove(storageObjectCollection.getElement(0));
            }
            for (int i = 0; i < n; ++i) {
                if (this.subPartitions.get(i) instanceof PartitionOracle) {
                    PartitionOracle partitionOracle = (PartitionOracle)this.subPartitions.get(i);
                    partitionOracle.setParent(storageObjectCollection);
                    storageObjectCollection.add(partitionOracle);
                    partitionOracle.setPosition(i + 1);
                    continue;
                }
                storageObjectCollection.add((ModelObject)this.subPartitions.get(i));
            }
        }
    }

    @Override
    protected void clearOnDispose() {
        StorageObjectCollection storageObjectCollection;
        PartitionListOracle partitionListOracle = this.listPartition.getPartitionList();
        if (partitionListOracle != null && (storageObjectCollection = this.getSubPartitions()) != null) {
            storageObjectCollection.setForbiddenCreateElement(partitionListOracle.getSubpartitionType().equals(""));
        }
    }

    private class SubMoveDownAction
    implements ActionListener {
        private SubMoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < ListPartitionPropertyDialogOraclev11g.this.subPartitions.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(n);
                    ListPartitionPropertyDialogOraclev11g.this.subMoveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                ListPartitionPropertyDialogOraclev11g.this.setSelection(ListPartitionPropertyDialogOraclev11g.this.subPartSelectionModel, nArray);
                ListPartitionPropertyDialogOraclev11g.this.subPartOrdered = true;
                ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubMoveUpAction
    implements ActionListener {
        private SubMoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(n);
                    ListPartitionPropertyDialogOraclev11g.this.subMoveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                ListPartitionPropertyDialogOraclev11g.this.setSelection(ListPartitionPropertyDialogOraclev11g.this.subPartSelectionModel, nArray);
                ListPartitionPropertyDialogOraclev11g.this.subPartOrdered = true;
                ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubPartitionsOrderModel
    extends AbstractTableModel {
        private SubPartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (ListPartitionPropertyDialogOraclev11g.this.subPartitions == null) {
                return 0;
            }
            return ListPartitionPropertyDialogOraclev11g.this.subPartitions.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionName");
            }
            if (n == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StorageObject storageObject = (StorageObject)ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(n);
            if (n2 == 0) {
                return storageObject.getName();
            }
            if (n2 == 1) {
                if (storageObject instanceof PartitionOracle) {
                    return ((PartitionOracle)storageObject).getValueList();
                }
                if (storageObject instanceof ListStorageTemplatePartitionOracle) {
                    return ((ListStorageTemplatePartitionOracle)storageObject).getValueList();
                }
                return "";
            }
            return new Integer(n * n2);
        }
    }

    private class SubPartitionPropertiesAction
    implements ActionListener {
        private SubPartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListPartitionPropertyDialogOraclev11g.this.subPartitionsOrderTable.getSelectedRow();
            if (n > -1 && n < ListPartitionPropertyDialogOraclev11g.this.subPartitions.size()) {
                StorageObject storageObject = (StorageObject)ListPartitionPropertyDialogOraclev11g.this.subPartitions.get(n);
                storageObject.showPropertyDialog();
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.isEmpty()) {
                Object[] objectArray = ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.contains(object)) continue;
                    ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.addElement(object);
                    ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.isEmpty()) {
                Object[] objectArray = ListPartitionPropertyDialogOraclev11g.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.contains(object)) continue;
                    ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSModel.addElement(object);
                    ListPartitionPropertyDialogOraclev11g.this.allSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (ListPartitionPropertyDialogOraclev11g.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    ListPartitionPropertyDialogOraclev11g.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    ListPartitionPropertyDialogOraclev11g.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (ListPartitionPropertyDialogOraclev11g.this.allSubPartTSList.getSelectedIndex() == -1) {
                    ListPartitionPropertyDialogOraclev11g.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    ListPartitionPropertyDialogOraclev11g.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }
}

