/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ColumnPropertyDialogOraclev10g;

public class ColumnPropertyDialogOraclev11g
extends ColumnPropertyDialogOraclev10g {
    private ColumnProxyOraclev11g column;
    private JTextField tfComputed;
    private JTextField tfColumnExpression;
    private boolean computed;
    private String expressionText;

    public ColumnPropertyDialogOraclev11g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.column = (ColumnProxyOraclev11g)storageObject;
    }

    @Override
    protected Integer getRDBMSType() {
        return new Integer(9);
    }

    @Override
    protected int initComputed(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.Computed"));
        this.general.add(jLabel);
        this.tfComputed = new JTextField("", 26);
        this.tfComputed.setEnabled(false);
        this.general.add(this.tfComputed);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfComputed, n);
        return 30;
    }

    @Override
    protected int initColumnExpression(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.ColumnExpression"));
        this.general.add(jLabel);
        this.tfColumnExpression = new JTextField("", 26);
        this.tfColumnExpression.setEnabled(false);
        this.general.add(this.tfColumnExpression);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfColumnExpression, n);
        return 30;
    }

    @Override
    protected int initLobStorageType(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.LobStorageType"));
        this.general.add(jLabel);
        this.cbLobStorageType = new JComboBox<String>(ColumnProxyOraclev11g.getLobStorageValues11g());
        this.setBG(this.cbLobStorageType);
        this.cbLobStorageType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobStorageType);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbLobStorageType, n);
        return 30;
    }

    @Override
    protected int initAllowAnySchema(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.AllowAnySchema"));
        this.xmlTypeOptions.add(jLabel);
        this.cbAllowAnySchema = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAllowAnySchema);
        this.cbAllowAnySchema.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbAllowAnySchema);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbAllowAnySchema, n);
        return n + 30;
    }

    @Override
    protected int initAllowNonSchema(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.AllowNonSchema"));
        this.xmlTypeOptions.add(jLabel);
        this.cbAllowNonSchema = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAllowNonSchema);
        this.cbAllowNonSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbAllowNonSchema);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbAllowNonSchema, n);
        return n + 30;
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.computed = this.column.isComputed();
        this.tfComputed.setText(this.computed ? YES : NO);
        this.expressionText = this.computed ? this.column.getColumnExpression() : "";
        this.tfColumnExpression.setText(this.expressionText);
        this.tfColumnExpression.setEnabled(this.computed);
        this.cbAllowAnySchema.setSelectedItem(ColumnPropertyDialogOraclev11g.translateYesNoForDisplay(this.column.getAllowAnySchema()));
        this.cbAllowNonSchema.setSelectedItem(ColumnPropertyDialogOraclev11g.translateYesNoForDisplay(this.column.getAllowNonSchema()));
        this.cbLobStorageType.setSelectedItem(this.column.getLobStorageType());
        if (this.column.getDataType().toString().equals("XMLTYPE") && (this.column.getStoreAs().equalsIgnoreCase("BINARY XML") || this.column.getStoreAs().equalsIgnoreCase("CLOB"))) {
            this.cbLobStorageType.setEnabled(true);
        } else {
            this.cbLobStorageType.setEnabled(false);
        }
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            super.setProperties();
            if (!this.expressionText.equals(this.tfColumnExpression.getText())) {
                this.expressionText = this.tfColumnExpression.getText();
                this.column.setColumnExpression(this.expressionText);
                this.column.setExpressionChanged(true);
            }
            if (this.cbLobStorageType.isEnabled()) {
                this.column.setLobStorageType((String)this.cbLobStorageType.getSelectedItem());
            }
            if (this.cbAllowAnySchema.isEnabled()) {
                this.column.setAllowAnySchema(ColumnPropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowAnySchema.getSelectedItem()));
                this.column.setAllowNonSchema(ColumnPropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowNonSchema.getSelectedItem()));
            }
        }
    }
}

