/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.DefaultPropertyDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.FunctionPropertyDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.UserAndRolePermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.IndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.SnapshotPropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ClusterPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DimensionOraclev9iPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SequencePropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.StoredProcedurePropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SynonymPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TableViewPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TriggerPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private static final long serialVersionUID = 7556452542536120399L;
    private UserOraclev10g user;
    private JComboBox cbAuthentication;
    private JPasswordField tfIdentifier;
    private JComboBox cbTableSpace;
    private JComboBox cbTempTableSpace;
    private JTextField tfTempTSGroup;
    private JTextField tfProfile;
    private JComboBox cbPasswordExpire;
    private JComboBox cbAccountLock;
    private JPanel clusters;
    private DefaultListModel clusterListModel;
    private JList clusterList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel snapshots;
    private DefaultListModel snapshotListModel;
    private JList snapshotList;
    private JPanel triggers;
    private DefaultListModel triggerListModel;
    private JList triggerList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel dimensions;
    private DefaultListModel dimensionListModel;
    private JList dimensionList;
    private JPanel sequences;
    private DefaultListModel seqListModel;
    private JList seqList;
    private JPanel synonyms;
    private DefaultListModel synListModel;
    private JList synList;
    private JPanel procedures;
    private DefaultListModel procListModel;
    private JList procList;
    private JPanel packages;
    private DefaultListModel packagesListModel;
    private JList packagesList;
    private JPanel functions;
    private DefaultListModel functionsListModel;
    private JList functionsList;
    private JPanel panelRoles;
    private JPanel panelSystemPrivileges;
    private JList allPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JList allRolesList;
    private JTable selectedRolesTable;
    private JTable selectedSystemPrivilegesTable;
    private List<Role> selectedRolesList;
    private List<SystemPrivilege> selectedSystemPrivilegesList;
    private DefaultListModel allRolesModel;
    private JButton bnAddRoles;
    private JButton bnRemoveRoles;
    private JTextField tfexternalName;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogOracle dialog;
    private JComboBox cbSchemaObject;

    public UserPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.user = (UserOraclev10g)storageObject;
        this.setHeight(460);
        this.initCommentsView(370);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UserPropertyDialogOracle.UserProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAuthentication();
        this.initIdentifier();
        this.initTableSpace();
        this.initTempTableSpace();
        this.initTempTSGroup();
        this.initProfile();
        this.initPasswordExpire();
        this.initAccountLock();
        this.initExternalName();
        this.initSchemaObject();
        this.initPermissionsButton();
    }

    private void initAuthentication() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.Authentication"));
        this.general.add(jLabel);
        this.cbAuthentication = new JComboBox<String>(UserOracle.getAuthTypes());
        this.setBG(this.cbAuthentication);
        this.cbAuthentication.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAuthentication);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbAuthentication, 50);
    }

    private void initIdentifier() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.Identifier"));
        this.general.add(jLabel);
        this.tfIdentifier = new JPasswordField("", 26);
        this.general.add(this.tfIdentifier);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfIdentifier, 80);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initTempTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.TempTableSpace"));
        this.general.add(jLabel);
        this.cbTempTableSpace = new JComboBox();
        this.setBG(this.cbTempTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTemporaryTablespaceSet().toArray(), this.cbTempTableSpace);
        }
        this.cbTempTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTempTableSpace);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbTempTableSpace, 140);
    }

    private void initTempTSGroup() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.TempTSGroup"));
        this.general.add(jLabel);
        this.tfTempTSGroup = new JTextField("", 26);
        this.general.add(this.tfTempTSGroup);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfTempTSGroup, 170);
    }

    private void initProfile() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.Profile"));
        this.general.add(jLabel);
        this.tfProfile = new JTextField("", 26);
        this.general.add(this.tfProfile);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfProfile, 200);
    }

    private void initPasswordExpire() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.PasswordExpire"));
        this.general.add(jLabel);
        this.cbPasswordExpire = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPasswordExpire);
        this.cbPasswordExpire.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPasswordExpire);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbPasswordExpire, 230);
    }

    private void initAccountLock() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.AccountLock"));
        this.general.add(jLabel);
        this.cbAccountLock = new JComboBox<String>(YES_NO);
        this.setBG(this.cbAccountLock);
        this.cbAccountLock.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAccountLock);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbAccountLock, 260);
    }

    private void initExternalName() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.ExternalName"));
        this.general.add(jLabel);
        this.tfexternalName = new JTextField("", 26);
        this.general.add(this.tfexternalName);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfexternalName, 290);
    }

    private void initSchemaObject() {
        JLabel jLabel = new JLabel(Messages.getString("UserPropertyDialogOracle.ImplementsSchema"));
        this.general.add(jLabel);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbSchemaObject, 320);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("UserPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 350);
    }

    @Override
    protected void addTabs() {
        this.initRolesView();
        this.initSystemPrivilegesView();
        this.initClustersView();
        this.initTablesView();
        this.initIndexesView();
        this.initSnapshotsView();
        this.initTriggersView();
        this.initViewsView();
        this.initDimensionsView();
        this.initSequencesView();
        this.initSynonymsView();
        this.initProceduresView();
        this.initFunctionsView();
        this.initPackagesView();
    }

    private void initRolesView() {
        this.panelRoles = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Roles"), this.panelRoles);
        this.initRoles();
    }

    private void initRoles() {
        this.initAllRolesList();
        this.initSelectedRolesList();
        this.initRolesButtons();
    }

    private void initSystemPrivilegesView() {
        this.panelSystemPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.SystemPrivileges"), this.panelSystemPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    protected SpringLayout getSystemPrivilegesLayout() {
        return (SpringLayout)this.panelSystemPrivileges.getLayout();
    }

    private void initAllPrivilegesList() {
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allPrivilegesList);
        jScrollPane.setPreferredSize(new Dimension(425, 170));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelSystemPrivileges.add(jScrollPane);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jScrollPane, 10, 10);
    }

    private void initSelectedPrivilegesList() {
        this.selectedSystemPrivilegesList = new ArrayList<SystemPrivilege>();
        this.selectedSystemPrivilegesTable = new JTable(new SelectedSystemPrivilegesModel());
        this.selectedSystemPrivilegesTable.setSelectionMode(0);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn tableColumn = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(355);
        tableColumn.setMaxWidth(355);
        TableColumn tableColumn2 = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(40);
        tableColumn2.setMaxWidth(40);
        tableColumn2.setCellRenderer(columnAdminRenderer);
        this.selectedSystemPrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getSelectedRow() == -1) {
                    UserPropertyDialogOraclev10g.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.selectedSystemPrivilegesTable);
        jScrollPane.setPreferredSize(new Dimension(425, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelSystemPrivileges.add(jScrollPane);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jScrollPane, 10, 220);
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON", 16));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelSystemPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), this.bnAddPrivileges, 170, 190);
        this.bnRemovePrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON", 16));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelSystemPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), this.bnRemovePrivileges, 230, 190);
        UserPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initAllRolesList() {
        this.allRolesModel = new DefaultListModel();
        this.allRolesList = new JList(this.allRolesModel);
        ListSelectionModel listSelectionModel = this.allRolesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllRolesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allRolesList);
        jScrollPane.setPreferredSize(new Dimension(425, 170));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelRoles.add(jScrollPane);
        this.setObjectConstraints(this.getRolesLayout(), jScrollPane, 10, 10);
    }

    private void initSelectedRolesList() {
        this.selectedRolesList = new ArrayList<Role>();
        this.selectedRolesTable = new JTable(new SelectedRolessModel());
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn tableColumn = this.selectedRolesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(355);
        tableColumn.setMaxWidth(355);
        TableColumn tableColumn2 = this.selectedRolesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(40);
        tableColumn2.setMaxWidth(40);
        tableColumn2.setCellRenderer(columnAdminRenderer);
        this.selectedRolesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserPropertyDialogOraclev10g.this.selectedRolesTable.getSelectedRow() == -1) {
                    UserPropertyDialogOraclev10g.this.bnRemoveRoles.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnRemoveRoles.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.selectedRolesTable);
        jScrollPane.setPreferredSize(new Dimension(425, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelRoles.add(jScrollPane);
        this.setObjectConstraints(this.getRolesLayout(), jScrollPane, 10, 220);
    }

    private void initRolesButtons() {
        this.bnAddRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON", 16));
        this.bnAddRoles.addActionListener(new AddRolesActionListener());
        this.bnAddRoles.setEnabled(false);
        this.panelRoles.add(this.bnAddRoles);
        this.setObjectConstraints(this.getRolesLayout(), this.bnAddRoles, 170, 190);
        this.bnRemoveRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON", 16));
        this.bnRemoveRoles.setEnabled(false);
        this.bnRemoveRoles.addActionListener(new RemoveRolesActionListener());
        this.panelRoles.add(this.bnRemoveRoles);
        this.setObjectConstraints(this.getRolesLayout(), this.bnRemoveRoles, 230, 190);
        UserPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddRoles, this.bnRemoveRoles);
    }

    protected SpringLayout getRolesLayout() {
        return (SpringLayout)this.panelRoles.getLayout();
    }

    private void initClustersView() {
        this.clusters = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Clusters"), this.clusters);
        this.initClusters();
    }

    private void initClusters() {
        this.clusterListModel = new DefaultListModel();
        this.clusterList = new JList(this.clusterListModel);
        this.clusterList.addMouseListener(new ClusterListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.clusterList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusters.add(jScrollPane);
        this.setObjectConstraints(this.getClusterLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getClusterLayout() {
        return (SpringLayout)this.clusters.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTableLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.indexList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(jScrollPane);
        this.setObjectConstraints(this.getIndexLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initSnapshotsView() {
        this.snapshots = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Snapshots"), this.snapshots);
        this.initSnapshots();
    }

    private void initSnapshots() {
        this.snapshotListModel = new DefaultListModel();
        this.snapshotList = new JList(this.snapshotListModel);
        this.snapshotList.addMouseListener(new SnapshotListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.snapshotList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.snapshots.add(jScrollPane);
        this.setObjectConstraints(this.getSnapshotLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSnapshotLayout() {
        return (SpringLayout)this.snapshots.getLayout();
    }

    private void initTriggersView() {
        this.triggers = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Triggers"), this.triggers);
        this.initTriggers();
    }

    private void initTriggers() {
        this.triggerListModel = new DefaultListModel();
        this.triggerList = new JList(this.triggerListModel);
        this.triggerList.addMouseListener(new TriggerListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.triggerList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.triggers.add(jScrollPane);
        this.setObjectConstraints(this.getTriggerLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTriggerLayout() {
        return (SpringLayout)this.triggers.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.viewList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(jScrollPane);
        this.setObjectConstraints(this.getViewLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initDimensionsView() {
        this.dimensions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Dimensions"), this.dimensions);
        this.initDimensions();
    }

    private void initDimensions() {
        this.dimensionListModel = new DefaultListModel();
        this.dimensionList = new JList(this.dimensionListModel);
        this.dimensionList.addMouseListener(new DimensionListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.dimensionList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.dimensions.add(jScrollPane);
        this.setObjectConstraints(this.getDimensionLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getDimensionLayout() {
        return (SpringLayout)this.dimensions.getLayout();
    }

    private void initSequencesView() {
        this.sequences = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Sequences"), this.sequences);
        this.initSequences();
    }

    private void initSequences() {
        this.seqListModel = new DefaultListModel();
        this.seqList = new JList(this.seqListModel);
        this.seqList.addMouseListener(new SequencesListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.seqList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.sequences.add(jScrollPane);
        this.setObjectConstraints(this.getSequencesLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSequencesLayout() {
        return (SpringLayout)this.sequences.getLayout();
    }

    private void initSynonymsView() {
        this.synonyms = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Synonyms"), this.synonyms);
        this.initSynonyms();
    }

    private void initSynonyms() {
        this.synListModel = new DefaultListModel();
        this.synList = new JList(this.synListModel);
        this.synList.addMouseListener(new SynonymsListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.synList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.synonyms.add(jScrollPane);
        this.setObjectConstraints(this.getSynonymsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSynonymsLayout() {
        return (SpringLayout)this.synonyms.getLayout();
    }

    private void initProceduresView() {
        this.procedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Procedures"), this.procedures);
        this.initProcedures();
    }

    private void initPackagesView() {
        this.packages = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Packages"), this.packages);
        this.initPackages();
    }

    private void initFunctionsView() {
        this.functions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Functions"), this.functions);
        this.initFunctions();
    }

    private void initProcedures() {
        this.procListModel = new DefaultListModel();
        this.procList = new JList(this.procListModel);
        this.procList.addMouseListener(new ProceduresListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.procList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.procedures.add(jScrollPane);
        this.setObjectConstraints(this.getProceduresLayout(), jScrollPane, 10, 12);
    }

    private void initPackages() {
        this.packagesListModel = new DefaultListModel();
        this.packagesList = new JList(this.packagesListModel);
        this.packagesList.addMouseListener(new PackagesListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.packagesList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.packages.add(jScrollPane);
        this.setObjectConstraints(this.getPackagesLayout(), jScrollPane, 10, 12);
    }

    private void initFunctions() {
        this.functionsListModel = new DefaultListModel();
        this.functionsList = new JList(this.functionsListModel);
        this.functionsList.addMouseListener(new FunctionsListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.functionsList);
        jScrollPane.setPreferredSize(new Dimension(425, 370));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.functions.add(jScrollPane);
        this.setObjectConstraints(this.getFunctionsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getProceduresLayout() {
        return (SpringLayout)this.procedures.getLayout();
    }

    protected SpringLayout getPackagesLayout() {
        return (SpringLayout)this.packages.getLayout();
    }

    protected SpringLayout getFunctionsLayout() {
        return (SpringLayout)this.functions.getLayout();
    }

    @Override
    public void initProperties() {
        int n;
        Object object;
        Object object2;
        StringTokenizer stringTokenizer;
        this.initCaption(this.user.getName());
        this.tfName.setText(this.user.getName());
        this.cbAuthentication.setSelectedItem(this.user.getAuthType());
        this.tfIdentifier.setText(this.user.decodeIdentifier());
        this.selectObject(this.cbTableSpace, this.user.getDefTableSpace());
        this.selectObject(this.cbTempTableSpace, this.user.getTempTableSpace());
        this.tfTempTSGroup.setText(this.user.getTempTSGroupName());
        this.tfProfile.setText(this.user.getProfile());
        this.cbPasswordExpire.setSelectedItem(UserPropertyDialogOraclev10g.translateYesNoForDisplay(this.user.getPasswordExpire()));
        this.cbAccountLock.setSelectedItem(UserPropertyDialogOraclev10g.translateYesNoForDisplay(this.user.getAccountLock()));
        this.tfexternalName.setText(this.user.getExternalName());
        Object[] objectArray = this.getStorageDesign().getRoleSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.user.getRoles(), ",");
            stringTokenizer = new StringTokenizer(this.user.getRolesWithAdminOption(), ",");
            object2 = new Role(objectArray[i]);
            ((Role)object2).setObjectID(((RoleOracle)objectArray[i]).getObjectID());
            boolean bl = false;
            while (stringTokenizer2.hasMoreTokens()) {
                object = stringTokenizer2.nextToken().trim();
                if (!((Role)object2).getObjectID().equalsIgnoreCase((String)object)) continue;
                this.selectedRolesList.add((Role)object2);
                bl = true;
                break;
            }
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (!((Role)object2).getObjectID().equalsIgnoreCase((String)object)) continue;
                ((Role)object2).setAdminOption(true);
                this.selectedRolesList.add((Role)object2);
                bl = true;
                break;
            }
            if (bl) continue;
            this.allRolesModel.addElement(((Role)object2).getObject());
        }
        this.sort(this.allRolesModel);
        if (this.allRolesModel.getSize() > 0) {
            this.allRolesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedRolesList.size() > 0) {
            this.selectedRolesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        String[] stringArray = this.user.getPrivilegeValues();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            stringTokenizer = new StringTokenizer(this.user.getPrivileges(), ",");
            object2 = new StringTokenizer(this.user.getPrivilegesWithAdminOption(), ",");
            String string2 = stringArray[i].trim();
            object = null;
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (!string2.equalsIgnoreCase(string)) continue;
                object = new SystemPrivilege(string.trim());
                ((SystemPrivilege)object).setName(string);
                this.selectedSystemPrivilegesList.add((SystemPrivilege)object);
                n = 1;
                break;
            }
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = ((StringTokenizer)object2).nextToken().trim();
                if (!string2.equalsIgnoreCase(string)) continue;
                object = new SystemPrivilege(string.trim());
                ((SystemPrivilege)object).setName(string);
                ((SystemPrivilege)object).setAdminOption(true);
                this.selectedSystemPrivilegesList.add((SystemPrivilege)object);
                n = 1;
                break;
            }
            if (n != 0) continue;
            this.allPrivilegesModel.addElement(string2);
        }
        this.sort(this.allPrivilegesModel);
        if (this.allPrivilegesModel.getSize() > 0) {
            this.allPrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedSystemPrivilegesList.size() > 0) {
            this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        Object[] objectArray2 = this.getStorageDesign().getClusterSet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((ClusterOracle)objectArray2[i]).getUser() != this.user) continue;
            this.clusterListModel.addElement(objectArray2[i]);
        }
        Object[] objectArray3 = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            if (((TableProxyOracle)objectArray3[i]).getUser() != this.user) continue;
            this.tableListModel.addElement(objectArray3[i]);
        }
        Object[] objectArray4 = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < objectArray4.length; ++i) {
            if (((IndexProxyOracle)objectArray4[i]).getUser() != this.user) continue;
            this.indexListModel.addElement(objectArray4[i]);
        }
        Object[] objectArray5 = this.getStorageDesign().getSnapshotSet().toArray();
        for (int i = 0; i < objectArray5.length; ++i) {
            if (((SnapshotOracle)objectArray5[i]).getUser() != this.user) continue;
            this.snapshotListModel.addElement(objectArray5[i]);
        }
        Object[] objectArray6 = this.getStorageDesign().getTriggerSet().toArray();
        for (n = 0; n < objectArray6.length; ++n) {
            if (((TriggerOracle)objectArray6[n]).getOwner() != this.user) continue;
            this.triggerListModel.addElement(objectArray6[n]);
        }
        Object[] objectArray7 = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i = 0; i < objectArray7.length; ++i) {
            if (((TableViewProxyOracle)objectArray7[i]).getUser() != this.user) continue;
            this.viewListModel.addElement(objectArray7[i]);
        }
        Object[] objectArray8 = this.getStorageDesign().getDimensionSet().toArray();
        for (int i = 0; i < objectArray8.length; ++i) {
            if (((DimensionOracle)objectArray8[i]).getUser() != this.user) continue;
            this.dimensionListModel.addElement(objectArray8[i]);
        }
        Object[] objectArray9 = this.getStorageDesign().getSequenceSet().toArray();
        for (int i = 0; i < objectArray9.length; ++i) {
            if (((SequenceOracle)objectArray9[i]).getUser() != this.user) continue;
            this.seqListModel.addElement(objectArray9[i]);
        }
        Object[] objectArray10 = this.getStorageDesign().getSynonymSet().toArray();
        for (int i = 0; i < objectArray10.length; ++i) {
            if (((SynonymOracle)objectArray10[i]).getUser() != this.user) continue;
            this.synListModel.addElement(objectArray10[i]);
        }
        Object[] objectArray11 = this.getStorageDesign().getStoredProcedureSet().toArray();
        for (int i = 0; i < objectArray11.length; ++i) {
            if (((StoredProcedureOracle)objectArray11[i]).getOwner() != this.user) continue;
            this.procListModel.addElement(objectArray11[i]);
        }
        Object[] objectArray12 = this.getStorageDesign().getFunctionSet().toArray();
        for (int i = 0; i < objectArray12.length; ++i) {
            if (((FunctionOracle)objectArray12[i]).getOwner() != this.user) continue;
            this.functionsListModel.addElement(objectArray12[i]);
        }
        Object[] objectArray13 = this.getStorageDesign().getPackageSet().toArray();
        for (int i = 0; i < objectArray13.length; ++i) {
            if (((PackageOracle)objectArray13[i]).getOwner() != this.user) continue;
            this.packagesListModel.addElement(objectArray13[i]);
        }
        this.getCommentsList().insert(this.user.getComment(), 0);
        this.cbSchemaObject.setSelectedItem(this.user.getSchemaObject());
    }

    @Override
    protected void setProperties() {
        if (this.user != null) {
            this.user.clear();
            this.user.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            this.user.setName(this.tfName.getText());
            this.user.setAuthType((String)this.cbAuthentication.getSelectedItem());
            this.user.encodeIdentifier(String.valueOf(this.tfIdentifier.getPassword()));
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOraclev10g) {
                this.user.setDefTableSpace((TableSpaceOraclev10g)object);
            } else {
                this.user.setDefTableSpace(null);
            }
            object = this.cbTempTableSpace.getSelectedItem();
            if (object instanceof TemporaryTablespaceOraclev10g) {
                this.user.setTempTableSpace((TemporaryTablespaceOraclev10g)object);
            } else {
                this.user.setTempTableSpace(null);
            }
            this.user.setTempTSGroupName(this.tfTempTSGroup.getText());
            this.user.setProfile(this.tfProfile.getText());
            this.user.setPasswordExpire(UserPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbPasswordExpire.getSelectedItem()));
            this.user.setAccountLock(UserPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbAccountLock.getSelectedItem()));
            this.user.setExternalName(this.tfexternalName.getText());
            Object[] objectArray = this.selectedRolesList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Role role = (Role)objectArray[i];
                boolean bl = role.getAdminOption();
                if (bl) {
                    this.user.setRolesWithAdminOption(role.getObjectID());
                    continue;
                }
                this.user.setRoles(role.getObjectID());
            }
            Object[] objectArray2 = this.selectedSystemPrivilegesList.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = objectArray2[i];
                if (!(object2 instanceof SystemPrivilege)) continue;
                SystemPrivilege systemPrivilege = (SystemPrivilege)object2;
                if (systemPrivilege.getAdminOption()) {
                    this.user.setPrivilegesWithAdminOption(systemPrivilege.getObject().toString());
                    continue;
                }
                this.user.setPrivileges(systemPrivilege.getObject().toString());
            }
            this.user.setComment(this.getCommentsList().getText());
        }
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                if (defaultListModel.get(j).toString().compareTo(defaultListModel.get(j - 1).toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    public class ColumnAdminRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -215127161678321822L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(bl3);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedRolessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3109094884784088828L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserPropertyDialogOraclev10g.Role"), Messages.getString("UserPropertyDialogOraclev10g.Admin")};

        private SelectedRolessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserPropertyDialogOraclev10g.this.selectedRolesList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Role role = (Role)UserPropertyDialogOraclev10g.this.selectedRolesList.get(n);
            if (object instanceof Boolean && n2 == 1) {
                role.setAdminOption((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Role role = (Role)UserPropertyDialogOraclev10g.this.selectedRolesList.get(n);
            if (n2 == 0) {
                return role.getObject();
            }
            if (n2 == 1) {
                return role.getAdminOption();
            }
            return "";
        }
    }

    private class SelectedSystemPrivilegesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4043791265287763172L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserPropertyDialogOraclev10g.Privilege"), Messages.getString("UserPropertyDialogOraclev10g.Admin")};

        private SelectedSystemPrivilegesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SystemPrivilege systemPrivilege = (SystemPrivilege)UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.get(n);
            if (object instanceof Boolean && n2 == 1) {
                systemPrivilege.setAdminOption((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SystemPrivilege systemPrivilege = (SystemPrivilege)UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.get(n);
            if (n2 == 0) {
                return systemPrivilege.getObject();
            }
            if (n2 == 1) {
                return systemPrivilege.getAdminOption();
            }
            return "";
        }
    }

    class Role {
        Object obj = null;
        String name = "";
        String objectID = "";
        boolean adminOption = false;

        Role(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setObjectID(String string) {
            this.objectID = string;
        }

        String getObjectID() {
            return this.objectID;
        }

        void setAdminOption(boolean bl) {
            this.adminOption = bl;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    class SystemPrivilege {
        Object obj = null;
        String name = "";
        boolean adminOption = false;

        SystemPrivilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setAdminOption(boolean bl) {
            this.adminOption = bl;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    private class FunctionsListMouseListener
    extends MouseAdapter {
        private FunctionsListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            FunctionOracle functionOracle;
            if (mouseEvent.getClickCount() == 2 && (functionOracle = (FunctionOracle)UserPropertyDialogOraclev10g.this.functionsList.getSelectedValue()) != null && !functionOracle.isDialogVisible()) {
                FunctionPropertyDialogOracle functionPropertyDialogOracle = new FunctionPropertyDialogOracle(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), functionOracle);
                functionPropertyDialogOracle.show();
            }
        }
    }

    private class PackagesListMouseListener
    extends MouseAdapter {
        private PackagesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PackageOracle packageOracle;
            if (mouseEvent.getClickCount() == 2 && (packageOracle = (PackageOracle)UserPropertyDialogOraclev10g.this.packagesList.getSelectedValue()) != null && !packageOracle.isDialogVisible()) {
                DefaultPropertyDialogOracle defaultPropertyDialogOracle = new DefaultPropertyDialogOracle(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), packageOracle);
                defaultPropertyDialogOracle.show();
            }
        }
    }

    private class ProceduresListMouseListener
    extends MouseAdapter {
        private ProceduresListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            StoredProcedureOracle storedProcedureOracle;
            if (mouseEvent.getClickCount() == 2 && (storedProcedureOracle = (StoredProcedureOracle)UserPropertyDialogOraclev10g.this.procList.getSelectedValue()) != null && !storedProcedureOracle.isDialogVisible()) {
                StoredProcedurePropertyDialogOraclev9i storedProcedurePropertyDialogOraclev9i = new StoredProcedurePropertyDialogOraclev9i(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), storedProcedureOracle);
                storedProcedurePropertyDialogOraclev9i.show();
            }
        }
    }

    private class SynonymsListMouseListener
    extends MouseAdapter {
        private SynonymsListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SynonymOracle synonymOracle;
            if (mouseEvent.getClickCount() == 2 && (synonymOracle = (SynonymOracle)UserPropertyDialogOraclev10g.this.synList.getSelectedValue()) != null && !synonymOracle.isDialogVisible()) {
                SynonymPropertyDialogOraclev9i synonymPropertyDialogOraclev9i = new SynonymPropertyDialogOraclev9i(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), synonymOracle);
                synonymPropertyDialogOraclev9i.show();
            }
        }
    }

    private class SequencesListMouseListener
    extends MouseAdapter {
        private SequencesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SequenceOracle sequenceOracle;
            if (mouseEvent.getClickCount() == 2 && (sequenceOracle = (SequenceOracle)UserPropertyDialogOraclev10g.this.seqList.getSelectedValue()) != null && !sequenceOracle.isDialogVisible()) {
                SequencePropertyDialogOraclev9i sequencePropertyDialogOraclev9i = new SequencePropertyDialogOraclev9i(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), sequenceOracle);
                sequencePropertyDialogOraclev9i.show();
            }
        }
    }

    private class DimensionListMouseListener
    extends MouseAdapter {
        private DimensionListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DimensionOracle dimensionOracle;
            if (mouseEvent.getClickCount() == 2 && (dimensionOracle = (DimensionOracle)UserPropertyDialogOraclev10g.this.dimensionList.getSelectedValue()) != null && !dimensionOracle.isDialogVisible()) {
                DimensionOraclev9iPropertyDialog dimensionOraclev9iPropertyDialog = new DimensionOraclev9iPropertyDialog(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), dimensionOracle);
                dimensionOraclev9iPropertyDialog.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableViewProxyOracle tableViewProxyOracle;
            if (mouseEvent.getClickCount() == 2 && (tableViewProxyOracle = (TableViewProxyOracle)UserPropertyDialogOraclev10g.this.viewList.getSelectedValue()) != null && !tableViewProxyOracle.isDialogVisible()) {
                TableViewPropertyDialogOraclev9i tableViewPropertyDialogOraclev9i = new TableViewPropertyDialogOraclev9i(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), tableViewProxyOracle);
                tableViewPropertyDialogOraclev9i.show();
            }
        }
    }

    private class TriggerListMouseListener
    extends MouseAdapter {
        private TriggerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TriggerOracle triggerOracle;
            if (mouseEvent.getClickCount() == 2 && (triggerOracle = (TriggerOracle)UserPropertyDialogOraclev10g.this.triggerList.getSelectedValue()) != null && !triggerOracle.isDialogVisible()) {
                TriggerPropertyDialogOraclev9i triggerPropertyDialogOraclev9i = new TriggerPropertyDialogOraclev9i(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), triggerOracle);
                triggerPropertyDialogOraclev9i.show();
            }
        }
    }

    private class SnapshotListMouseListener
    extends MouseAdapter {
        private SnapshotListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SnapshotOracle snapshotOracle;
            if (mouseEvent.getClickCount() == 2 && (snapshotOracle = (SnapshotOracle)UserPropertyDialogOraclev10g.this.snapshotList.getSelectedValue()) != null && !snapshotOracle.isDialogVisible()) {
                SnapshotPropertyDialogOraclev10g snapshotPropertyDialogOraclev10g = new SnapshotPropertyDialogOraclev10g(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), snapshotOracle);
                snapshotPropertyDialogOraclev10g.show();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IndexProxyOracle indexProxyOracle;
            if (mouseEvent.getClickCount() == 2 && (indexProxyOracle = (IndexProxyOracle)UserPropertyDialogOraclev10g.this.indexList.getSelectedValue()) != null && !indexProxyOracle.isDialogVisible()) {
                IndexPropertyDialogOraclev10g indexPropertyDialogOraclev10g = new IndexPropertyDialogOraclev10g(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), indexProxyOracle);
                indexPropertyDialogOraclev10g.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyOracle tableProxyOracle;
            if (mouseEvent.getClickCount() == 2 && (tableProxyOracle = (TableProxyOracle)UserPropertyDialogOraclev10g.this.tableList.getSelectedValue()) != null && !tableProxyOracle.isDialogVisible()) {
                TablePropertyDialogOraclev10g tablePropertyDialogOraclev10g = new TablePropertyDialogOraclev10g(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), tableProxyOracle);
                tablePropertyDialogOraclev10g.show();
            }
        }
    }

    private class ClusterListMouseListener
    extends MouseAdapter {
        private ClusterListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ClusterOracle clusterOracle;
            if (mouseEvent.getClickCount() == 2 && (clusterOracle = (ClusterOracle)UserPropertyDialogOraclev10g.this.clusterList.getSelectedValue()) != null && !clusterOracle.isDialogVisible()) {
                ClusterPropertyDialogOraclev9i clusterPropertyDialogOraclev9i = new ClusterPropertyDialogOraclev9i(UserPropertyDialogOraclev10g.this.user.getDesign().getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), clusterOracle);
                clusterPropertyDialogOraclev9i.show();
            }
        }
    }

    private class RemoveRolesActionListener
    implements ActionListener {
        private RemoveRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = UserPropertyDialogOraclev10g.this.selectedRolesTable.getSelectedRows();
            Object object = null;
            for (int i = 0; i < nArray.length; ++i) {
                Role role = (Role)UserPropertyDialogOraclev10g.this.selectedRolesList.get(nArray[i]);
                object = role.getObject();
                if (UserPropertyDialogOraclev10g.this.allRolesModel.contains(object)) continue;
                UserPropertyDialogOraclev10g.this.allRolesModel.addElement(object);
                UserPropertyDialogOraclev10g.this.selectedRolesList.remove(role);
                UserPropertyDialogOraclev10g.this.sort(UserPropertyDialogOraclev10g.this.allRolesModel);
            }
            UserPropertyDialogOraclev10g.this.selectedRolesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedRolesTable.clearSelection();
            UserPropertyDialogOraclev10g.this.allRolesList.setSelectedValue(object, true);
        }
    }

    private class AddRolesActionListener
    implements ActionListener {
        private AddRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            if (!UserPropertyDialogOraclev10g.this.allRolesModel.isEmpty()) {
                Object[] objectArray = UserPropertyDialogOraclev10g.this.allRolesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (UserPropertyDialogOraclev10g.this.selectedRolesList.contains(object)) continue;
                    Role role = new Role(object);
                    role.setName(object.toString());
                    role.setObjectID(((RoleOracle)objectArray[i]).getObjectID());
                    UserPropertyDialogOraclev10g.this.selectedRolesList.add(role);
                    UserPropertyDialogOraclev10g.this.allRolesModel.removeElement(objectArray[i]);
                }
            }
            UserPropertyDialogOraclev10g.this.selectedRolesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedRolesTable.getSelectionModel().setSelectionInterval(UserPropertyDialogOraclev10g.this.selectedRolesTable.getRowCount() - 1, UserPropertyDialogOraclev10g.this.selectedRolesTable.getRowCount() - 1);
        }
    }

    private class AllRolesListSelectionHandler
    implements ListSelectionListener {
        private AllRolesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (UserPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (UserPropertyDialogOraclev10g.this.allRolesList.getSelectedIndex() == -1) {
                    UserPropertyDialogOraclev10g.this.bnAddRoles.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnAddRoles.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (UserPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (UserPropertyDialogOraclev10g.this.allPrivilegesList.getSelectedIndex() == -1) {
                    UserPropertyDialogOraclev10g.this.bnAddPrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getSelectedRows();
            Object object = null;
            for (int i = 0; i < nArray.length; ++i) {
                SystemPrivilege systemPrivilege = (SystemPrivilege)UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.get(nArray[i]);
                object = systemPrivilege.getObject();
                if (UserPropertyDialogOraclev10g.this.allPrivilegesModel.contains(object)) continue;
                UserPropertyDialogOraclev10g.this.allPrivilegesModel.addElement(object);
                UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.remove(systemPrivilege);
                UserPropertyDialogOraclev10g.this.sort(UserPropertyDialogOraclev10g.this.allPrivilegesModel);
            }
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.clearSelection();
            UserPropertyDialogOraclev10g.this.allPrivilegesList.setSelectedValue(object, true);
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            if (!UserPropertyDialogOraclev10g.this.allPrivilegesModel.isEmpty()) {
                Object[] objectArray = UserPropertyDialogOraclev10g.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.contains(object)) continue;
                    SystemPrivilege systemPrivilege = new SystemPrivilege(object);
                    systemPrivilege.setName(object.toString());
                    UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.add(systemPrivilege);
                    UserPropertyDialogOraclev10g.this.allPrivilegesModel.removeElement(object);
                }
            }
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getRowCount() - 1, UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getRowCount() - 1);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserPropertyDialogOraclev10g.this.dialog = new UserAndRolePermissionsDialogOracle(UserPropertyDialogOraclev10g.this.getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), UserPropertyDialogOraclev10g.this.user);
            UserPropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

