/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.LocalIndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TBPartitionPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private PartitionOracle partition;
    private JTextField tfValueList;
    private JIntegerField ifPosition;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JIntegerField ifIotCompress;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbSegmentCompression;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel subPartOrderPanel;
    private JTable subPartitionsOrderTable;
    private List subPartitions;
    private DefaultListSelectionModel subPartSelectionModel;
    private SubPartitionsOrderModel subPartitionsOrderModel;
    private boolean subPartOrdered = false;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public TBPartitionPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.partition = (PartitionOracle)storageObject;
        this.setHeight(370);
        this.initCommentsView(300);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TBPartitionPropertyDialogOracle.PartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initPosition();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initSegmentCompression();
        this.initIOTCompress();
        this.initIOTOverflowSegment();
        this.initSubPartQuantity();
    }

    private void initValueList() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.ValueList"));
        this.general.add(jLabel);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initPosition() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Position"));
        this.general.add(jLabel);
        this.ifPosition = new JIntegerField(0, 26);
        this.general.add(this.ifPosition);
        this.ifPosition.setEnabled(false);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifPosition, 80);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    private void initSegmentCompression() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SegCompression"));
        this.general.add(jLabel);
        this.cbSegmentCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbSegmentCompression);
        this.cbSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegmentCompression);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbSegmentCompression, 200);
    }

    private void initIOTCompress() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.IOTCompress"));
        this.general.add(jLabel);
        this.ifIotCompress = new JIntegerField(0, 26);
        this.general.add(this.ifIotCompress);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifIotCompress, 230);
    }

    private void initIOTOverflowSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.OverflowSegment"));
        this.general.add(jLabel);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbIotOverflowSegment, 260);
    }

    private void initSubPartQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SubPartQuantity"));
        this.general.add(jLabel);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.general.add(this.ifSubPartQuantity);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.ifSubPartQuantity, 290);
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private void initIndexesTab() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.getList());
        jScrollPane.setPreferredSize(new Dimension(390, 270));
        jPanel.add((Component)this.getIndexesButtonPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.LocalIndexes"), jPanel);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.edit = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("TBPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TBPartitionPropertyDialogOraclev10g.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.edit);
            jToolBar.addSeparator();
            this.indexesButtonPanel.add(jToolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    private void editSelected() {
        Object e = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev10g localIndexPropertyDialogOraclev10g = new LocalIndexPropertyDialogOraclev10g(this.partition.getDesign().getAppView(), this.getStorageDesign(), this.partition, (StorageObject)e);
        localIndexPropertyDialogOraclev10g.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    @Override
    protected void addTabs() {
        StorageObject storageObject = this.getStorageObject();
        if (((PartitionOracle)storageObject).getPartitionList() != null) {
            this.initSubPartTSView();
            this.initSubPartOrderTab();
        }
        this.initIndexesTab();
    }

    private void initSubPartTSView() {
        this.subPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionTableSpaces"), this.subPartTS);
        this.initSubPartTS();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initAllSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(jLabel);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(jLabel);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Add"));
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 160, 135);
        this.bnRemoveSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Remove"));
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 160, 165);
        TBPartitionPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    private void initSubPartOrderTab() {
        JComponent jComponent;
        this.subPartOrderPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionsOrder"), this.subPartOrderPanel);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        jButton.addActionListener(new SubPartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new SubMoveUpAction());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            jButton2.addActionListener(new SubMoveDownAction());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.subPartOrderPanel.add(jPanel);
        this.setObjectConstraints(this.getSubPartOrderLayout(), jPanel, 10, 0);
        this.subPartitionsOrderModel = new SubPartitionsOrderModel();
        this.subPartSelectionModel = new DefaultListSelectionModel();
        this.subPartSelectionModel.setSelectionMode(2);
        this.subPartitionsOrderTable = new JTable(this.subPartitionsOrderModel);
        this.subPartitionsOrderTable.setSelectionModel(this.subPartSelectionModel);
        jComponent = new JScrollPane(this.subPartitionsOrderTable);
        jComponent.setPreferredSize(new Dimension(400, 270));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartOrderPanel.add(jComponent);
        this.setObjectConstraints(this.getSubPartOrderLayout(), jComponent, 6, 40);
    }

    private SpringLayout getSubPartOrderLayout() {
        return (SpringLayout)this.subPartOrderPanel.getLayout();
    }

    private StorageObjectCollection getSubPartitions() {
        PartitionListOracle partitionListOracle = this.partition.getPartitionList();
        if (partitionListOracle != null) {
            String string = partitionListOracle.getSubpartitionType();
            if (string.equals("HASH")) {
                return this.partition.getPartitions();
            }
            if (string.equals("LIST")) {
                return this.partition.getListPartitions();
            }
            if (string.equals("RANGE")) {
                return ((PartitionOraclev11g)this.partition).getRangeSubpartitions();
            }
        }
        return null;
    }

    private boolean subMoveToIndex(Object object, int n) {
        if (this.subPartitions.contains(object) && this.subPartitions.size() > n && n >= 0) {
            this.subPartitions.remove(object);
            this.subPartitions.add(n, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel defaultListSelectionModel, int[] nArray) {
        defaultListSelectionModel.clearSelection();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                defaultListSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
            }
        }
    }

    @Override
    public void initProperties() {
        Object object;
        Object object2;
        ModelObject modelObject;
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.tfValueList.setText(this.partition.getValueList());
        this.ifPosition.setValue((long)this.partition.getPosition());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.cbLogging.setSelectedItem(TBPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.partition.getLogging()));
        this.selectObject(this.cbSegment, this.partition.getSegment());
        this.cbSegmentCompression.setSelectedItem(TBPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.partition.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.partition.getIOTCompress());
        this.selectObject(this.cbIotOverflowSegment, this.partition.getIOTOverflowSegment());
        PartitionListOracle partitionListOracle = this.partition.getPartitionList();
        if (partitionListOracle == null || this.partition.hasSubPartitions() || !partitionListOracle.getSubpartitionType().equalsIgnoreCase("HASH")) {
            this.ifSubPartQuantity.setEnabled(false);
            int n = this.getPane().indexOfComponent(this.subPartTS);
            if (n > -1) {
                this.getPane().setEnabledAt(n, false);
            }
        } else {
            this.ifSubPartQuantity.setValue((long)this.partition.getSubPartitionsQuantity());
        }
        if (partitionListOracle != null) {
            String string = partitionListOracle.getPartitionType();
            if (string.equalsIgnoreCase("REFERENCE") || string.equalsIgnoreCase("SYSTEM")) {
                this.tfValueList.setEnabled(false);
            }
            this.subPartitions = new ArrayList();
            modelObject = this.getSubPartitions();
            if (modelObject != null) {
                ((StorageObjectCollection)modelObject).setForbiddenCreateElement(true);
                ((ModelObjectSet)modelObject).addAllElementsTo(this.subPartitions);
            }
            object2 = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
            for (int i = 0; i < ((TableSpaceOracle[])object2).length; ++i) {
                object = object2[i];
                if (this.partition.getSubPartTSSet().contains(((ModelIDObject)object).getObjectID())) {
                    this.selectedSubPartTSModel.addElement(object);
                    continue;
                }
                this.allSubPartTSModel.addElement(object);
            }
        } else if (this.partition instanceof PartitionOraclev11g) {
            AbstractStorageObjectOracle abstractStorageObjectOracle = ((PartitionOraclev11g)this.partition).getSubPartitionOf();
            if (abstractStorageObjectOracle instanceof PartitionOracle) {
                partitionListOracle = ((PartitionOracle)abstractStorageObjectOracle).getPartitionList();
            } else if (abstractStorageObjectOracle instanceof ListPartitionOracle) {
                partitionListOracle = ((ListPartitionOracle)abstractStorageObjectOracle).getPartitionList();
            } else if (abstractStorageObjectOracle instanceof HashPartitionOracle) {
                partitionListOracle = ((HashPartitionOracle)abstractStorageObjectOracle).getPartitionList();
            }
        }
        TableProxyOracle tableProxyOracle = null;
        if (partitionListOracle != null) {
            tableProxyOracle = partitionListOracle.getTable();
            if (tableProxyOracle == null && (modelObject = partitionListOracle.getSnapshot()) != null) {
                tableProxyOracle = ((SnapshotOracle)modelObject).getImplementedTable();
            }
        } else if (this.partition instanceof PartitionOraclev11g) {
            tableProxyOracle = ((PartitionOraclev11g)this.partition).getPartOfStorageTable();
        }
        if (tableProxyOracle != null) {
            Object object3;
            Object object4;
            boolean bl = tableProxyOracle.getOrganization().equals(TableProxyOracle.getOrganizationChoices()[1]);
            boolean bl2 = this.partition.getPartitionList() != null;
            this.cbLogging.setEnabled(bl2);
            this.ifIotCompress.setEnabled(bl);
            this.cbIotOverflowSegment.setEnabled(bl2 && bl);
            IndexProxy[] indexProxyArray = tableProxyOracle.getIndexProxies();
            for (int i = 0; i < indexProxyArray.length; ++i) {
                object4 = (IndexProxyOracle)indexProxyArray[i];
                if (object4 == null || !((IndexProxyOracle)object4).getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(object4);
            }
            object = tableProxyOracle.getBjIndexes().iterator();
            while (object.hasNext()) {
                object4 = (BitmapJoinIndexOraclev10g)object.next();
                if (!((BitmapJoinIndexOracle)object4).getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(object4);
            }
            object4 = tableProxyOracle.getUniqueKeys().iterator();
            while (object4.hasNext()) {
                object3 = (UniqueOraclev10g)object4.next();
                if (!((UniqueOraclev10g)object3).getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(object3);
            }
            object3 = tableProxyOracle.getPrimaryKeys().iterator();
            while (object3.hasNext()) {
                PKProxyOraclev10g pKProxyOraclev10g = (PKProxyOraclev10g)object3.next();
                if (!pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(pKProxyOraclev10g);
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (this.listModel.get(i) instanceof IndexProxyOraclev10g) {
                object2 = (IndexProxyOraclev10g)this.listModel.get(i);
                LocalIndexProperties localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, (StorageObject)object2);
                if (localIndexProperties != null) continue;
                localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                localIndexProperties.setIndex((StorageObject)object2);
                localIndexProperties.setPartition(this.partition);
                continue;
            }
            if (this.listModel.get(i) instanceof BitmapJoinIndexOraclev10g) {
                object2 = (BitmapJoinIndexOraclev10g)this.listModel.get(i);
                LocalIndexProperties localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, (StorageObject)object2);
                if (localIndexProperties != null) continue;
                localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                localIndexProperties.setIndex((StorageObject)object2);
                localIndexProperties.setPartition(this.partition);
                continue;
            }
            if (this.listModel.get(i) instanceof UniqueOraclev10g) {
                object2 = (UniqueOraclev10g)this.listModel.get(i);
                LocalIndexProperties localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, (StorageObject)object2);
                if (localIndexProperties != null) continue;
                localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                localIndexProperties.setIndex((StorageObject)object2);
                localIndexProperties.setPartition(this.partition);
                continue;
            }
            if (!(this.listModel.get(i) instanceof PKProxyOraclev10g)) continue;
            object2 = (PKProxyOraclev10g)this.listModel.get(i);
            LocalIndexProperties localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, (StorageObject)object2);
            if (localIndexProperties != null) continue;
            localIndexProperties = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            localIndexProperties.setIndex((StorageObject)object2);
            localIndexProperties.setPartition(this.partition);
        }
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            int n;
            Object[] objectArray;
            this.partition.setName(this.tfName.getText());
            this.partition.setValueList(this.tfValueList.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOraclev10g) {
                this.partition.setTableSpace((TableSpaceOraclev10g)object);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setLogging(TBPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object = this.cbSegment.getSelectedItem();
            if (object instanceof SegmentOraclev10g) {
                this.partition.setSegment((SegmentOraclev10g)object);
            } else {
                this.partition.setSegment(null);
            }
            this.partition.setDataSegmentCompression(TBPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbSegmentCompression.getSelectedItem()));
            this.partition.setIOTCompress(this.ifIotCompress.getIntValue());
            object = this.cbIotOverflowSegment.getSelectedItem();
            if (object instanceof SegmentOraclev10g) {
                this.partition.setIOTOverflowSegment((SegmentOraclev10g)object);
            } else {
                this.partition.setIOTOverflowSegment(null);
            }
            this.partition.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
            if (this.selectedSubPartTSModel != null) {
                this.partition.getSubPartTSSet().clear();
                objectArray = this.selectedSubPartTSModel.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    Object object2 = objectArray[n];
                    if (!(object2 instanceof TableSpaceOraclev10g)) continue;
                    this.partition.setSubPartitionsTableSpaces(((TableSpaceOraclev10g)object2).getObjectID());
                }
            }
            if (this.subPartOrdered && (n = (objectArray = this.getSubPartitions()).size()) == this.subPartitions.size()) {
                this.subPartOrdered = false;
                for (int i = 0; i < n; ++i) {
                    objectArray.justRemove(objectArray.getElement(0));
                }
                for (int i = 0; i < n; ++i) {
                    if (this.subPartitions.get(i) instanceof PartitionOracle) {
                        PartitionOracle partitionOracle = (PartitionOracle)this.subPartitions.get(i);
                        partitionOracle.setParent(objectArray);
                        objectArray.add(partitionOracle);
                        partitionOracle.setPosition(i + 1);
                        continue;
                    }
                    objectArray.add((ModelObject)this.subPartitions.get(i));
                }
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    @Override
    protected void clearOnDispose() {
        StorageObjectCollection storageObjectCollection;
        PartitionListOracle partitionListOracle = this.partition.getPartitionList();
        if (partitionListOracle != null && (storageObjectCollection = this.getSubPartitions()) != null) {
            storageObjectCollection.setForbiddenCreateElement(partitionListOracle.getSubpartitionType().equals(""));
        }
    }

    private class SubMoveDownAction
    implements ActionListener {
        private SubMoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < TBPartitionPropertyDialogOraclev10g.this.subPartitions.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(n);
                    TBPartitionPropertyDialogOraclev10g.this.subMoveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                TBPartitionPropertyDialogOraclev10g.this.setSelection(TBPartitionPropertyDialogOraclev10g.this.subPartSelectionModel, nArray);
                TBPartitionPropertyDialogOraclev10g.this.subPartOrdered = true;
                TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubMoveUpAction
    implements ActionListener {
        private SubMoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(n);
                    TBPartitionPropertyDialogOraclev10g.this.subMoveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                TBPartitionPropertyDialogOraclev10g.this.setSelection(TBPartitionPropertyDialogOraclev10g.this.subPartSelectionModel, nArray);
                TBPartitionPropertyDialogOraclev10g.this.subPartOrdered = true;
                TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubPartitionsOrderModel
    extends AbstractTableModel {
        private SubPartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (TBPartitionPropertyDialogOraclev10g.this.subPartitions == null) {
                return 0;
            }
            return TBPartitionPropertyDialogOraclev10g.this.subPartitions.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionName");
            }
            if (n == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StorageObject storageObject = (StorageObject)TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(n);
            if (n2 == 0) {
                return storageObject.getName();
            }
            if (n2 == 1) {
                if (storageObject instanceof PartitionOracle) {
                    return ((PartitionOracle)storageObject).getValueList();
                }
                if (storageObject instanceof ListStorageTemplatePartitionOracle) {
                    return ((ListStorageTemplatePartitionOracle)storageObject).getValueList();
                }
                return "";
            }
            return new Integer(n * n2);
        }
    }

    private class SubPartitionPropertiesAction
    implements ActionListener {
        private SubPartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.getSelectedRow();
            if (n > -1 && n < TBPartitionPropertyDialogOraclev10g.this.subPartitions.size()) {
                StorageObject storageObject = (StorageObject)TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(n);
                storageObject.showPropertyDialog();
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.isEmpty()) {
                Object[] objectArray = TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.contains(object)) continue;
                    TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.addElement(object);
                    TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.isEmpty()) {
                Object[] objectArray = TBPartitionPropertyDialogOraclev10g.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.contains(object)) continue;
                    TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.addElement(object);
                    TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev10g.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev10g.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev10g.this.allSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev10g.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev10g.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TBPartitionPropertyDialogOraclev10g.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Index) {
                this.setText(((Index)object).getName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

