/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPH_ShortName;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class PKPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private static final String NO_INDEX = NO;
    private static final String LOCAL = "LOCAL";
    private static final String GLOBAL_BY_RANGE = "GLOBAL BY RANGE";
    private static final String GLOBAL_HASH_PARTITIONED_BY_QUANTITY = "GLOBAL HASH PARTITIONED BY QUANTITY";
    private static final String GLOBAL_HASH_PARTITIONED_BY_LIST = "GLOBAL HASH PARTITIONED BY LIST";
    private static final String BY_INDEX_NAME = "BY INDEX NAME";
    private static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    private static final String[] USING_INDEX_CHOICES = new String[]{NO_INDEX, "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static final String NO_SORT = NO;
    private static final String SORTED = "SORTED";
    private static final String REVERSE = "REVERSE";
    private static final String[] SORT_CHOICES = new String[]{NO_SORT, "SORTED", "REVERSE"};
    private PKProxyOraclev10g pkProxy;
    private JTextField tfTable;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbUsingIndex;
    private JComboBox cbIndexSort;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbExTable;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel partitioning;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel hashSubPartQuantityTS;
    private JIntegerField ifHashPQuantity;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JList allIOTOverflowHashPTSList;
    private JList selectedIOTOverflowHashPTSList;
    private DefaultListModel allIOTOverflowHashPTSModel;
    private DefaultListModel selectedIOTOverflowHashPTSModel;
    private JButton bnAddIOTOverflowHashPTS;
    private JButton bnRemoveIOTOverflowHashPTS;
    private JPanel usingIndex;
    private JComboBox cbComputeStatistics;
    private JComboBox cbExistingIndex;
    private JTextArea taCreateIndexStatement;
    private JScrollPane spCreateIndexStatement;
    private String comment;
    private String commentInRDBMS;

    public PKPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.pkProxy = (PKProxyOraclev10g)storageObject;
        this.setHeight(430);
        this.initCommentsView(165);
        this.initCommentsInRDBMS(165);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("PKPropertyDialogOracle.PrimaryKeyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initUsingIndex();
        this.initExTable();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initInitially() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Initially"));
        this.general.add(jLabel);
        this.cbInitially = new JComboBox<String>(PKProxyOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbInitially, 80);
    }

    private void initDeferrable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Deferrable"));
        this.general.add(jLabel);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDeferrable, 110);
    }

    private void initEnable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Enable"));
        this.general.add(jLabel);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbEnable, 140);
    }

    private void initValidate() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Validate"));
        this.general.add(jLabel);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbValidate, 170);
    }

    private void initUsingIndex() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.UsingIndexL"));
        this.general.add(jLabel);
        this.cbUsingIndex = new JComboBox<String>(USING_INDEX_CHOICES);
        this.setBG(this.cbUsingIndex);
        this.cbUsingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.cbUsingIndex.addActionListener(new PartitionTypeListener());
        this.cbUsingIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((String)PKPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem()).equalsIgnoreCase(PKPropertyDialogOraclev10g.BY_INDEX_NAME)) {
                    Component[] componentArray = PKPropertyDialogOraclev10g.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(true);
                    }
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev10g.this.cbExistingIndex.setEnabled(true);
                } else if (((String)PKPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem()).equalsIgnoreCase(PKPropertyDialogOraclev10g.BY_CREATE_INDEX_STATEMENT)) {
                    Component[] componentArray = PKPropertyDialogOraclev10g.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(true);
                    }
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(true);
                    PKPropertyDialogOraclev10g.this.cbExistingIndex.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.cbExistingIndex.setSelectedItem(null);
                } else if (((String)PKPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem()).equalsIgnoreCase(NO_INDEX)) {
                    Component[] componentArray = PKPropertyDialogOraclev10g.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(false);
                    }
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev10g.this.cbExistingIndex.setSelectedItem(null);
                } else {
                    Component[] componentArray = PKPropertyDialogOraclev10g.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(true);
                    }
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.cbExistingIndex.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev10g.this.cbExistingIndex.setSelectedItem(null);
                }
            }
        });
        this.general.add(this.cbUsingIndex);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbUsingIndex, 200);
    }

    private void initExTable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.ExceptionsTable"));
        this.general.add(jLabel);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbExTable, 230);
    }

    private void initIndexSort() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.IndexSort"));
        this.usingIndex.add(jLabel);
        this.cbIndexSort = new JComboBox<String>(SORT_CHOICES);
        this.setBG(this.cbIndexSort);
        this.cbIndexSort.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbIndexSort);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 20);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbIndexSort, 20);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.TableSpace"));
        this.usingIndex.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbTableSpace);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 50);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbTableSpace, 50);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Logging"));
        this.usingIndex.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbLogging);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 80);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbLogging, 80);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Segment"));
        this.usingIndex.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbSegment);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 110);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbSegment, 110);
    }

    private void initComputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.ComputeStatistics"));
        this.usingIndex.add(jLabel);
        this.cbComputeStatistics = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStatistics);
        this.cbComputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbComputeStatistics);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 140);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbComputeStatistics, 140);
    }

    private void initExistingIndex() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.ExistingIndex"));
        this.usingIndex.add(jLabel);
        this.cbExistingIndex = new JComboBox();
        this.setBG(this.cbExistingIndex);
        this.cbExistingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbExistingIndex);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 170);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbExistingIndex, 170);
    }

    private void initCreateIndexStatement() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.CreateIndexStatement"));
        this.usingIndex.add(jLabel);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 200);
        this.taCreateIndexStatement = new JTextArea();
        this.spCreateIndexStatement = new JScrollPane(this.taCreateIndexStatement);
        this.spCreateIndexStatement.setPreferredSize(new Dimension(395, 140));
        this.spCreateIndexStatement.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCreateIndexStatement.setLineWrap(true);
        this.usingIndex.add(this.spCreateIndexStatement);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.spCreateIndexStatement, 10, 230);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initPartitioningView();
        this.initGlobalHashPartitionsByQuantityView();
        this.initUsingIndexView();
    }

    protected SpringLayout getUsingIndexLayout() {
        return (SpringLayout)this.usingIndex.getLayout();
    }

    private void initUsingIndexView() {
        this.usingIndex = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.UsingIndex"), this.usingIndex);
        this.initIndexSort();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initComputeStatistics();
        this.initExistingIndex();
        this.initCreateIndexStatement();
    }

    private void initGlobalHashPartitionsByQuantityView() {
        this.hashSubPartQuantityTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOraclev10g.GlobalHashPartitionsByQuantity"), this.hashSubPartQuantityTS);
        this.initGlobalHashPartitionsByQuantity();
    }

    private void initGlobalHashPartitionsByQuantity() {
        this.initHashPQuantity();
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
        this.initAllIOTOverflowHashPTSList();
        this.initSelectedIOTOverflowHashPTSList();
        this.initIOTOverflowHashPTSButtons();
    }

    protected SpringLayout getHashSubPartTSQuantityLayout() {
        return (SpringLayout)this.hashSubPartQuantityTS.getLayout();
    }

    private void initHashPQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOraclev10g.HashPQuantity"));
        this.hashSubPartQuantityTS.add(jLabel);
        this.ifHashPQuantity = new JIntegerField(0, 26);
        this.hashSubPartQuantityTS.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), jLabel, 20);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.ifHashPQuantity, 20);
    }

    private void initAllHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOraclev10g.AllTableSpaces"));
        this.hashSubPartQuantityTS.add(jLabel);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), jLabel, 12, 54);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), jScrollPane, 10, 72);
    }

    private void initSelectedHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOraclev10g.HashPTableSpaces"));
        this.hashSubPartQuantityTS.add(jLabel);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), jLabel, 292, 54);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), jScrollPane, 290, 72);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashSubPartQuantityTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnAddHashPTS, 175, 120);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashSubPartQuantityTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnRemoveHashPTS, 175, 150);
        PKPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void initAllIOTOverflowHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOraclev10g.AllTableSpaces"));
        this.hashSubPartQuantityTS.add(jLabel);
        this.allIOTOverflowHashPTSModel = new DefaultListModel();
        this.allIOTOverflowHashPTSList = new JList(this.allIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.allIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIOTOverflowHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allIOTOverflowHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), jLabel, 12, 224);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), jScrollPane, 10, 242);
    }

    private void initSelectedIOTOverflowHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTOverflowTS"));
        this.hashSubPartQuantityTS.add(jLabel);
        this.selectedIOTOverflowHashPTSModel = new DefaultListModel();
        this.selectedIOTOverflowHashPTSList = new JList(this.selectedIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIOTOverflowHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedIOTOverflowHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), jLabel, 292, 224);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), jScrollPane, 290, 242);
    }

    private void initIOTOverflowHashPTSButtons() {
        this.bnAddIOTOverflowHashPTS = new JButton(ADD_CAPTION);
        this.bnAddIOTOverflowHashPTS.addActionListener(new AddIOTOverflowHashPTSActionListener());
        this.bnAddIOTOverflowHashPTS.setEnabled(false);
        this.hashSubPartQuantityTS.add(this.bnAddIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnAddIOTOverflowHashPTS, 175, 280);
        this.bnRemoveIOTOverflowHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
        this.bnRemoveIOTOverflowHashPTS.addActionListener(new RemoveIOTOverflowHashPTSActionListener());
        this.hashSubPartQuantityTS.add(this.bnRemoveIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnRemoveIOTOverflowHashPTS, 175, 310);
        PKPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddIOTOverflowHashPTS, this.bnRemoveIOTOverflowHashPTS);
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 360));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initPartitioningView() {
        this.partitioning = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.GlobalPartitioning"), this.partitioning);
        this.initPartitioning();
    }

    protected SpringLayout getPartitioningLayout() {
        return (SpringLayout)this.partitioning.getLayout();
    }

    private void initPartitioning() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.AllColumns"));
        this.partitioning.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 340));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningLayout(), jLabel, 12, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), jScrollPane, 10, 30);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.SelectedColumns"));
        this.partitioning.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 340));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningLayout(), jLabel, 292, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), jScrollPane, 290, 30);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("PKPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioning.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnAdd, 175, 165);
        this.bnRemove = new JButton(Messages.getString("PKPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioning.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnRemove, 175, 195);
        PKPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void setPartitioning(boolean bl) {
        this.allColumnsList.setEnabled(bl);
        this.selectedColumnsList.setEnabled(bl);
        this.bnAdd.setEnabled(bl && this.allColumnsList.getSelectedIndex() != -1);
        this.bnAdd.setEnabled(bl && this.selectedColumnsList.getSelectedIndex() != -1);
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)this.pkProxy.getIndexGlobalPL();
        this.initPartColumns(indexGlobalPartitionsListOraclev10g);
        this.ifHashPQuantity.setValue((long)indexGlobalPartitionsListOraclev10g.getHashPQuantity());
        this.initHashPTS(indexGlobalPartitionsListOraclev10g);
        this.initIOTOverflowHashPTS(indexGlobalPartitionsListOraclev10g);
    }

    private void initHashPTS(IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g) {
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (indexGlobalPartitionsListOraclev10g != null && indexGlobalPartitionsListOraclev10g.getHashPartitionsTableSpacesSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedHashPTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allHashPTSModel.addElement(tableSpaceOracle);
        }
    }

    private void initIOTOverflowHashPTS(IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g) {
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (indexGlobalPartitionsListOraclev10g != null && indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTSSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedIOTOverflowHashPTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allIOTOverflowHashPTSModel.addElement(tableSpaceOracle);
        }
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.pkProxy.getName());
        this.tfName.setText(this.pkProxy.getName());
        this.tfTable.setText(this.pkProxy.getTable().getName());
        ColumnProxy[] columnProxyArray = this.pkProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            object = columnProxyArray[i];
            this.columnListModel.addElement(object);
        }
        this.cbInitially.setSelectedItem(this.pkProxy.getInitially());
        this.cbDeferrable.setSelectedItem(PKPropertyDialogOraclev10g.translateYesNoForDisplay(this.pkProxy.getDeferrable()));
        this.cbEnable.setSelectedItem(PKPropertyDialogOraclev10g.translateYesNoForDisplay(this.pkProxy.getEnable()));
        this.cbValidate.setSelectedItem(PKPropertyDialogOraclev10g.translateYesNoForDisplay(this.pkProxy.getValidate()));
        this.cbUsingIndex.setSelectedItem(this.translate(this.pkProxy.getUsingIndex(), PKProxyOraclev10g.getUsingIndexChoices(), USING_INDEX_CHOICES));
        this.cbIndexSort.setSelectedItem(this.translate(this.pkProxy.getIndexSort(), PKProxyOraclev10g.getIndexSortChoices(), SORT_CHOICES));
        this.cbTableSpace.setSelectedItem(this.pkProxy.getTableSpace());
        this.cbLogging.setSelectedItem(PKPropertyDialogOraclev10g.translateYesNoForDisplay(this.pkProxy.getLogging()));
        this.cbSegment.setSelectedItem(this.pkProxy.getIndexSegment());
        this.cbExTable.setSelectedItem(this.pkProxy.getExceptionsTable());
        this.cbComputeStatistics.setSelectedItem(PKPropertyDialogOraclev10g.translateYesNoForDisplay(this.pkProxy.getComputeStatistics()));
        this.cbExistingIndex.addItem(null);
        KeyObjectSet keyObjectSet = this.pkProxy.getTable().getKeySet();
        object = this.pkProxy.getTable().getIndexes().iterator();
        while (object.hasNext()) {
            ContainerObjectPH_ShortName containerObjectPH_ShortName = (ContainerObjectPH_ShortName)object.next();
            Index index = (Index)keyObjectSet.getByName(containerObjectPH_ShortName.toString());
            if (index == null) continue;
            IndexProxyOracle indexProxyOracle = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
            this.cbExistingIndex.addItem(indexProxyOracle);
        }
        this.cbExistingIndex.setSelectedItem(this.pkProxy.getExistingIndex());
        this.taCreateIndexStatement.insert(this.pkProxy.getCreateIndexStatement(), 0);
        if (this.pkProxy.getIndexGlobalPL() != null) {
            this.setPartitioning(true);
        }
        this.comment = this.pkProxy.getObject().getComment();
        this.commentInRDBMS = this.pkProxy.getObject().getCommentInRDBMS();
        if (this.pkProxy.isCommentChanged()) {
            this.getCommentsList().insert(this.pkProxy.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.pkProxy.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.pkProxy.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void initPartColumns(IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle) {
        this.selectedColumnsModel.clear();
        this.allColumnsModel.clear();
        ColumnProxy[] columnProxyArray = this.pkProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (indexGlobalPartitionsListOracle != null && indexGlobalPartitionsListOracle.getColumnSet().contains(columnProxy.getObjectID())) {
                this.selectedColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allColumnsModel.addElement(columnProxy);
        }
    }

    @Override
    protected void setProperties() {
        if (this.pkProxy != null) {
            Object object;
            Object object2;
            this.pkProxy.setName(this.tfName.getText());
            this.pkProxy.setInitially((String)this.cbInitially.getSelectedItem());
            this.pkProxy.setDeferrable(PKPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.pkProxy.setEnable(PKPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.pkProxy.setValidate(PKPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            this.pkProxy.setUsingIndex(this.translate((String)this.cbUsingIndex.getSelectedItem(), USING_INDEX_CHOICES, PKProxyOraclev10g.getUsingIndexChoices()));
            this.pkProxy.setIndexSort(this.translate((String)this.cbIndexSort.getSelectedItem(), SORT_CHOICES, PKProxyOraclev10g.getIndexSortChoices()));
            this.pkProxy.setComputeStatistics(PKPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbComputeStatistics.getSelectedItem()));
            this.pkProxy.setExistingIndex((IndexProxyOracle)this.cbExistingIndex.getSelectedItem());
            this.pkProxy.setCreateIndexStatement(this.taCreateIndexStatement.getText());
            Object object3 = this.cbTableSpace.getSelectedItem();
            if (object3 instanceof TableSpaceOracle) {
                this.pkProxy.setTableSpace((TableSpaceOracle)object3);
            } else {
                this.pkProxy.setTableSpace(null);
            }
            this.pkProxy.setLogging(PKPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object3 = this.cbSegment.getSelectedItem();
            if (object3 instanceof SegmentOracle) {
                this.pkProxy.setIndexSegment((SegmentOracle)object3);
            } else {
                this.pkProxy.setIndexSegment(null);
            }
            object3 = this.cbExTable.getSelectedItem();
            if (object3 instanceof TableProxyOracle) {
                this.pkProxy.setExceptionsTable((TableProxyOracle)object3);
            } else {
                this.pkProxy.setExceptionsTable(null);
            }
            String string = (String)this.cbUsingIndex.getSelectedItem();
            if (!string.equalsIgnoreCase(NO_INDEX) && !string.equalsIgnoreCase(LOCAL)) {
                object2 = this.pkProxy.getIndexGlobalPL() != null ? (IndexGlobalPartitionsListOraclev10g)this.pkProxy.getIndexGlobalPL() : (IndexGlobalPartitionsListOraclev10g)this.getStorageDesign().getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                this.pkProxy.setIndexGlobalPL((IndexGlobalPartitionsListOracle)object2);
                object = this.selectedColumnsModel.toArray();
                ((IndexGlobalPartitionsListOraclev10g)object2).clear();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    Object object4 = object[i];
                    if (!(object4 instanceof RelationalObjectProxy)) continue;
                    ((IndexGlobalPartitionsListOracle)object2).setGlobalPartColumns(((RelationalObjectProxy)object4).getObjectID());
                }
                if (string.equalsIgnoreCase(GLOBAL_HASH_PARTITIONED_BY_QUANTITY)) {
                    ((IndexGlobalPartitionsListOraclev10g)object2).setHashPQuantity(this.ifHashPQuantity.getIntValue());
                    Object[] objectArray = this.selectedHashPTSModel.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object5 = objectArray[i];
                        if (!(object5 instanceof TableSpaceOraclev10g)) continue;
                        ((IndexGlobalPartitionsListOraclev10g)object2).setHashPTableSpaces(((TableSpaceOraclev10g)object5).getObjectID());
                    }
                    Object[] objectArray2 = this.selectedIOTOverflowHashPTSModel.toArray();
                    for (int i = 0; i < objectArray2.length; ++i) {
                        Object object6 = objectArray2[i];
                        if (!(object6 instanceof TableSpaceOraclev10g)) continue;
                        ((IndexGlobalPartitionsListOraclev10g)object2).setIOTOverflowHashPTSSet(((TableSpaceOraclev10g)object6).getObjectID());
                    }
                } else {
                    ((IndexGlobalPartitionsListOraclev10g)object2).setHashPQuantity(0);
                    ((IndexGlobalPartitionsListOraclev10g)object2).setHashPTableSpaces("");
                    ((IndexGlobalPartitionsListOraclev10g)object2).setIOTOverflowHashPTSSet("");
                }
            } else if (this.pkProxy.getIndexGlobalPL() != null) {
                object2 = this.pkProxy.getIndexGlobalPL();
                this.pkProxy.setIndexGlobalPL(null);
                this.getStorageDesign().getIndexGlobalPartitionsListSet().remove((ModelObject)object2);
            }
            object2 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty((String)object2) && !this.comment.equals(object2)) {
                this.pkProxy.setComment((String)object2);
                this.pkProxy.setCommentChanged(true);
            } else {
                this.pkProxy.setComment("");
                this.pkProxy.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equals(object)) {
                this.pkProxy.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
                this.pkProxy.setCommentInRDBMSChanged(true);
            } else {
                this.pkProxy.setCommentInRDBMS("");
                this.pkProxy.setCommentInRDBMSChanged(false);
            }
        }
    }

    public class PartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)PKPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem();
            if (string.equalsIgnoreCase(NO_INDEX) || string.equalsIgnoreCase(PKPropertyDialogOraclev10g.LOCAL)) {
                PKPropertyDialogOraclev10g.this.allColumnsList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAdd.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemove.setEnabled(false);
                PKPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(false);
                PKPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
            } else if (string.equalsIgnoreCase(PKPropertyDialogOraclev10g.GLOBAL_BY_RANGE)) {
                PKPropertyDialogOraclev10g.this.allColumnsList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.bnAdd.setEnabled(PKPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.bnRemove.setEnabled(PKPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(false);
                PKPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.initPartColumns(PKPropertyDialogOraclev10g.this.pkProxy.getIndexGlobalPL());
            } else if (string.equalsIgnoreCase(PKPropertyDialogOraclev10g.GLOBAL_HASH_PARTITIONED_BY_QUANTITY)) {
                PKPropertyDialogOraclev10g.this.allColumnsList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.bnAdd.setEnabled(PKPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.bnRemove.setEnabled(PKPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(true);
                PKPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(PKPropertyDialogOraclev10g.this.allHashPTSList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(PKPropertyDialogOraclev10g.this.selectedHashPTSList.getSelectedIndex() != -1);
                if (((TableProxyOracle)PKPropertyDialogOraclev10g.this.pkProxy.getTableProxy()).getOrganization().equalsIgnoreCase("INDEX")) {
                    PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(true);
                    PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(true);
                    PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
                    PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
                    PKPropertyDialogOraclev10g.this.initIOTOverflowHashPTS((IndexGlobalPartitionsListOraclev10g)PKPropertyDialogOraclev10g.this.pkProxy.getIndexGlobalPL());
                } else {
                    PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                    PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                }
                PKPropertyDialogOraclev10g.this.initPartColumns(PKPropertyDialogOraclev10g.this.pkProxy.getIndexGlobalPL());
                PKPropertyDialogOraclev10g.this.initHashPTS((IndexGlobalPartitionsListOraclev10g)PKPropertyDialogOraclev10g.this.pkProxy.getIndexGlobalPL());
            } else if (string.equalsIgnoreCase(PKPropertyDialogOraclev10g.GLOBAL_HASH_PARTITIONED_BY_LIST)) {
                PKPropertyDialogOraclev10g.this.allColumnsList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(true);
                PKPropertyDialogOraclev10g.this.bnAdd.setEnabled(PKPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.bnRemove.setEnabled(PKPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() != -1);
                PKPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(false);
                PKPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                PKPropertyDialogOraclev10g.this.initPartColumns(PKPropertyDialogOraclev10g.this.pkProxy.getIndexGlobalPL());
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev10g.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev10g.this.allColumnsModel.contains(object)) continue;
                    PKPropertyDialogOraclev10g.this.allColumnsModel.addElement(object);
                    PKPropertyDialogOraclev10g.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev10g.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev10g.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev10g.this.selectedColumnsModel.contains(object)) continue;
                    PKPropertyDialogOraclev10g.this.selectedColumnsModel.addElement(object);
                    PKPropertyDialogOraclev10g.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev10g.this.bnRemove.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev10g.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev10g.this.bnAdd.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev10g.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveIOTOverflowHashPTSActionListener
    implements ActionListener {
        private RemoveIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.contains(object)) continue;
                    PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.addElement(object);
                    PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddIOTOverflowHashPTSActionListener
    implements ActionListener {
        private AddIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.contains(object)) continue;
                    PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.addElement(object);
                    PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev10g.this.selectedHashPTSModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev10g.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev10g.this.allHashPTSModel.contains(object)) continue;
                    PKPropertyDialogOraclev10g.this.allHashPTSModel.addElement(object);
                    PKPropertyDialogOraclev10g.this.selectedHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev10g.this.allHashPTSModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev10g.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev10g.this.selectedHashPTSModel.contains(object)) continue;
                    PKPropertyDialogOraclev10g.this.selectedHashPTSModel.addElement(object);
                    PKPropertyDialogOraclev10g.this.allHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev10g.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev10g.this.allHashPTSList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }
}

