/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.LocalIndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ListStorageTemplatePartitionPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private ListStorageTemplatePartitionOraclev10g template;
    private JTextField tfValueList;
    private JComboBox cbTableSpace;
    private JComboBox cbCompression;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public ListStorageTemplatePartitionPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.template = (ListStorageTemplatePartitionOraclev10g)storageObject;
        this.setHeight(170);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.ListSubpartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initTableSpace();
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initDataSegmentCompression();
        }
    }

    private void initValueList() {
        JLabel jLabel = new JLabel(Messages.getString("ListStorageTemplatePartitionPropertyDialogOraclev10g.ValueList"));
        this.general.add(jLabel);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    private void initDataSegmentCompression() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Compression"));
        this.general.add(jLabel);
        this.cbCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbCompression);
        this.cbCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompression);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCompression, 110);
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initIndexesTab() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.getList());
        jScrollPane.setPreferredSize(new Dimension(390, 60));
        jPanel.add((Component)this.getIndexesButtonPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getPane().addTab(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.LocalIndexes"), jPanel);
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.edit = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ListStorageTemplatePartitionPropertyDialogOraclev10g.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.edit);
            jToolBar.addSeparator();
            this.indexesButtonPanel.add(jToolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private void editSelected() {
        Object e = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev10g localIndexPropertyDialogOraclev10g = new LocalIndexPropertyDialogOraclev10g(this.template.getDesign().getAppView(), this.getStorageDesign(), this.template, (StorageObject)e);
        localIndexPropertyDialogOraclev10g.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    @Override
    public void initProperties() {
        Object object;
        Object object2;
        IndexProxy[] indexProxyArray;
        this.initCaption(this.template.getName());
        this.tfName.setText(this.template.getName());
        this.tfValueList.setText(this.template.getValueList());
        this.selectObject(this.cbTableSpace, this.template.getTablespace());
        if (this.cbCompression != null) {
            this.cbCompression.setSelectedItem(ListStorageTemplatePartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.template.getDataSegmentCompression()));
        }
        TableProxyOraclev10g tableProxyOraclev10g = null;
        if (this.template.getPartOfStorageTable() != null) {
            tableProxyOraclev10g = (TableProxyOraclev10g)this.template.getPartOfStorageTable();
        } else {
            indexProxyArray = this.template.getSubPartitionOf();
            object2 = null;
            if (indexProxyArray instanceof PartitionOracle) {
                object2 = ((PartitionOracle)indexProxyArray).getPartitionList();
            } else if (indexProxyArray instanceof ListPartitionOracle) {
                object2 = ((ListPartitionOracle)indexProxyArray).getPartitionList();
            } else if (indexProxyArray instanceof HashPartitionOracle) {
                object2 = ((HashPartitionOracle)indexProxyArray).getPartitionList();
            }
            if (object2 != null && (tableProxyOraclev10g = (TableProxyOraclev10g)((PartitionListOracle)object2).getTable()) == null && (object = ((PartitionListOracle)object2).getSnapshot()) != null) {
                tableProxyOraclev10g = (TableProxyOraclev10g)((SnapshotOracle)object).getImplementedTable();
            }
        }
        if (tableProxyOraclev10g != null) {
            Object object3;
            indexProxyArray = tableProxyOraclev10g.getIndexProxies();
            for (int i = 0; i < indexProxyArray.length; ++i) {
                object = (IndexProxyOracle)indexProxyArray[i];
                if (object == null || !((IndexProxyOracle)object).getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(object);
            }
            object2 = tableProxyOraclev10g.getBjIndexes().iterator();
            while (object2.hasNext()) {
                object = (BitmapJoinIndexOraclev10g)object2.next();
                if (!((BitmapJoinIndexOracle)object).getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(object);
            }
            object = tableProxyOraclev10g.getUniqueKeys().iterator();
            while (object.hasNext()) {
                object3 = (UniqueOraclev10g)object.next();
                if (!((UniqueOraclev10g)object3).getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(object3);
            }
            object3 = tableProxyOraclev10g.getPrimaryKeys().iterator();
            while (object3.hasNext()) {
                PKProxyOraclev10g pKProxyOraclev10g = (PKProxyOraclev10g)object3.next();
                if (!pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(pKProxyOraclev10g);
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (this.listModel.get(i) instanceof IndexProxyOraclev10g) {
                object2 = (IndexProxyOraclev10g)this.listModel.get(i);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, (StorageObject)object2);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setPartition(this.template);
                ((LocalIndexProperties)object).setIndex((StorageObject)object2);
                continue;
            }
            if (this.listModel.get(i) instanceof BitmapJoinIndexOraclev10g) {
                object2 = (BitmapJoinIndexOraclev10g)this.listModel.get(i);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, (StorageObject)object2);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setPartition(this.template);
                ((LocalIndexProperties)object).setIndex((StorageObject)object2);
                continue;
            }
            if (this.listModel.get(i) instanceof UniqueOraclev10g) {
                object2 = (UniqueOraclev10g)this.listModel.get(i);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, (StorageObject)object2);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setPartition(this.template);
                ((LocalIndexProperties)object).setIndex((StorageObject)object2);
                continue;
            }
            if (!(this.listModel.get(i) instanceof PKProxyOraclev10g)) continue;
            object2 = (PKProxyOraclev10g)this.listModel.get(i);
            object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, (StorageObject)object2);
            if (object != null) continue;
            object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            ((LocalIndexProperties)object).setPartition(this.template);
            ((LocalIndexProperties)object).setIndex((StorageObject)object2);
        }
        this.getCommentsList().insert(this.template.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.template != null) {
            this.template.setName(this.tfName.getText());
            this.template.setValueList(this.tfValueList.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.template.setTablespace((TableSpaceOracle)object);
            } else {
                this.template.setTablespace(null);
            }
            if (this.cbCompression != null) {
                this.template.setDataSegmentCompression(ListStorageTemplatePartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbCompression.getSelectedItem()));
            }
            this.template.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ListStorageTemplatePartitionPropertyDialogOraclev10g.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Index) {
                this.setText(((Index)object).getName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

