/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ExternalTableOraclePropertyDialogv10g
extends AbstractOraclePropertyDialog {
    private ExternalTableOraclev10g table;
    protected JTextField tfAccessDriverType;
    protected JTextField tfLocation;
    protected JComboBox cbOwner;
    protected JComboBox cbDefaultDir;
    protected JComboBox cbAccessParamType;
    private JPanel opaqueFormatSpecPanel;
    private JPanel clobSubqueryPanel;
    private JTextArea opaqueFormatSpecArea;
    private JTextArea clobSubqueryArea;
    private JComboBox cbParallel;
    private JIntegerField ifParallelNum;
    private JTextField tfRejectLimit;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public ExternalTableOraclePropertyDialogv10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (ExternalTableOraclev10g)storageObject;
        this.setHeight(370);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ExternalTableOraclePropertyDialog.ExternalTableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initAccessDriverType();
        this.initDefaultDir();
        this.initAccessParametersType();
        this.initLocation();
        this.initParallel();
        this.initParallelNum();
        this.initRejectLimit();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initAccessDriverType() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.AccessDriver"));
        this.general.add(jLabel);
        this.tfAccessDriverType = new JTextField("", 26);
        this.general.add(this.tfAccessDriverType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfAccessDriverType, 80);
    }

    private void initDefaultDir() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.DefaultDir"));
        this.general.add(jLabel);
        this.cbDefaultDir = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDirectorySet().toArray(), this.cbDefaultDir);
        }
        this.setBG(this.cbDefaultDir);
        this.cbDefaultDir.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefaultDir);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDefaultDir, 110);
    }

    private void initAccessParametersType() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.AccessParams"));
        this.general.add(jLabel);
        this.cbAccessParamType = new JComboBox<String>(ExternalTableOracle.getAccessParametersChoices());
        this.setBG(this.cbAccessParamType);
        this.cbAccessParamType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAccessParamType);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbAccessParamType, 140);
    }

    private void initLocation() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.Location"));
        this.general.add(jLabel);
        this.tfLocation = new JTextField("", 26);
        this.general.add(this.tfLocation);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfLocation, 170);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(ConstantsOracle.PARALLEL_CHOICES);
        this.setBG(this.cbParallel);
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbParallel, 200);
    }

    private void initParallelNum() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.ParallelNum"));
        this.general.add(jLabel);
        this.ifParallelNum = new JIntegerField(0, 26);
        this.general.add(this.ifParallelNum);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifParallelNum, 230);
    }

    private void initRejectLimit() {
        JLabel jLabel = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.RejectLimit"));
        this.general.add(jLabel);
        this.tfRejectLimit = new JTextField("", 26);
        this.general.add(this.tfRejectLimit);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfRejectLimit, 260);
    }

    @Override
    protected void addTabs() {
        this.initOpaqueFormatSpecView();
        this.initClobSubqueryView();
    }

    protected SpringLayout getOpaqueFormatSpecLayout() {
        return (SpringLayout)this.opaqueFormatSpecPanel.getLayout();
    }

    protected SpringLayout getClobSubqueryLayout() {
        return (SpringLayout)this.clobSubqueryPanel.getLayout();
    }

    private void initOpaqueFormatSpecView() {
        this.opaqueFormatSpecPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ExternalTableOraclePropertyDialog.OpaqueFormatSpec"), this.opaqueFormatSpecPanel);
        this.initOpaqueFormatSpec();
    }

    private void initOpaqueFormatSpec() {
        this.opaqueFormatSpecArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.opaqueFormatSpecArea);
        jScrollPane.setPreferredSize(new Dimension(395, 270));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.opaqueFormatSpecArea.setLineWrap(true);
        this.opaqueFormatSpecPanel.add(jScrollPane);
        this.setObjectConstraints(this.getOpaqueFormatSpecLayout(), jScrollPane, 10, 12);
    }

    private void initClobSubqueryView() {
        this.clobSubqueryPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ExternalTableOraclePropertyDialog.CLOBSubquery"), this.clobSubqueryPanel);
        this.initClobSubquery();
    }

    private void initClobSubquery() {
        this.clobSubqueryArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.clobSubqueryArea);
        jScrollPane.setPreferredSize(new Dimension(395, 270));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.opaqueFormatSpecArea.setLineWrap(true);
        this.clobSubqueryPanel.add(jScrollPane);
        this.setObjectConstraints(this.getClobSubqueryLayout(), jScrollPane, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.cbOwner.setSelectedItem(this.table.getOwner());
        this.tfAccessDriverType.setText(this.table.getAccessDriverType());
        this.cbDefaultDir.setSelectedItem(this.table.getDefaultDir());
        this.cbAccessParamType.setSelectedItem(this.table.getAccessParametersType());
        this.tfLocation.setText(this.table.getLocation());
        this.cbParallel.setSelectedItem(this.table.getParallel());
        this.ifParallelNum.setValue((long)this.table.getParallelNum());
        this.tfRejectLimit.setText(this.table.getRejectLimit());
        this.taComments.setText(this.table.getComment());
        this.opaqueFormatSpecArea.setText(this.table.getOpaqueFormatSpec());
        this.clobSubqueryArea.setText(this.table.getClobSubquery());
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            this.table.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.table.setName(this.tfName.getText());
            this.table.setAccessDriverType(this.tfAccessDriverType.getText());
            this.table.setDefaultDir((DirectoryOracle)this.cbDefaultDir.getSelectedItem());
            this.table.setAccessParametersType((String)this.cbAccessParamType.getSelectedItem());
            this.table.setLocation(this.tfLocation.getText());
            this.table.setParallel((String)this.cbParallel.getSelectedItem());
            this.table.setParallelNum(this.ifParallelNum.getIntValue());
            this.table.setRejectLimit(this.tfRejectLimit.getText());
            this.table.setOpaqueFormatSpec(this.opaqueFormatSpecArea.getText());
            this.table.setClobSubquery(this.clobSubqueryArea.getText());
            this.table.setComment(this.taComments.getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("ExternalTableOraclePropertyDialogv10g.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 290);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExternalTableOraclePropertyDialogv10g.this.dialog = new ObjectPermissionsDialogOracle(ExternalTableOraclePropertyDialogv10g.this.getAppView(), ExternalTableOraclePropertyDialogv10g.this.getStorageDesign(), ExternalTableOraclePropertyDialogv10g.this.table);
            ExternalTableOraclePropertyDialogv10g.this.dialog.showDialog();
        }
    }
}

