/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DiskGroupPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private DiskGroupOraclev10g diskGroup;
    private JComboBox cbRedundancy;

    public DiskGroupPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.diskGroup = (DiskGroupOraclev10g)storageObject;
        this.setHeight(110);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DiskGroupPropertyDialogOraclev10g.DiskGroup");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initRedundancy();
    }

    private void initRedundancy() {
        JLabel jLabel = new JLabel(Messages.getString("DiskGroupPropertyDialogOraclev10g.Redundancy"));
        this.general.add(jLabel);
        this.cbRedundancy = new JComboBox<String>(DiskGroupOraclev10g.getRedundancyStates());
        this.setBG(this.cbRedundancy);
        this.cbRedundancy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRedundancy);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbRedundancy, 50);
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.diskGroup.getName());
        this.cbRedundancy.setSelectedItem(this.diskGroup.getRedundancy());
        this.getCommentsList().insert(this.diskGroup.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        this.diskGroup.setName(this.tfName.getText());
        this.diskGroup.setRedundancy((String)this.cbRedundancy.getSelectedItem());
        this.diskGroup.setComment(this.getCommentsList().getText());
    }
}

