/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class CollectionTypePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private CollectionTypeProxyOraclev10g type;
    private JComboBox cbOwner;
    private JTextField tfType;
    private JIntegerField ifMaxElement;
    private JTextField tfDataType;
    private JTextField tfObjectIdentifier;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public CollectionTypePropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.type = (CollectionTypeProxyOraclev10g)storageObject;
        this.setHeight(270);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CollectionTypePropertyDialogOracle.CollectionTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initObjectIdentifier();
        this.initOwner();
        this.initType();
        this.initMaxElement();
        this.initDataType();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox<Object>(this.getStorageDesign().getUserSet().toArray());
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initObjectIdentifier() {
        JLabel jLabel = new JLabel(Messages.getString("CollectionTypePropertyDialogOraclev10g.ObjectIdentifier"));
        this.general.add(jLabel);
        this.tfObjectIdentifier = new JTextField("", 26);
        this.general.add(this.tfObjectIdentifier);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfObjectIdentifier, 80);
    }

    private void initType() {
        JLabel jLabel = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.CollectionType"));
        this.general.add(jLabel);
        this.tfType = new JTextField("", 26);
        this.tfType.setEnabled(false);
        this.general.add(this.tfType);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfType, 110);
    }

    private void initMaxElement() {
        JLabel jLabel = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.MaxElement"));
        this.general.add(jLabel);
        this.ifMaxElement = new JIntegerField(0, 26);
        this.ifMaxElement.setEnabled(false);
        this.general.add(this.ifMaxElement);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifMaxElement, 140);
    }

    private void initDataType() {
        JLabel jLabel = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.DataType"));
        this.general.add(jLabel);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfDataType, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.type.getName());
        this.tfName.setText(this.type.getName());
        this.tfType.setText(this.type.getType());
        this.ifMaxElement.setValue((long)this.type.getMaxElement());
        this.tfDataType.setText(this.type.getDataType());
        this.cbOwner.setSelectedItem(this.type.getOwner());
        this.tfObjectIdentifier.setText(this.type.getGlobalOid());
        this.getCommentsList().insert(this.type.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.type != null) {
            this.type.setName(this.tfName.getText());
            this.type.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.type.setGlobalOid(this.tfObjectIdentifier.getText());
            this.type.setComment(this.getCommentsList().getText());
        }
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("CollectionTypePropertyDialogOraclev10g.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 210);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CollectionTypePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(CollectionTypePropertyDialogOraclev10g.this.getAppView(), CollectionTypePropertyDialogOraclev10g.this.getStorageDesign(), CollectionTypePropertyDialogOraclev10g.this.type);
            CollectionTypePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

