/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BitmapJoinIndexPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private BitmapJoinIndexOraclev10g index;
    protected JTextField tfTablespace;
    protected JComboBox cbUser;
    protected JComboBox cbLocalPartitioning;
    protected JComboBox cbLogging;
    protected JComboBox cbSegment;
    protected JComboBox cbParallel;
    private JTextField tfDegree;
    protected JComboBox cbComputeStatistics;
    protected JComboBox cbOnline;
    protected JIntegerField ifCompress;
    private JPanel columnsPanel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JPanel sortOrderPanel;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JPanel dimensionKeysPanel;
    private JTable dimensionKeysTable;
    private KeysTableModel keysModel;
    private JPanel dimensionColumnsPanel;
    private JTable dimensionColumnsTable;
    private KeysTableModel columnsModel;
    private JPanel hashSubPartTS;
    private JList allHashSubPartTSList;
    private JList selectedHashSubPartTSList;
    private DefaultListModel allHashSubPartTSModel;
    private DefaultListModel selectedHashSubPartTSModel;
    private JButton bnAddHashSubPartTS;
    private JButton bnRemoveHashSubPartTS;

    public BitmapJoinIndexPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (BitmapJoinIndexOraclev10g)storageObject;
        this.setHeight(420);
        this.initCommentsView(this.getPane().getPreferredSize().height - 90);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    public BitmapJoinIndexPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, StorageObject storageObject2) {
        super(applicationView, storageDesign, storageObject);
        this.index = (BitmapJoinIndexOraclev10g)storageObject2;
        this.setHeight(420);
        this.initCommentsView(this.getPane().getPreferredSize().height - 90);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BitmapJoinIndexPropertyDialogOracle.BitmapJoinIndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initLocalPartitioning();
        this.initTablespace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initParallel();
        this.initDegree();
        this.initComputeStatistics();
        this.initOnline();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        if (this.storageDesign != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbUser);
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initLocalPartitioning() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.LocalPartitioning"));
        this.general.add(jLabel);
        this.cbLocalPartitioning = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLocalPartitioning);
        this.cbLocalPartitioning.addActionListener(new LocalPartitionListener());
        this.cbLocalPartitioning.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLocalPartitioning);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbLocalPartitioning, 80);
    }

    private void initTablespace() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Tablespace"));
        this.general.add(jLabel);
        this.tfTablespace = new JTextField("", 26);
        this.general.add(this.tfTablespace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfTablespace, 110);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        if (this.storageDesign != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.setBG(this.cbSegment);
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    private void initCompress() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Compress"));
        this.general.add(jLabel);
        this.ifCompress = new JIntegerField(0, 26);
        this.general.add(this.ifCompress);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifCompress, 200);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbParallel, 230);
    }

    private void initDegree() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Degree"));
        this.general.add(jLabel);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDegree);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfDegree, 260);
    }

    private void initComputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ComputeStatistics"));
        this.general.add(jLabel);
        this.cbComputeStatistics = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStatistics);
        this.cbComputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbComputeStatistics);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbComputeStatistics, 290);
    }

    private void initOnline() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Online"));
        this.general.add(jLabel);
        this.cbOnline = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbOnline, 320);
    }

    @Override
    protected void addTabs() {
        this.initIndexColumnsView();
        this.initSortOrderView(this.getPane().getPreferredSize().height - 90);
        this.initDimensionKeysView();
        this.initDimensionColumnsView();
        this.initHashPartTSView();
    }

    private void initDimensionColumnsView() {
        this.dimensionColumnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTablesColumns"), this.dimensionColumnsPanel);
        this.dimensionColumnsTable = new DimensionColumnsTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.dimensionColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(417, 355));
        this.columnsModel = (KeysTableModel)this.dimensionColumnsTable.getModel();
        this.dimensionColumnsPanel.add(jScrollPane);
    }

    private void initDimensionKeysView() {
        this.dimensionKeysPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTablesKeys"), this.dimensionKeysPanel);
        this.dimensionKeysTable = new OptionsTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.dimensionKeysTable);
        jScrollPane.setPreferredSize(new Dimension(417, 355));
        this.keysModel = (KeysTableModel)this.dimensionKeysTable.getModel();
        this.dimensionKeysPanel.add(jScrollPane);
    }

    private void initIndexColumnsView() {
        this.columnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.IndexColumns"), this.columnsPanel);
        this.initColumns();
    }

    protected SpringLayout getIndexColumnsLayout() {
        return (SpringLayout)this.columnsPanel.getLayout();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.AllColumns"));
        this.columnsPanel.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new LongNameCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 310));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(jScrollPane);
        this.setLabelConstraints(this.getIndexColumnsLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getIndexColumnsLayout(), jScrollPane, 10, 34);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.SelectedColumns"));
        this.columnsPanel.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        this.selectedColumnsList.setCellRenderer(new LongNameCellRenderer());
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 310));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(jScrollPane);
        this.setLabelConstraints(this.getIndexColumnsLayout(), jLabel, 292, 14);
        this.setObjectConstraints(this.getIndexColumnsLayout(), jScrollPane, 290, 34);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(ADD_CAPTION);
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.columnsPanel.add(this.bnAddColumns);
        this.setObjectConstraints(this.getIndexColumnsLayout(), this.bnAddColumns, 175, 145);
        this.bnRemoveColumns = new JButton(REMOVE_CAPTION);
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.columnsPanel.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getIndexColumnsLayout(), this.bnRemoveColumns, 175, 175);
        BitmapJoinIndexPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected void initSortOrderView(int n) {
        this.sortOrderPanel = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ColumnsSortOrder"), this.sortOrderPanel);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.sortOrderPanel.add(jScrollPane);
    }

    private void initColumnsSortOrderAndDimensionKeys() {
        ColumnProxyOraclev10g[] columnProxyOraclev10gArray = new ColumnProxyOraclev10g[this.selectedColumnsModel.size()];
        for (int i = 0; i < this.selectedColumnsModel.size(); ++i) {
            columnProxyOraclev10gArray[i] = (ColumnProxyOraclev10g)this.selectedColumnsModel.elementAt(i);
        }
        this.initColumnsSortOrder(columnProxyOraclev10gArray);
        this.initDimensionKeys(columnProxyOraclev10gArray);
    }

    protected void initColumnsSortOrder(ColumnProxyOraclev10g[] columnProxyOraclev10gArray) {
        this.sortModel = new ColumnsSortOrderModel(this.index, columnProxyOraclev10gArray);
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void initDimensionKeys(ColumnProxyOraclev10g[] columnProxyOraclev10gArray) {
        int n = this.keysModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.keysModel.removeRow(0);
        }
        ArrayList<TableProxyOracle> arrayList = new ArrayList<TableProxyOracle>();
        for (int i = 0; i < columnProxyOraclev10gArray.length; ++i) {
            TableProxyOracle tableProxyOracle = columnProxyOraclev10gArray[i].getTableProxy();
            if (arrayList.contains(tableProxyOracle)) continue;
            arrayList.add(tableProxyOracle);
            ModelObject modelObject = this.index.getDimensionKey(tableProxyOracle);
            if (modelObject == null) {
                modelObject = tableProxyOracle.getPrimaryKeys().size() > 0 ? tableProxyOracle.getPrimaryKeys().getElement(0) : tableProxyOracle.getUniqueKeys().getElement(0);
            }
            this.keysModel.addRow(new Object[]{tableProxyOracle, modelObject});
        }
    }

    private void initDimensionColumns() {
        int n;
        Object[] objectArray = new Object[this.keysModel.getRowCount()];
        for (n = 0; n < this.keysModel.getRowCount(); ++n) {
            if (!(this.keysModel.getValueAt(n, 1) instanceof IndexProxy)) continue;
            objectArray[n] = this.keysModel.getValueAt(n, 1);
        }
        n = this.columnsModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.columnsModel.removeRow(0);
        }
        if (this.index.getTable().getColumnProxies().length > 0) {
            ArrayList<ColumnProxy> arrayList = new ArrayList<ColumnProxy>();
            for (int i = 0; i < objectArray.length; ++i) {
                ColumnProxy[] columnProxyArray = ((IndexProxy)objectArray[i]).getColumnProxies();
                for (int j = 0; j < columnProxyArray.length; ++j) {
                    if (arrayList.contains(columnProxyArray[j])) continue;
                    arrayList.add(columnProxyArray[j]);
                    ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)this.index.getJoinColumn((ColumnProxyOraclev10g)columnProxyArray[j]);
                    if (columnProxyOraclev10g == null) {
                        columnProxyOraclev10g = (ColumnProxyOraclev10g)this.index.getTable().getColumnProxies()[0];
                    }
                    this.columnsModel.addRow(new Object[]{columnProxyArray[j], columnProxyOraclev10g});
                }
            }
        }
    }

    protected void applyColumnsSortOrder() {
        Object[] objectArray = this.sortModel.getRows();
        this.index.clearIndexColumns();
        if (objectArray.length > 0) {
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken().trim();
                this.index.setIndexColumns(string);
                this.index.setIndexColumns(string2);
            }
        } else {
            Object[] objectArray2 = this.selectedColumnsModel.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                this.index.setIndexColumns(((ColumnProxyOraclev10g)objectArray2[i]).getObjectID());
                this.index.setIndexColumns("ASC");
            }
        }
    }

    protected void setDimensionKeys() {
        this.index.clearDimensionKeys();
        for (int i = 0; i < this.keysModel.getRowCount(); ++i) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)this.keysModel.getValueAt(i, 0);
            IndexProxy indexProxy = (IndexProxy)this.keysModel.getValueAt(i, 1);
            this.index.setDimensionKeys(tableProxyOracle.getObjectID());
            this.index.setDimensionKeys(indexProxy.getObjectID());
        }
    }

    protected void setJoinColumns() {
        this.index.clearJoinColumns();
        for (int i = 0; i < this.columnsModel.getRowCount(); ++i) {
            ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)this.columnsModel.getValueAt(i, 0);
            ColumnProxyOraclev10g columnProxyOraclev10g2 = (ColumnProxyOraclev10g)this.columnsModel.getValueAt(i, 1);
            this.index.setJoinColumns(columnProxyOraclev10g.getObjectID());
            this.index.setJoinColumns(columnProxyOraclev10g2.getObjectID());
        }
    }

    private void initHashPartTSView() {
        this.hashSubPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.HashCompositeByHashTablespaces"), this.hashSubPartTS);
        this.initHashPartTablespaces();
    }

    private void initHashPartTablespaces() {
        this.initAllHashSubPartTSList();
        this.initSelectedHashSubPartTSList();
        this.initHashSubPartTSButtons();
    }

    private void initAllHashSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.AllTableSpaces"));
        this.hashSubPartTS.add(jLabel);
        this.allHashSubPartTSModel = new DefaultListModel();
        this.allHashSubPartTSList = new JList(this.allHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allHashSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 310));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), jScrollPane, 10, 34);
    }

    private void initSelectedHashSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.SelectedTableSpaces"));
        this.hashSubPartTS.add(jLabel);
        this.selectedHashSubPartTSModel = new DefaultListModel();
        this.selectedHashSubPartTSList = new JList(this.selectedHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedHashSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 310));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSLayout(), jLabel, 292, 14);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), jScrollPane, 290, 34);
    }

    private void initHashSubPartTSButtons() {
        this.bnAddHashSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddHashSubPartTS.addActionListener(new AddHashSubPartTSActionListener());
        this.bnAddHashSubPartTS.setEnabled(false);
        this.hashSubPartTS.add(this.bnAddHashSubPartTS);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), this.bnAddHashSubPartTS, 175, 145);
        this.bnRemoveHashSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashSubPartTS.setEnabled(false);
        this.bnRemoveHashSubPartTS.addActionListener(new RemoveHashSubPartTSActionListener());
        this.hashSubPartTS.add(this.bnRemoveHashSubPartTS);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), this.bnRemoveHashSubPartTS, 175, 175);
        BitmapJoinIndexPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddHashSubPartTS, this.bnRemoveHashSubPartTS);
    }

    protected SpringLayout getHashSubPartTSLayout() {
        return (SpringLayout)this.hashSubPartTS.getLayout();
    }

    @Override
    public void initProperties() {
        Object object;
        Object object22;
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.cbUser.setSelectedItem(this.index.getUser());
        this.cbLocalPartitioning.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getLocalPartitioning()));
        this.tfTablespace.setText(this.index.getTablespace());
        this.cbLogging.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getLogging()));
        this.cbSegment.setSelectedItem(this.index.getSegment());
        this.ifCompress.setValue((long)this.index.getCompress());
        this.cbParallel.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getParallel()));
        this.tfDegree.setText(this.index.getDegree());
        this.cbComputeStatistics.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getComputeStatistics()));
        this.cbOnline.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getOnline()));
        TableProxySet tableProxySet = this.getStorageDesign().getTableProxySet();
        tableProxySet.sort();
        for (Object object3 : tableProxySet.getElements()) {
            if (this.index.getTable() == object3 || ((TableProxyOracle)object3).getPrimaryKeys().size() <= 0 && ((TableProxyOracle)object3).getUniqueKeys().size() <= 0) continue;
            object22 = ((TableProxy)object3).getColumns();
            object22.sortByName();
            for (int i = 0; i < object22.size(); ++i) {
                this.allColumnsModel.addElement(object22.getElement(i));
            }
        }
        for (Object object22 : this.index.getIndexColumnSet()) {
            StorageObject storageObject = this.storageDesign.getStorageObject((String)object22);
            if (!(storageObject instanceof ColumnProxyOracle)) continue;
            this.allColumnsModel.removeElement(storageObject);
            this.selectedColumnsModel.addElement(storageObject);
        }
        this.initColumnsSortOrderAndDimensionKeys();
        this.initDimensionColumns();
        object22 = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < ((TableSpaceOracle[])object22).length; ++i) {
            object = object22[i];
            if (this.index != null && this.index.getHashPartitionsTableSpacesSet().contains(((StorageObject)object).getName())) {
                this.selectedHashSubPartTSModel.addElement(object);
                continue;
            }
            this.allHashSubPartTSModel.addElement(object);
        }
        PartitionListOracle partitionListOracle = this.index.getTable().getPartitionList();
        object = null;
        String string = "";
        if (partitionListOracle != null) {
            object = partitionListOracle.getPartitionType();
            string = partitionListOracle.getSubpartitionType();
        }
        if (this.index.getLocalPartitioning().equalsIgnoreCase("YES") && object != null && (((String)object).equalsIgnoreCase("HASH BY QUANTITY") || ((String)object).equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || string.equalsIgnoreCase("HASH"))) {
            this.allHashSubPartTSList.setEnabled(true);
            this.selectedHashSubPartTSList.setEnabled(true);
            this.bnAddHashSubPartTS.setEnabled(this.allHashSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveHashSubPartTS.setEnabled(this.selectedHashSubPartTSList.getSelectedIndex() != -1);
        } else {
            this.allHashSubPartTSList.setEnabled(false);
            this.selectedHashSubPartTSList.setEnabled(false);
            this.bnAddHashSubPartTS.setEnabled(false);
            this.bnRemoveHashSubPartTS.setEnabled(false);
        }
        this.getCommentsList().insert(this.index.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setUser((UserOracle)this.cbUser.getSelectedItem());
            this.index.setName(this.tfName.getText());
            this.index.setLocalPartitioning(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLocalPartitioning.getSelectedItem()));
            this.index.setTablespace(this.tfTablespace.getText());
            this.index.setLogging(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.index.setSegment((SegmentOracle)this.cbSegment.getSelectedItem());
            this.index.setCompress(this.ifCompress.getIntValue());
            this.index.setParallel(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.index.setDegree(this.tfDegree.getText());
            this.index.setComputeStatistics(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbComputeStatistics.getSelectedItem()));
            this.index.setOnline(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbOnline.getSelectedItem()));
            this.applyColumnsSortOrder();
            this.setDimensionKeys();
            this.setJoinColumns();
            Object[] objectArray = this.selectedHashSubPartTSModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof TableSpaceOracle)) continue;
                this.index.setHashSubPartitionsTableSpaces(((TableSpaceOracle)object).getObjectID());
            }
            this.index.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbUser.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class RemoveHashSubPartTSActionListener
    implements ActionListener {
        private RemoveHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.isEmpty()) {
                Object[] objectArray = BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.contains(object)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.addElement(object);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddHashSubPartTSActionListener
    implements ActionListener {
        private AddHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.isEmpty()) {
                Object[] objectArray = BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.contains(object)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.addElement(object);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    protected class ColumnsSortOrderModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("BitmapJoinIndexPropertyDialogOracle.ColumnName"), Messages.getString("BitmapJoinIndexPropertyDialogOracle.SortOrder")};
        private ArrayList columns = new ArrayList();

        public ColumnsSortOrderModel(BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g, ColumnProxyOraclev10g[] columnProxyOraclev10gArray) {
            for (int i = 0; i < columnProxyOraclev10gArray.length; ++i) {
                this.columns.add(new ColumnNode(bitmapJoinIndexOraclev10g, columnProxyOraclev10gArray[i]));
            }
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.columns.size();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ColumnNode columnNode = (ColumnNode)this.columns.get(n);
            if (n2 == 0) {
                return columnNode;
            }
            return columnNode.sortOrder;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable()) {
                return false;
            }
            return n2 != 0;
        }

        public Object[] getRows() {
            int n = this.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = ((ColumnNode)this.getValueAt(i, 0)).getColumnId() + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ColumnNode columnNode = (ColumnNode)this.columns.get(n);
            if (n2 == 1) {
                columnNode.sortOrder = (String)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public void setUpSortOrderColumn(TableColumn tableColumn) {
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem("ASC");
            jComboBox.addItem("DESC");
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setToolTipText(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ClickForComboBox"));
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ClickTheSort"));
            }
        }

        public class ColumnNode {
            public String name;
            public String objectId;
            public String sortOrder;

            ColumnNode(BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
                this.name = columnProxyOraclev10g.getLongName();
                this.objectId = columnProxyOraclev10g.getObjectID();
                this.sortOrder = bitmapJoinIndexOraclev10g.getColumnSortOrder(columnProxyOraclev10g.getObjectID());
            }

            public String toString() {
                return this.name;
            }

            public String getColumnId() {
                return this.objectId;
            }
        }
    }

    class LongNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LongNameCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ColumnProxyOracle) {
                this.setText(((ColumnProxyOracle)object).getLongName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.contains(object)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.addElement(object);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.removeElement(object);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initColumnsSortOrderAndDimensionKeys();
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initDimensionColumns();
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.contains(object)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.addElement(object);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.removeElement(object);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initColumnsSortOrderAndDimensionKeys();
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initDimensionColumns();
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveColumns.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddColumns.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    class DimensionColumnsTable
    extends JTable {
        KeysTableModel dataModel;

        public DimensionColumnsTable() {
            String[] stringArray = new String[]{Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTableColumns"), Messages.getString("BitmapJoinIndexPropertyDialogOracle.BaseTableColumns")};
            this.dataModel = new KeysTableModel(stringArray);
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == 1) {
                return new LabelTableCellRenderer();
            }
            return super.getCellRenderer(n, n2);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 1) {
                return new BaseTableColumnsCellEditor();
            }
            return super.getCellEditor();
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class BaseTableColumnsCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        BaseTableColumnsCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<ColumnProxy>(BitmapJoinIndexPropertyDialogOraclev10g.this.index.getTable().getColumnProxies()));
            this.cbox.setSelectedItem(object);
            return this.cbox;
        }
    }

    class ComboBoxCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        ComboBoxCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)jTable.getValueAt(n, 0);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(tableProxyOraclev10g.getPrimaryKeys().getElementsList());
            arrayList.addAll(tableProxyOraclev10g.getUniqueKeys().getElementsList());
            this.cbox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
            this.cbox.setSelectedItem(object);
            return this.cbox;
        }
    }

    class OptionsTable
    extends JTable {
        KeysTableModel dataModel;

        public OptionsTable() {
            String[] stringArray = new String[]{Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTable"), Messages.getString("BitmapJoinIndexPropertyDialogOracle.TableKey")};
            this.dataModel = new KeysTableModel(stringArray);
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == 1) {
                return new LabelTableCellRenderer();
            }
            return super.getCellRenderer(n, n2);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 1) {
                return new ComboBoxCellEditor();
            }
            return super.getCellEditor();
        }
    }

    class KeysTableModel
    extends DefaultTableModel {
        String[] cNames;

        public KeysTableModel(String[] stringArray) {
            this.cNames = stringArray;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable()) {
                return false;
            }
            return n2 == 0 || n2 == 1;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = this.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }
    }

    private class LocalPartitionListener
    implements ActionListener {
        private LocalPartitionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PartitionListOracle partitionListOracle = BitmapJoinIndexPropertyDialogOraclev10g.this.index.getTable().getPartitionList();
            String string = null;
            String string2 = "";
            if (partitionListOracle != null) {
                string = partitionListOracle.getPartitionType();
                string2 = partitionListOracle.getSubpartitionType();
            }
            if (((String)BitmapJoinIndexPropertyDialogOraclev10g.this.cbLocalPartitioning.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES) && string != null && (string.equalsIgnoreCase("HASH BY QUANTITY") || string.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || string2.equalsIgnoreCase("HASH"))) {
                BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.setEnabled(true);
                BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.setEnabled(true);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.getSelectedIndex() != -1);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.getSelectedIndex() != -1);
            } else {
                BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.setEnabled(false);
                BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.setEnabled(false);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(false);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(false);
            }
        }
    }
}

