/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserAndRolePermissionsDialogOracle
extends CustomDialog {
    private static final long serialVersionUID = 2832957674589015374L;
    private final String TABLES = Messages.getString("UserAndRolePermissionsDialogOracle.Tables");
    private final String VIEWS = Messages.getString("UserAndRolePermissionsDialogOracle.Views");
    private final String SNAPSHOTS = Messages.getString("UserAndRolePermissionsDialogOracle.Snapshots");
    private final String SEQUENCES = Messages.getString("UserAndRolePermissionsDialogOracle.Sequences");
    private final String PROCEDURES = Messages.getString("UserAndRolePermissionsDialogOracle.Procedures");
    private final String DIRECTORIES = Messages.getString("UserAndRolePermissionsDialogOracle.Directories");
    private final String STRUCT_TYPES = Messages.getString("UserAndRolePermissionsDialogOracle.StructuredTypes");
    private final String COLLECTION_TYPES = Messages.getString("UserAndRolePermissionsDialogOracle.CollectionTypes");
    private final String EXT_TABLES = Messages.getString("UserAndRolePermissionsDialogOracle.ExternalTables");
    private final String COLUMNS = Messages.getString("UserAndRolePermissionsDialogOracle.Columns");
    public final String CLEAR_FILTER = " ";
    public final String TABLE_T = "table";
    public final String VIEW_T = "view";
    public final String M_VIEW_T = "mview";
    public final String SEQUENCE_T = "seq";
    public final String PACKAGE_T = "pkg";
    public final String PROCEDURE_T = "proc";
    public final String FUNCTION_T = "func";
    public final String DIRECTORY_T = "dir";
    public final String STRUCT_TYPE_T = "str_t";
    public final String COLL_TYPE_T = "col_t";
    public final String EXT_TABLE_T = "ext_t";
    public final String COLUMN_T = "col";
    private Object storageObject;
    private StorageDesignOracle storageDesign;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private final JPanel generalPanel;
    private JTable privilegedObjectsTable;
    private JTable privilegedObjectPrivilegesTable;
    private JButton buttonObjectAdd;
    private JButton buttonObjectRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private JPanel allObjectsPanel;
    private List<Object> privilegedObjectsContainerList;
    private List<Privilege> containerListPrivileges;
    private JPanel privilegesPanel;
    private JPanel objectsPanel;
    private JPanel objectPrivilegesListPanel;
    private JScrollPane tablesScrollPane;
    private JScrollPane viewsScrollPane;
    private JScrollPane sequencesScrollPane;
    private JScrollPane snapshotsScrollPane;
    private JScrollPane proceduresScrollPane;
    private JScrollPane directoriesScrollPane;
    private JScrollPane structuredTypesScrollPane;
    private JScrollPane collectionTypesScrollPane;
    private JScrollPane externalTablesScrollPane;
    private JScrollPane columnsScrollPane;
    private JDialog dialog;
    private DefaultListModel allTablesPanelListModel;
    private DefaultListModel allViewsPanelListModel;
    private DefaultListModel allSnapshotsPanelListModel;
    private DefaultListModel allSequencesPanelListModel;
    private DefaultListModel allProceduresPanelListModel;
    private DefaultListModel allDirectoriesPanelListModel;
    private DefaultListModel allStructuredTypesPanelListModel;
    private DefaultListModel allCollectionTypesPanelListModel;
    private DefaultListModel allExternalTablesPanelListModel;
    private DefaultListModel allColumnsPanelListModel;
    private JList allTablesPanelList;
    private JList allViewsPanelList;
    private JList allSnapshotsPanelList;
    private JList allSequencesPanelList;
    private JList allProceduresPanelList;
    private JList allDirectoriesPanelList;
    private JList allStructuredTypesPanelList;
    private JList allCollectionTypesPanelList;
    private JList allExternalTablesPanelList;
    private JList allColumnsPanelList;
    private DefaultListModel availablePrivilegesModel;
    private ArrayList<PrivilegedObject> currentPrivilegedObjectList;
    private Privilege currentPrivilege;
    private JList availablePrivilegesList;
    private JScrollPane availablePrivilegesScrollPane;
    private TableProxySetOracle tablesSet;
    private TableViewProxySetOracle viewSet;
    private SnapshotSetOracle snapshotSet;
    private SequenceSetOracle sequenceSet;
    private ApplicationView appView;
    private JTabbedPane tablesTPane;
    private JComboBox cmbObjects;
    private JComboBox cmbFilterType;
    private TableRowSorter<SelectedObjectsModel> sorter;
    private JPanel objListPanel;
    private ArrayList<PrivilegedObject> objWithRevokedPrivs = new ArrayList();

    public UserAndRolePermissionsDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView);
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.appView = applicationView;
        this.storageObject = storageObject;
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(new Dimension(600, 500));
        this.initLeftPanel(this.generalPanel);
        this.initAllObjectsPanelAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel, storageObject);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, "Center");
    }

    private void initBottomPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.bnOK = new JButton(Messages.getString("UserAndRolePermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("UserAndRolePermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("UserAndRolePermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnCancel);
        jPanel.add((Component)jPanel2, "South");
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    private void initAllObjectsPanelAddRemoveButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel2.setPreferredSize(new Dimension(35, 500));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonObjectAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonObjectAdd.addActionListener(new AddObjectActionListener());
        this.buttonObjectAdd.setEnabled(false);
        this.buttonObjectAdd.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Add"));
        this.buttonObjectRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonObjectRemove.setEnabled(false);
        this.buttonObjectRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonObjectRemove.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Remove"));
        this.buttonObjectAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonObjectRemove.setPreferredSize(this.buttonObjectAdd.getPreferredSize());
        jPanel4.add((Component)this.buttonObjectAdd, "North");
        jPanel4.add((Component)this.buttonObjectRemove, "Center");
        jPanel3.add(jPanel4);
        jPanel2.add(new JPanel());
        jPanel2.add(jPanel3);
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        jPanel.add((Component)jPanel2, "Center");
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonPrivilegeAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Add"));
        this.buttonPrivilegeRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Remove"));
        this.buttonPrivilegeAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove.setPreferredSize(this.buttonPrivilegeAdd.getPreferredSize());
        jPanel3.add((Component)this.buttonPrivilegeAdd, "North");
        jPanel3.add((Component)this.buttonPrivilegeRemove, "Center");
        jPanel2.add(jPanel3);
        jPanel.add(new JPanel());
        jPanel.add(jPanel2);
        jPanel.add(new JPanel());
        this.privilegesPanel.add((Component)jPanel, "East");
    }

    private void initLeftPanel(JPanel jPanel) {
        this.allObjectsPanel = new JPanel(new BorderLayout());
        this.allObjectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.AvailableObjects")));
        this.objListPanel = new JPanel(new BorderLayout());
        this.cmbObjects = new JComboBox<Object>(this.getObjectsNames().toArray());
        this.cmbObjects.setPreferredSize(new Dimension(130, 20));
        this.cmbObjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    UserAndRolePermissionsDialogOracle.this.loadAllObjectsPanelList();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.setPreferredSize(new Dimension(180, 30));
        jPanel2.add(this.cmbObjects);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.cmbObjects, 5, 1);
        this.objListPanel.setPreferredSize(new Dimension(180, 400));
        this.initAllObjectsPanelList();
        this.loadAllObjectsPanelList();
        this.allObjectsPanel.add((Component)jPanel2, "North");
        this.allObjectsPanel.add((Component)this.objListPanel, "Center");
        jPanel.add((Component)this.allObjectsPanel, "West");
    }

    private void initAllObjectsPanelList() {
        this.tablesTPane = new JTabbedPane();
        this.tablesTPane.setPreferredSize(new Dimension(180, 432));
        this.allTablesPanelListModel = new DefaultListModel();
        this.allTablesPanelList = new JList(this.allTablesPanelListModel);
        this.tablesScrollPane = new JScrollPane(this.allTablesPanelList);
        this.tablesScrollPane.setPreferredSize(new Dimension(180, 432));
        this.allTablesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.clear();
                if (UserAndRolePermissionsDialogOracle.this.allTablesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.initColumns((TableProxyOracle)UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.get(UserAndRolePermissionsDialogOracle.this.allTablesPanelList.getSelectedIndex()));
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.tablesTPane.addTab(this.TABLES, this.tablesScrollPane);
        this.allColumnsPanelListModel = new DefaultListModel();
        this.allColumnsPanelList = new JList(this.allColumnsPanelListModel);
        this.allColumnsPanelList.setCellRenderer(new ColumnsCellRenderer());
        this.columnsScrollPane = new JScrollPane(this.allColumnsPanelList);
        this.columnsScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allColumnsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allColumnsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.tablesTPane.addTab(this.COLUMNS, this.columnsScrollPane);
        this.allViewsPanelListModel = new DefaultListModel();
        this.allViewsPanelList = new JList(this.allViewsPanelListModel);
        this.viewsScrollPane = new JScrollPane(this.allViewsPanelList);
        this.viewsScrollPane.setPreferredSize(new Dimension(180, 432));
        this.allViewsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allViewsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allSequencesPanelListModel = new DefaultListModel();
        this.allSequencesPanelList = new JList(this.allSequencesPanelListModel);
        this.sequencesScrollPane = new JScrollPane(this.allSequencesPanelList);
        this.sequencesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allSequencesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allSequencesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allSnapshotsPanelListModel = new DefaultListModel();
        this.allSnapshotsPanelList = new JList(this.allSnapshotsPanelListModel);
        this.snapshotsScrollPane = new JScrollPane(this.allSnapshotsPanelList);
        this.snapshotsScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allSnapshotsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allProceduresPanelListModel = new DefaultListModel();
        this.allProceduresPanelList = new JList(this.allProceduresPanelListModel);
        this.proceduresScrollPane = new JScrollPane(this.allProceduresPanelList);
        this.proceduresScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allProceduresPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allProceduresPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allDirectoriesPanelListModel = new DefaultListModel();
        this.allDirectoriesPanelList = new JList(this.allDirectoriesPanelListModel);
        this.directoriesScrollPane = new JScrollPane(this.allDirectoriesPanelList);
        this.directoriesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allDirectoriesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allStructuredTypesPanelListModel = new DefaultListModel();
        this.allStructuredTypesPanelList = new JList(this.allStructuredTypesPanelListModel);
        this.structuredTypesScrollPane = new JScrollPane(this.allStructuredTypesPanelList);
        this.structuredTypesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allStructuredTypesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allCollectionTypesPanelListModel = new DefaultListModel();
        this.allCollectionTypesPanelList = new JList(this.allCollectionTypesPanelListModel);
        this.collectionTypesScrollPane = new JScrollPane(this.allCollectionTypesPanelList);
        this.collectionTypesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allCollectionTypesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allExternalTablesPanelListModel = new DefaultListModel();
        this.allExternalTablesPanelList = new JList(this.allExternalTablesPanelListModel);
        this.externalTablesScrollPane = new JScrollPane(this.allExternalTablesPanelList);
        this.externalTablesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allExternalTablesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
    }

    private void loadAllObjectsPanelList() {
        this.objListPanel.removeAll();
        String string = (String)this.cmbObjects.getSelectedItem();
        if (string.equals(this.TABLES)) {
            this.objListPanel.add(this.tablesTPane);
        } else if (string.equals(this.VIEWS)) {
            this.objListPanel.add(this.viewsScrollPane);
        } else if (string.equals(this.SNAPSHOTS)) {
            this.objListPanel.add(this.snapshotsScrollPane);
        } else if (string.equals(this.SEQUENCES)) {
            this.objListPanel.add(this.sequencesScrollPane);
        } else if (string.equals(this.PROCEDURES)) {
            this.objListPanel.add(this.proceduresScrollPane);
        } else if (string.equals(this.DIRECTORIES)) {
            this.objListPanel.add(this.directoriesScrollPane);
        } else if (string.equals(this.STRUCT_TYPES)) {
            this.objListPanel.add(this.structuredTypesScrollPane);
        } else if (string.equals(this.COLLECTION_TYPES)) {
            this.objListPanel.add(this.collectionTypesScrollPane);
        } else if (string.equals(this.EXT_TABLES)) {
            this.objListPanel.add(this.externalTablesScrollPane);
        }
        this.objListPanel.updateUI();
    }

    private PermissionsOracle getPermissionPerObject(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        ColumnProxyOracle columnProxyOracle = null;
        if (storageObject2 instanceof ColumnProxyOracle) {
            columnProxyOracle = (ColumnProxyOracle)storageObject2;
        }
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getUser() != storageObject && permissionsOracle.getRole() != storageObject || permissionsOracle.getTable() != storageObject2 && permissionsOracle.getView() != storageObject2 && permissionsOracle.getProc() != storageObject2 && permissionsOracle.getFunctionOracle() != storageObject2 && permissionsOracle.getPackage() != storageObject2 && permissionsOracle.getSequence() != storageObject2 && permissionsOracle.getSnapshot() != storageObject2 && permissionsOracle.getDirectoryOracle() != storageObject2 && permissionsOracle.getStructuredTypeOracle() != storageObject2 && permissionsOracle.getCollectionTypeOracle() != storageObject2 && permissionsOracle.getExternalTableOracle() != storageObject2 && (columnProxyOracle == null || permissionsOracle.getColumnsTable() == null || !permissionsOracle.getColumnsTable().getObjectID().equals(columnProxyOracle.getTableProxy().getObjectID()) || !permissionsOracle.getColumns().contains(columnProxyOracle.getName()) && !permissionsOracle.getColumnsWithGrantOption().contains(columnProxyOracle.getName()))) continue;
            return permissionsOracle;
        }
        return null;
    }

    private void checkPermissions(Object object) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.storageObject, (StorageObject)object);
        if (permissionsOracle == null) {
            if (object instanceof TableProxyOracle) {
                this.allTablesPanelListModel.addElement(object);
            } else if (object instanceof TableViewProxyOracle) {
                this.allViewsPanelListModel.addElement(object);
            } else if (object instanceof SnapshotOracle) {
                this.allSnapshotsPanelListModel.addElement(object);
            } else if (object instanceof SequenceOracle) {
                this.allSequencesPanelListModel.addElement(object);
            } else if (object instanceof StoredProcedureOracle || object instanceof FunctionOracle || object instanceof PackageOracle) {
                this.allProceduresPanelListModel.addElement(object);
            } else if (object instanceof DirectoryOracle) {
                this.allDirectoriesPanelListModel.addElement(object);
            } else if (object instanceof StructuredTypeProxyOracle) {
                this.allStructuredTypesPanelListModel.addElement(object);
            } else if (object instanceof CollectionTypeProxyOracle) {
                this.allCollectionTypesPanelListModel.addElement(object);
            } else if (object instanceof ExternalTableOracle) {
                this.allExternalTablesPanelListModel.addElement(object);
            }
        } else if (permissionsOracle != null) {
            this.privilegedObjectPrivilegesTable.updateUI();
            PrivilegedObject privilegedObject = new PrivilegedObject(object);
            ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
            if (object instanceof ColumnProxyOracle) {
                Object object2;
                Object object3;
                StringTokenizer stringTokenizer = new StringTokenizer(permissionsOracle.getPrivs((ColumnProxyOracle)object), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object3 = stringTokenizer.nextToken().trim();
                    object2 = new Privilege(((String)object3).trim());
                    ((Privilege)object2).setName((String)object3);
                    arrayList.add((Privilege)object2);
                }
                object3 = new StringTokenizer(permissionsOracle.getPrivsWithGrantOption((ColumnProxyOracle)object), ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken().trim();
                    Privilege privilege = new Privilege(((String)object2).trim());
                    privilege.setName((String)object2);
                    privilege.setGrantOption(true);
                    arrayList.add(privilege);
                }
            } else {
                Object object4;
                Object object5;
                Object object6;
                StringTokenizer stringTokenizer = new StringTokenizer(permissionsOracle.getPrivileges(), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object6 = stringTokenizer.nextToken().trim();
                    object5 = new Privilege(((String)object6).trim());
                    ((Privilege)object5).setName((String)object6);
                    arrayList.add((Privilege)object5);
                }
                object6 = new StringTokenizer(permissionsOracle.getPrivilegesWithGrantOption(), ",");
                while (((StringTokenizer)object6).hasMoreTokens()) {
                    object5 = ((StringTokenizer)object6).nextToken().trim();
                    object4 = new Privilege(((String)object5).trim());
                    ((Privilege)object4).setName((String)object5);
                    ((Privilege)object4).setGrantOption(true);
                    arrayList.add((Privilege)object4);
                }
                object5 = new StringTokenizer(permissionsOracle.getPrivilegesWithHierarchyOption(), ",");
                while (((StringTokenizer)object5).hasMoreTokens()) {
                    object4 = ((StringTokenizer)object5).nextToken().trim();
                    Privilege privilege = new Privilege(((String)object4).trim());
                    privilege.setName((String)object4);
                    privilege.setHierarchy(true);
                    arrayList.add(privilege);
                }
            }
            privilegedObject.setPrivileges(arrayList);
            this.privilegedObjectsContainerList.add(privilegedObject);
            this.privilegedObjectsTable.updateUI();
        }
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                String string = defaultListModel.get(j).toString();
                String string2 = defaultListModel.get(j - 1).toString();
                int n = string.indexOf(".");
                int n2 = string2.indexOf(".");
                if (n > -1) {
                    string = string.substring(n + 1, string.length());
                }
                if (n2 > -1) {
                    string2 = string2.substring(n2 + 1, string2.length());
                }
                if (string.toString().compareTo(string2.toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    private void initTables() {
        this.tablesSet = (TableProxySetOracle)this.storageDesign.getTableProxySet();
        for (Object e : this.tablesSet.getElements()) {
            this.checkPermissions(e);
        }
        this.sort(this.allTablesPanelListModel);
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetOracle)this.storageDesign.getTableViewProxySet();
        for (Object e : this.viewSet.getElements()) {
            this.checkPermissions(e);
        }
        this.sort(this.allViewsPanelListModel);
    }

    private void initSnapshots() {
        this.snapshotSet = this.storageDesign.getSnapshotSet();
        Iterator iterator = this.snapshotSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allSnapshotsPanelListModel);
    }

    private void initSequences() {
        this.sequenceSet = this.storageDesign.getSequenceSet();
        Iterator iterator = this.sequenceSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allSequencesPanelListModel);
    }

    private void initStoredProcedures() {
        Object e;
        Iterator iterator = this.storageDesign.getPackageSet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            this.checkPermissions(e);
        }
        iterator = this.storageDesign.getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            this.checkPermissions(e);
        }
        iterator = this.storageDesign.getFunctionSet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allProceduresPanelListModel);
    }

    private void initDirectories() {
        Iterator iterator = this.storageDesign.getDirectorySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allDirectoriesPanelListModel);
    }

    private void initStructuredTypes() {
        Iterator iterator = this.storageDesign.getStructuredTypeProxySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allStructuredTypesPanelListModel);
    }

    private void initCollectionTypes() {
        Iterator iterator = this.storageDesign.getCollectionTypeProxySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allCollectionTypesPanelListModel);
    }

    private void initExternalTables() {
        ExternalTableSetOracle externalTableSetOracle = null;
        if (this.storageDesign instanceof StorageDesignOraclev10g) {
            externalTableSetOracle = ((StorageDesignOraclev10g)this.storageDesign).getExternalTableSet();
        } else if (this.storageDesign instanceof StorageDesignOraclev9i) {
            externalTableSetOracle = ((StorageDesignOraclev9i)this.storageDesign).getExternalTableSet();
        }
        Iterator iterator = externalTableSetOracle.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.checkPermissions(e);
        }
        this.sort(this.allExternalTablesPanelListModel);
    }

    private void initColumns() {
        this.tablesSet = (TableProxySetOracle)this.storageDesign.getTableProxySet();
        for (TableProxyOracle tableProxyOracle : this.tablesSet.getElements()) {
            Iterator<ColumnProxy> iterator = Arrays.asList(tableProxyOracle.getColumnProxies()).iterator();
            while (iterator.hasNext()) {
                this.checkPermissions(iterator.next());
            }
        }
    }

    private void initColumns(TableProxyOracle tableProxyOracle) {
        if (tableProxyOracle != null) {
            for (ColumnProxy columnProxy : Arrays.asList(tableProxyOracle.getColumnProxies())) {
                PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.storageObject, columnProxy);
                if (permissionsOracle != null) continue;
                this.allColumnsPanelListModel.addElement(columnProxy);
            }
        }
        this.sort(this.allColumnsPanelListModel);
    }

    private void initRightPanel(JPanel jPanel, StorageObject storageObject) {
        this.objectsPanel = new JPanel(new BorderLayout());
        this.objectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.Objects")));
        this.objectsPanel.setPreferredSize(new Dimension(370, 400));
        this.initPrivilegedObjectInfo();
        this.initAvailablePrivileges();
        this.initGrantedObjectProvileges(storageObject);
        this.loadObjectsAndPrivileges();
        jPanel.add((Component)this.objectsPanel, "East");
    }

    private void initPrivilegedObjectInfo() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.privilegedObjectsContainerList = new ArrayList<Object>();
        this.privilegedObjectsTable = new JTable(new SelectedObjectsModel());
        this.privilegedObjectsTable.setSelectionMode(2);
        this.sorter = new TableRowSorter<SelectedObjectsModel>(new SelectedObjectsModel());
        this.privilegedObjectsTable.setRowSorter(this.sorter);
        this.cmbFilterType = new JComboBox<Object>(this.getObjectTypesList().toArray());
        this.cmbFilterType.setPreferredSize(new Dimension(70, 20));
        this.cmbFilterType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                UserAndRolePermissionsDialogOracle.this.filterTypeField();
            }
        });
        JLabel jLabel = new JLabel(Messages.getString("UserAndRolePermissionsDialogOracle.FilterByType"));
        jLabel.setPreferredSize(new Dimension(185, 20));
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.setPreferredSize(new Dimension(180, 30));
        jPanel2.add(this.cmbFilterType);
        jPanel2.add(jLabel);
        CommonUtil.setLabelConstraints((SpringLayout)jPanel2.getLayout(), jLabel, 1, 1);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.cmbFilterType, 100, 1);
        TableColumn tableColumn = this.privilegedObjectsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(35);
        tableColumn.setMaxWidth(35);
        TableColumn tableColumn2 = this.privilegedObjectsTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(148);
        tableColumn2.setMaxWidth(148);
        TableColumn tableColumn3 = this.privilegedObjectsTable.getColumnModel().getColumn(2);
        tableColumn3.setWidth(185);
        tableColumn3.setMaxWidth(185);
        this.privilegedObjectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRow() == -1) {
                    UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.clear();
                    UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                    UserAndRolePermissionsDialogOracle.this.buttonObjectRemove.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList = new ArrayList();
                    UserAndRolePermissionsDialogOracle.this.buttonObjectRemove.setEnabled(true);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRowCount() > 1) {
                        PrivilegedObject privilegedObject = null;
                        int[] nArray = UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRows();
                        for (int i = 0; i < nArray.length; ++i) {
                            PrivilegedObject privilegedObject2 = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.convertRowIndexToModel(nArray[i]));
                            UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.add(privilegedObject2);
                            privilegedObject = privilegedObject2;
                        }
                        if (UserAndRolePermissionsDialogOracle.this.cmbFilterType.getSelectedItem().equals(" ")) {
                            UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.clear();
                            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
                            UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                        } else {
                            UserAndRolePermissionsDialogOracle.this.loadAvailableObjectPrivileges(privilegedObject, new ArrayList(), true);
                            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
                        }
                    } else {
                        PrivilegedObject privilegedObject = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.convertRowIndexToModel(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRow()));
                        UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.add(privilegedObject);
                        ArrayList arrayList = UserAndRolePermissionsDialogOracle.this.loadGrantedObjectProvileges(privilegedObject);
                        UserAndRolePermissionsDialogOracle.this.loadAvailableObjectPrivileges(privilegedObject, arrayList, false);
                    }
                    UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.clearSelection();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.privilegedObjectsTable);
        jScrollPane.setPreferredSize(new Dimension(400, 180));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.objectsPanel.add((Component)jPanel, "North");
    }

    private void loadObjectsAndPrivileges() {
        this.initTables();
        this.initViews();
        this.initSnapshots();
        this.initSequences();
        this.initStoredProcedures();
        this.initDirectories();
        this.initStructuredTypes();
        this.initCollectionTypes();
        this.initExternalTables();
        this.initColumns();
    }

    private void initAvailablePrivileges() {
        this.objectPrivilegesListPanel = new JPanel(new BorderLayout());
        this.objectPrivilegesListPanel.setPreferredSize(new Dimension(100, 400));
        this.privilegesPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        this.availablePrivilegesScrollPane.setPreferredSize(new Dimension(110, 200));
        jPanel.add(this.availablePrivilegesScrollPane);
        this.privilegesPanel.add((Component)jPanel, "West");
        this.objectPrivilegesListPanel.add((Component)this.privilegesPanel, "West");
        this.initPrivilegesAddRemoveButtons();
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.sort(this.availablePrivilegesModel);
    }

    private void loadAvailableObjectPrivileges(PrivilegedObject privilegedObject, ArrayList<Object> arrayList, boolean bl) {
        String[] stringArray = null;
        Object object = privilegedObject.getObject();
        if (object instanceof TableProxyOracle) {
            stringArray = PermissionsOracle.getTablePrivilegesValues();
        } else if (object instanceof TableViewProxyOracle) {
            stringArray = PermissionsOracle.getViewPrivilegesValues();
        } else if (object instanceof SnapshotOracle) {
            stringArray = PermissionsOracle.getSnapshotPrivilegesValues();
        } else if (object instanceof SequenceOracle) {
            stringArray = PermissionsOracle.getSeqPrivilegesValues();
        } else if (object instanceof StoredProcedureOracle) {
            stringArray = PermissionsOracle.getProcedurePrivilegesValues();
        } else if (object instanceof PackageOracle) {
            stringArray = PermissionsOracle.getPackagePrivilegesValues();
        } else if (object instanceof FunctionOracle) {
            stringArray = PermissionsOracle.getProcedurePrivilegesValues();
        } else if (object instanceof DirectoryOracle) {
            stringArray = PermissionsOracle.getDirectoryPrivilegesValues();
        } else if (object instanceof StructuredTypeProxyOracle) {
            stringArray = PermissionsOracle.getStructuredTypePrivilegesValues();
        } else if (object instanceof CollectionTypeProxyOracle) {
            stringArray = PermissionsOracle.getCollectionTypePrivilegesValues();
        } else if (object instanceof ExternalTableOracle) {
            stringArray = PermissionsOracle.getExtTablesPrivilegesValues();
        } else if (object instanceof ColumnProxyOracle) {
            stringArray = PermissionsOracle.getColumnPermissionsValues();
        }
        this.availablePrivilegesModel.clear();
        if (stringArray != null) {
            Iterator<String> iterator = Arrays.asList(stringArray).iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().trim();
                if (bl) {
                    this.availablePrivilegesModel.addElement(string);
                    continue;
                }
                if (arrayList.size() != 0 && arrayList.contains(string)) continue;
                this.availablePrivilegesModel.addElement(string);
            }
        }
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject privilegedObject) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> arrayList = privilegedObject.getPrivileges();
        Iterator<Privilege> iterator = arrayList.iterator();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Privilege privilege = iterator.next();
            this.containerListPrivileges.add(privilege);
            arrayList2.add(privilege.getObject());
        }
        return arrayList2;
    }

    private void initGrantedObjectProvileges(StorageObject storageObject) {
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        ColumnHierarchyRenderer columnHierarchyRenderer = new ColumnHierarchyRenderer();
        if (storageObject instanceof RoleOracle) {
            this.privilegedObjectPrivilegesTable = new JTable(new RoleGrantedPrivilegessModel());
            serializable = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(0);
            TableColumn tableColumn = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(1);
            ((TableColumn)serializable).setWidth(162);
            ((TableColumn)serializable).setMaxWidth(162);
            tableColumn.setWidth(52);
            tableColumn.setMaxWidth(52);
            tableColumn.setCellRenderer(columnHierarchyRenderer);
        } else if (storageObject instanceof UserOracle) {
            this.privilegedObjectPrivilegesTable = new JTable(new UserGrantedPrivilegessModel());
            serializable = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(0);
            TableColumn tableColumn = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(1);
            TableColumn tableColumn2 = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(2);
            ((TableColumn)serializable).setWidth(100);
            ((TableColumn)serializable).setMaxWidth(100);
            tableColumn.setWidth(40);
            tableColumn.setMaxWidth(40);
            tableColumn2.setWidth(52);
            tableColumn2.setMaxWidth(52);
            tableColumn2.setCellRenderer(columnHierarchyRenderer);
        }
        this.privilegedObjectPrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectedRow() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    UserAndRolePermissionsDialogOracle.this.currentPrivilege = (Privilege)UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectedRow());
                }
            }
        });
        serializable = new JScrollPane(this.privilegedObjectPrivilegesTable);
        ((JComponent)serializable).setPreferredSize(new Dimension(192, 100));
        jPanel.add((Component)serializable, "East");
        this.objectPrivilegesListPanel.add((Component)jPanel, "East");
        this.objectsPanel.add((Component)this.objectPrivilegesListPanel, "Center");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserAndRolePermissionsDialogOracle.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    protected void savePermissions() {
        Object object;
        Object object2;
        PermissionsOracle permissionsOracle = null;
        this.cmbFilterType.setSelectedItem(" ");
        PermissionsSetOracle permissionsSetOracle = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedObjectsTable.getRowCount(); ++i) {
            String string;
            String string2;
            ColumnProxyOracle columnProxyOracle;
            object2 = (PrivilegedObject)this.privilegedObjectsContainerList.get(i);
            object = ((PrivilegedObject)object2).getObject();
            permissionsOracle = this.getPermissionPerObject((StorageObject)this.storageObject, (StorageObject)object);
            if (permissionsOracle == null) {
                permissionsOracle = permissionsSetOracle.createPermissions();
                for (Privilege privilege : ((PrivilegedObject)object2).getPrivileges()) {
                    if (object instanceof ColumnProxyOracle) {
                        columnProxyOracle = (ColumnProxyOracle)object;
                        permissionsOracle.setColumnsTable(columnProxyOracle.getTableProxy());
                        string2 = "";
                        string2 = string2.concat(columnProxyOracle.getName());
                        string = "";
                        string = string.concat(columnProxyOracle.getName());
                        if (privilege.getGrantOption()) {
                            string = string.concat(", ").concat((String)privilege.getObject());
                        } else {
                            string2 = string2.concat(", ").concat((String)privilege.getObject());
                        }
                        if (string2.indexOf(",") > -1) {
                            permissionsOracle.setColumnList(string2);
                        }
                        if (string.indexOf(",") > -1) {
                            permissionsOracle.setColumnListWithGrantOption(string);
                        }
                    } else {
                        if (object instanceof TableProxyOracle) {
                            permissionsOracle.setTable((TableProxyOracle)object);
                        } else if (object instanceof TableViewProxyOracle) {
                            permissionsOracle.setView((TableViewProxyOracle)object);
                        } else if (object instanceof SnapshotOracle) {
                            permissionsOracle.setSnapshot((SnapshotOracle)object);
                        } else if (object instanceof SequenceOracle) {
                            permissionsOracle.setSequence((SequenceOracle)object);
                        } else if (object instanceof StoredProcedureOracle) {
                            permissionsOracle.setProc((StoredProcedureOracle)object);
                        } else if (object instanceof FunctionOracle) {
                            permissionsOracle.setFunctionOracle((FunctionOracle)object);
                        } else if (object instanceof PackageOracle) {
                            permissionsOracle.setPackage((PackageOracle)object);
                        } else if (object instanceof DirectoryOracle) {
                            permissionsOracle.setDirectoryOracle((DirectoryOracle)object);
                        } else if (object instanceof StructuredTypeProxyOracle) {
                            permissionsOracle.setStructuredTypeOracle((StructuredTypeProxyOracle)object);
                        } else if (object instanceof CollectionTypeProxyOracle) {
                            permissionsOracle.setCollectionTypeOracle((CollectionTypeProxyOracle)object);
                        } else if (object instanceof ExternalTableOracle) {
                            permissionsOracle.setExternalTableOracle((ExternalTableOracle)object);
                        }
                        permissionsOracle.setPrivileges((String)privilege.getObject());
                        if (privilege.getGrantOption()) {
                            permissionsOracle.setPrivilegesWithGrantOption((String)privilege.getObject());
                        }
                        if (privilege.getHierarchy()) {
                            permissionsOracle.setPrivilegesWithHierarchyOption((String)privilege.getObject());
                        }
                    }
                    if (permissionsOracle.getUser() != null && permissionsOracle.getRole() != null) continue;
                    if (this.storageObject instanceof UserOracle) {
                        permissionsOracle.setUser((UserOracle)this.storageObject);
                        continue;
                    }
                    if (!(this.storageObject instanceof RoleOracle)) continue;
                    permissionsOracle.setRole((RoleOracle)this.storageObject);
                }
                continue;
            }
            if (permissionsOracle == null) continue;
            permissionsOracle.clear();
            permissionsOracle.clearColPermissions();
            for (Privilege privilege : ((PrivilegedObject)object2).getPrivileges()) {
                if (object instanceof ColumnProxyOracle) {
                    columnProxyOracle = (ColumnProxyOracle)object;
                    permissionsOracle.setColumnsTable(columnProxyOracle.getTableProxy());
                    string2 = "";
                    string2 = string2.concat(columnProxyOracle.getName());
                    string = "";
                    string = string.concat(columnProxyOracle.getName());
                    if (privilege.getGrantOption()) {
                        string = string.concat(", ").concat((String)privilege.getObject());
                    } else {
                        string2 = string2.concat(", ").concat((String)privilege.getObject());
                    }
                    if (string2.indexOf(",") > -1) {
                        permissionsOracle.setColumnList(string2);
                    }
                    if (string.indexOf(",") <= -1) continue;
                    permissionsOracle.setColumnListWithGrantOption(string);
                    continue;
                }
                permissionsOracle.setPrivileges((String)privilege.getObject());
                if (privilege.getGrantOption()) {
                    permissionsOracle.setPrivilegesWithGrantOption((String)privilege.getObject());
                }
                if (!privilege.getHierarchy()) continue;
                permissionsOracle.setPrivilegesWithHierarchyOption((String)privilege.getObject());
            }
        }
        Iterator<PrivilegedObject> iterator = this.objWithRevokedPrivs.iterator();
        while (iterator.hasNext()) {
            object2 = (StorageObject)iterator.next().getObject();
            object = this.getPermissionPerObject((StorageObject)this.storageObject, (StorageObject)object2);
            permissionsSetOracle.remove((ModelObject)object);
        }
    }

    private void filterTypeField() {
        this.privilegedObjectsTable.clearSelection();
        RowFilter rowFilter = null;
        try {
            rowFilter = this.cmbFilterType.getSelectedItem().equals(" ") ? RowFilter.regexFilter("", 0) : RowFilter.regexFilter("^" + this.cmbFilterType.getSelectedItem(), 0);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        this.sorter.setRowFilter(rowFilter);
    }

    private ArrayList<String> getObjectsNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.TABLES);
        arrayList.add(this.VIEWS);
        arrayList.add(this.SNAPSHOTS);
        arrayList.add(this.SEQUENCES);
        arrayList.add(this.PROCEDURES);
        arrayList.add(this.DIRECTORIES);
        arrayList.add(this.STRUCT_TYPES);
        arrayList.add(this.COLLECTION_TYPES);
        arrayList.add(this.EXT_TABLES);
        return arrayList;
    }

    private ArrayList<String> getObjectTypesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(" ");
        arrayList.add("table");
        arrayList.add("view");
        arrayList.add("mview");
        arrayList.add("seq");
        arrayList.add("pkg");
        arrayList.add("proc");
        arrayList.add("func");
        arrayList.add("dir");
        arrayList.add("str_t");
        arrayList.add("col_t");
        arrayList.add("ext_t");
        arrayList.add("col");
        return arrayList;
    }

    class ColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)object;
            this.setText(columnProxyOracle.getName());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class allObjectsPanelSelectionListener
    implements ListSelectionListener {
        private allObjectsPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectedRows();
            ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
            for (int i = 0; i < nArray.length; ++i) {
                UserAndRolePermissionsDialogOracle.this.currentPrivilege = (Privilege)UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(nArray[i]);
                Object object = UserAndRolePermissionsDialogOracle.this.currentPrivilege.getObject();
                arrayList.add(UserAndRolePermissionsDialogOracle.this.currentPrivilege);
                if (UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.contains(object)) continue;
                UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.addElement(object);
                for (PrivilegedObject privilegedObject : UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList) {
                    privilegedObject.removePrivilege(UserAndRolePermissionsDialogOracle.this.currentPrivilege);
                }
                UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel);
                UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(object, true);
            }
            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.removeAll(arrayList);
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.clearSelection();
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Privilege privilege = new Privilege(objectArray[i]);
                if (UserAndRolePermissionsDialogOracle.this.containerListPrivileges.contains(privilege)) continue;
                arrayList.add(objectArray[i]);
                for (PrivilegedObject privilegedObject : UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList) {
                    if (UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.size() > 1 && UserAndRolePermissionsDialogOracle.this.containerListPrivileges.size() == 0) {
                        privilegedObject.removeAllPrivileges();
                    }
                    privilegedObject.addPrivilege(privilege);
                }
                UserAndRolePermissionsDialogOracle.this.containerListPrivileges.add(privilege);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.removeElement(iterator.next());
            }
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectionModel().setSelectionInterval(UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getRowCount() - 1, UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogOracle.this.objWithRevokedPrivs.clear();
            int[] nArray = UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                PrivilegedObject privilegedObject = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(nArray[i]);
                Object object = privilegedObject.getObject();
                UserAndRolePermissionsDialogOracle.this.objWithRevokedPrivs.add(privilegedObject);
                if (privilegedObject.getObject() instanceof TableProxyOracle && !UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.TABLES);
                    UserAndRolePermissionsDialogOracle.this.tablesTPane.setSelectedIndex(0);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allTablesPanelList.setSelectedValue(object, true);
                }
                if (privilegedObject.getObject() instanceof ColumnProxyOracle) {
                    ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)privilegedObject.getObject();
                    TableProxyOracle tableProxyOracle = columnProxyOracle.getTableProxy();
                    boolean bl = false;
                    for (PrivilegedObject privilegedObject2 : UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList) {
                        if (!(privilegedObject2.getObject() instanceof TableProxyOracle) || !((TableProxyOracle)privilegedObject2.getObject()).getObjectID().equals(tableProxyOracle.getObjectID())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        UserAndRolePermissionsDialogOracle.this.allTablesPanelList.setSelectedValue(columnProxyOracle.getTableProxy(), true);
                        if (!UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.contains(object)) {
                            UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.addElement(object);
                            UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.TABLES);
                            UserAndRolePermissionsDialogOracle.this.tablesTPane.setSelectedIndex(1);
                            UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel);
                            UserAndRolePermissionsDialogOracle.this.allColumnsPanelList.setSelectedValue(object, true);
                        }
                    }
                }
                if (privilegedObject.getObject() instanceof TableViewProxyOracle && !UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.VIEWS);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allViewsPanelList.setSelectedValue(object, true);
                }
                if (privilegedObject.getObject() instanceof SnapshotOracle && !UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.SNAPSHOTS);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelList.setSelectedValue(object, true);
                }
                if (privilegedObject.getObject() instanceof SequenceOracle && !UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.SEQUENCES);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allSequencesPanelList.setSelectedValue(object, true);
                }
                if ((privilegedObject.getObject() instanceof StoredProcedureOracle || privilegedObject.getObject() instanceof PackageOracle || privilegedObject.getObject() instanceof FunctionOracle) && !UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.PROCEDURES);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allProceduresPanelList.setSelectedValue(object, true);
                }
                if (privilegedObject.getObject() instanceof DirectoryOracle && !UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.DIRECTORIES);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelList.setSelectedValue(object, true);
                }
                if (privilegedObject.getObject() instanceof StructuredTypeProxyOracle && !UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.STRUCT_TYPES);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelList.setSelectedValue(object, true);
                }
                if (privilegedObject.getObject() instanceof CollectionTypeProxyOracle && !UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel.contains(object)) {
                    UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel.addElement(object);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.COLLECTION_TYPES);
                    UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelList.setSelectedValue(object, true);
                }
                if (!(privilegedObject.getObject() instanceof ExternalTableOracle) || UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel.contains(object)) continue;
                UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel.addElement(object);
                UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.EXT_TABLES);
                UserAndRolePermissionsDialogOracle.this.sort(UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel);
                UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelList.setSelectedValue(object, true);
            }
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.removeAll(UserAndRolePermissionsDialogOracle.this.objWithRevokedPrivs);
            UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.clear();
            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.clearSelection();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.clearSelection();
        }
    }

    private class AddObjectActionListener
    implements ActionListener {
        private AddObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)UserAndRolePermissionsDialogOracle.this.cmbObjects.getSelectedItem();
            if (string.equals(UserAndRolePermissionsDialogOracle.this.TABLES)) {
                if (UserAndRolePermissionsDialogOracle.this.tablesTPane.getSelectedIndex() == 0) {
                    Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allTablesPanelList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                        if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                        UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                        UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.removeElement(objectArray[i]);
                    }
                } else if (UserAndRolePermissionsDialogOracle.this.tablesTPane.getSelectedIndex() == 1) {
                    Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allColumnsPanelList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                        if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                        UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                        UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.removeElement(objectArray[i]);
                    }
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.VIEWS)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allViewsPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.SNAPSHOTS)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.SEQUENCES)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allSequencesPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.PROCEDURES)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allProceduresPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.DIRECTORIES)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.STRUCT_TYPES)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.COLLECTION_TYPES)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(UserAndRolePermissionsDialogOracle.this.EXT_TABLES)) {
                Object[] objectArray = UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel.removeElement(objectArray[i]);
                }
            }
            ((SelectedObjectsModel)UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getModel()).fireTableRowsInserted(0, 0);
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectionModel().setSelectionInterval(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowCount() - 1, UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowCount() - 1);
        }
    }

    private class RoleGrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8480891404209029651L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserAndRolePermissionsDialogOracle.Privilege"), Messages.getString("UserAndRolePermissionsDialogOracle.Hierarchy")};

        private RoleGrantedPrivilegessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserAndRolePermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Object object;
            Object object2 = null;
            Iterator iterator = UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.iterator();
            if (iterator.hasNext()) {
                object = (PrivilegedObject)iterator.next();
                object2 = ((PrivilegedObject)object).getObject();
            }
            object = null;
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1) {
                if (this.getValueAt(n, 0).equals("SELECT") && (object2 instanceof TableProxyOracle || object2 instanceof TableViewProxyOracle)) {
                    DesignObject designObject;
                    if (object2 instanceof TableProxyOracle) {
                        designObject = (Table)((TableProxyOracle)object2).getObject();
                        object = designObject;
                    }
                    if (object2 instanceof TableViewProxyOracle) {
                        designObject = (TableView)((TableViewProxyOracle)object2).getObject();
                        object = designObject;
                    }
                    if ((designObject = ((ContainerObject)object).getBasedOnStructuredType()) != null && !((StructuredType)designObject).isFinal()) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Privilege privilege = (Privilege)UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (object instanceof Boolean) {
                privilege.setHierarchy((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Privilege privilege = (Privilege)UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (n2 == 0) {
                return ((String)privilege.getObject()).trim();
            }
            if (n2 == 1) {
                return new Boolean(privilege.hierarchy);
            }
            return "";
        }
    }

    private class UserGrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserAndRolePermissionsDialogOracle.Privilege"), Messages.getString("UserAndRolePermissionsDialogOracle.Grant"), Messages.getString("UserAndRolePermissionsDialogOracle.Hierarchy")};

        private UserGrantedPrivilegessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserAndRolePermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Object object;
            Object object2 = null;
            Iterator iterator = UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.iterator();
            if (iterator.hasNext()) {
                object = (PrivilegedObject)iterator.next();
                object2 = ((PrivilegedObject)object).getObject();
            }
            object = null;
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1) {
                return true;
            }
            if (n2 == 2) {
                if (this.getValueAt(n, 0).equals("SELECT") && (object2 instanceof TableProxyOracle || object2 instanceof TableViewProxyOracle)) {
                    DesignObject designObject;
                    if (object2 instanceof TableProxyOracle) {
                        designObject = (Table)((TableProxyOracle)object2).getObject();
                        object = designObject;
                    }
                    if (object2 instanceof TableViewProxyOracle) {
                        designObject = (TableView)((TableViewProxyOracle)object2).getObject();
                        object = designObject;
                    }
                    if ((designObject = ((ContainerObject)object).getBasedOnStructuredType()) != null && !((StructuredType)designObject).isFinal()) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Privilege privilege = (Privilege)UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (object instanceof Boolean) {
                if (n2 == 1) {
                    privilege.setGrantOption((Boolean)object);
                } else if (n2 == 2) {
                    privilege.setHierarchy((Boolean)object);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Privilege privilege = (Privilege)UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (n2 == 0) {
                return ((String)privilege.getObject()).trim();
            }
            if (n2 == 1) {
                return new Boolean(privilege.grantOption);
            }
            if (n2 == 2) {
                return new Boolean(privilege.hierarchy);
            }
            return "";
        }
    }

    private class SelectedObjectsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2600753990274250235L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserAndRolePermissionsDialogOracle.Type"), Messages.getString("UserAndRolePermissionsDialogOracle.Object"), Messages.getString("UserAndRolePermissionsDialogOracle.PrivilegesPermissions")};

        private SelectedObjectsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PrivilegedObject privilegedObject = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(n);
            if (n2 == 0) {
                Object object = privilegedObject.getObject();
                if (object instanceof TableProxyOracle) {
                    return "table";
                }
                if (object instanceof TableViewProxyOracle) {
                    return "view";
                }
                if (object instanceof SnapshotOracle) {
                    return "mview";
                }
                if (object instanceof SequenceOracle) {
                    return "seq";
                }
                if (object instanceof PackageOracle) {
                    return "pkg";
                }
                if (object instanceof StoredProcedureOracle) {
                    return "proc";
                }
                if (object instanceof FunctionOracle) {
                    return "func";
                }
                if (object instanceof DirectoryOracle) {
                    return "dir";
                }
                if (object instanceof StructuredTypeProxyOracle) {
                    return "str_t";
                }
                if (object instanceof CollectionTypeProxyOracle) {
                    return "col_t";
                }
                if (object instanceof ExternalTableOracle) {
                    return "ext_t";
                }
                if (object instanceof ColumnProxyOracle) {
                    return "col";
                }
                return "";
            }
            if (n2 == 1) {
                Object object = privilegedObject.getObject();
                if (object instanceof ColumnProxyOracle) {
                    return ((ColumnProxyOracle)object).getTableProxy().getName() + "." + ((ColumnProxyOracle)object).getName();
                }
                return object;
            }
            if (n2 == 2) {
                String string = "";
                ArrayList<Privilege> arrayList = privilegedObject.getPrivileges();
                Iterator<Privilege> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = string + "," + iterator.next().getObject();
                }
                return privilegedObject.getPrivileges().size() == 0 ? "" : string.substring(1, string.length());
            }
            return "";
        }
    }

    public class ColumnHierarchyRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -8185097460651240900L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = null;
            Iterator iterator = UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.iterator();
            if (iterator.hasNext()) {
                PrivilegedObject privilegedObject = (PrivilegedObject)iterator.next();
                object2 = privilegedObject.getObject();
            }
            boolean bl3 = (Boolean)object;
            if (!jTable.getModel().getValueAt(n, 0).equals("SELECT") || !(object2 instanceof TableProxyOracle) && !(object2 instanceof TableViewProxyOracle)) {
                this.setOpaque(true);
                this.setEnabled(false);
                this.setSelected(false);
                return new JLabel("");
            }
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(bl3);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogOracle.this.savePermissions();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogOracle.this.savePermissions();
            UserAndRolePermissionsDialogOracle.this.close();
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> arrayList) {
            this.privileges = arrayList;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }

        void setPrivilegeWithGrantOption(ArrayList<Privilege> arrayList) {
            this.privilegesWithGrantOption = arrayList;
        }

        void removeAllPrivileges() {
            this.privileges.clear();
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean bl) {
            this.grantOption = bl;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean bl) {
            this.hierarchy = bl;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }
}

