/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.UserAndRolePermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RolePropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private static final long serialVersionUID = 6223251914507648749L;
    private RoleOraclev9i role;
    private JComboBox cbIdentified;
    private JComboBox cbIdentType;
    private JPasswordField tfPassword;
    private JTextField tfSchema;
    private JTextField tfPackage;
    private JPanel panelRoles;
    private JPanel panelSystemPrivileges;
    private JList allPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JList allRolesList;
    private JTable selectedRolesTable;
    private JTable selectedSystemPrivilegesTable;
    private List<Role> selectedRolesList;
    private List<SystemPrivilege> selectedSystemPrivilegesList;
    private DefaultListModel allRolesModel;
    private JButton bnAddRoles;
    private JButton bnRemoveRoles;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogOracle dialog;

    public RolePropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.role = (RoleOraclev9i)storageObject;
        this.setHeight(330);
        this.initCommentsView();
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertyDialogOracle.RoleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initIdentified();
        this.initIdentType();
        this.initPassword();
        this.initSchema();
        this.initPackage();
        this.initPermissionsButton();
    }

    private void initIdentified() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogOracle.Identified"));
        this.general.add(jLabel);
        this.cbIdentified = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIdentified);
        this.cbIdentified.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIdentified);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbIdentified, 50);
    }

    private void initIdentType() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogOracle.IdentificationType"));
        this.general.add(jLabel);
        this.cbIdentType = new JComboBox<String>(RoleOraclev9i.getAuthTypes());
        this.setBG(this.cbIdentType);
        this.cbIdentType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbIdentType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RolePropertyDialogOracle.this.cbIdentType.getSelectedItem() != null) {
                    if (((String)RolePropertyDialogOracle.this.cbIdentType.getSelectedItem()).equalsIgnoreCase("BY_PASSWORD")) {
                        RolePropertyDialogOracle.this.tfPassword.setEditable(true);
                        RolePropertyDialogOracle.this.tfPassword.setText(RolePropertyDialogOracle.this.role.decodePassword());
                    } else {
                        RolePropertyDialogOracle.this.tfPassword.setEditable(false);
                        RolePropertyDialogOracle.this.tfPassword.setText("");
                    }
                }
            }
        });
        this.general.add(this.cbIdentType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbIdentType, 80);
    }

    private void initPassword() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogOracle.Password"));
        this.general.add(jLabel);
        this.tfPassword = new JPasswordField("", 26);
        this.general.add(this.tfPassword);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfPassword, 110);
    }

    private void initSchema() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogOracle.Schema"));
        this.general.add(jLabel);
        this.tfSchema = new JTextField("", 26);
        this.general.add(this.tfSchema);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfSchema, 140);
    }

    private void initPackage() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogOracle.Package"));
        this.general.add(jLabel);
        this.tfPackage = new JTextField("", 26);
        this.general.add(this.tfPackage);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfPackage, 170);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("RolePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 270);
    }

    @Override
    protected void addTabs() {
        this.initRolesView();
        this.initSystemPrivilegesView();
    }

    private void initRolesView() {
        this.panelRoles = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogOracle.Roles"), this.panelRoles);
        this.initRoles();
    }

    private void initSystemPrivilegesView() {
        this.panelSystemPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogOracle.SystemPrivileges"), this.panelSystemPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    private void initAllPrivilegesList() {
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allPrivilegesList);
        jScrollPane.setPreferredSize(new Dimension(430, 125));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelSystemPrivileges.add(jScrollPane);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jScrollPane, 10, 10);
    }

    private void initSelectedPrivilegesList() {
        this.selectedSystemPrivilegesList = new ArrayList<SystemPrivilege>();
        this.selectedSystemPrivilegesTable = new JTable(new SelectedSystemPrivilegesModel());
        this.selectedSystemPrivilegesTable.setSelectionMode(0);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn tableColumn = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(355);
        tableColumn.setMaxWidth(355);
        TableColumn tableColumn2 = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(40);
        tableColumn2.setMaxWidth(40);
        tableColumn2.setCellRenderer(columnAdminRenderer);
        this.selectedSystemPrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getSelectedRow() == -1) {
                    RolePropertyDialogOracle.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.selectedSystemPrivilegesTable);
        jScrollPane.setPreferredSize(new Dimension(430, 125));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelSystemPrivileges.add(jScrollPane);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jScrollPane, 10, 170);
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON", 16));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelSystemPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), this.bnAddPrivileges, 170, 137);
        this.bnRemovePrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON", 16));
        this.bnRemovePrivileges.setPreferredSize(new Dimension(32, 32));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelSystemPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), this.bnRemovePrivileges, 225, 137);
        RolePropertyDialogOracle.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initRoles() {
        this.initAllRolesList();
        this.initSelectedRolesList();
        this.initRolesButtons();
    }

    private void initAllRolesList() {
        this.allRolesModel = new DefaultListModel();
        this.allRolesList = new JList(this.allRolesModel);
        ListSelectionModel listSelectionModel = this.allRolesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllRolesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allRolesList);
        jScrollPane.setPreferredSize(new Dimension(430, 125));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelRoles.add(jScrollPane);
        this.setObjectConstraints(this.getRolesLayout(), jScrollPane, 10, 10);
    }

    private void initSelectedRolesList() {
        this.selectedRolesList = new ArrayList<Role>();
        this.selectedRolesTable = new JTable(new SelectedRolessModel());
        this.selectedRolesTable.setSelectionMode(0);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn tableColumn = this.selectedRolesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(355);
        tableColumn.setMaxWidth(355);
        TableColumn tableColumn2 = this.selectedRolesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(40);
        tableColumn2.setMaxWidth(40);
        tableColumn2.setCellRenderer(columnAdminRenderer);
        this.selectedRolesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RolePropertyDialogOracle.this.selectedRolesTable.getSelectedRow() == -1) {
                    RolePropertyDialogOracle.this.bnRemoveRoles.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnRemoveRoles.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.selectedRolesTable);
        jScrollPane.setPreferredSize(new Dimension(430, 125));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelRoles.add(jScrollPane);
        this.setObjectConstraints(this.getRolesLayout(), jScrollPane, 10, 170);
    }

    private void initRolesButtons() {
        this.bnAddRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON", 16));
        this.bnAddRoles.addActionListener(new AddRolesActionListener());
        this.bnAddRoles.setEnabled(false);
        this.panelRoles.add(this.bnAddRoles);
        this.setObjectConstraints(this.getRolesLayout(), this.bnAddRoles, 170, 137);
        this.bnRemoveRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON", 16));
        this.bnRemoveRoles.setPreferredSize(new Dimension(32, 32));
        this.bnRemoveRoles.setEnabled(false);
        this.bnRemoveRoles.addActionListener(new RemoveRolesActionListener());
        this.panelRoles.add(this.bnRemoveRoles);
        this.setObjectConstraints(this.getRolesLayout(), this.bnRemoveRoles, 225, 137);
        RolePropertyDialogOracle.equalizeButtonSizes(this.bnAddRoles, this.bnRemoveRoles);
    }

    protected SpringLayout getSystemPrivilegesLayout() {
        return (SpringLayout)this.panelSystemPrivileges.getLayout();
    }

    protected SpringLayout getRolesLayout() {
        return (SpringLayout)this.panelRoles.getLayout();
    }

    @Override
    public void initProperties() {
        Object object;
        Object object2;
        StringTokenizer stringTokenizer;
        this.initCaption(this.role.getName());
        this.tfName.setText(this.role.getName());
        this.cbIdentified.setSelectedItem(RolePropertyDialogOracle.translateYesNoForDisplay(this.role.getIdentified()));
        this.cbIdentType.setSelectedItem(this.role.getAuthType());
        this.tfPassword.setText(this.role.decodePassword());
        this.tfSchema.setText(this.role.getSchema());
        this.tfPackage.setText(this.role.getPack());
        Object[] objectArray = this.getStorageDesign().getRoleSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.role.getRoles(), ",");
            stringTokenizer = new StringTokenizer(this.role.getRolesWithAdminOption(), ",");
            object2 = new Role(objectArray[i]);
            ((Role)object2).setObjectID(((RoleOracle)objectArray[i]).getObjectID());
            boolean bl = false;
            while (stringTokenizer2.hasMoreTokens()) {
                object = stringTokenizer2.nextToken().trim();
                if (!((Role)object2).getObjectID().equalsIgnoreCase((String)object)) continue;
                this.selectedRolesList.add((Role)object2);
                bl = true;
                break;
            }
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (!((Role)object2).getObjectID().equalsIgnoreCase((String)object)) continue;
                ((Role)object2).setAdminOption(true);
                this.selectedRolesList.add((Role)object2);
                bl = true;
                break;
            }
            if (bl || this.role.getObjectID().equalsIgnoreCase(((RoleOracle)((Role)object2).getObject()).getObjectID())) continue;
            this.allRolesModel.addElement(((Role)object2).getObject());
        }
        this.sort(this.allRolesModel);
        if (this.allRolesModel.getSize() > 0) {
            this.allRolesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedRolesList.size() > 0) {
            this.selectedRolesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        String[] stringArray = this.role.getPrivilegesValues();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            stringTokenizer = new StringTokenizer(this.role.getPrivileges(), ",");
            object2 = new StringTokenizer(this.role.getPrivilegesWithAdminOption(), ",");
            String string2 = stringArray[i];
            object = null;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (!string2.equalsIgnoreCase(string)) continue;
                object = new SystemPrivilege(string.trim());
                ((SystemPrivilege)object).setName(string);
                this.selectedSystemPrivilegesList.add((SystemPrivilege)object);
                bl = true;
                break;
            }
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = ((StringTokenizer)object2).nextToken().trim();
                if (!string2.equalsIgnoreCase(string)) continue;
                object = new SystemPrivilege(string.trim());
                ((SystemPrivilege)object).setName(string);
                ((SystemPrivilege)object).setAdminOption(true);
                this.selectedSystemPrivilegesList.add((SystemPrivilege)object);
                bl = true;
                break;
            }
            if (bl) continue;
            this.allPrivilegesModel.addElement(string2);
        }
        this.sort(this.allPrivilegesModel);
        if (this.allPrivilegesModel.getSize() > 0) {
            this.allPrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedSystemPrivilegesList.size() > 0) {
            this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.getCommentsList().insert(this.role.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.role != null) {
            this.role.clear();
            this.role.setName(this.tfName.getText());
            this.role.setIdentified(RolePropertyDialogOracle.translateYesNoForStorage((String)this.cbIdentified.getSelectedItem()));
            this.role.setAuthType((String)this.cbIdentType.getSelectedItem());
            this.role.encodePassword(String.valueOf(this.tfPassword.getPassword()));
            this.role.setSchema(this.tfSchema.getText());
            this.role.setPack(this.tfPackage.getText());
            Object[] objectArray = this.selectedRolesList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Role role = (Role)objectArray[i];
                boolean bl = role.getAdminOption();
                if (bl) {
                    this.role.setRolesWithAdminOption(role.getObjectID());
                    continue;
                }
                this.role.setRoles(role.getObjectID());
            }
            Object[] objectArray2 = this.selectedSystemPrivilegesList.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray2[i];
                if (!(object instanceof SystemPrivilege)) continue;
                SystemPrivilege systemPrivilege = (SystemPrivilege)object;
                if (systemPrivilege.getAdminOption()) {
                    this.role.setPrivilegesWithAdminOption(systemPrivilege.getObject().toString());
                    continue;
                }
                this.role.setPrivileges(systemPrivilege.getObject().toString());
            }
            this.role.setComment(this.getCommentsList().getText());
        }
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                if (defaultListModel.get(j).toString().compareTo(defaultListModel.get(j - 1).toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    public class ColumnAdminRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -215127161678321822L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(bl3);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedRolessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1999134389475107666L;
        final String[] COL_NAMES = new String[]{Messages.getString("RolePropertyDialogOracle.Role"), Messages.getString("RolePropertyDialogOracle.Admin")};

        private SelectedRolessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return RolePropertyDialogOracle.this.selectedRolesList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Role role = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(n);
            if (object instanceof Boolean && n2 == 1) {
                role.setAdminOption((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Role role = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(n);
            if (n2 == 0) {
                return role.getObject();
            }
            if (n2 == 1) {
                return role.getAdminOption();
            }
            return "";
        }
    }

    private class SelectedSystemPrivilegesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7290076584038675384L;
        final String[] COL_NAMES = new String[]{Messages.getString("RolePropertyDialogOracle.Privilege"), Messages.getString("RolePropertyDialogOracle.Admin")};

        private SelectedSystemPrivilegesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return RolePropertyDialogOracle.this.selectedSystemPrivilegesList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SystemPrivilege systemPrivilege = (SystemPrivilege)RolePropertyDialogOracle.this.selectedSystemPrivilegesList.get(n);
            if (object instanceof Boolean && n2 == 1) {
                systemPrivilege.setAdminOption((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SystemPrivilege systemPrivilege = (SystemPrivilege)RolePropertyDialogOracle.this.selectedSystemPrivilegesList.get(n);
            if (n2 == 0) {
                return systemPrivilege.getObject();
            }
            if (n2 == 1) {
                return systemPrivilege.getAdminOption();
            }
            return "";
        }
    }

    private class RemoveRolesActionListener
    implements ActionListener {
        private RemoveRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            int[] nArray = RolePropertyDialogOracle.this.selectedRolesTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                Role role = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(nArray[i]);
                object = role.getObject();
                if (RolePropertyDialogOracle.this.allRolesModel.contains(object)) continue;
                RolePropertyDialogOracle.this.selectedRolesList.remove(role);
                RolePropertyDialogOracle.this.allRolesModel.addElement(object);
                RolePropertyDialogOracle.this.sort(RolePropertyDialogOracle.this.allRolesModel);
            }
            RolePropertyDialogOracle.this.selectedRolesTable.updateUI();
            RolePropertyDialogOracle.this.selectedRolesTable.clearSelection();
            RolePropertyDialogOracle.this.allRolesList.setSelectedValue(object, true);
        }
    }

    private class AddRolesActionListener
    implements ActionListener {
        private AddRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            if (!RolePropertyDialogOracle.this.allRolesModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogOracle.this.allRolesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (RolePropertyDialogOracle.this.selectedRolesList.contains(object)) continue;
                    Role role = new Role(object);
                    role.setName(object.toString());
                    role.setObjectID(((RoleOracle)objectArray[i]).getObjectID());
                    RolePropertyDialogOracle.this.selectedRolesList.add(role);
                    RolePropertyDialogOracle.this.allRolesModel.removeElement(objectArray[i]);
                }
            }
            RolePropertyDialogOracle.this.selectedRolesTable.updateUI();
            RolePropertyDialogOracle.this.selectedRolesTable.getSelectionModel().setSelectionInterval(RolePropertyDialogOracle.this.selectedRolesTable.getRowCount() - 1, RolePropertyDialogOracle.this.selectedRolesTable.getRowCount() - 1);
        }
    }

    private class AllRolesListSelectionHandler
    implements ListSelectionListener {
        private AllRolesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogOracle.this.allRolesList.getSelectedIndex() == -1) {
                    RolePropertyDialogOracle.this.bnAddRoles.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnAddRoles.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogOracle.this.allPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogOracle.this.bnAddPrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getSelectedRows();
            Object object = null;
            for (int i = 0; i < nArray.length; ++i) {
                SystemPrivilege systemPrivilege = (SystemPrivilege)RolePropertyDialogOracle.this.selectedSystemPrivilegesList.get(nArray[i]);
                object = systemPrivilege.getObject();
                if (RolePropertyDialogOracle.this.allPrivilegesModel.contains(object)) continue;
                RolePropertyDialogOracle.this.allPrivilegesModel.addElement(object);
                RolePropertyDialogOracle.this.selectedSystemPrivilegesList.remove(systemPrivilege);
                RolePropertyDialogOracle.this.sort(RolePropertyDialogOracle.this.allPrivilegesModel);
            }
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.updateUI();
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.clearSelection();
            RolePropertyDialogOracle.this.allPrivilegesList.setSelectedValue(object, true);
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            if (!RolePropertyDialogOracle.this.allPrivilegesModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogOracle.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (RolePropertyDialogOracle.this.selectedSystemPrivilegesList.contains(object)) continue;
                    SystemPrivilege systemPrivilege = new SystemPrivilege(object);
                    systemPrivilege.setName(object.toString());
                    RolePropertyDialogOracle.this.selectedSystemPrivilegesList.add(systemPrivilege);
                    RolePropertyDialogOracle.this.allPrivilegesModel.removeElement(object);
                }
            }
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.updateUI();
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getRowCount() - 1, RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getRowCount() - 1);
        }
    }

    class Role {
        Object obj = null;
        String name = "";
        String objectID = "";
        boolean adminOption = false;

        Role(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setObjectID(String string) {
            this.objectID = string;
        }

        String getObjectID() {
            return this.objectID;
        }

        void setAdminOption(boolean bl) {
            this.adminOption = bl;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    class SystemPrivilege {
        Object obj = null;
        String name = "";
        boolean adminOption = false;

        SystemPrivilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setAdminOption(boolean bl) {
            this.adminOption = bl;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RolePropertyDialogOracle.this.dialog == null) {
                RolePropertyDialogOracle.this.dialog = new UserAndRolePermissionsDialogOracle(RolePropertyDialogOracle.this.getAppView(), RolePropertyDialogOracle.this.getStorageDesign(), RolePropertyDialogOracle.this.role);
            }
            RolePropertyDialogOracle.this.dialog.showDialog();
        }
    }
}

