/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ColumnsPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ObjectPermissionsDialogOracle
extends CustomDialog {
    private static final long serialVersionUID = 5087210931570700703L;
    private final String USERS = Messages.getString("ObjectPermissionsDialogOracle.Users");
    private final String ROLES = Messages.getString("ObjectPermissionsDialogOracle.Roles");
    private StorageDesignOracle storageDesign;
    private Object storageObject;
    private JButton bnColumns;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private JButton buttonUserRoleAdd;
    private JButton buttonUserRoleRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private final JPanel generalPanel;
    private JPanel allUsersRolesPanel;
    private JPanel usersRolesPanel;
    private JPanel userRolePrivilegesListPanel;
    private JPanel privilegesPanel;
    private JPanel panelUsers;
    private JPanel panelRoles;
    private JPanel grantedUserRolePrivilegesPanel;
    private JDialog dialog;
    private List<Object> privilegedUsersRolesContainerList;
    private List<Privilege> containerListPrivileges;
    private JTable privilegedUsersRolesTable;
    private JTable privilegedUserRolePrivilegesTable;
    private PrivilegedObject currentPrivilegedObject;
    private JScrollPane availablePrivilegesScrollPane;
    private UserSetOracle userSet;
    private RoleSetOracle roleSet;
    private DefaultListModel availablePrivilegesModel;
    private DefaultListModel allUsersPanelListModel;
    private DefaultListModel allRolesPanelListModel;
    private JList availablePrivilegesList;
    private JList allUsersPanelList;
    private JList allRolesPanelList;
    protected JTabbedPane tpane;
    private Privilege currentPrivilege;
    private GrantedPrivilegessModel grantedPrivilegessModel;
    private ArrayList<PrivilegedObject> objWithRevokedPrivs = new ArrayList();
    private ColumnsPermissionsDialogOracle cpDialog;
    private ApplicationView appView;

    public ObjectPermissionsDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView);
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.appView = applicationView;
        this.storageObject = storageObject;
        this.tpane = new JTabbedPane();
        this.tpane.setPreferredSize(new Dimension(180, 400));
        this.generalPanel = new JPanel(new BorderLayout());
        this.initLeftPanel(this.generalPanel);
        this.initAllObjectsPanelAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.setPreferredSize(new Dimension(600, 500));
    }

    private void initLeftPanel(JPanel jPanel) {
        this.allUsersRolesPanel = new JPanel(new BorderLayout());
        this.allUsersRolesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AllUsersRoles")));
        this.initUsersRolesPanelList();
        this.allUsersRolesPanel.add(this.tpane);
        jPanel.add((Component)this.allUsersRolesPanel, "West");
    }

    private void initRightPanel(JPanel jPanel) {
        this.usersRolesPanel = new JPanel(new BorderLayout());
        this.usersRolesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.PrivilegedUsersRoles")));
        this.usersRolesPanel.setPreferredSize(new Dimension(370, 400));
        this.initPrivilegedUsersRoles();
        this.initAvailablePrivileges();
        this.initGrantedUserRoleProvileges();
        this.loadObjectsAndPrivileges();
        jPanel.add((Component)this.usersRolesPanel, "East");
    }

    private void refreshGrantedUserRoleProvileges() {
        ColumnHierarchyRenderer columnHierarchyRenderer = new ColumnHierarchyRenderer();
        if (this.storageObject instanceof TableProxyOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = true;
        } else if (this.storageObject instanceof TableViewProxyOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = true;
        } else if (this.storageObject instanceof SequenceOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = false;
        } else if (this.storageObject instanceof SnapshotOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = false;
        } else if (this.storageObject instanceof StoredProcedureOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = false;
        }
        if (this.currentPrivilegedObject.getObject() instanceof RoleOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = false;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn tableColumn = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() == 1) {
                tableColumn.setWidth(214);
                tableColumn.setMaxWidth(214);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 1) {
                tableColumn.setWidth(162);
                tableColumn.setMaxWidth(162);
                TableColumn tableColumn2 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
                tableColumn2.setWidth(52);
                tableColumn2.setMaxWidth(52);
                tableColumn2.setCellRenderer(columnHierarchyRenderer);
            }
        } else if (this.currentPrivilegedObject.getObject() instanceof UserOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = true;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn tableColumn = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            TableColumn tableColumn3 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() <= 2) {
                tableColumn.setWidth(152);
                tableColumn.setMaxWidth(152);
                tableColumn3.setWidth(40);
                tableColumn3.setMaxWidth(40);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 2) {
                tableColumn.setWidth(100);
                tableColumn.setMaxWidth(100);
                TableColumn tableColumn4 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(2);
                tableColumn4.setWidth(52);
                tableColumn4.setMaxWidth(52);
                tableColumn4.setCellRenderer(columnHierarchyRenderer);
            }
        }
        this.grantedUserRolePrivilegesPanel.updateUI();
    }

    private void initGrantedUserRoleProvileges() {
        this.grantedUserRolePrivilegesPanel = new JPanel(new BorderLayout());
        this.grantedUserRolePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        this.grantedPrivilegessModel = new GrantedPrivilegessModel();
        this.privilegedUserRolePrivilegesTable = new JTable(this.grantedPrivilegessModel);
        this.privilegedUserRolePrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    ObjectPermissionsDialogOracle.this.currentPrivilege = (Privilege)ObjectPermissionsDialogOracle.this.containerListPrivileges.get(ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.privilegedUserRolePrivilegesTable);
        jScrollPane.setPreferredSize(new Dimension(192, 100));
        this.grantedUserRolePrivilegesPanel.add(jScrollPane, "East", 0);
        this.userRolePrivilegesListPanel.add((Component)this.grantedUserRolePrivilegesPanel, "East");
        this.usersRolesPanel.add((Component)this.userRolePrivilegesListPanel, "Center");
    }

    private void initAvailablePrivileges() {
        this.userRolePrivilegesListPanel = new JPanel(new BorderLayout());
        this.userRolePrivilegesListPanel.setPreferredSize(new Dimension(100, 400));
        this.privilegesPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        this.availablePrivilegesScrollPane.setPreferredSize(new Dimension(110, 200));
        jPanel.add(this.availablePrivilegesScrollPane);
        this.privilegesPanel.add((Component)jPanel, "West");
        this.userRolePrivilegesListPanel.add((Component)this.privilegesPanel, "West");
        this.initPrivilegesAddRemoveButtons();
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ObjectPermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.sort(this.availablePrivilegesModel);
    }

    private void initPrivilegedUsersRoles() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.privilegedUsersRolesContainerList = new ArrayList<Object>();
        this.privilegedUsersRolesTable = new JTable(new PriviligedUsersRolesModel());
        this.privilegedUsersRolesTable.setSelectionMode(0);
        TableColumn tableColumn = this.privilegedUsersRolesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(35);
        tableColumn.setMaxWidth(35);
        TableColumn tableColumn2 = this.privilegedUsersRolesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(148);
        tableColumn2.setMaxWidth(148);
        TableColumn tableColumn3 = this.privilegedUsersRolesTable.getColumnModel().getColumn(2);
        tableColumn3.setWidth(185);
        tableColumn3.setMaxWidth(185);
        this.privilegedUsersRolesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectedRow() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleRemove.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleRemove.setEnabled(true);
                    PrivilegedObject privilegedObject = (PrivilegedObject)ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.get(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectedRow());
                    ObjectPermissionsDialogOracle.this.containerListPrivileges = new ArrayList();
                    ObjectPermissionsDialogOracle.this.currentPrivilegedObject = privilegedObject;
                    ObjectPermissionsDialogOracle.this.refreshGrantedUserRoleProvileges();
                    ObjectPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ArrayList arrayList = ObjectPermissionsDialogOracle.this.loadGrantedObjectProvileges(privilegedObject);
                    ObjectPermissionsDialogOracle.this.loadAvailableObjectPrivileges(arrayList);
                    ObjectPermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    ObjectPermissionsDialogOracle.this.allUsersPanelList.clearSelection();
                    ObjectPermissionsDialogOracle.this.allRolesPanelList.clearSelection();
                    ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                    ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.privilegedUsersRolesTable);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        jPanel.add((Component)jScrollPane, "North");
        this.usersRolesPanel.add((Component)jPanel, "North");
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject privilegedObject) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> arrayList = privilegedObject.getPrivileges();
        Iterator<Privilege> iterator = arrayList.iterator();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Privilege privilege = iterator.next();
            this.containerListPrivileges.add(privilege);
            arrayList2.add(privilege.getObject());
        }
        return arrayList2;
    }

    private void loadAvailableObjectPrivileges(ArrayList<Object> arrayList) {
        String[] stringArray = null;
        if (this.storageObject instanceof TableProxyOracle) {
            stringArray = PermissionsOracle.getTablePrivilegesValues();
        } else if (this.storageObject instanceof TableViewProxyOracle) {
            stringArray = PermissionsOracle.getViewPrivilegesValues();
        } else if (this.storageObject instanceof SnapshotOracle) {
            stringArray = PermissionsOracle.getSnapshotPrivilegesValues();
        } else if (this.storageObject instanceof SequenceOracle) {
            stringArray = PermissionsOracle.getSeqPrivilegesValues();
        } else if (this.storageObject instanceof StoredProcedureOracle) {
            stringArray = PermissionsOracle.getProcedurePrivilegesValues();
        } else if (this.storageObject instanceof PackageOracle) {
            stringArray = PermissionsOracle.getPackagePrivilegesValues();
        } else if (this.storageObject instanceof FunctionOracle) {
            stringArray = PermissionsOracle.getProcedurePrivilegesValues();
        } else if (this.storageObject instanceof DirectoryOracle) {
            stringArray = PermissionsOracle.getDirectoryPrivilegesValues();
        } else if (this.storageObject instanceof StructuredTypeProxyOracle) {
            stringArray = PermissionsOracle.getStructuredTypePrivilegesValues();
        } else if (this.storageObject instanceof CollectionTypeProxyOracle) {
            stringArray = PermissionsOracle.getCollectionTypePrivilegesValues();
        } else if (this.storageObject instanceof ExternalTableOracle) {
            stringArray = PermissionsOracle.getExtTablesPrivilegesValues();
        }
        this.availablePrivilegesModel.clear();
        if (stringArray != null) {
            Iterator<String> iterator = Arrays.asList(stringArray).iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().trim();
                if (arrayList.size() != 0 && arrayList.contains(string)) continue;
                this.availablePrivilegesModel.addElement(string);
            }
        }
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonPrivilegeAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonPrivilegeRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonPrivilegeAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove.setPreferredSize(this.buttonPrivilegeAdd.getPreferredSize());
        jPanel3.add((Component)this.buttonPrivilegeAdd, "North");
        jPanel3.add((Component)this.buttonPrivilegeRemove, "Center");
        jPanel2.add(jPanel3);
        jPanel.add(new JPanel());
        jPanel.add(jPanel2);
        jPanel.add(new JPanel());
        this.privilegesPanel.add((Component)jPanel, "East");
    }

    private void loadObjectsAndPrivileges() {
        this.initUsers();
        this.initRoles();
    }

    private void initUsers() {
        this.userSet = this.storageDesign.getUserSet();
        for (Object e : this.userSet.getElementsList()) {
            this.checkPermissions(e);
        }
        this.sort(this.allUsersPanelListModel);
    }

    private void initRoles() {
        this.roleSet = this.storageDesign.getRoleSet();
        for (Object e : this.roleSet.getElementsList()) {
            this.checkPermissions(e);
        }
        this.sort(this.allRolesPanelListModel);
    }

    private void checkPermissions(Object object) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)object, (StorageObject)this.storageObject);
        if (permissionsOracle == null) {
            if (object instanceof UserOracle) {
                this.allUsersPanelListModel.addElement(object);
            } else if (object instanceof RoleOracle) {
                this.allRolesPanelListModel.addElement(object);
            }
        } else if (permissionsOracle != null) {
            Object object2;
            Object object3;
            Object object4;
            this.privilegedUserRolePrivilegesTable.updateUI();
            PrivilegedObject privilegedObject = new PrivilegedObject(object);
            ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
            StringTokenizer stringTokenizer = new StringTokenizer(permissionsOracle.getPrivileges(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                object4 = stringTokenizer.nextToken().trim();
                object3 = new Privilege(((String)object4).trim());
                ((Privilege)object3).setName((String)object4);
                arrayList.add((Privilege)object3);
            }
            object4 = new StringTokenizer(permissionsOracle.getPrivilegesWithGrantOption(), ",");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                object3 = ((StringTokenizer)object4).nextToken().trim();
                object2 = new Privilege(((String)object3).trim());
                ((Privilege)object2).setName((String)object3);
                ((Privilege)object2).setGrantOption(true);
                arrayList.add((Privilege)object2);
            }
            object3 = new StringTokenizer(permissionsOracle.getPrivilegesWithHierarchyOption(), ",");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().trim();
                Privilege privilege = new Privilege(((String)object2).trim());
                privilege.setName((String)object2);
                privilege.setHierarchy(true);
                arrayList.add(privilege);
            }
            privilegedObject.setPrivileges(arrayList);
            this.privilegedUsersRolesContainerList.add(privilegedObject);
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getUser() != storageObject && permissionsOracle.getRole() != storageObject || permissionsOracle.getTable() != storageObject2 && permissionsOracle.getView() != storageObject2 && permissionsOracle.getProc() != storageObject2 && permissionsOracle.getFunctionOracle() != storageObject2 && permissionsOracle.getSequence() != storageObject2 && permissionsOracle.getSnapshot() != storageObject2 && permissionsOracle.getPackage() != storageObject2 && permissionsOracle.getDirectoryOracle() != storageObject2 && permissionsOracle.getStructuredTypeOracle() != storageObject2 && permissionsOracle.getCollectionTypeOracle() != storageObject2 && permissionsOracle.getExternalTableOracle() != storageObject2) continue;
            return permissionsOracle;
        }
        return null;
    }

    private void initBottomPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        if (this.storageObject instanceof TableProxyOracle) {
            this.bnColumns = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Columns"));
            this.bnColumns.addActionListener(new ShowColumnsPermissionsAction());
            this.bnColumns.setMnemonic(79);
            this.bnColumns.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel2.add(this.bnColumns);
        }
        this.bnOK = new JButton(Messages.getString("ObjectPermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnCancel);
        jPanel.add((Component)jPanel2, "South");
    }

    private void initUsersRolesPanelList() {
        this.panelUsers = new JPanel(new SpringLayout());
        this.tpane.addTab(this.USERS, this.panelUsers);
        this.allUsersPanelListModel = new DefaultListModel();
        this.allUsersPanelList = new JList(this.allUsersPanelListModel);
        JScrollPane jScrollPane = new JScrollPane(this.allUsersPanelList);
        jScrollPane.setPreferredSize(new Dimension(176, 417));
        this.panelUsers.add(jScrollPane);
        this.allUsersPanelList.getSelectionModel().addListSelectionListener(new allUsersRolesPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ObjectPermissionsDialogOracle.this.allUsersPanelList.getSelectedIndex() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.clearSelection();
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(true);
                }
            }
        });
        this.panelRoles = new JPanel(new SpringLayout());
        this.tpane.addTab(this.ROLES, this.panelRoles);
        this.allRolesPanelListModel = new DefaultListModel();
        this.allRolesPanelList = new JList(this.allRolesPanelListModel);
        JScrollPane jScrollPane2 = new JScrollPane(this.allRolesPanelList);
        jScrollPane2.setPreferredSize(new Dimension(180, 432));
        this.panelRoles.add(jScrollPane2);
        this.allRolesPanelList.getSelectionModel().addListSelectionListener(new allUsersRolesPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ObjectPermissionsDialogOracle.this.allRolesPanelList.getSelectedIndex() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(true);
                }
            }
        });
    }

    private void initAllObjectsPanelAddRemoveButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel2.setPreferredSize(new Dimension(35, 500));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonUserRoleAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonUserRoleAdd.addActionListener(new AddUserRoleActionListener());
        this.buttonUserRoleAdd.setEnabled(false);
        this.buttonUserRoleAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonUserRoleRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonUserRoleRemove.setEnabled(false);
        this.buttonUserRoleRemove.addActionListener(new RemoveUserRoleActionActionListener());
        this.buttonUserRoleRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonUserRoleAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonUserRoleRemove.setPreferredSize(this.buttonUserRoleAdd.getPreferredSize());
        jPanel4.add((Component)this.buttonUserRoleAdd, "North");
        jPanel4.add((Component)this.buttonUserRoleRemove, "Center");
        jPanel3.add(jPanel4);
        jPanel2.add(new JPanel());
        jPanel2.add(jPanel3);
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        jPanel.add((Component)jPanel2, "Center");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ObjectPermissionsDialogOracle.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                if (defaultListModel.get(j).toString().compareTo(defaultListModel.get(j - 1).toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    protected void savePermissions() {
        Object object;
        Object object2;
        PermissionsOracle permissionsOracle = null;
        PermissionsSetOracle permissionsSetOracle = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedUsersRolesTable.getRowCount(); ++i) {
            object2 = (PrivilegedObject)this.privilegedUsersRolesContainerList.get(i);
            object = ((PrivilegedObject)object2).getObject();
            permissionsOracle = this.getPermissionPerObject((StorageObject)object, (StorageObject)this.storageObject);
            if (permissionsOracle == null) {
                permissionsOracle = permissionsSetOracle.createPermissions();
                if (this.storageObject instanceof TableProxyOracle) {
                    permissionsOracle.setTable((TableProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof TableViewProxyOracle) {
                    permissionsOracle.setView((TableViewProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof SnapshotOracle) {
                    permissionsOracle.setSnapshot((SnapshotOracle)this.storageObject);
                } else if (this.storageObject instanceof SequenceOracle) {
                    permissionsOracle.setSequence((SequenceOracle)this.storageObject);
                } else if (this.storageObject instanceof StoredProcedureOracle) {
                    permissionsOracle.setProc((StoredProcedureOracle)this.storageObject);
                } else if (this.storageObject instanceof PackageOracle) {
                    permissionsOracle.setPackage((PackageOracle)this.storageObject);
                } else if (this.storageObject instanceof FunctionOracle) {
                    permissionsOracle.setFunctionOracle((FunctionOracle)this.storageObject);
                } else if (this.storageObject instanceof DirectoryOracle) {
                    permissionsOracle.setDirectoryOracle((DirectoryOracle)this.storageObject);
                } else if (this.storageObject instanceof StructuredTypeProxyOracle) {
                    permissionsOracle.setStructuredTypeOracle((StructuredTypeProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof CollectionTypeProxyOracle) {
                    permissionsOracle.setCollectionTypeOracle((CollectionTypeProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof ExternalTableOracle) {
                    permissionsOracle.setExternalTableOracle((ExternalTableOracle)this.storageObject);
                }
                if (object instanceof UserOracle) {
                    permissionsOracle.setUser((UserOracle)object);
                } else if (object instanceof RoleOracle) {
                    permissionsOracle.setRole((RoleOracle)object);
                }
            } else if (permissionsOracle != null) {
                permissionsOracle.clear();
            }
            for (Privilege privilege : ((PrivilegedObject)object2).getPrivileges()) {
                permissionsOracle.setPrivileges((String)privilege.getObject());
                if (privilege.getGrantOption()) {
                    permissionsOracle.setPrivilegesWithGrantOption((String)privilege.getObject());
                }
                if (!privilege.getHierarchy()) continue;
                permissionsOracle.setPrivilegesWithHierarchyOption((String)privilege.getObject());
            }
        }
        Iterator<PrivilegedObject> iterator = this.objWithRevokedPrivs.iterator();
        while (iterator.hasNext()) {
            object2 = (StorageObject)iterator.next().getObject();
            object = this.getPermissionPerObject((StorageObject)object2, (StorageObject)this.storageObject);
            permissionsSetOracle.remove((ModelObject)object);
            ((StorageObject)object2).setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPermissionsDialogOracle.this.savePermissions();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPermissionsDialogOracle.this.savePermissions();
            ObjectPermissionsDialogOracle.this.close();
        }
    }

    private class ShowColumnsPermissionsAction
    implements ActionListener {
        private ShowColumnsPermissionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ObjectPermissionsDialogOracle.this.allUsersPanelList.getSelectedValues();
            Object[] objectArray2 = ObjectPermissionsDialogOracle.this.allRolesPanelList.getSelectedValues();
            if (objectArray.length == 0 && objectArray2.length == 0 && ObjectPermissionsDialogOracle.this.currentPrivilegedObject == null) {
                JOptionPane.showMessageDialog(null, Messages.getString("ColumnsPermissionsDialogOracle.UserRoleMustBeSelected"), Messages.getString("ObjectPermissionsDialogOracle.Error"), 0);
            } else if (objectArray.length > 1 || objectArray2.length > 1) {
                JOptionPane.showMessageDialog(null, Messages.getString("ColumnsPermissionsDialogOracle.MultipleUserRoleSelected"), Messages.getString("ObjectPermissionsDialogOracle.Error"), 0);
            } else if (objectArray.length == 1 || objectArray2.length == 1 || ObjectPermissionsDialogOracle.this.currentPrivilegedObject != null) {
                if (objectArray.length == 1) {
                    ObjectPermissionsDialogOracle.this.cpDialog = new ColumnsPermissionsDialogOracle(ObjectPermissionsDialogOracle.this.appView, ObjectPermissionsDialogOracle.this.storageDesign, objectArray[0], (TableProxyOracle)ObjectPermissionsDialogOracle.this.storageObject);
                    ObjectPermissionsDialogOracle.this.cpDialog.showDialog();
                } else if (objectArray2.length == 1) {
                    ObjectPermissionsDialogOracle.this.cpDialog = new ColumnsPermissionsDialogOracle(ObjectPermissionsDialogOracle.this.appView, ObjectPermissionsDialogOracle.this.storageDesign, objectArray2[0], (TableProxyOracle)ObjectPermissionsDialogOracle.this.storageObject);
                    ObjectPermissionsDialogOracle.this.cpDialog.showDialog();
                } else if (ObjectPermissionsDialogOracle.this.currentPrivilegedObject != null) {
                    ObjectPermissionsDialogOracle.this.cpDialog = new ColumnsPermissionsDialogOracle(ObjectPermissionsDialogOracle.this.appView, ObjectPermissionsDialogOracle.this.storageDesign, ObjectPermissionsDialogOracle.this.currentPrivilegedObject.getObject(), (TableProxyOracle)ObjectPermissionsDialogOracle.this.storageObject);
                    ObjectPermissionsDialogOracle.this.cpDialog.showDialog();
                }
            }
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> arrayList) {
            this.privileges = arrayList;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }

        void setPrivilegeWithGrantOption(ArrayList<Privilege> arrayList) {
            this.privilegesWithGrantOption = arrayList;
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean bl) {
            this.grantOption = bl;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean bl) {
            this.hierarchy = bl;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRows();
            ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
            for (int i = 0; i < nArray.length; ++i) {
                Privilege privilege = (Privilege)ObjectPermissionsDialogOracle.this.containerListPrivileges.get(nArray[i]);
                Object object = privilege.getObject();
                arrayList.add(privilege);
                if (ObjectPermissionsDialogOracle.this.availablePrivilegesModel.contains(object)) continue;
                ObjectPermissionsDialogOracle.this.availablePrivilegesModel.addElement(object);
                ObjectPermissionsDialogOracle.this.currentPrivilegedObject.removePrivilege(privilege);
                ObjectPermissionsDialogOracle.this.sort(ObjectPermissionsDialogOracle.this.availablePrivilegesModel);
                ObjectPermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(object, true);
            }
            ObjectPermissionsDialogOracle.this.containerListPrivileges.removeAll(arrayList);
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ObjectPermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Privilege privilege = new Privilege(objectArray[i]);
                if (ObjectPermissionsDialogOracle.this.containerListPrivileges.contains(privilege)) continue;
                ObjectPermissionsDialogOracle.this.containerListPrivileges.add(privilege);
                ObjectPermissionsDialogOracle.this.availablePrivilegesModel.removeElement(objectArray[i]);
                ObjectPermissionsDialogOracle.this.currentPrivilegedObject.addPrivilege(privilege);
            }
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectionModel().setSelectionInterval(ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1, ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemoveUserRoleActionActionListener
    implements ActionListener {
        private RemoveUserRoleActionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectPermissionsDialogOracle.this.objWithRevokedPrivs.clear();
            int[] nArray = ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                PrivilegedObject privilegedObject = (PrivilegedObject)ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.get(nArray[i]);
                Object object = privilegedObject.getObject();
                ObjectPermissionsDialogOracle.this.objWithRevokedPrivs.add(privilegedObject);
                if (privilegedObject.getObject() instanceof UserOracle && !ObjectPermissionsDialogOracle.this.allUsersPanelListModel.contains(object)) {
                    ObjectPermissionsDialogOracle.this.allUsersPanelListModel.addElement(object);
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.remove(privilegedObject);
                    ObjectPermissionsDialogOracle.this.tpane.setSelectedIndex(ObjectPermissionsDialogOracle.this.tpane.indexOfTab(ObjectPermissionsDialogOracle.this.USERS));
                    ObjectPermissionsDialogOracle.this.sort(ObjectPermissionsDialogOracle.this.allUsersPanelListModel);
                    ObjectPermissionsDialogOracle.this.allUsersPanelList.setSelectedValue(object, true);
                }
                if (!(privilegedObject.getObject() instanceof RoleOracle) || ObjectPermissionsDialogOracle.this.allRolesPanelListModel.contains(object)) continue;
                ObjectPermissionsDialogOracle.this.allRolesPanelListModel.addElement(object);
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.remove(privilegedObject);
                ObjectPermissionsDialogOracle.this.tpane.setSelectedIndex(ObjectPermissionsDialogOracle.this.tpane.indexOfTab(ObjectPermissionsDialogOracle.this.ROLES));
                ObjectPermissionsDialogOracle.this.sort(ObjectPermissionsDialogOracle.this.allRolesPanelListModel);
                ObjectPermissionsDialogOracle.this.allRolesPanelList.setSelectedValue(object, true);
            }
            ObjectPermissionsDialogOracle.this.availablePrivilegesModel.clear();
            ObjectPermissionsDialogOracle.this.containerListPrivileges.clear();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.clearSelection();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
        }
    }

    private class AddUserRoleActionListener
    implements ActionListener {
        private AddUserRoleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ObjectPermissionsDialogOracle.this.tpane.getTitleAt(ObjectPermissionsDialogOracle.this.tpane.getSelectedIndex());
            if (string.equals(ObjectPermissionsDialogOracle.this.USERS)) {
                Object[] objectArray = ObjectPermissionsDialogOracle.this.allUsersPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.contains(privilegedObject)) continue;
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.add(privilegedObject);
                    ObjectPermissionsDialogOracle.this.allUsersPanelListModel.removeElement(objectArray[i]);
                }
            } else if (string.equals(ObjectPermissionsDialogOracle.this.ROLES)) {
                Object[] objectArray = ObjectPermissionsDialogOracle.this.allRolesPanelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                    if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.contains(privilegedObject)) continue;
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.add(privilegedObject);
                    ObjectPermissionsDialogOracle.this.allRolesPanelListModel.removeElement(objectArray[i]);
                }
            }
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectionModel().setSelectionInterval(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowCount() - 1, ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowCount() - 1);
        }
    }

    private class allUsersRolesPanelSelectionListener
    implements ListSelectionListener {
        private allUsersRolesPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class PriviligedUsersRolesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2600753990274250235L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Type"), Messages.getString("ObjectPermissionsDialogOracle.UserRole"), Messages.getString("ObjectPermissionsDialogOracle.Privilegepermission")};

        private PriviligedUsersRolesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PrivilegedObject privilegedObject = (PrivilegedObject)ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.get(n);
            if (n2 == 0) {
                Object object = privilegedObject.getObject();
                if (object instanceof UserOracle) {
                    return "user";
                }
                if (object instanceof RoleOracle) {
                    return "role";
                }
                return "";
            }
            if (n2 == 1) {
                return privilegedObject.getObject();
            }
            if (n2 == 2) {
                String string = "";
                ArrayList<Privilege> arrayList = privilegedObject.getPrivileges();
                Iterator<Privilege> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = string + "," + iterator.next().getObject();
                }
                return privilegedObject.getPrivileges().size() == 0 ? "" : string.substring(1, string.length());
            }
            return "";
        }
    }

    private class GrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Privilege"), Messages.getString("ObjectPermissionsDialogOracle.Grant"), Messages.getString("ObjectPermissionsDialogOracle.Heiarachy")};
        boolean[] columnsVisible = new boolean[3];

        public GrantedPrivilegessModel() {
            this.columnsVisible[0] = true;
            this.columnsVisible[1] = false;
            this.columnsVisible[2] = false;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            for (int i = 0; i < this.COL_NAMES.length; ++i) {
                if (!this.columnsVisible[i]) continue;
                ++n;
            }
            return n;
        }

        protected int getNumber(int n) {
            int n2 = n;
            int n3 = 0;
            do {
                if (this.columnsVisible[n3]) continue;
                ++n2;
            } while (++n3 < n2);
            while (!this.columnsVisible[n2]) {
                ++n2;
            }
            return n2;
        }

        @Override
        public int getRowCount() {
            return ObjectPermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[this.getNumber(n)];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Object object = ObjectPermissionsDialogOracle.this.storageObject;
            ContainerObject containerObject = null;
            int n3 = this.getNumber(n2);
            if (n3 == 0) {
                return false;
            }
            if (n3 == 1) {
                return true;
            }
            if (n3 == 2) {
                if (this.getValueAt(n, 0).equals("SELECT") && (object instanceof TableProxyOracle || object instanceof TableViewProxyOracle)) {
                    DesignObject designObject;
                    if (object instanceof TableProxyOracle) {
                        designObject = (Table)((TableProxyOracle)object).getObject();
                        containerObject = designObject;
                    }
                    if (object instanceof TableViewProxyOracle) {
                        designObject = (TableView)((TableViewProxyOracle)object).getObject();
                        containerObject = designObject;
                    }
                    if ((designObject = containerObject.getBasedOnStructuredType()) != null && !((StructuredType)designObject).isFinal()) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = this.getNumber(n2);
            Privilege privilege = (Privilege)ObjectPermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (object instanceof Boolean) {
                if (n3 == 1) {
                    privilege.setGrantOption((Boolean)object);
                } else if (n3 == 2) {
                    privilege.setHierarchy((Boolean)object);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = this.getNumber(n2);
            Privilege privilege = (Privilege)ObjectPermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (n3 == 0) {
                return ((String)privilege.getObject()).trim();
            }
            if (n3 == 1) {
                return new Boolean(privilege.grantOption);
            }
            if (n3 == 2) {
                return new Boolean(privilege.hierarchy);
            }
            return "";
        }
    }

    public class ColumnHierarchyRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 3347256798461278910L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = ObjectPermissionsDialogOracle.this.storageObject;
            boolean bl3 = (Boolean)object;
            if (!jTable.getModel().getValueAt(n, 0).equals("SELECT") || !(object2 instanceof TableProxyOracle) && !(object2 instanceof TableViewProxyOracle)) {
                this.setOpaque(true);
                this.setEnabled(false);
                this.setSelected(false);
                return new JLabel("");
            }
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(bl3);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

