/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class MethodParamPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private MethodParamProxyOracle param;
    private JTextField tfDatatype;
    private JComboBox cbDirectionType;
    private JComboBox cbCopyArg;

    public MethodParamPropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.param = (MethodParamProxyOracle)storageObject;
        this.setHeight(170);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodParamPropertyDialogOracle.MethodParamProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatatype();
        this.initDirectionType();
        this.initCopyClause();
    }

    private void initDatatype() {
        JLabel jLabel = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.Datatype"));
        this.general.add(jLabel);
        this.tfDatatype = new JTextField("", 26);
        this.tfDatatype.setEnabled(false);
        this.general.add(this.tfDatatype);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDatatype, 50);
    }

    private void initDirectionType() {
        JLabel jLabel = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.DirectionType"));
        this.general.add(jLabel);
        this.cbDirectionType = new JComboBox<String>(MethodParamProxyOracle.DIRECTION_TYPE_CHOICES);
        this.setBG(this.cbDirectionType);
        this.cbDirectionType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDirectionType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbDirectionType, 80);
    }

    private void initCopyClause() {
        JLabel jLabel = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.CopyArgument"));
        this.general.add(jLabel);
        this.cbCopyArg = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCopyArg);
        this.cbCopyArg.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCopyArg);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCopyArg, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.param.getName());
        this.tfName.setText(this.param.getName());
        this.tfDatatype.setText(((MethodParam)this.param.getObject()).getDataType());
        this.cbDirectionType.setSelectedItem(this.param.getDirectionType());
        this.cbCopyArg.setSelectedItem(MethodParamPropertyDialogOracle.translateYesNoForDisplay(this.param.getCopyArgument()));
        this.getCommentsList().insert(this.param.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.param != null) {
            this.param.setName(this.tfName.getText());
            this.param.setDirectionType((String)this.cbDirectionType.getSelectedItem());
            this.param.setCopyArgument(MethodParamPropertyDialogOracle.translateYesNoForStorage((String)this.cbCopyArg.getSelectedItem()));
            this.param.setComment(this.getCommentsList().getText());
        }
    }
}

