/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class LobStoragePropertyDialogOracle
extends AbstractOraclePropertyDialog {
    protected LobStorageOracle lobStorage;
    private JTextField tfColumn;
    private JTextField tfLobSegmentName;
    private JComboBox cbTableSpace;
    private JComboBox cbStorageInRow;
    protected JComboBox cbLogging;
    private JComboBox cbCache;
    private JIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JIntegerField ifPctVersion;
    private JIntegerField ifFreePools;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JIntegerField ifSCPctIncrease;
    private JComboBox cbSCBufferPool;
    private JIntegerField ifSCFreeLists;
    private JIntegerField ifSCFreeListsGroups;

    public LobStoragePropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.lobStorage = (LobStorageOracle)storageObject;
        this.setHeight(620);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    public String getCaption() {
        return Messages.getString("LobStoragePropertyDialogOracle.LobStorageProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        int n = 50;
        n += this.initLobColumn(n);
        n += this.initLobStorageType(n);
        n += this.initLobSegmentName(n);
        n += this.initTableSpace(n);
        n += this.initStorageInRow(n);
        n += this.initLogging(n);
        n += this.initCache(n);
        n += this.initChunk(n);
        n += this.initOldVersions(n);
        n += this.initPctVersion(n);
        n += this.initFreePools(n);
        n += this.initSCInitialExtent(n);
        n += this.initSCNextExtent(n);
        n += this.initSCMinExtents(n);
        n += this.initSCMaxExtents(n);
        n += this.initSCPctIncrease(n);
        n += this.initSCBufferPool(n);
        n += this.initSCFreeLists(n);
        n += this.initSCFreeListsGroups(n);
    }

    private int initLobColumn(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.LobColumn"));
        this.general.add(jLabel);
        this.tfColumn = new JTextField("", 26);
        this.tfColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfColumn);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfColumn, n);
        return 30;
    }

    protected int initLobStorageType(int n) {
        return 0;
    }

    private int initLobSegmentName(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.LobSegmentName"));
        this.general.add(jLabel);
        this.tfLobSegmentName = new JTextField("", 26);
        this.general.add(this.tfLobSegmentName);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfLobSegmentName, n);
        return 30;
    }

    private int initTableSpace(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbTableSpace, n);
        return 30;
    }

    private int initStorageInRow(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.StorageInRow"));
        this.general.add(jLabel);
        this.cbStorageInRow = new JComboBox<String>(LobStorageOracle.getStorageInRowChoices());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageInRow);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbStorageInRow, n);
        return 30;
    }

    protected int initLogging(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbLogging, n);
        return 30;
    }

    private int initCache(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.Cache"));
        this.general.add(jLabel);
        this.cbCache = new JComboBox<String>(LobStorageOracle.getCacheChoices());
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbCache, n);
        return 30;
    }

    private int initChunk(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.Chunk"));
        this.general.add(jLabel);
        this.ifChunk = new JIntegerField(0, 26);
        this.general.add(this.ifChunk);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifChunk, n);
        return 30;
    }

    private int initOldVersions(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.OldVersions"));
        this.general.add(jLabel);
        this.cbOldVersions = new JComboBox<String>(LobStorageOracle.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOldVersions);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbOldVersions, n);
        return 30;
    }

    private int initPctVersion(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.PCTVersion"));
        this.general.add(jLabel);
        this.ifPctVersion = new JIntegerField(0, 26);
        this.general.add(this.ifPctVersion);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifPctVersion, n);
        return 30;
    }

    private int initFreePools(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.FreePools"));
        this.general.add(jLabel);
        this.ifFreePools = new JIntegerField(0, 26);
        this.general.add(this.ifFreePools);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifFreePools, n);
        return 30;
    }

    private int initSCInitialExtent(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCInitialExtent"));
        this.general.add(jLabel);
        this.ifSCInitialExtent = new JIntegerField(0, 26);
        this.general.add(this.ifSCInitialExtent);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifSCInitialExtent, n);
        return 30;
    }

    private int initSCNextExtent(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCNextExtent"));
        this.general.add(jLabel);
        this.ifSCNextExtent = new JIntegerField(0, 26);
        this.general.add(this.ifSCNextExtent);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifSCNextExtent, n);
        return 30;
    }

    private int initSCMinExtents(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCMinExtents"));
        this.general.add(jLabel);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.general.add(this.ifSCMinExtents);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifSCMinExtents, n);
        return 30;
    }

    private int initSCMaxExtents(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCMaxExtents"));
        this.general.add(jLabel);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.general.add(this.tfSCMaxExtents);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfSCMaxExtents, n);
        return 30;
    }

    private int initSCPctIncrease(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCPCTIncrease"));
        this.general.add(jLabel);
        this.ifSCPctIncrease = new JIntegerField(0, 26);
        this.general.add(this.ifSCPctIncrease);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifSCPctIncrease, n);
        return 30;
    }

    private int initSCBufferPool(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCBufferPool"));
        this.general.add(jLabel);
        this.cbSCBufferPool = new JComboBox<String>(LobStorageOracle.getSCBufferPoolValues());
        this.setBG(this.cbSCBufferPool);
        this.cbSCBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSCBufferPool);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbSCBufferPool, n);
        return 30;
    }

    private int initSCFreeLists(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCFreeLists"));
        this.general.add(jLabel);
        this.ifSCFreeLists = new JIntegerField(0, 26);
        this.general.add(this.ifSCFreeLists);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifSCFreeLists, n);
        return 30;
    }

    private int initSCFreeListsGroups(int n) {
        JLabel jLabel = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCFreeListsGrps"));
        this.general.add(jLabel);
        this.ifSCFreeListsGroups = new JIntegerField(0, 26);
        this.general.add(this.ifSCFreeListsGroups);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifSCFreeListsGroups, n);
        return 30;
    }

    @Override
    public void initProperties() {
        this.initCaption(this.lobStorage.getName());
        this.tfName.setText(this.lobStorage.getName());
        this.tfColumn.setText(this.lobStorage.getColumn());
        this.tfLobSegmentName.setText(this.lobStorage.getLobSegmentName());
        this.selectObject(this.cbTableSpace, this.lobStorage.getTableSpace());
        this.cbStorageInRow.setSelectedItem(this.lobStorage.getStorageInRow());
        this.cbLogging.setSelectedItem(LobStoragePropertyDialogOracle.translateYesNoForDisplay(this.lobStorage.getLogging()));
        this.cbCache.setSelectedItem(this.lobStorage.getCache());
        this.ifChunk.setValue((long)this.lobStorage.getChunk());
        this.cbOldVersions.setSelectedItem(this.lobStorage.getOldVersions());
        this.ifFreePools.setValue((long)this.lobStorage.getFreepools());
        this.ifPctVersion.setValue((long)this.lobStorage.getPCTVersion());
        this.ifSCInitialExtent.setValue(this.lobStorage.getSCInitialExtent());
        this.ifSCNextExtent.setValue(this.lobStorage.getSCNextExtent());
        this.ifSCMinExtents.setValue((long)this.lobStorage.getSCMinExtents());
        this.tfSCMaxExtents.setText(this.lobStorage.getSCMaxExtents());
        this.ifSCPctIncrease.setValue((long)this.lobStorage.getSCPctIncrease());
        this.cbSCBufferPool.setSelectedItem(this.lobStorage.getSCBufferPool());
        this.ifSCFreeLists.setValue((long)this.lobStorage.getSCFreeLists());
        this.ifSCFreeListsGroups.setValue((long)this.lobStorage.getSCFreelistGroups());
        this.getCommentsList().insert(this.lobStorage.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.lobStorage != null) {
            this.lobStorage.setName(this.tfName.getText());
            this.lobStorage.setColumn(this.tfColumn.getText());
            this.lobStorage.setLobSegmentName(this.tfLobSegmentName.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.lobStorage.setTableSpace((TableSpaceOracle)object);
            } else {
                this.lobStorage.setTableSpace(null);
            }
            this.lobStorage.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
            this.lobStorage.setLogging(LobStoragePropertyDialogOracle.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.lobStorage.setCache((String)this.cbCache.getSelectedItem());
            this.lobStorage.setChunk(this.ifChunk.getIntValue());
            this.lobStorage.setOldVersions((String)this.cbOldVersions.getSelectedItem());
            this.lobStorage.setFreepools(this.ifFreePools.getIntValue());
            this.lobStorage.setPCTVersion(this.ifPctVersion.getIntValue());
            this.lobStorage.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
            this.lobStorage.setSCNextExtent(this.ifSCNextExtent.getIntValue());
            this.lobStorage.setSCMinExtents(this.ifSCMinExtents.getIntValue());
            this.lobStorage.setSCMaxExtents(this.tfSCMaxExtents.getText());
            this.tfSCMaxExtents.setText(this.lobStorage.getSCMaxExtents());
            this.lobStorage.setSCPctIncrease(this.ifSCPctIncrease.getIntValue());
            this.lobStorage.setSCBufferPool((String)this.cbSCBufferPool.getSelectedItem());
            this.lobStorage.setSCFreeLists(this.ifSCFreeLists.getIntValue());
            this.lobStorage.setSCFreelistGroups(this.ifSCFreeListsGroups.getIntValue());
            this.lobStorage.setComment(this.getCommentsList().getText());
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((String)LobStoragePropertyDialogOracle.this.cbOldVersions.getSelectedItem()).equalsIgnoreCase(LobStorageOracle.getOldVersionChoices()[0])) {
                LobStoragePropertyDialogOracle.this.ifPctVersion.setEnabled(false);
            } else {
                LobStoragePropertyDialogOracle.this.ifPctVersion.setEnabled(true);
            }
        }
    }
}

