/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class HierarchyPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private HierarchyOracle hierarchy;
    private DefaultListModel allLevelsModel;
    private DefaultListModel selectedLevelsModel;
    private JList allLevelsList;
    private JList selectedLevelsList;
    private JButton bnLevelAdd;
    private JButton bnLevelRemove;
    private JPanel joins;
    private JList joinList;
    private DefaultListModel joinListModel;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBox cbLevel;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnColumnAdd;
    private JButton bnColumnRemove;

    public HierarchyPropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.hierarchy = (HierarchyOracle)storageObject;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("HierarchyPropertyDialogOracle.HierarchyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAllLevelsList();
        this.initSelectedLevelsList();
        this.initButtons();
    }

    @Override
    protected void addTabs() {
        this.initJoinView();
    }

    private void initJoinView() {
        this.joins = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("HierarchyPropertyDialogOracle.JoinClause"), this.joins);
        this.initJoinClause();
    }

    private void initJoinClause() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
        this.initLevel();
        this.initJoinButtons();
        this.initJoinList();
    }

    private void initJoinList() {
        JLabel jLabel = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.Joins"));
        this.joins.add(jLabel);
        this.joinListModel = new DefaultListModel();
        this.joinList = new JList(this.joinListModel);
        this.joinList.setSelectionMode(0);
        this.joinList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (HierarchyPropertyDialogOracle.this.joinList.getSelectedValue() != null) {
                    HierarchyPropertyDialogOracle.this.btnRemove.setEnabled(HierarchyPropertyDialogOracle.this.isEditable());
                } else {
                    HierarchyPropertyDialogOracle.this.btnRemove.setEnabled(false);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.joinList);
        jScrollPane.setPreferredSize(new Dimension(395, 130));
        this.joins.add(jScrollPane);
        this.setLabelConstraints(this.getJoinsLayout(), jLabel, 12, 210);
        this.setObjectConstraints(this.getJoinsLayout(), jScrollPane, 10, 230);
    }

    private String getReferencedLevel(LevelOracle levelOracle) {
        ListModel listModel = this.selectedLevelsList.getModel();
        TableProxy tableProxy = levelOracle.getLevelTable();
        if (listModel.getSize() > 1) {
            for (int i = 0; i < listModel.getSize() - 1; ++i) {
                if (listModel.getElementAt(i) != levelOracle) continue;
                for (int j = i; j < listModel.getSize() - 1; ++j) {
                    LevelOracle levelOracle2 = (LevelOracle)listModel.getElementAt(j + 1);
                    if (tableProxy == levelOracle2.getLevelTable()) continue;
                    return levelOracle2.getName();
                }
                return "#none#";
            }
        }
        return "";
    }

    protected void initJoinButtons() {
        this.btnAdd = new JButton(Messages.getString("HierarchyPropertyDialogOracle.AddJoin"));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setEnabled(this.isEditable());
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelOracle levelOracle = (LevelOracle)HierarchyPropertyDialogOracle.this.cbLevel.getSelectedItem();
                Object[] objectArray = HierarchyPropertyDialogOracle.this.selectedColumnsModel.toArray();
                if (levelOracle != null && objectArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer("JOIN KEY ");
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray.length > 1 && i == 0) {
                            stringBuffer.append('(');
                        }
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(((ColumnProxy)objectArray[i]).getLongName());
                    }
                    if (objectArray.length > 1) {
                        stringBuffer.append(')');
                    }
                    stringBuffer.append(" REFERENCES ");
                    String string = HierarchyPropertyDialogOracle.this.getReferencedLevel(levelOracle);
                    stringBuffer.append(string);
                    String string2 = stringBuffer.toString();
                    if (string.equalsIgnoreCase("#none#")) {
                        string2 = Messages.getString("HierarchyPropertyDialogOracle.JoinText");
                        HierarchyPropertyDialogOracle.this.joinListModel.addElement(string2);
                    } else {
                        HierarchyPropertyDialogOracle.this.joinListModel.addElement(string2);
                    }
                    HierarchyPropertyDialogOracle.this.joinList.setSelectedValue(string2, true);
                    HierarchyPropertyDialogOracle.this.btnRemove.setEnabled(true);
                }
            }
        });
        this.joins.add(this.btnAdd);
        this.setObjectConstraints(this.getJoinsLayout(), this.btnAdd, 70, 170);
        this.btnRemove = new JButton(Messages.getString("HierarchyPropertyDialogOracle.RemoveJoin"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)HierarchyPropertyDialogOracle.this.joinList.getSelectedValue();
                if (string != null) {
                    HierarchyPropertyDialogOracle.this.joinListModel.removeElement(string);
                }
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.joins.add(this.btnRemove);
        this.setObjectConstraints(this.getJoinsLayout(), this.btnRemove, 255, 170);
    }

    private void initLevel() {
        JLabel jLabel = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.Level"));
        this.joins.add(jLabel);
        this.cbLevel = new JComboBox();
        this.setBG(this.cbLevel);
        this.cbLevel.addActionListener(new LevelListener());
        this.cbLevel.setPreferredSize(this.tfName.getPreferredSize());
        this.joins.add(this.cbLevel);
        this.setLabelConstraints(this.getJoinsLayout(), jLabel, 12, 140);
        this.setObjectConstraints(this.getJoinsLayout(), this.cbLevel, 140);
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.AllColumns"));
        this.joins.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 100));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.joins.add(jScrollPane);
        this.setLabelConstraints(this.getJoinsLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getJoinsLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.SelectedColumns"));
        this.joins.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 100));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.joins.add(jScrollPane);
        this.setLabelConstraints(this.getJoinsLayout(), jLabel, 292, 14);
        this.setObjectConstraints(this.getJoinsLayout(), jScrollPane, 290, 32);
    }

    private void initColumnsButtons() {
        this.bnColumnAdd = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Add"));
        this.bnColumnAdd.addActionListener(new AddColumnsActionListener());
        this.bnColumnAdd.setEnabled(false);
        this.joins.add(this.bnColumnAdd);
        this.setObjectConstraints(this.getJoinsLayout(), this.bnColumnAdd, 175, 55);
        this.bnColumnRemove = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Remove"));
        this.bnColumnRemove.setEnabled(false);
        this.bnColumnRemove.addActionListener(new RemoveColumnsActionListener());
        this.joins.add(this.bnColumnRemove);
        this.setObjectConstraints(this.getJoinsLayout(), this.bnColumnRemove, 175, 85);
        HierarchyPropertyDialogOracle.equalizeButtonSizes(this.bnColumnAdd, this.bnColumnRemove);
    }

    private void initAllLevelsList() {
        JLabel jLabel = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.AllLevels"));
        this.general.add(jLabel);
        this.allLevelsModel = new DefaultListModel();
        this.allLevelsList = new JList(this.allLevelsModel);
        ListSelectionModel listSelectionModel = this.allLevelsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allLevelsList);
        jScrollPane.setPreferredSize(new Dimension(144, 280));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getLevelsLayout(), jLabel, 12, 64);
        this.setObjectConstraints(this.getLevelsLayout(), jScrollPane, 10, 82);
    }

    private void initSelectedLevelsList() {
        JLabel jLabel = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.CHILDOFRelation"));
        this.general.add(jLabel);
        this.selectedLevelsModel = new DefaultListModel();
        this.selectedLevelsList = new JList(this.selectedLevelsModel);
        ListSelectionModel listSelectionModel = this.selectedLevelsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedLevelsList);
        jScrollPane.setPreferredSize(new Dimension(145, 280));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getLevelsLayout(), jLabel, 292, 64);
        this.setObjectConstraints(this.getLevelsLayout(), jScrollPane, 290, 82);
    }

    private void initButtons() {
        this.bnLevelAdd = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Add"));
        this.bnLevelAdd.addActionListener(new AddLevelsActionListener());
        this.bnLevelAdd.setEnabled(false);
        this.general.add(this.bnLevelAdd);
        this.setObjectConstraints(this.getLevelsLayout(), this.bnLevelAdd, 175, 185);
        this.bnLevelRemove = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Remove"));
        this.bnLevelRemove.setEnabled(false);
        this.bnLevelRemove.addActionListener(new RemoveLevelsActionListener());
        this.general.add(this.bnLevelRemove);
        this.setObjectConstraints(this.getLevelsLayout(), this.bnLevelRemove, 175, 215);
        HierarchyPropertyDialogOracle.equalizeButtonSizes(this.bnLevelAdd, this.bnLevelRemove);
    }

    protected SpringLayout getLevelsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected SpringLayout getJoinsLayout() {
        return (SpringLayout)this.joins.getLayout();
    }

    private void updateLevelCombo() {
        Object[] objectArray = this.selectedLevelsModel.toArray();
        this.cbLevel.removeAllItems();
        if (objectArray.length > 1) {
            for (int i = 0; i < objectArray.length - 1; ++i) {
                this.cbLevel.addItem(objectArray[i]);
            }
        }
    }

    @Override
    public void initProperties() {
        this.initCaption(this.hierarchy.getName());
        ArrayList<LevelOracle> arrayList = new ArrayList<LevelOracle>();
        Object[] objectArray = this.hierarchy.getDimension().getLevelSet();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = (LevelOracle)objectArray[i];
            if (!this.hierarchy.getLevelSet().contains(((StorageObject)object).getName()) && !this.hierarchy.getLevelSet().contains(((ModelIDObject)object).getObjectID())) {
                this.allLevelsModel.addElement(object);
                continue;
            }
            arrayList.add((LevelOracle)object);
        }
        for (Object object : this.hierarchy.getLevelSet()) {
            LevelOracle levelOracle = this.getLevelByID(arrayList, (String)object);
            if (levelOracle == null) continue;
            this.selectedLevelsModel.addElement(levelOracle);
        }
        Iterator iterator = this.hierarchy.getJoinSet().iterator();
        while (iterator.hasNext()) {
            this.joinListModel.addElement(iterator.next());
        }
        this.tfName.setText(this.hierarchy.getName());
        this.updateLevelCombo();
        this.getCommentsList().insert(this.hierarchy.getComment(), 0);
    }

    private LevelOracle getLevelByID(List<LevelOracle> list, String string) {
        if (string != null) {
            for (LevelOracle levelOracle : list) {
                if (!string.equalsIgnoreCase(levelOracle.getObjectID())) continue;
                return levelOracle;
            }
        }
        return null;
    }

    @Override
    protected void setProperties() {
        if (this.hierarchy != null) {
            this.hierarchy.setName(this.tfName.getText());
            Object[] objectArray = this.selectedLevelsModel.toArray();
            this.hierarchy.clearLevels();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof LevelOracle)) continue;
                this.hierarchy.setLevels(((LevelOracle)object).getObjectID());
            }
            Object[] objectArray2 = this.joinListModel.toArray();
            this.hierarchy.clearJoins();
            for (int i = 0; i < objectArray2.length; ++i) {
                String string = (String)objectArray2[i];
                this.hierarchy.setJoins(string);
            }
            this.hierarchy.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.selectedColumnsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnColumnRemove.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnColumnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.allColumnsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnColumnAdd.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnColumnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!HierarchyPropertyDialogOracle.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = HierarchyPropertyDialogOracle.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (HierarchyPropertyDialogOracle.this.allColumnsModel.contains(object)) continue;
                    HierarchyPropertyDialogOracle.this.allColumnsModel.addElement(object);
                    HierarchyPropertyDialogOracle.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!HierarchyPropertyDialogOracle.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = HierarchyPropertyDialogOracle.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (HierarchyPropertyDialogOracle.this.selectedColumnsModel.contains(object)) continue;
                    HierarchyPropertyDialogOracle.this.selectedColumnsModel.addElement(object);
                    HierarchyPropertyDialogOracle.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.selectedLevelsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnLevelRemove.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnLevelRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.allLevelsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnLevelAdd.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnLevelAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveLevelsActionListener
    implements ActionListener {
        private RemoveLevelsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!HierarchyPropertyDialogOracle.this.selectedLevelsModel.isEmpty()) {
                Object[] objectArray = HierarchyPropertyDialogOracle.this.selectedLevelsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (HierarchyPropertyDialogOracle.this.allLevelsModel.contains(object)) continue;
                    HierarchyPropertyDialogOracle.this.allLevelsModel.addElement(object);
                    HierarchyPropertyDialogOracle.this.selectedLevelsModel.removeElement(object);
                }
                HierarchyPropertyDialogOracle.this.updateLevelCombo();
            }
        }
    }

    private class AddLevelsActionListener
    implements ActionListener {
        private AddLevelsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!HierarchyPropertyDialogOracle.this.allLevelsModel.isEmpty()) {
                Object[] objectArray = HierarchyPropertyDialogOracle.this.allLevelsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (HierarchyPropertyDialogOracle.this.selectedLevelsModel.contains(object)) continue;
                    HierarchyPropertyDialogOracle.this.selectedLevelsModel.addElement(object);
                    HierarchyPropertyDialogOracle.this.allLevelsModel.removeElement(object);
                }
                HierarchyPropertyDialogOracle.this.updateLevelCombo();
            }
        }
    }

    private class LevelListener
    implements ActionListener {
        private LevelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HierarchyPropertyDialogOracle.this.cbLevel.getSelectedItem() != null) {
                LevelOracle levelOracle = (LevelOracle)HierarchyPropertyDialogOracle.this.cbLevel.getSelectedItem();
                HierarchyPropertyDialogOracle.this.allColumnsModel.removeAllElements();
                HierarchyPropertyDialogOracle.this.selectedColumnsModel.removeAllElements();
                TableProxy tableProxy = levelOracle.getLevelTable();
                ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
                    HierarchyPropertyDialogOracle.this.allColumnsModel.addElement(columnProxyOracle);
                }
            } else {
                HierarchyPropertyDialogOracle.this.allColumnsModel.removeAllElements();
                HierarchyPropertyDialogOracle.this.selectedColumnsModel.removeAllElements();
            }
        }
    }
}

