/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DirectoryPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private DirectoryOracle dir;
    protected JTextField tfDirPath;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public DirectoryPropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.dir = (DirectoryOracle)storageObject;
        this.setHeight(150);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DirectoryPropertyDialogOracle.DirectoryProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDirPath();
        this.initPermissionsButton();
    }

    private void initDirPath() {
        JLabel jLabel = new JLabel(Messages.getString("DirectoryPropertyDialogOracle.DirPath"));
        this.general.add(jLabel);
        this.tfDirPath = new JTextField("", 26);
        this.general.add(this.tfDirPath);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDirPath, 50);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.dir.getName());
        this.tfName.setText(this.dir.getName());
        this.tfDirPath.setText(this.dir.getDirPath());
        this.taComments.setText(this.dir.getComment());
    }

    @Override
    protected void setProperties() {
        if (this.dir != null) {
            this.dir.setName(this.tfName.getText());
            this.dir.setDirPath(this.tfDirPath.getText());
            this.dir.setComment(this.taComments.getText());
        }
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("DirectoryPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 90);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryPropertyDialogOracle.this.dialog = new ObjectPermissionsDialogOracle(DirectoryPropertyDialogOracle.this.getAppView(), DirectoryPropertyDialogOracle.this.getStorageDesign(), DirectoryPropertyDialogOracle.this.dir);
            DirectoryPropertyDialogOracle.this.dialog.showDialog();
        }
    }
}

