/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TablePropertyDialogDB2v80;

public class TableSpacePropertyDialogDB2v80
extends TableSpacePropertyDialogDB2 {
    private JComboBox cbPartTable;

    public TableSpacePropertyDialogDB2v80(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.tableSpace = (TableSpaceDB2v80)storageObject;
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPartTable();
    }

    protected void initPartTable() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2v80.PartitionTable"));
        this.general.add(jLabel);
        this.cbPartTable = new JComboBox();
        this.setBG(this.cbPartTable);
        this.cbPartTable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartTable.setEnabled(false);
        this.general.add(this.cbPartTable);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbPartTable, 260);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initUsePrivilegesView();
        this.initTablesView();
        this.initPartitionsOrderView();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2v80.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2v80.Properties"));
        jButton.addActionListener(new PartitionPropertiesAction());
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        jButton2.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2v80.MoveUp"));
        jButton2.addActionListener(new MoveUpAction());
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        jButton3.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2v80.MoveDown"));
        jButton3.addActionListener(new MoveDownAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel.add(jToolBar);
        this.partitionsOrder.add((Component)jPanel, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        JScrollPane jScrollPane = new JScrollPane(this.partitionsList);
        jScrollPane.setPreferredSize(new Dimension(400, 510));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jScrollPane);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jScrollPane, 6, 40);
    }

    @Override
    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2v80.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tablesList);
        jScrollPane.setPreferredSize(new Dimension(395, 540));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTSLayout(), jScrollPane, 10, 12);
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbType.setSelectedItem(this.tableSpace.getType());
        this.cbClustered.setSelectedItem(TableSpacePropertyDialogDB2v80.translateYesNoForDisplay(this.tableSpace.getClustered()));
        this.selectObject(this.cbDB, this.tableSpace.getDataBase());
        this.selectObject(this.cbStorageTemplate, this.tableSpace.getStorageTemplate());
        this.cbLobLogging.setSelectedItem(this.tableSpace.isLobLogging() ? YES_NO[0] : YES_NO[1]);
        this.cbDSSize.setSelectedItem(this.tableSpace.getDsSize());
        this.cbSegSize.setSelectedItem(this.tableSpace.getSegSize());
        if (((TableSpaceDB2v80)this.tableSpace).getPartTable() != null) {
            this.cbPartTable.addItem(((TableSpaceDB2v80)this.tableSpace).getPartTable());
        }
        this.cbPartTable.setSelectedItem(((TableSpaceDB2v80)this.tableSpace).getPartTable());
        this.ifNumParts.setValue((long)this.tableSpace.getNumParts());
        this.selectObject(this.cbBufferPool, this.tableSpace.getBufferPool());
        this.cbLockSize.setSelectedItem(this.tableSpace.getLockSize());
        String string = this.tableSpace.getLockMax() == -1 ? "SYSTEM" : String.valueOf(this.tableSpace.getLockMax());
        this.tfLockMax.setText(string);
        this.cbClose.setSelectedItem(this.tableSpace.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbCompress.setSelectedItem(this.tableSpace.isCompress() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.tableSpace.getCcsid());
        this.cbLockPart.setSelectedItem(this.tableSpace.isLockPart() ? YES_NO[0] : YES_NO[1]);
        if (this.tableSpace.getMaxRows() != 0) {
            this.ifMaxRows.setValue((long)this.tableSpace.getMaxRows());
        } else {
            this.ifMaxRows.setText("");
        }
        this.ifOBID.setValue((long)this.tableSpace.getObid());
        this.ifPSID.setValue((long)this.tableSpace.getPsid());
        this.ifNactive.setValue((long)this.tableSpace.getNactive());
        this.tfCreatedBy.setText(this.tableSpace.getCreatedBy());
        this.ifSpace.setValue((long)this.tableSpace.getSpace());
        this.ifPageSave.setValue((long)this.tableSpace.getPageSave());
        this.ifMaintenanceInterval.setValue((long)this.tableSpace.getMaintenanceInterval());
        this.ifSpaceAllocInterval.setValue((long)this.tableSpace.getSpaceAllocationInterval());
        this.ifCompRatio.setValue((long)this.tableSpace.getCompressionRatio());
        this.ifPCTFragmentation.setValue((long)this.tableSpace.getFragmentationPCT());
        Owner[] ownerArray = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < ownerArray.length; ++i) {
            Owner owner = ownerArray[i];
            if (owner.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.tableSpace.getUserSet().contains(owner.getName())) {
                this.selectedUsersModel.addElement(owner);
                continue;
            }
            this.allUsersModel.addElement(owner);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogDB2v80.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        this.tablesListModel.clear();
        Object[] objectArray = this.tableSpace.getTables().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            object = (TableProxyDB2)objectArray[i];
            this.tablesListModel.addElement(object);
        }
        this.cbType.setEnabled(((TableSpaceDB2v80)this.tableSpace).getPartTable() == null);
        this.partitionsModel.clear();
        object = this.tableSpace.getTSPartitions().iterator();
        while (object.hasNext()) {
            try {
                PartitionDB2 partitionDB2 = (PartitionDB2)object.next();
                this.partitionsModel.addElement(partitionDB2);
            }
            catch (ClassCastException classCastException) {}
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.cbType.setEnabled(((TableSpaceDB2v80)this.tableSpace).getPartTable() == null);
        this.initSpaceCalcs();
        this.enableMaxRows();
        this.enableLog();
        if (this.tableSpace.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbDB.setEnabled(false);
            this.cbStorageTemplate.setEnabled(false);
            this.cbLobLogging.setEnabled(false);
            this.cbDSSize.setEnabled(false);
            this.cbSegSize.setEnabled(false);
            this.cbPartTable.setEnabled(false);
            this.ifNumParts.setEditable(false);
            this.cbBufferPool.setEnabled(false);
            this.cbLockSize.setEnabled(false);
            this.tfLockMax.setEditable(false);
            this.cbClose.setEnabled(false);
            this.cbCompress.setEnabled(false);
            this.cbCCSID.setEnabled(false);
            this.cbLockPart.setEnabled(false);
            this.ifMaxRows.setEditable(false);
            this.ifOBID.setEditable(false);
            this.ifPSID.setEditable(false);
            this.ifNactive.setEditable(false);
            this.tfCreatedBy.setEditable(false);
            this.ifSpace.setEditable(false);
            this.ifPageSave.setEditable(false);
            this.ifMaintenanceInterval.setEditable(false);
            this.ifSpaceAllocInterval.setEditable(false);
            this.ifCompRatio.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null && !this.tableSpace.isNullInstance()) {
            int n;
            int n2;
            this.tableSpace.setName(this.tfName.getText());
            this.tableSpace.setType((String)this.cbType.getSelectedItem());
            this.tableSpace.setClustered(TableSpacePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbClustered.getSelectedItem()));
            Object object = this.cbDB.getSelectedItem();
            if (object instanceof DataBaseDB2) {
                this.tableSpace.setDataBase((DataBaseDB2)object);
            } else {
                this.tableSpace.setDataBase(null);
            }
            object = this.cbStorageTemplate.getSelectedItem();
            if (object instanceof StorageTemplateDB2) {
                this.tableSpace.setStorageTemplate((StorageTemplateDB2)object);
            } else {
                this.tableSpace.setStorageTemplate(null);
            }
            object = this.cbLobLogging.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLobLogging(bl);
            this.tableSpace.setDsSize((String)this.cbDSSize.getSelectedItem());
            this.tableSpace.setSegSize((String)this.cbSegSize.getSelectedItem());
            if (((TableSpaceDB2v80)this.tableSpace).getPartTable() == null) {
                this.tableSpace.setNumParts(this.ifNumParts.getIntValue());
            }
            if ((object = this.cbBufferPool.getSelectedItem()) instanceof BufferPoolDB2) {
                this.tableSpace.setBufferPool((BufferPoolDB2)object);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setLockSize((String)this.cbLockSize.getSelectedItem());
            if ("SYSTEM".equalsIgnoreCase(this.tfLockMax.getText())) {
                n2 = -1;
            } else {
                try {
                    n2 = Integer.parseInt(this.tfLockMax.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            }
            this.tableSpace.setLockMax(n2);
            object = this.cbClose.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setClose(bl);
            object = this.cbCompress.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setCompress(bl);
            this.tableSpace.setCcsid((String)this.cbCCSID.getSelectedItem());
            object = this.cbLockPart.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLockPart(bl);
            this.tableSpace.setMaxRows(this.ifMaxRows.getIntValue());
            this.tableSpace.setObid(this.ifOBID.getIntValue());
            this.tableSpace.setPsid(this.ifPSID.getIntValue());
            this.tableSpace.setNactive(this.ifNactive.getIntValue());
            this.tableSpace.setCreatedBy(this.tfCreatedBy.getText());
            this.tableSpace.setSpace(this.ifSpace.getIntValue());
            this.tableSpace.setPageSave(this.ifPageSave.getIntValue());
            this.tableSpace.setMaintenanceInterval(this.ifMaintenanceInterval.getIntValue());
            this.tableSpace.setSpaceAllocationInterval(this.ifSpaceAllocInterval.getIntValue());
            this.tableSpace.setCompressionRatio(this.ifCompRatio.getIntValue());
            this.tableSpace.setFragmentationPCT(this.ifPCTFragmentation.getIntValue());
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = objectArray[n];
                if (!(object2 instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)object2).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            if (((String)this.cbType.getSelectedItem()).equalsIgnoreCase("PARTITIONED")) {
                n = this.tableSpace.getTSPartitions().size();
                for (int i = 0; i < n; ++i) {
                    this.tableSpace.getTSPartitions().justRemove(this.tableSpace.getTSPartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof PartitionDB2)) continue;
                    PartitionDB2 partitionDB2 = (PartitionDB2)this.partitionsModel.get(i);
                    partitionDB2.addObjectListener(this.tableSpace);
                    partitionDB2.setPartNumber(i + 1);
                    partitionDB2.setParent(this.tableSpace.getTSPartitions());
                    this.tableSpace.getTSPartitions().add(partitionDB2);
                }
            }
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.initSpaceCalcs();
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableSpacePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == -1 || TableSpacePropertyDialogDB2v80.this.partitionsModel.size() - 1 <= nArray[i]) continue;
                PartitionDB2 partitionDB2 = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(nArray[i]);
                PartitionDB2 partitionDB22 = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(nArray[i] + 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(partitionDB2, nArray[i] + 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(partitionDB22, nArray[i]);
            }
            TableSpacePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableSpacePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1 || nArray[i] <= 0) continue;
                PartitionDB2 partitionDB2 = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(nArray[i]);
                PartitionDB2 partitionDB22 = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsModel.get(nArray[i] - 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(partitionDB2, nArray[i] - 1);
                TableSpacePropertyDialogDB2v80.this.partitionsModel.setElementAt(partitionDB22, nArray[i]);
            }
            TableSpacePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PartitionDB2 partitionDB2 = (PartitionDB2)TableSpacePropertyDialogDB2v80.this.partitionsList.getSelectedValue();
            if (partitionDB2 != null && !partitionDB2.isDialogVisible()) {
                IndexPartitionPropertyDialogDB2 indexPartitionPropertyDialogDB2 = new IndexPartitionPropertyDialogDB2(TableSpacePropertyDialogDB2v80.this.getAppView(), TableSpacePropertyDialogDB2v80.this.getStorageDesign(), partitionDB2);
                indexPartitionPropertyDialogDB2.show();
            }
        }
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyDB2 tableProxyDB2;
            if (mouseEvent.getClickCount() == 2 && (tableProxyDB2 = (TableProxyDB2)TableSpacePropertyDialogDB2v80.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogDB2v80 tablePropertyDialogDB2v80 = new TablePropertyDialogDB2v80(TableSpacePropertyDialogDB2v80.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogDB2v80.this.getStorageDesign(), tableProxyDB2);
                tablePropertyDialogDB2v80.show();
            }
        }
    }
}

