/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.FKProxyDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKPropertyDialogDB2v80
extends AbstractDB2PropertyDialog {
    private FKProxyDB2v80 fkey;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfDeleteRule;
    private JComboBox cbEnforced;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;

    public FKPropertyDialogDB2v80(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.fkey = (FKProxyDB2v80)storageObject;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogDB2v80.FKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initDeleteRule();
        this.initEnforced();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogDB2v80.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogDB2v80.RefTable"));
        this.general.add(jLabel);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initDeleteRule() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogDB2v80.DeleteRule"));
        this.general.add(jLabel);
        this.tfDeleteRule = new JTextField();
        this.setBG(this.tfDeleteRule);
        this.tfDeleteRule.setPreferredSize(this.tfName.getPreferredSize());
        this.tfDeleteRule.setEnabled(false);
        this.general.add(this.tfDeleteRule);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfDeleteRule, 110);
    }

    private void initEnforced() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogDB2v80.Enforced"));
        this.general.add(jLabel);
        this.cbEnforced = new JComboBox<String>(FKProxyDB2.getYesNoChoices());
        this.setBG(this.cbEnforced);
        this.cbEnforced.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnforced);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbEnforced, 140);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogDB2v80.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogDB2v80.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.refColumnsList);
        jScrollPane.setPreferredSize(new Dimension(395, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(jScrollPane);
        this.setObjectConstraints(this.getRefColumnsLayout(), jScrollPane, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fkey.getName());
        this.tfName.setText(this.fkey.getName());
        this.tfTable.setText(this.fkey.getTable().getName());
        this.tfRefTable.setText(this.fkey.getReferenceTable());
        ColumnProxy[] columnProxyArray = this.fkey.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            this.columnListModel.addElement(columnProxy);
        }
        Column[] columnArray = this.fkey.getRefColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            this.refColumnsListModel.addElement(column);
        }
        String string = ((Index)this.fkey.getObject()).getFKAssociation().getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = ((Index)this.fkey.getObject()).getFKAssociation().isMandatory() ? "RESTRICT" : "SET NULL";
        }
        this.tfDeleteRule.setText(string);
        this.cbEnforced.setSelectedItem(this.fkey.getEnforced());
        this.getCommentsList().insert(this.fkey.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.fkey != null) {
            this.fkey.setName(this.tfName.getText());
            this.fkey.setEnforced((String)this.cbEnforced.getSelectedItem());
            this.fkey.setComment(this.getCommentsList().getText());
        }
    }
}

