/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.InstanceDescriptorColumnPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    protected TableProxyDB2 table;
    protected JComboBox cbOwner;
    protected JComboBox cbTableSpace;
    protected JComboBox cbDataBase;
    protected JIntegerField ifObid;
    protected JTextField tfEditProc;
    protected JTextField tfValidProc;
    protected JComboBox cbAudit;
    protected JComboBox cbDataCapture;
    protected JComboBox cbRestrictOnDrop;
    protected JComboBox cbCCSID;
    protected JTextField tfLabel;
    protected JPanel columns;
    protected JPanel indices;
    protected JPanel catalogStats;
    protected JPanel designStats;
    protected JList columnList;
    protected JList indexList;
    protected DefaultListModel columnListModel;
    protected DefaultListModel indexListModel;
    protected JIntegerField ifCARDF;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifRecLength;
    protected JIntegerField ifNPAGES;
    protected JIntegerField ifPCTPAGES;
    protected JIntegerField ifMaxRows;
    protected JIntegerField ifInitialRows;
    protected JDecimalField dfAURInsert;
    protected JDecimalField dfAURDelete;
    protected JDecimalField dfAURNetGrowth;
    protected JDecimalField dfAGInsert;
    protected JDecimalField dfAGDelete;
    protected JDecimalField dfAGData;
    protected JIntegerField ifGrowthHorizon;
    protected JIntegerField ifPCTFilling;
    protected JComboBox cbGrowthMethod;
    protected JComboBox cbInsertMethod;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    protected JCheckBox chbUsePCTFilling;
    private JPanel instDescriptorPanel;
    private List eList;
    private JTable etable;
    protected JScrollPane spSpaceCalcs;
    protected JScrollPane spColumns;
    protected JScrollPane spIndices;
    private String commentInRDBMS;
    private String comment;
    private int attrCounter = 0;
    private JButton bnPermissions;
    private PermissionsPropertyDialogDB2 dialog;

    public TablePropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (TableProxyDB2)storageObject;
        this.setHeight(470);
        this.initCommentsView(190);
        this.initCommentsInRDBMS(190);
        this.initSpaceCalcsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogDB2.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initTableSpace();
        this.initDataBase();
        this.initOBID();
        this.initEditProc();
        this.initValidProc();
        this.initAudit();
        this.initDataCapture();
        this.initRestrictOnDrop();
        this.initCCSID();
        this.initLabel();
        this.initSpaceCalcs();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    protected void initOwner() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2.OwnerProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 50);
        this.setObjectConstraints(jButton, 50);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertyDialogDB2.this.cbOwner.getSelectedItem();
                if (object != null && object instanceof Owner) {
                    Owner owner = (Owner)object;
                    owner.showPropertyDialog();
                }
            }
        });
    }

    protected void initTableSpace() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2.TablespaceProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.cbTableSpace.addActionListener(new ComboListener());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.setObjectConstraints(jButton, 80);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertyDialogDB2.this.cbTableSpace.getSelectedItem();
                if (object != null && object instanceof TableSpaceDB2) {
                    TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)object;
                    tableSpaceDB2.showPropertyDialog();
                }
            }
        });
    }

    protected void initDataBase() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2.DataBaseProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.DataBase"));
        this.general.add(jLabel);
        this.cbDataBase = new JComboBox();
        this.setBG(this.cbDataBase);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDataBaseSet().toArray(), this.cbDataBase);
        }
        this.cbDataBase.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.cbDataBase.setEnabled(false);
        this.general.add(this.cbDataBase);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDataBase, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(jButton, 110);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertyDialogDB2.this.cbDataBase.getSelectedItem();
                if (object != null && object instanceof DataBaseDB2) {
                    DataBaseDB2 dataBaseDB2 = (DataBaseDB2)object;
                    dataBaseDB2.showPropertyDialog();
                }
            }
        });
    }

    protected void initOBID() {
        JLabel jLabel = new JLabel("OBID");
        this.general.add(jLabel);
        this.ifObid = new JIntegerField(0, 26);
        this.general.add(this.ifObid);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifObid, 140);
    }

    protected void initEditProc() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.EditProc"));
        this.general.add(jLabel);
        this.tfEditProc = new JTextField("", 26);
        this.general.add(this.tfEditProc);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfEditProc, 170);
    }

    protected void initValidProc() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.ValidProc"));
        this.general.add(jLabel);
        this.tfValidProc = new JTextField("", 26);
        this.general.add(this.tfValidProc);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfValidProc, 200);
    }

    protected void initAudit() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.Audit"));
        this.general.add(jLabel);
        this.cbAudit = new JComboBox<String>(TableProxyDB2.getAuditChoices());
        this.setBG(this.cbAudit);
        this.cbAudit.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAudit);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbAudit, 230);
    }

    protected void initDataCapture() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.DataCapture"));
        this.general.add(jLabel);
        this.cbDataCapture = new JComboBox<String>(TableProxyDB2.getDataCaptureValues());
        this.setBG(this.cbDataCapture);
        this.cbDataCapture.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataCapture);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbDataCapture, 260);
    }

    protected void initRestrictOnDrop() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.DropRestrict"));
        this.general.add(jLabel);
        this.cbRestrictOnDrop = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRestrictOnDrop);
        this.cbRestrictOnDrop.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRestrictOnDrop);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbRestrictOnDrop, 290);
    }

    protected void initCCSID() {
        JLabel jLabel = new JLabel("CCSID");
        this.general.add(jLabel);
        this.cbCCSID = new JComboBox<String>(TableProxyDB2.getCcsidValues());
        this.setBG(this.cbCCSID);
        this.cbCCSID.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCCSID);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbCCSID, 320);
    }

    protected void initLabel() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.Label"));
        this.general.add(jLabel);
        this.tfLabel = new JTextField("", 26);
        this.general.add(this.tfLabel);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.tfLabel, 350);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TablePropertyDialogDB2.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TablePropertyDialogDB2.this.getStorageDesign().getTableProxySet().getElements());
                arrayList.remove(TablePropertyDialogDB2.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogDB2.this.getAppView(), TablePropertyDialogDB2.this.table, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 390);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogDB2.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, 390);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initInstanceDescriptorView();
    }

    private void initInstanceDescriptorView() {
        this.instDescriptorPanel = new JPanel();
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2.InstanceDescriptor"), this.instDescriptorPanel);
        this.initInstanceDescriptor();
    }

    private void initInstanceDescriptor() {
        ElementModel elementModel = new ElementModel();
        this.eList = new ArrayList();
        this.etable = new JTable(elementModel);
        this.etable.setSelectionMode(0);
        this.etable.setFocusTraversalKeysEnabled(false);
        TableColumn tableColumn = this.etable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(400);
        tableColumn = this.etable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        this.etable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = TablePropertyDialogDB2.this.etable.getSelectedRow()) != -1 && TablePropertyDialogDB2.this.eList.size() > 0 && n < TablePropertyDialogDB2.this.eList.size() && !(instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2.this.eList.get(n)).isDialogVisible()) {
                    InstanceDescriptorColumnPropertyDialogDB2 instanceDescriptorColumnPropertyDialogDB2 = new InstanceDescriptorColumnPropertyDialogDB2(TablePropertyDialogDB2.this.getAppView(), TablePropertyDialogDB2.this.table.getStorageDesign(), instanceDescriptorColumnDB2);
                    instanceDescriptorColumnPropertyDialogDB2.initProperties();
                    instanceDescriptorColumnPropertyDialogDB2.show();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.etable);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2.Properties"));
        jButton.addActionListener(new PropertiesAction());
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton2.setToolTipText(Messages.getString("TablePropertyDialogDB2.Add"));
        jButton2.addActionListener(new AddAction());
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton3.setToolTipText(Messages.getString("TablePropertyDialogDB2.Remove"));
        jButton3.addActionListener(new RemoveAction());
        JButton jButton4 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        jButton4.setToolTipText(Messages.getString("TablePropertyDialogDB2.MoveUp"));
        jButton4.addActionListener(new MoveUpAction());
        JButton jButton5 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        jButton5.setToolTipText(Messages.getString("TablePropertyDialogDB2.MoveDown"));
        jButton5.addActionListener(new MoveDownAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jToolBar.add(jButton5);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(395, 30));
        jScrollPane.setPreferredSize(new Dimension(395, 370));
        this.instDescriptorPanel.add((Component)jPanel, "North");
        this.instDescriptorPanel.add(jScrollPane);
    }

    protected String generateName() {
        String string = "InstanceDescriptorCol";
        int n = 0;
        int n2 = this.eList.size();
        if (n2 != 0) {
            n = this.attrCounter = n2 + 1;
        } else {
            ++this.attrCounter;
            n = this.attrCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.instDescrExists(string2)) {
            n = ++this.attrCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean instDescrExists(String string) {
        for (int i = 0; i < this.eList.size(); ++i) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)this.eList.get(i);
            if (!string.equalsIgnoreCase(instanceDescriptorColumnDB2.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveElementToIndex(InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2, int n) {
        if (this.eList.contains(instanceDescriptorColumnDB2) && this.eList.size() > n && n >= 0) {
            this.eList.remove(instanceDescriptorColumnDB2);
            this.eList.add(n, instanceDescriptorColumnDB2);
            return true;
        }
        return false;
    }

    private void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    private void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    private void initCatalogStats() {
        this.initCARDF();
        this.initCreatedBy();
        this.initRecLength();
        this.initNPAGES();
        this.initPCTPAGES();
    }

    private void initDesignStats() {
        this.initMaxRows();
        this.initInitialRows();
        this.initAURInsert();
        this.initAURDelete();
        this.initAURNetGrowth();
        this.initAGInsert();
        this.initAGDelete();
        this.initAGData();
        this.initGrowthHorizon();
        this.initGrowthMethod();
        this.initInsertMethod();
        this.initUsePCTFilling();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initCARDF() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.NumberOfRows"));
        this.catalogStats.add(jLabel);
        this.ifCARDF = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifCARDF);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifCARDF, 20);
    }

    private void initCreatedBy() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.CreatedBy"));
        this.catalogStats.add(jLabel);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 50);
    }

    private void initRecLength() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.RecordLength"));
        this.catalogStats.add(jLabel);
        this.ifRecLength = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifRecLength);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifRecLength, 80);
    }

    private void initNPAGES() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.NumberOfPages"));
        this.catalogStats.add(jLabel);
        this.ifNPAGES = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNPAGES);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNPAGES, 110);
    }

    private void initPCTPAGES() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.PCTPages"));
        this.catalogStats.add(jLabel);
        this.ifPCTPAGES = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPCTPAGES);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPCTPAGES, 140);
    }

    private void initMaxRows() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.MaxRows"));
        this.designStats.add(jLabel);
        this.ifMaxRows = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaxRows);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaxRows, 20);
    }

    private void initInitialRows() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.InitialRows"));
        this.designStats.add(jLabel);
        this.ifInitialRows = new JIntegerField(0, 26);
        this.designStats.add(this.ifInitialRows);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifInitialRows, 50);
    }

    private void initAURInsert() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.AURInsert"));
        this.designStats.add(jLabel);
        this.dfAURInsert = new JDecimalField(0.0, 26);
        this.dfAURInsert.addActionListener(new AURFieldListener());
        this.designStats.add(this.dfAURInsert);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURInsert, 80);
    }

    private void initAURDelete() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.AURDelete"));
        this.designStats.add(jLabel);
        this.dfAURDelete = new JDecimalField(0.0, 26);
        this.dfAURDelete.addActionListener(new AURFieldListener());
        this.designStats.add(this.dfAURDelete);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURDelete, 110);
    }

    private void initAURNetGrowth() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.AURNetGrowth"));
        this.designStats.add(jLabel);
        this.dfAURNetGrowth = new JDecimalField(0.0, 26);
        this.dfAURNetGrowth.setEditable(false);
        this.designStats.add(this.dfAURNetGrowth);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURNetGrowth, 140);
    }

    private void initAGInsert() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.AGInsert"));
        this.designStats.add(jLabel);
        this.dfAGInsert = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGInsert);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 170);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGInsert, 170);
    }

    private void initAGDelete() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.AGDelete"));
        this.designStats.add(jLabel);
        this.dfAGDelete = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGDelete);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 200);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGDelete, 200);
    }

    private void initAGData() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.AGData"));
        this.designStats.add(jLabel);
        this.dfAGData = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGData);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 230);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGData, 230);
    }

    private void initGrowthHorizon() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.GrowthHorizon"));
        this.designStats.add(jLabel);
        this.ifGrowthHorizon = new JIntegerField(0, 26);
        this.designStats.add(this.ifGrowthHorizon);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 260);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifGrowthHorizon, 260);
    }

    private void initGrowthMethod() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.GrowthMethod"));
        this.designStats.add(jLabel);
        this.cbGrowthMethod = new JComboBox<String>(TableProxyDB2.getGrowthMethodChoices());
        this.setBG(this.cbGrowthMethod);
        this.cbGrowthMethod.setPreferredSize(this.tfName.getPreferredSize());
        this.designStats.add(this.cbGrowthMethod);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 290);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.cbGrowthMethod, 290);
    }

    protected void initSpaceCalcsView() {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.taSpaceCalcs.setParagraphAttributes(simpleAttributeSet, true);
        this.spSpaceCalcs = new JScrollPane(this.taSpaceCalcs);
        this.spSpaceCalcs.setPreferredSize(new Dimension(395, 400));
        this.spSpaceCalcs.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(this.spSpaceCalcs);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), this.spSpaceCalcs, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private void initInsertMethod() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.InsertMethod"));
        this.designStats.add(jLabel);
        this.cbInsertMethod = new JComboBox<String>(TableProxyDB2.getInsertMethodChoices());
        this.setBG(this.cbInsertMethod);
        this.cbInsertMethod.setPreferredSize(this.tfName.getPreferredSize());
        this.designStats.add(this.cbInsertMethod);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 320);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.cbInsertMethod, 320);
    }

    private String formatText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        while (stringBuffer.length() < 30) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("\t");
        return stringBuffer.toString();
    }

    private String formatInt(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        for (int i = 0; i < 15 - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.table != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2.InitialPagesUsed"))).append(this.formatInt(this.table.getInitialNumberUsedPages())).append("\n");
            stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2.MaxPagesUsed"))).append(this.formatInt(this.table.getMaxNumberUsedPages())).append("\n\n");
            if (this.table.getTableSpace() != null) {
                String string;
                stringBuffer.append(Messages.getString("TablePropertyDialogDB2.ForTablespace")).append(this.table.getTableSpace().getName());
                stringBuffer.append('\n');
                if (this.table.getTableSpace().getStorageTemplate() != null) {
                    stringBuffer.append("(" + Messages.getString("TablePropertyDialogDB2.StorageTemplate")).append(this.table.getTableSpace().getStorageTemplate().getName());
                    stringBuffer.append(")\n");
                }
                stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2.ProposedPRIQTY"))).append(this.formatInt(this.table.getTableSpace().getProposedPRIQTY())).append("\n");
                stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2.ProposedvSECQTY"))).append(this.formatInt(this.table.getTableSpace().getProposedSECQTY())).append("\n");
                if (this.table.getTableSpace().getStorageTemplate() != null) {
                    stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2.CurrentPRIQTY"))).append(this.formatInt(this.table.getTableSpace().getStorageTemplate().getSgPriqty())).append("\n");
                    stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2.CurrentSECQTY"))).append(this.formatInt(this.table.getTableSpace().getStorageTemplate().getSgSeqty())).append("\n");
                }
                if (!(string = this.table.getTableSpace().getProposedQTYRemarks()).equals("")) {
                    stringBuffer.append(Messages.getString("TablePropertyDialogDB2.RemarksOnProposedPRIQTYAndSECQTY")).append(string);
                }
            }
            this.taSpaceCalcs.setText(stringBuffer.toString());
        }
    }

    private void initUsePCTFilling() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.UsePCTFillingForVarTypes"));
        this.designStats.add(jLabel);
        this.chbUsePCTFilling = new JCheckBox("");
        this.chbUsePCTFilling.addActionListener(new CheckBoxListener());
        this.designStats.add(this.chbUsePCTFilling);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 350);
        SpringLayout.Constraints constraints = this.getDesignStatsLayout().getConstraints(this.chbUsePCTFilling);
        constraints.setX(Spring.constant(175));
        constraints.setY(Spring.constant(350));
        jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2.PCTFilling"));
        constraints = this.getDesignStatsLayout().getConstraints(jLabel);
        constraints.setX(Spring.constant(220));
        constraints.setY(Spring.constant(350));
        this.designStats.add(jLabel);
        this.ifPCTFilling = new JIntegerField(0, 3);
        this.setBG(this.ifPCTFilling);
        this.designStats.add(this.ifPCTFilling);
        constraints = this.getDesignStatsLayout().getConstraints(this.ifPCTFilling);
        constraints.setX(Spring.constant(290));
        constraints.setY(Spring.constant(350));
        this.setPCTFillingUse(false);
    }

    protected void setPCTFillingUse(boolean bl) {
        this.ifPCTFilling.setEditable(bl);
        this.ifPCTFilling.setEnabled(bl);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.selectObject(this.cbOwner, this.table.getOwner());
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        this.selectObject(this.cbDataBase, this.table.getDataBase());
        this.ifObid.setValue((long)this.table.getObid());
        this.tfEditProc.setText(this.table.getEditProc());
        this.tfValidProc.setText(this.table.getValidProc());
        this.cbAudit.setSelectedItem(this.table.getAudit());
        this.cbDataCapture.setSelectedItem(this.table.getDataCapture() ? TableProxyDB2.getDataCaptureValues()[1] : TableProxyDB2.getDataCaptureValues()[0]);
        this.cbRestrictOnDrop.setSelectedItem(this.table.getDropRestrict() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.table.getCcsid());
        this.tfLabel.setText(this.table.getLabel());
        Table table = (Table)this.table.getObject();
        if (table.isRoot() && table.isBST()) {
            int n = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (n > -1) {
                this.getPane().setEnabledAt(n, true);
            }
            this.eList.addAll(this.table.getInstDescriptorCols().getElementsList());
        } else {
            int n = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (n > -1) {
                this.getPane().setEnabledAt(n, false);
            }
        }
        this.ifCARDF.setValue(this.table.getNumberOfRows());
        this.tfCreatedBy.setText(this.table.getCreatedBy());
        this.ifRecLength.setValue((long)this.table.getRecordLength());
        this.ifNPAGES.setValue((long)this.table.getNumberOfPages());
        this.ifPCTPAGES.setValue((long)this.table.getPercentageOfPages());
        this.ifMaxRows.setValue(this.table.getMaxRowNumber());
        this.ifInitialRows.setValue(this.table.getInitialRowNumber());
        this.dfAURInsert.setValue(this.table.getAnnualUpdateRateInsert());
        this.dfAURDelete.setValue(this.table.getAnnualUpdateRateDelete());
        this.dfAURNetGrowth.setValue(this.table.getAnnualUpdateRateNetGrowth());
        this.dfAGInsert.setValue(this.table.getActiveGroupInsert());
        this.dfAGDelete.setValue(this.table.getActiveGroupDelete());
        this.dfAGData.setValue(this.table.getActiveGroupData());
        this.ifGrowthHorizon.setValue((long)this.table.getGrowthHorizon());
        this.cbGrowthMethod.setSelectedItem(this.table.getGrowthMethod());
        this.cbInsertMethod.setSelectedItem(this.table.getInsertMethod());
        this.ifPCTFilling.setValue((long)this.table.getPctFilling());
        this.chbUsePCTFilling.setSelected(this.table.isUsePCTFilling());
        this.setPCTFillingUse(this.table.isUsePCTFilling());
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initSpaceCalcs();
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            this.table.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof Owner) {
                this.table.setOwner((Owner)object);
            } else {
                this.table.setOwner(null);
            }
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceDB2) {
                this.table.setTableSpace((TableSpaceDB2)object);
            } else {
                this.table.setTableSpace(null);
            }
            this.table.setObid(this.ifObid.getIntValue());
            this.table.setEditProc(this.tfEditProc.getText());
            this.table.setValidProc(this.tfValidProc.getText());
            object = this.cbAudit.getSelectedItem();
            this.table.setAudit(String.valueOf(object));
            object = this.cbDataCapture.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(TableProxyDB2.getDataCaptureValues()[1]);
            this.table.setDataCapture(bl);
            object = this.cbRestrictOnDrop.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.table.setDropRestrict(bl);
            this.table.setCcsid(String.valueOf(this.cbCCSID.getSelectedItem()));
            this.table.setLabel(this.tfLabel.getText());
            this.table.setNumberOfRows(this.ifCARDF.getIntValue());
            this.table.setCreatedBy(this.tfCreatedBy.getText());
            this.table.setRecordLength(this.ifRecLength.getIntValue());
            this.table.setNumberOfPages(this.ifNPAGES.getIntValue());
            this.table.setPercentageOfPages(this.ifPCTPAGES.getIntValue());
            this.table.setMaxRowNumber(this.ifMaxRows.getIntValue());
            this.table.setInitialRowNumber(this.ifInitialRows.getIntValue());
            this.table.setAnnualUpdateRateInsert(this.dfAURInsert.getFloatValue());
            this.table.setAnnualUpdateRateDelete(this.dfAURDelete.getFloatValue());
            this.table.setActiveGroupInsert(this.dfAGInsert.getFloatValue());
            this.table.setActiveGroupDelete(this.dfAGDelete.getFloatValue());
            this.table.setActiveGroupData(this.dfAGData.getFloatValue());
            this.table.setGrowthHorizon(this.ifGrowthHorizon.getIntValue());
            this.table.setGrowthMethod((String)this.cbGrowthMethod.getSelectedItem());
            this.table.setInsertMethod((String)this.cbInsertMethod.getSelectedItem());
            this.table.setPctFilling(this.ifPCTFilling.getIntValue());
            this.table.setUsePCTFilling(this.chbUsePCTFilling.isSelected());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.table.setComment(string);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.table.setCommentInRDBMS(string2);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
            this.initSpaceCalcs();
            Object[] objectArray = this.table.getInstDescriptorCols().toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)objectArray[i];
                if (this.eList.contains(instanceDescriptorColumnDB2)) continue;
                instanceDescriptorColumnDB2.remove();
            }
            Object[] objectArray2 = this.eList.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = objectArray2[i];
                if (!(object2 instanceof InstanceDescriptorColumnDB2)) continue;
                if (!this.table.getInstDescriptorCols().contains((InstanceDescriptorColumnDB2)object2)) {
                    this.getStorageDesign().getInstanceDescriptorColumnSet().addInstanceDescriptorColumn((InstanceDescriptorColumnDB2)object2);
                    ((InstanceDescriptorColumnDB2)object2).setTable(this.table);
                    continue;
                }
                this.table.getInstDescriptorCols().moveElementToIndex((InstanceDescriptorColumnDB2)object2, i);
            }
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogDB2.this.setPCTFillingUse(TablePropertyDialogDB2.this.chbUsePCTFilling.isSelected());
        }
    }

    private class AURFieldListener
    implements ActionListener {
        private AURFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogDB2.this.dfAURNetGrowth.setValue(TablePropertyDialogDB2.this.dfAURInsert.getFloatValue() - TablePropertyDialogDB2.this.dfAURDelete.getFloatValue());
        }
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object != null && object instanceof TableSpaceDB2) {
                TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)object;
                TablePropertyDialogDB2.this.cbDataBase.setSelectedItem(tableSpaceDB2.getDataBase());
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogDB2.this.etable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogDB2.this.eList.size()) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2.this.eList.get(n);
                TablePropertyDialogDB2.this.moveElementToIndex(instanceDescriptorColumnDB2, n + 1);
                TablePropertyDialogDB2.this.etable.changeSelection(n + 1, 0, false, false);
                TablePropertyDialogDB2.this.etable.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogDB2.this.etable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogDB2.this.eList.size()) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2.this.eList.get(n);
                TablePropertyDialogDB2.this.moveElementToIndex(instanceDescriptorColumnDB2, n - 1);
                TablePropertyDialogDB2.this.etable.changeSelection(n - 1, 0, false, false);
                TablePropertyDialogDB2.this.etable.updateUI();
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogDB2.this.etable.getSelectedRow();
            if (n != -1 && TablePropertyDialogDB2.this.eList.size() > 0 && n < TablePropertyDialogDB2.this.eList.size()) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2.this.eList.get(n);
                TablePropertyDialogDB2.this.eList.remove(instanceDescriptorColumnDB2);
                TablePropertyDialogDB2.this.etable.updateUI();
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = new InstanceDescriptorColumnDB2();
            instanceDescriptorColumnDB2.setName(TablePropertyDialogDB2.this.generateName());
            instanceDescriptorColumnDB2.setDesign(TablePropertyDialogDB2.this.table.getDesign());
            TablePropertyDialogDB2.this.eList.add(instanceDescriptorColumnDB2);
            TablePropertyDialogDB2.this.etable.updateUI();
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2;
            int n = TablePropertyDialogDB2.this.etable.getSelectedRow();
            if (n != -1 && TablePropertyDialogDB2.this.eList.size() > 0 && n < TablePropertyDialogDB2.this.eList.size() && !(instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2.this.eList.get(n)).isDialogVisible()) {
                InstanceDescriptorColumnPropertyDialogDB2 instanceDescriptorColumnPropertyDialogDB2 = new InstanceDescriptorColumnPropertyDialogDB2(TablePropertyDialogDB2.this.getAppView(), TablePropertyDialogDB2.this.table.getStorageDesign(), instanceDescriptorColumnDB2);
                instanceDescriptorColumnPropertyDialogDB2.initProperties();
                instanceDescriptorColumnPropertyDialogDB2.show();
            }
        }
    }

    public class ElementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogDB2.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TablePropertyDialogDB2.Name");
            }
            if (n == 1) {
                return Messages.getString("TablePropertyDialogDB2.Datatype");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2.this.eList.get(n);
            if (n2 == 0) {
                return instanceDescriptorColumnDB2.getName();
            }
            if (n2 == 1) {
                return instanceDescriptorColumnDB2.getDataType();
            }
            return new Integer(n * n2);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogDB2.this.dialog == null) {
                TablePropertyDialogDB2.this.dialog = new PermissionsPropertyDialogDB2(TablePropertyDialogDB2.this.getAppView(), TablePropertyDialogDB2.this.getStorageDesign(), TablePropertyDialogDB2.this.table);
            }
            TablePropertyDialogDB2.this.dialog.show();
        }
    }
}

