/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StoredProcedurePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private StoredProcedureDB2 proc;
    private JComboBox cbOwner;
    private JTextArea bodyArea;
    private JPanel executePrivilegesPanel;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbGrantOption;

    public StoredProcedurePropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.proc = (StoredProcedureDB2)storageObject;
        this.setHeight(240);
        this.initCommentsView(85);
        this.initCommentsInRDBMS(85);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected void addTabs() {
        this.initExecutePrivilegesView();
    }

    private void initExecutePrivilegesView() {
        this.executePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StoredProcedurePropertyDialogDB2.ExecutePrivileges"), this.executePrivilegesPanel);
        this.initExecutePrivileges();
    }

    private void initExecutePrivileges() {
        this.initToUsers();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogDB2.AllUsers"));
        this.executePrivilegesPanel.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(144, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.executePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getExecutePrivilegesLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getExecutePrivilegesLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogDB2.SelectedUsers"));
        this.executePrivilegesPanel.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(145, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.executePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getExecutePrivilegesLayout(), jLabel, 292, 14);
        this.setObjectConstraints(this.getExecutePrivilegesLayout(), jScrollPane, 290, 32);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("StoredProcedurePropertyDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.executePrivilegesPanel.add(this.bnAdd);
        this.setObjectConstraints(this.getExecutePrivilegesLayout(), this.bnAdd, 175, 65);
        this.bnRemove = new JButton(Messages.getString("StoredProcedurePropertyDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.executePrivilegesPanel.add(this.bnRemove);
        this.setObjectConstraints(this.getExecutePrivilegesLayout(), this.bnRemove, 175, 95);
        StoredProcedurePropertyDialogDB2.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getExecutePrivilegesLayout() {
        return (SpringLayout)this.executePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogDB2.GrantOption"));
        this.executePrivilegesPanel.add(jLabel);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.executePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getExecutePrivilegesLayout(), jLabel, 180);
        this.setObjectConstraints(this.getExecutePrivilegesLayout(), this.cbGrantOption, 180);
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoredProcedurePropertyDialogDB2.StoredProcedureProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initBody();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner, this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        }
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initBody() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogDB2.Body"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 80);
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(395, 100));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 100);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.proc.getName());
        this.tfName.setText(this.proc.getName());
        this.cbOwner.setSelectedItem(this.proc.getOwner());
        this.bodyArea.setText(this.proc.getBody());
        Owner[] ownerArray = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < ownerArray.length; ++i) {
            Owner owner = ownerArray[i];
            if (owner.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.proc.getUserSet().contains(owner.getName())) {
                this.selectedUsersModel.addElement(owner);
                continue;
            }
            this.allUsersModel.addElement(owner);
        }
        this.cbGrantOption.setSelectedItem(StoredProcedurePropertyDialogDB2.translateYesNoForDisplay(this.proc.getGrantOption()));
        this.getCommentsList().insert(this.proc.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.proc.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.proc != null) {
            this.proc.setOwner((Owner)this.cbOwner.getSelectedItem());
            this.proc.setName(this.tfName.getText());
            this.proc.setBody(this.bodyArea.getText());
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.proc.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof Owner)) continue;
                this.proc.setUsers(((Owner)object).getName());
            }
            this.proc.setGrantOption(StoredProcedurePropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.proc.setComment(this.getCommentsList().getText());
            this.proc.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Owner owner;
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof Owner && !(owner = (Owner)object).isNullInstance()) {
            string = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + '.' + string : owner.getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (StoredProcedurePropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (StoredProcedurePropertyDialogDB2.this.selectedUsersList.getSelectedIndex() == -1) {
                    StoredProcedurePropertyDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    StoredProcedurePropertyDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (StoredProcedurePropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (StoredProcedurePropertyDialogDB2.this.allUsersList.getSelectedIndex() == -1) {
                    StoredProcedurePropertyDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    StoredProcedurePropertyDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!StoredProcedurePropertyDialogDB2.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = StoredProcedurePropertyDialogDB2.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (StoredProcedurePropertyDialogDB2.this.allUsersModel.contains(object)) continue;
                    StoredProcedurePropertyDialogDB2.this.allUsersModel.addElement(object);
                    StoredProcedurePropertyDialogDB2.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!StoredProcedurePropertyDialogDB2.this.allUsersModel.isEmpty()) {
                Object[] objectArray = StoredProcedurePropertyDialogDB2.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (StoredProcedurePropertyDialogDB2.this.selectedUsersModel.contains(object)) continue;
                    StoredProcedurePropertyDialogDB2.this.selectedUsersModel.addElement(object);
                    StoredProcedurePropertyDialogDB2.this.allUsersModel.removeElement(object);
                }
            }
        }
    }
}

