/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.db2.ColumnsPermissionsDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertyDialogDB2
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertyDialogDB2.Edit");
    private static String COLUMN_CHECKED = Messages.getString("PermissionsPropertyDialogDB2.C");
    private StorageObject storageObject;
    private ArrayList usersSet;
    private ApplicationView appView;
    private AbstractStorageDesignDB2 storageDesign;
    private JButton bnCancel;
    private JPanel jpanel;
    private ColumnsPermissionsDialogDB2 dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogDB2.this.bnCancel.doClick();
        }
    };
    private UsersTable usersTable;

    public PermissionsPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView.getFrame());
        JComponent jComponent;
        this.appView = applicationView;
        this.storageDesign = (AbstractStorageDesignDB2)storageDesign;
        this.storageObject = storageObject;
        this.setResizable(false);
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PermissionsPropertyDialogDB2.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        if (this.isEditable()) {
            JButton jButton;
            if (this.storageObject instanceof TableProxyDB2) {
                jButton = new JButton(Messages.getString("PermissionsPropertyDialogDB2.Columns"));
                jButton.addActionListener(new ColumnsPermissionsListener(this));
                jButton.setCursor(Cursor.getPredefinedCursor(12));
                jButton.setMnemonic(79);
                jPanel.add((Component)jButton, "Before");
            }
            jButton = new JButton(Messages.getString("PermissionsPropertyDialogDB2.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            jComponent = new JButton(Messages.getString("PermissionsPropertyDialogDB2.Apply"));
            ((AbstractButton)jComponent).addActionListener(new ApplyAction());
            jComponent.setCursor(Cursor.getPredefinedCursor(12));
            ((AbstractButton)jComponent).setMnemonic(65);
            jPanel.add(jComponent);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jComponent.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("PermissionsPropertyDialogDB2.Cancel") : Messages.getString("PermissionsPropertyDialogDB2.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int n = 1;
        jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.initUsersTable();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setModal(true);
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    public void initProperties() {
        for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
            Owner owner = (Owner)this.usersTable.getValueAt(i, 0);
            for (int j = 0; j < this.usersTable.getColumnCount(); ++j) {
                if (!(this.usersTable.getValueAt(i, j) instanceof JButton)) continue;
                JButton jButton = (JButton)this.usersTable.getValueAt(i, j);
                if (this.getPermission(owner, this.storageObject) != null) {
                    if (this.getPermission(owner, this.storageObject).getPrivileges().indexOf(this.usersTable.getColumnName(j)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (this.getPermission(owner, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(j)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    if (this.getPermission(owner, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(j))) {
                        jButton.setText(COLUMN_CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
    }

    private void initUsersTable() {
        Iterator iterator = this.storageDesign.getOwnerSet().iterator();
        this.usersSet = new ArrayList();
        while (iterator.hasNext()) {
            Owner owner = (Owner)iterator.next();
            if (owner.getName().equalsIgnoreCase("[Implicit]")) continue;
            this.usersSet.add(owner);
        }
        int n = 0;
        if (this.storageObject instanceof TableProxyDB2) {
            if (((TableProxyDB2)this.storageObject).getOwner() != null) {
                this.usersSet.remove(((TableProxyDB2)this.storageObject).getOwner());
            }
            if (!this.usersSet.contains(this.storageDesign.getPublicAtAllLocations())) {
                this.usersSet.add(this.storageDesign.getPublicAtAllLocations());
            }
            n = PermissionsDB2.getTablePrivilegesValues().length;
        } else if (this.storageObject instanceof TableViewProxyDB2) {
            if (((TableViewProxyDB2)this.storageObject).getOwner() != null) {
                this.usersSet.remove(((TableViewProxyDB2)this.storageObject).getOwner());
            }
            if (!this.usersSet.contains(this.storageDesign.getPublicAtAllLocations())) {
                this.usersSet.add(this.storageDesign.getPublicAtAllLocations());
            }
            n = PermissionsDB2.getViewPrivilegesValues().length;
        } else if (this.storageObject instanceof AUXTableDB2) {
            if (((AUXTableDB2)this.storageObject).getOwner() != null) {
                this.usersSet.remove(((AUXTableDB2)this.storageObject).getOwner());
            }
            n = PermissionsDB2.getAuxTablePrivilegesValues().length;
        }
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.usersTable);
        jScrollPane.setPreferredSize(new Dimension(90 * n + 50, 280));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.jpanel.add(jScrollPane);
        this.usersTable.updateUI();
        UsersModel usersModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.usersSet.size(); ++i) {
            Owner owner = (Owner)this.usersSet.get(i);
            String[] stringArray = this.storageObject instanceof TableProxyDB2 ? (String[])PermissionsDB2.getTablePermissionsValues().toArray() : (this.storageObject instanceof TableViewProxyDB2 ? (String[])PermissionsDB2.getViewPermissionsValues().toArray() : (String[])PermissionsDB2.getAuxTablePermissionsValues().toArray());
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(owner);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            usersModel.addRow(objectArray);
        }
    }

    protected void setProperties() {
        for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
            Owner owner = (Owner)this.usersTable.getValueAt(i, 0);
            PermissionsDB2 permissionsDB2 = this.getPermission(owner, this.storageObject);
            if (this.hasSelectedUserPrivileges(i)) {
                if (permissionsDB2 == null) {
                    permissionsDB2 = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsDB2.setUser(owner);
                    if (this.storageObject instanceof TableProxyDB2) {
                        permissionsDB2.setTable((TableProxyDB2)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyDB2) {
                        permissionsDB2.setView((TableViewProxyDB2)this.storageObject);
                    } else if (this.storageObject instanceof AUXTableDB2) {
                        permissionsDB2.setAuxTable((AUXTableDB2)this.storageObject);
                    }
                }
                permissionsDB2.clear();
                for (int j = 0; j < this.usersTable.getColumnCount(); ++j) {
                    if (!(this.usersTable.getValueAt(i, j) instanceof JButton)) continue;
                    JButton jButton = (JButton)this.usersTable.getValueAt(i, j);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsDB2.setPrivileges(this.usersTable.getColumnName(j));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsDB2.setPrivilegesWithGrantOption(this.usersTable.getColumnName(j));
                }
                continue;
            }
            if (permissionsDB2 == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsDB2);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertyDialogDB2.Permissions");
    }

    public ArrayList getUsersSet() {
        return this.usersSet;
    }

    private PermissionsDB2 getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsDB2 permissionsDB2 = (PermissionsDB2)iterator.next();
            if (permissionsDB2.getUser() != storageObject || permissionsDB2.getTable() != storageObject2 && permissionsDB2.getView() != storageObject2 && permissionsDB2.getAuxTable() != storageObject2) continue;
            return permissionsDB2;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int n) {
        for (int i = 1; i < this.usersTable.getColumnCount(); ++i) {
            if (!(this.usersTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.usersTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject storageObject, String string) {
        int n = 0;
        if (storageObject instanceof Owner) {
            int n2;
            for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
                if (this.usersTable.getValueAt(n2, 0) != storageObject) continue;
                n = n2;
                break;
            }
            for (n2 = 1; n2 < this.usersTable.getColumnCount(); ++n2) {
                if (!((UsersModel)this.usersTable.getModel()).getColumnName(n2).equalsIgnoreCase(string)) continue;
                JButton jButton = (JButton)this.usersTable.getValueAt(n, n2);
                jButton.setText(COLUMN_CHECKED);
                this.usersTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject storageObject, String string) {
        int n = 0;
        if (storageObject instanceof Owner) {
            int n2;
            for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
                if (this.usersTable.getValueAt(n2, 0) != storageObject) continue;
                n = n2;
                break;
            }
            for (n2 = 1; n2 < this.usersTable.getColumnCount(); ++n2) {
                JButton jButton;
                if (!((UsersModel)this.usersTable.getModel()).getColumnName(n2).equalsIgnoreCase(string) || !(jButton = (JButton)this.usersTable.getValueAt(n, n2)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                jButton.setText(EMPTY_VALUE);
            }
        }
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogDB2.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogDB2.this.setProperties();
            PermissionsPropertyDialogDB2.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogDB2.this.setProperties();
            PermissionsPropertyDialogDB2.this.storageObject.setDirty(true);
            PermissionsPropertyDialogDB2.this.dispose();
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertyDialogDB2 permDialog;

        public ColumnsPermissionsListener(PermissionsPropertyDialogDB2 permissionsPropertyDialogDB22) {
            this.permDialog = permissionsPropertyDialogDB22;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StorageObject storageObject = null;
            if (PermissionsPropertyDialogDB2.this.usersTable.getSelectedRow() > -1) {
                storageObject = (StorageObject)PermissionsPropertyDialogDB2.this.usersTable.getValueAt(PermissionsPropertyDialogDB2.this.usersTable.getSelectedRow(), 0);
            }
            if (storageObject != null && (PermissionsPropertyDialogDB2.this.dialog == null || PermissionsPropertyDialogDB2.this.dialog.getUser() != storageObject)) {
                PermissionsPropertyDialogDB2.this.dialog = new ColumnsPermissionsDialogDB2(PermissionsPropertyDialogDB2.this.appView, PermissionsPropertyDialogDB2.this.storageDesign, PermissionsPropertyDialogDB2.this.storageObject, storageObject, this.permDialog);
            }
            if (PermissionsPropertyDialogDB2.this.dialog != null) {
                PermissionsPropertyDialogDB2.this.dialog.show();
            }
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] objectArray = PermissionsPropertyDialogDB2.this.storageObject instanceof TableProxyDB2 ? PermissionsDB2.getTablePermissionsValues().toArray() : (PermissionsPropertyDialogDB2.this.storageObject instanceof TableViewProxyDB2 ? PermissionsDB2.getViewPermissionsValues().toArray() : PermissionsDB2.getAuxTablePermissionsValues().toArray());
            return objectArray.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsPropertyDialogDB2.this.storageObject instanceof TableProxyDB2 ? PermissionsDB2.getTablePermissionsValues().toArray() : (PermissionsPropertyDialogDB2.this.storageObject instanceof TableViewProxyDB2 ? PermissionsDB2.getViewPermissionsValues().toArray() : PermissionsDB2.getAuxTablePermissionsValues().toArray());
            if (n == 0) {
                return Messages.getString("PermissionsPropertyDialogDB2.User");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!PermissionsPropertyDialogDB2.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

