/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DataBasePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private DataBaseDB2 database;
    private JComboBox cbBufferPool;
    private JComboBox cbIndexBP;
    private JComboBox cbType;
    private JTextField tfMember;
    private JComboBox cbStorageGroup;
    private JComboBox cbCCSID;
    private JPanel privs;
    private JComboBox cbUser;
    private JComboBox cbGrantOption;
    private DefaultListModel allPrivsModel;
    private DefaultListModel selectedPrivsModel;
    private JList allPrivsList;
    private JList selectedPrivsList;
    private JButton bnPrivsAdd;
    private JButton bnPrivsRemove;

    public DataBasePropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.database = (DataBaseDB2)storageObject;
        this.setHeight(260);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DataBasePropertyDialogDB2.DatabaseProperties");
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
    }

    private void initPrivilegesView() {
        this.privs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("DataBasePropertyDialogDB2.Privileges"), this.privs);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initUser();
        this.initGrantOption();
        this.initAllPrivsList();
        this.initSelectedPrivsList();
        this.initPrivsButtons();
    }

    protected SpringLayout getPrivsLayout() {
        return (SpringLayout)this.privs.getLayout();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.User"));
        this.privs.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        this.cbUser.addActionListener(new UserListener());
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbUser);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbUser, 20);
    }

    private void initGrantOption() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.GrantOption"));
        this.privs.add(jLabel);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbGrantOption);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbGrantOption, 50);
    }

    private void initAllPrivsList() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.AllPrivileges"));
        this.privs.add(jLabel);
        this.allPrivsModel = new DefaultListModel();
        this.allPrivsList = new JList(this.allPrivsModel);
        ListSelectionModel listSelectionModel = this.allPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allPrivsList);
        jScrollPane.setPreferredSize(new Dimension(144, 120));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(jScrollPane);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 12, 84);
        this.setObjectConstraints(this.getPrivsLayout(), jScrollPane, 10, 102);
    }

    private void initSelectedPrivsList() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.SelectedPrivileges"));
        this.privs.add(jLabel);
        this.selectedPrivsModel = new DefaultListModel();
        this.selectedPrivsList = new JList(this.selectedPrivsModel);
        ListSelectionModel listSelectionModel = this.selectedPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedPrivsList);
        jScrollPane.setPreferredSize(new Dimension(145, 120));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(jScrollPane);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 292, 84);
        this.setObjectConstraints(this.getPrivsLayout(), jScrollPane, 290, 102);
    }

    private void initPrivsButtons() {
        this.bnPrivsAdd = new JButton(Messages.getString("DataBasePropertyDialogDB2.Add"));
        this.bnPrivsAdd.addActionListener(new AddPrivsActionListener());
        this.bnPrivsAdd.setEnabled(false);
        this.privs.add(this.bnPrivsAdd);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsAdd, 175, 135);
        this.bnPrivsRemove = new JButton(Messages.getString("DataBasePropertyDialogDB2.Remove"));
        this.bnPrivsRemove.setEnabled(false);
        this.bnPrivsRemove.addActionListener(new RemovePrivsActionListener());
        this.privs.add(this.bnPrivsRemove);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsRemove, 175, 165);
        DataBasePropertyDialogDB2.equalizeButtonSizes(this.bnPrivsAdd, this.bnPrivsRemove);
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initBufferPool();
        this.initIndexBP();
        this.initType();
        this.initMember();
        this.initStorageGroup();
        this.initCCSID();
    }

    private void initBufferPool() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.BufferPool"));
        this.general.add(jLabel);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbBufferPool, 50);
    }

    private void initIndexBP() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.IndexBP"));
        this.general.add(jLabel);
        this.cbIndexBP = new JComboBox();
        this.setBG(this.cbIndexBP);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbIndexBP);
        }
        this.cbIndexBP.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexBP);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbIndexBP, 80);
    }

    private void initType() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.Type"));
        this.general.add(jLabel);
        this.cbType = new JComboBox<String>(DataBaseDB2.getTypesChoices());
        this.setBG(this.cbType);
        this.cbType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbType);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbType, 110);
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBasePropertyDialogDB2.this.enableCCSID();
                DataBasePropertyDialogDB2.this.enableMember();
            }
        });
    }

    private void initMember() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.Member"));
        this.general.add(jLabel);
        this.tfMember = new JTextField("", 26);
        this.general.add(this.tfMember);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfMember, 140);
    }

    private void initStorageGroup() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogDB2.StorageGroup"));
        this.general.add(jLabel);
        this.cbStorageGroup = new JComboBox();
        this.setBG(this.cbStorageGroup);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageGroupSet().toArray(), this.cbStorageGroup);
        }
        this.cbStorageGroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageGroup);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbStorageGroup, 170);
    }

    private void initCCSID() {
        JLabel jLabel = new JLabel("CCSID");
        this.general.add(jLabel);
        this.cbCCSID = new JComboBox<String>(DataBaseDB2.getCcsidChoices());
        this.setBG(this.cbCCSID);
        this.cbCCSID.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCCSID);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbCCSID, 200);
    }

    private PrivilegesDB2 getPrivileges(Object object) {
        PrivilegesDB2 privilegesDB2;
        Iterator iterator = this.getStorageDesign().getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            privilegesDB2 = (PrivilegesDB2)iterator.next();
            if (privilegesDB2.getUser() != object) continue;
            return privilegesDB2;
        }
        privilegesDB2 = this.getStorageDesign().getPrivilegesSet().createPriv();
        privilegesDB2.setDb(this.database);
        privilegesDB2.setUser((Owner)object);
        return privilegesDB2;
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.selectObject(this.cbBufferPool, this.database.getBufferPool());
        this.selectObject(this.cbIndexBP, this.database.getIndexBufferPool());
        this.cbType.setSelectedItem(this.database.getType());
        this.tfMember.setText(this.database.getMember());
        this.selectObject(this.cbStorageGroup, this.database.getStorageGroup());
        this.cbCCSID.setSelectedItem(this.database.getCcsid());
        if (this.database.isNullInstance()) {
            this.tfName.setEnabled(false);
            this.cbBufferPool.setEnabled(false);
            this.cbIndexBP.setEnabled(false);
            this.cbType.setEnabled(false);
            this.tfMember.setEnabled(false);
            this.cbStorageGroup.setEnabled(false);
            this.cbCCSID.setEnabled(false);
        } else {
            this.enableCCSID();
            this.enableMember();
        }
        this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbUser, this.getStorageDesign().getOwnerSet().getByName("[Implicit]"));
        this.getCommentsList().insert(this.database.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            Object object = this.cbBufferPool.getSelectedItem();
            if (object instanceof BufferPoolDB2) {
                this.database.setBufferPool((BufferPoolDB2)object);
            } else {
                this.database.setBufferPool(null);
            }
            object = this.cbIndexBP.getSelectedItem();
            if (object instanceof BufferPoolDB2) {
                this.database.setIndexBufferPool((BufferPoolDB2)object);
            } else {
                this.database.setIndexBufferPool(null);
            }
            object = this.cbType.getSelectedItem();
            if (object instanceof String) {
                this.database.setType((String)object);
            }
            this.database.setMember(this.tfMember.getText());
            object = this.cbStorageGroup.getSelectedItem();
            if (object instanceof StorageGroupDB2) {
                this.database.setStorageGroup((StorageGroupDB2)object);
            } else {
                this.database.setStorageGroup(null);
            }
            object = this.cbCCSID.getSelectedItem();
            if (object instanceof String) {
                this.database.setCcsid((String)object);
            }
            Object object2 = this.cbUser.getSelectedItem();
            PrivilegesDB2 privilegesDB2 = this.getPrivileges(object2);
            privilegesDB2.clear();
            Object[] objectArray = this.selectedPrivsModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                privilegesDB2.setSystemPrivileges((String)objectArray[i]);
            }
            privilegesDB2.setGrantOption(DataBasePropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.database.setComment(this.getCommentsList().getText());
        }
    }

    private void enableCCSID() {
        String string = (String)this.cbType.getSelectedItem();
        if (string.equalsIgnoreCase("WORKFILE") || string.equalsIgnoreCase("TEMP")) {
            this.cbCCSID.setEnabled(false);
        } else {
            this.cbCCSID.setEnabled(true);
        }
    }

    private void enableMember() {
        String string = (String)this.cbType.getSelectedItem();
        if (string.equalsIgnoreCase("WORKFILE") || string.equalsIgnoreCase("TEMP")) {
            this.tfMember.setEnabled(true);
        } else {
            this.tfMember.setEnabled(false);
        }
    }

    private class UserListener
    implements ActionListener {
        private UserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DataBasePropertyDialogDB2.this.cbUser.getSelectedItem() != null) {
                Object object = DataBasePropertyDialogDB2.this.cbUser.getSelectedItem();
                PrivilegesDB2 privilegesDB2 = DataBasePropertyDialogDB2.this.getPrivileges(object);
                DataBasePropertyDialogDB2.this.allPrivsModel.removeAllElements();
                DataBasePropertyDialogDB2.this.selectedPrivsModel.removeAllElements();
                DataBasePropertyDialogDB2.this.cbGrantOption.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(privilegesDB2.getGrantOption()));
                String[] stringArray = (String[])PrivilegesDB2.getPrivilegesValues().toArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (privilegesDB2.getSystemPrivilegesSet().contains(stringArray[i])) {
                        DataBasePropertyDialogDB2.this.selectedPrivsModel.addElement(stringArray[i]);
                        continue;
                    }
                    DataBasePropertyDialogDB2.this.allPrivsModel.addElement(stringArray[i]);
                }
            } else {
                DataBasePropertyDialogDB2.this.allPrivsModel.removeAllElements();
                DataBasePropertyDialogDB2.this.selectedPrivsModel.removeAllElements();
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (DataBasePropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (DataBasePropertyDialogDB2.this.selectedPrivsList.getSelectedIndex() == -1) {
                    DataBasePropertyDialogDB2.this.bnPrivsRemove.setEnabled(false);
                } else {
                    DataBasePropertyDialogDB2.this.bnPrivsRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (DataBasePropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (DataBasePropertyDialogDB2.this.allPrivsList.getSelectedIndex() == -1) {
                    DataBasePropertyDialogDB2.this.bnPrivsAdd.setEnabled(false);
                } else {
                    DataBasePropertyDialogDB2.this.bnPrivsAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivsActionListener
    implements ActionListener {
        private RemovePrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DataBasePropertyDialogDB2.this.selectedPrivsModel.isEmpty()) {
                Object[] objectArray = DataBasePropertyDialogDB2.this.selectedPrivsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DataBasePropertyDialogDB2.this.allPrivsModel.contains(object)) continue;
                    DataBasePropertyDialogDB2.this.allPrivsModel.addElement(object);
                    DataBasePropertyDialogDB2.this.selectedPrivsModel.removeElement(object);
                }
            }
        }
    }

    private class AddPrivsActionListener
    implements ActionListener {
        private AddPrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DataBasePropertyDialogDB2.this.allPrivsModel.isEmpty()) {
                Object[] objectArray = DataBasePropertyDialogDB2.this.allPrivsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DataBasePropertyDialogDB2.this.selectedPrivsModel.contains(object)) continue;
                    DataBasePropertyDialogDB2.this.selectedPrivsModel.addElement(object);
                    DataBasePropertyDialogDB2.this.allPrivsModel.removeElement(object);
                }
            }
        }
    }
}

