/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColumnsPermissionsDialogDB2
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = Messages.getString("ColumnsPermissionsDialogDB2.1");
    protected static final String EDIT = Messages.getString("ColumnsPermissionsDialogDB2.Edit");
    private StorageObject storageObject;
    private Object[] columnsSet;
    private StorageObject user;
    private AbstractStorageDesignDB2 storageDesign;
    private JButton bnCancel;
    private JPanel jpanel;
    private PermissionsPropertyDialogDB2 permDialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogDB2.this.bnCancel.doClick();
        }
    };
    private ColumnsTable columnsTable;

    public ColumnsPermissionsDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, StorageObject storageObject2, PermissionsPropertyDialogDB2 permissionsPropertyDialogDB2) {
        super(applicationView.getFrame());
        this.storageDesign = (AbstractStorageDesignDB2)storageDesign;
        this.storageObject = storageObject;
        this.user = storageObject2;
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ColumnsPermissionsDialogDB2.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("ColumnsPermissionsDialogDB2.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(Messages.getString("ColumnsPermissionsDialogDB2.Apply"));
        jButton2.addActionListener(new ApplyAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton2.setMnemonic(65);
        jPanel.add(jButton2);
        this.bnCancel = new JButton(Messages.getString("ColumnsPermissionsDialogDB2.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        AbstractPropertyDialog.equalizeButtonSizes(jButton2, this.bnCancel);
        AbstractPropertyDialog.equalizeButtonSizes(jButton, this.bnCancel);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.initColumnsTable();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setModal(true);
        this.setResizable(false);
        this.permDialog = permissionsPropertyDialogDB2;
    }

    public void initProperties() {
        for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
            ColumnProxyDB2 columnProxyDB2 = (ColumnProxyDB2)this.columnsTable.getValueAt(i, 0);
            for (int j = 0; j < this.columnsTable.getColumnCount(); ++j) {
                if (!(this.columnsTable.getValueAt(i, j) instanceof JButton)) continue;
                JButton jButton = (JButton)this.columnsTable.getValueAt(i, j);
                if (this.getPermission(this.user, this.storageObject, columnProxyDB2) != null) {
                    if (this.getPermission(this.user, this.storageObject, columnProxyDB2).getPrivs(columnProxyDB2).indexOf(this.columnsTable.getColumnName(j)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.setBackground(Color.WHITE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.setBackground(Color.WHITE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.setBackground(Color.WHITE);
                jButton.updateUI();
            }
        }
    }

    private void initColumnsTable() {
        this.columnsSet = ((TableProxyDB2)this.storageObject).getColumnProxies();
        this.columnsTable = new ColumnsTable();
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(440, 180));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.jpanel.add(jScrollPane);
        this.columnsTable.updateUI();
        ColumnsModel columnsModel = (ColumnsModel)this.columnsTable.getModel();
        for (int i = 0; i < this.columnsSet.length; ++i) {
            ColumnProxyDB2 columnProxyDB2 = (ColumnProxyDB2)this.columnsSet[i];
            String[] stringArray = (String[])PermissionsDB2.getColumnPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(columnProxyDB2);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            columnsModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedColumnsPrivileges(int n) {
        for (int i = 1; i < this.columnsTable.getColumnCount(); ++i) {
            JButton jButton;
            if (!(this.columnsTable.getValueAt(n, i) instanceof JButton) || !(jButton = (JButton)this.columnsTable.getValueAt(n, i)).getText().equals(CHECKED)) continue;
            return true;
        }
        return false;
    }

    protected void setProperties() {
        int n;
        PermissionsDB2 permissionsDB2 = this.getPermission(this.user, this.storageObject);
        if (permissionsDB2 != null) {
            permissionsDB2.clearColPermissions();
        }
        for (n = 0; n < this.columnsTable.getRowCount(); ++n) {
            ColumnProxyDB2 columnProxyDB2 = (ColumnProxyDB2)this.columnsTable.getValueAt(n, 0);
            if (this.hasSelectedColumnsPrivileges(n)) {
                if (permissionsDB2 == null) {
                    permissionsDB2 = this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.user instanceof Owner) {
                        permissionsDB2.setUser((Owner)this.user);
                    }
                    permissionsDB2.setTable((TableProxyDB2)this.storageObject);
                }
                String string = "";
                string = string.concat(columnProxyDB2.getName());
                for (int i = 0; i < this.columnsTable.getColumnCount(); ++i) {
                    JButton jButton;
                    if (!(this.columnsTable.getValueAt(n, i) instanceof JButton) || !(jButton = (JButton)this.columnsTable.getValueAt(n, i)).getText().equals(CHECKED)) continue;
                    string = string.concat(", ").concat(this.columnsTable.getColumnName(i));
                    this.permDialog.setColumnPermissions(this.user, this.columnsTable.getColumnName(i));
                }
                permissionsDB2.setColumnList(string);
                continue;
            }
            if (permissionsDB2 == null || !permissionsDB2.getColumns().isEmpty()) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsDB2);
            for (int i = 0; i < this.columnsTable.getColumnCount(); ++i) {
                if (!(this.columnsTable.getValueAt(n, i) instanceof JButton)) continue;
                this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(i));
            }
        }
        for (n = 1; n < this.columnsTable.getColumnCount(); ++n) {
            boolean bl = false;
            for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
                if (!((JButton)this.columnsTable.getValueAt(i, n)).getText().equalsIgnoreCase(CHECKED)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(n));
        }
    }

    public String getCaption() {
        return Messages.getString("ColumnsPermissionsDialogDB2.Permissions");
    }

    private PermissionsDB2 getPermission(StorageObject storageObject, StorageObject storageObject2, StorageObject storageObject3) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsDB2 permissionsDB2 = (PermissionsDB2)iterator.next();
            if (permissionsDB2.getUser() != storageObject || permissionsDB2.getTable() != storageObject2 && permissionsDB2.getView() != storageObject2 || !permissionsDB2.getColumns().contains(storageObject3.getName())) continue;
            return permissionsDB2;
        }
        return null;
    }

    private PermissionsDB2 getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsDB2 permissionsDB2 = (PermissionsDB2)iterator.next();
            if (permissionsDB2.getUser() != storageObject || permissionsDB2.getTable() != storageObject2 && permissionsDB2.getView() != storageObject2) continue;
            return permissionsDB2;
        }
        return null;
    }

    public StorageObject getUser() {
        return this.user;
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (object != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(false);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            try {
                this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            if (object == null) {
                this.setText("");
            } else if (object instanceof ColumnProxyDB2) {
                this.setText(" " + ((ColumnProxyDB2)object).getName());
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogDB2.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogDB2.this.setProperties();
            ColumnsPermissionsDialogDB2.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogDB2.this.setProperties();
            ColumnsPermissionsDialogDB2.this.storageObject.setDirty(true);
            ColumnsPermissionsDialogDB2.this.dispose();
        }
    }

    class ColumnsTable
    extends JTable {
        ColumnsModel dataModel;

        public ColumnsTable() {
            this.dataModel = new ColumnsModel();
            this.setModel(this.dataModel);
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(220);
                    continue;
                }
                tableColumn.setPreferredWidth(80);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class ColumnsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] objectArray = PermissionsDB2.getColumnPermissionsValues().toArray();
            return objectArray.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsDB2.getColumnPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("ColumnsPermissionsDialogDB2.Column");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

