/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AUXTableIndexPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private AUXTableIndexDB2 auxIndex;
    private JComboBox cbTable;
    private JComboBox cbUnique;
    private JComboBox cbOwner;
    private JComboBox cbStorageTemplate;
    private JComboBox cbPieceSize;
    private JComboBox cbBufferPool;
    private JComboBox cbClose;
    private JComboBox cbCopy;
    private JTextArea taSpaceCalcs;
    private JPanel spaceCalcs;

    public AUXTableIndexPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.auxIndex = (AUXTableIndexDB2)storageObject;
        this.setHeight(320);
        this.initCommentsView();
        this.initSpaceCalcsView(this.getPane().getPreferredSize().height - 50);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AUXTableIndexPropertyDialogDB2.AUXTableIndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initUnique();
        this.initOwner();
        this.initStorageTemplate();
        this.initPieceSize();
        this.initBufferPool();
        this.initClose();
        this.initCopy();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.AUXTable"));
        this.general.add(jLabel);
        this.cbTable = new JComboBox();
        this.setBG(this.cbTable);
        this.cbTable.setEnabled(false);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getAUXTableSet().toArray(), this.cbTable);
        }
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbTable, 50);
    }

    private void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.Unique"));
        this.general.add(jLabel);
        this.cbUnique = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUnique);
        this.cbUnique.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUnique);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbUnique, 80);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbOwner, 110);
    }

    private void initStorageTemplate() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.StorageTemplate"));
        this.general.add(jLabel);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbStorageTemplate, 140);
    }

    private void initPieceSize() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.PieceSize"));
        this.general.add(jLabel);
        this.cbPieceSize = new JComboBox<String>(AUXTableIndexDB2.getPieceSizes());
        this.setBG(this.cbPieceSize);
        this.cbPieceSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPieceSize);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbPieceSize, 170);
    }

    private void initBufferPool() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.BufferPool"));
        this.general.add(jLabel);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbBufferPool, 200);
    }

    private void initClose() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.Close"));
        this.general.add(jLabel);
        this.cbClose = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClose);
        this.cbClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClose);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbClose, 230);
    }

    private void initCopy() {
        JLabel jLabel = new JLabel(Messages.getString("AUXTableIndexPropertyDialogDB2.Copy"));
        this.general.add(jLabel);
        this.cbCopy = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCopy);
        this.cbCopy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCopy);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbCopy, 260);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.auxIndex.getName());
        this.tfName.setText(this.auxIndex.getName());
        this.selectObject(this.cbTable, this.auxIndex.getAuxTable());
        this.cbUnique.setSelectedItem(this.auxIndex.isUnique() ? YES_NO[0] : YES_NO[1]);
        this.cbUnique.setEnabled(false);
        this.selectObject(this.cbOwner, this.auxIndex.getOwner());
        this.selectObject(this.cbStorageTemplate, this.auxIndex.getStorageTemplate());
        this.cbPieceSize.setSelectedItem(this.auxIndex.getPieceSize());
        this.selectObject(this.cbBufferPool, this.auxIndex.getBufferPool());
        this.cbClose.setSelectedItem(this.auxIndex.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbCopy.setSelectedItem(this.auxIndex.isCopy() ? YES_NO[0] : YES_NO[1]);
        this.getCommentsList().insert(this.auxIndex.getComment(), 0);
        this.initSpaceCalcs();
    }

    @Override
    protected void setProperties() {
        if (this.auxIndex != null) {
            Object object = this.cbUnique.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            object = this.cbOwner.getSelectedItem();
            if (object instanceof Owner) {
                this.auxIndex.setOwner((Owner)object);
            } else {
                this.auxIndex.setOwner(null);
            }
            this.auxIndex.setName(this.tfName.getText());
            object = this.cbStorageTemplate.getSelectedItem();
            if (object instanceof StorageTemplateDB2) {
                this.auxIndex.setStorageTemplate((StorageTemplateDB2)object);
            } else {
                this.auxIndex.setStorageTemplate(null);
            }
            this.auxIndex.setPieceSize((String)this.cbPieceSize.getSelectedItem());
            object = this.cbBufferPool.getSelectedItem();
            if (object instanceof BufferPoolDB2) {
                this.auxIndex.setBufferPool((BufferPoolDB2)object);
            } else {
                this.auxIndex.setBufferPool(null);
            }
            object = this.cbClose.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.auxIndex.setClose(bl);
            object = this.cbCopy.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.auxIndex.setCopy(bl);
            this.auxIndex.setComment(this.getCommentsList().getText());
            this.initSpaceCalcs();
        }
    }

    protected void initSpaceCalcsView(int n) {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("AUXTableIndexPropertyDialogDB2.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taSpaceCalcs);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taSpaceCalcs.setLineWrap(true);
        this.spaceCalcs.add(jScrollPane);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), jScrollPane, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private void initSpaceCalcs() {
        if (this.auxIndex != null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.getString("AUXTableIndexPropertyDialogDB2.InitialnumberOfUsedPages")).append(this.auxIndex.getInitialNumberUsedPages()).append(" \n");
            stringBuffer.append(Messages.getString("AUXTableIndexPropertyDialogDB2.MaxNumberOfUsedPages")).append(this.auxIndex.getMaxNumberUsedPages()).append(" \n\n");
            stringBuffer.append(Messages.getString("AUXTableIndexPropertyDialogDB2.ProposedPRIQTY")).append(this.auxIndex.getProposedPRIQTY()).append(" \n");
            stringBuffer.append(Messages.getString("AUXTableIndexPropertyDialogDB2.ProposedSECQTY")).append(this.auxIndex.getProposedSECQTY()).append(" \n");
            if (this.auxIndex.getStorageTemplate() != null) {
                stringBuffer.append("(" + Messages.getString("AUXTableIndexPropertyDialogDB2.CurrentPRIQTY")).append(Integer.toString(this.auxIndex.getStorageTemplate().getSgPriqty())).append(" )\n");
                stringBuffer.append("(" + Messages.getString("AUXTableIndexPropertyDialogDB2.CurrentSECQTY")).append(Integer.toString(this.auxIndex.getStorageTemplate().getSgSeqty())).append(" )\n\n");
            }
            if (!(string = this.auxIndex.getProposedQTYRemarks()).equals("")) {
                stringBuffer.append(Messages.getString("AUXTableIndexPropertyDialogDB2.RemarksOnProposedPRIQTYAndSECQTY")).append(string);
            }
            this.taSpaceCalcs.setText(stringBuffer.toString());
        } else {
            this.taSpaceCalcs.setText("");
        }
    }

    @Override
    protected boolean allowName(String string) {
        Owner owner;
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof Owner && !(owner = (Owner)object).isNullInstance()) {
            string = owner.getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }
}

