/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class PropertiesPropagationDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel generalPanel;
    private JTable tbProps;
    private JTable tbObjects;
    private List propsList;
    private List objectsList;
    private PropertiesPropagator propagator;

    public PropertiesPropagationDialog(ApplicationView applicationView, PropertiesPropagator propertiesPropagator, List list) {
        super(applicationView);
        this.propagator = propertiesPropagator;
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(new Dimension(450, 550));
        this.init();
        this.addObjects(list);
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.generalPanel.add((Component)this.getPropertiesPanel(), "North");
        this.generalPanel.add((Component)this.getObjectsPanel(), "Center");
    }

    private void addObjects(List list) {
        for (ModelIDObject modelIDObject : list) {
            this.objectsList.add(new ObjectItem(modelIDObject));
        }
    }

    private JPanel getPropertiesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PropertiesPropagationDialog.Properties")));
        this.propsList = new ArrayList();
        this.propsList.addAll(this.propagator.getPropertyWrapperList());
        this.tbProps = new JTable(new PropertiesModel());
        this.tbProps.setSelectionMode(0);
        this.tbProps.setFont(this.tbProps.getFont().deriveFont(1));
        this.tbProps.setForeground(Color.BLUE);
        TableColumn tableColumn = this.tbProps.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.tbProps.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(70);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.tbProps.getTableHeader(), "North");
        jPanel2.add((Component)this.tbProps, "Center");
        jPanel.add(jPanel2);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (PropertyWrapper propertyWrapper : PropertiesPropagationDialog.this.propsList) {
                    propertyWrapper.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (PropertyWrapper propertyWrapper : PropertiesPropagationDialog.this.propsList) {
                    propertyWrapper.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        jPopupMenu.add(jMenuItem);
        this.tbProps.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (PropertyWrapper propertyWrapper : PropertiesPropagationDialog.this.propsList) {
                    propertyWrapper.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (PropertyWrapper propertyWrapper : PropertiesPropagationDialog.this.propsList) {
                    propertyWrapper.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private JPanel getObjectsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PropertiesPropagationDialog.Objects")));
        this.objectsList = new ArrayList();
        this.tbObjects = new JTable(new ObjectModel());
        this.tbObjects.setSelectionMode(0);
        this.tbObjects.setFont(this.tbObjects.getFont().deriveFont(1));
        TableColumn tableColumn = this.tbObjects.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.tbObjects.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(235);
        JScrollPane jScrollPane = new JScrollPane(this.tbObjects);
        jPanel.add(jScrollPane);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ObjectItem objectItem : PropertiesPropagationDialog.this.objectsList) {
                    objectItem.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ObjectItem objectItem : PropertiesPropagationDialog.this.objectsList) {
                    objectItem.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        jPopupMenu.add(jMenuItem);
        this.tbObjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ObjectItem objectItem : PropertiesPropagationDialog.this.objectsList) {
                    objectItem.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ObjectItem objectItem : PropertiesPropagationDialog.this.objectsList) {
                    objectItem.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("PropertiesPropagationDialog.PropertiesPropagation"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("PropertiesPropagationDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPropagationDialog.this.setProperties();
                PropertiesPropagationDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("PropertiesPropagationDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPropagationDialog.this.close();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void setProperties() {
        for (ObjectItem objectItem : this.objectsList) {
            if (!objectItem.isSelected()) continue;
            this.applyTo(objectItem.getObject());
        }
    }

    private void applyTo(Object object) {
        for (PropertyWrapper propertyWrapper : this.propsList) {
            if (!propertyWrapper.isSelected()) continue;
            propertyWrapper.setValue(object);
        }
    }

    private class ObjectItem {
        private ModelIDObject object;
        private boolean selected = false;

        public ObjectItem(ModelIDObject modelIDObject) {
            this.object = modelIDObject;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public String getName() {
            return this.object.getName();
        }

        public ModelIDObject getObject() {
            return this.object;
        }
    }

    public class ObjectModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PropertiesPropagationDialog.this.objectsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("PropertiesPropagationDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("PropertiesPropagationDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ObjectItem objectItem = (ObjectItem)PropertiesPropagationDialog.this.objectsList.get(n);
            if (n2 == 0) {
                return objectItem.isSelected();
            }
            if (n2 == 1) {
                return objectItem.getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ObjectItem objectItem = (ObjectItem)PropertiesPropagationDialog.this.objectsList.get(n);
            if (n2 == 0) {
                objectItem.setSelected((Boolean)object);
            }
        }
    }

    public class PropertiesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return PropertiesPropagationDialog.this.propsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("PropertiesPropagationDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("PropertiesPropagationDialog.Name");
            }
            if (n == 2) {
                return Messages.getString("PropertiesPropagationDialog.Value");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PropertyWrapper propertyWrapper = (PropertyWrapper)PropertiesPropagationDialog.this.propsList.get(n);
            if (n2 == 0) {
                return propertyWrapper.isSelected();
            }
            if (n2 == 1) {
                return propertyWrapper.getName();
            }
            if (n2 == 2) {
                return propertyWrapper.getValueString();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PropertyWrapper propertyWrapper = (PropertyWrapper)PropertiesPropagationDialog.this.propsList.get(n);
            if (n2 == 0) {
                propertyWrapper.setSelected((Boolean)object);
            }
        }
    }
}

