/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DBMigrationDialog
extends CustomDialog {
    private JDialog dialog;
    private JButton bnCancel;
    private JButton bnOK;
    private JComboBox cbTargetST;
    private StorageDesign sourceST;
    private JCheckBox chbTableSpaces;
    private JCheckBox chbIndexes;
    private JCheckBox chbForeignKeys;
    private JProgressBar progressBar;
    private Map map;

    public DBMigrationDialog(ApplicationView applicationView, StorageDesign storageDesign) {
        super(applicationView);
        this.sourceST = storageDesign;
        this.add((Component)this.initGeneralPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
        this.initMap();
    }

    private JPanel initGeneralPanel() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("DBMigrationDialog.SelectTargetDatabase"));
        this.cbTargetST = new JComboBox();
        this.cbTargetST.setPreferredSize(new Dimension(200, 20));
        jPanel2.add(jLabel);
        jPanel2.add(this.cbTargetST);
        Iterator iterator = this.sourceST.getPhysicalDesign().getStorageDesignFactory().getSorageDesigns().iterator();
        while (iterator.hasNext()) {
            object = (StorageDesign)iterator.next();
            if (!(object instanceof StorageDesignOraclev9i)) continue;
            this.cbTargetST.addItem(object);
        }
        object = new JPanel(new BorderLayout(20, 20));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 20, 20));
        ((JComponent)object).setBorder(BorderFactory.createEtchedBorder());
        this.chbTableSpaces = new JCheckBox(Messages.getString("DBMigrationDialog.TransferTableSpaces"), true);
        this.chbIndexes = new JCheckBox(Messages.getString("DBMigrationDialog.TransferIndexes"), true);
        this.chbForeignKeys = new JCheckBox(Messages.getString("DBMigrationDialog.TransferForeignKeys"), true);
        jPanel3.add(this.chbTableSpaces);
        jPanel3.add(this.chbIndexes);
        jPanel3.add(this.chbForeignKeys);
        ((Container)object).add((Component)new JPanel(), "North");
        ((Container)object).add((Component)new JPanel(), "West");
        ((Container)object).add((Component)jPanel3, "Center");
        this.progressBar = new JProgressBar();
        ((Container)object).add((Component)this.progressBar, "South");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)object, "Center");
        return jPanel;
    }

    private JPanel initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        jPanel.add(this.bnOK);
        jPanel.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.setEnabled(this.cbTargetST.getItemCount() > 0);
        return jPanel;
    }

    public Action createOKButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DBMigrationDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMigrationDialog.this.migrate();
                DBMigrationDialog.this.close();
            }
        };
        return abstractAction;
    }

    public Action createCancelButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DBMigrationDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMigrationDialog.this.close();
            }
        };
        return abstractAction;
    }

    public void showDialog() {
        this.getDialog().show();
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DBMigrationDialog.DatabaseMigration"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void initMap() {
        this.map = new TreeMap();
        this.map.put("PCA", "CAS");
        this.map.put("PCC", "CCS");
        this.map.put("PCZ", "CCS");
        this.map.put("PFA", "AIS");
        this.map.put("PFC", "HCL");
        this.map.put("PFI", "PI");
        this.map.put("PFU", "FUS");
        this.map.put("PMN", "MNT");
        this.map.put("PRC", "ARC");
        this.map.put("PRM", "REM");
        this.map.put("DBA", "MF");
    }

    private String getOwnerName(String string) {
        String string2 = (String)this.map.get(string.toUpperCase().trim());
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    private void migrate() {
        StorageDesignOraclev9i storageDesignOraclev9i = (StorageDesignOraclev9i)this.cbTargetST.getSelectedItem();
        if (storageDesignOraclev9i != null && this.sourceST instanceof StorageDesignDB2v80) {
            StorageDesignDB2v80 storageDesignDB2v80 = (StorageDesignDB2v80)this.sourceST;
            this.progressBar.setMaximum(storageDesignDB2v80.getTableProxySet().size());
            String string = storageDesignDB2v80.getPhysicalDesign().getName();
            String string2 = this.getOwnerName(string);
            TableSpaceOraclev9i tableSpaceOraclev9i = null;
            TableSpaceOraclev9i tableSpaceOraclev9i2 = null;
            if (this.chbTableSpaces.isSelected()) {
                tableSpaceOraclev9i = (TableSpaceOraclev9i)storageDesignOraclev9i.getTableSpaceSet().createTableSpace();
                tableSpaceOraclev9i.setName(string2 + "_DATA1");
            }
            if (this.chbIndexes.isSelected()) {
                tableSpaceOraclev9i2 = (TableSpaceOraclev9i)storageDesignOraclev9i.getTableSpaceSet().createTableSpace();
                tableSpaceOraclev9i2.setName(string2 + "_INDEX1");
            }
            Iterator iterator = storageDesignDB2v80.getTableProxySet().iterator();
            while (iterator.hasNext()) {
                IndexProxy indexProxy;
                Object object;
                this.progressBar.setValue(this.progressBar.getValue() + 1);
                TableProxyDB2v80 tableProxyDB2v80 = (TableProxyDB2v80)iterator.next();
                TableProxyOracle tableProxyOracle = (TableProxyOracle)storageDesignOraclev9i.getTableProxySet().getProxy(tableProxyDB2v80.getObjectID());
                if (tableProxyOracle == null) continue;
                if (this.chbTableSpaces.isSelected()) {
                    tableProxyOracle.setTableSpace(tableSpaceOraclev9i);
                }
                int n = 0;
                if (tableProxyOracle.getPrimaryKeys().size() > 0) {
                    object = (IndexProxy[])tableProxyOracle.getPrimaryKeys().getElement(0);
                    ((RelationalObjectProxy)object).setName(tableProxyOracle.getName() + "_PK");
                    ((PKProxyOraclev9i)object).setUsingIndex(PKProxyOraclev9i.getUsingIndexChoices()[3]);
                    ((PKProxyOracle)object).setTableSpace(tableSpaceOraclev9i2);
                    ((PKProxyOracle)object).setExistingIndex(null);
                    n = 1;
                }
                if (this.chbIndexes.isSelected()) {
                    object = tableProxyDB2v80.getIndexProxies();
                    for (int i = 0; i < ((IndexProxy[])object).length; ++i) {
                        indexProxy = object[i];
                        IndexProxyOraclev9i indexProxyOraclev9i = (IndexProxyOraclev9i)tableProxyOracle.getIndexes().getById(indexProxy.getObjectID());
                        if (indexProxyOraclev9i == null || indexProxyOraclev9i.getIndex().isPK()) continue;
                        indexProxyOraclev9i.setName(tableProxyOracle.getName() + "_X" + ++n);
                        indexProxyOraclev9i.setTableSpace(tableSpaceOraclev9i2);
                    }
                }
                if (!this.chbForeignKeys.isSelected()) continue;
                object = tableProxyDB2v80.getFkeys().iterator();
                n = 0;
                while (object.hasNext()) {
                    FKProxyDB2 fKProxyDB2 = (FKProxyDB2)object.next();
                    indexProxy = (FKProxyOracle)tableProxyOracle.getFKeys().getById(fKProxyDB2.getObjectID());
                    if (indexProxy == null) continue;
                    indexProxy.setName(tableProxyOracle.getName() + "_FK" + ++n);
                }
            }
        }
    }
}

