/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.DB2_To_Oracle_CTLFileGenerator;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DB2_To_Oracle_CTLFilesDialog
extends CustomDialog {
    private JDialog dialog;
    private JButton bnCancel;
    private JButton bnOK;
    private static final int FIELD_WIDTH = 150;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(180, 20);
    private Dimension filePrefDimension = new Dimension(150, 20);
    private Dimension toolbarPrefDimension = new Dimension(180, 24);
    protected Design design;
    protected JComboBox cbRelDes;
    protected String allRelational = Messages.getString("DB2_To_Oracle_CTLFilesDialog.AllOpenRelationalModels");
    protected JTextField tfCTLDir;
    protected JTextField tfDataDir;
    protected JTextField tfFileMap;
    protected JTextField tfSeparator;
    protected String title = Messages.getString("DB2_To_Oracle_CTLFilesDialog.GenerateOracleLoadFilesForDB2Data");
    private static File lastFolder = null;
    private static File lastOutFolder = null;

    public DB2_To_Oracle_CTLFilesDialog(ApplicationView applicationView) {
        super(applicationView);
        this.design = applicationView.getCurrentDesign();
        this.add((Component)this.initGeneralPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
    }

    private JPanel initGeneralPanel() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        JLabel jLabel = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.RelationalModel"));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.allRelational);
        Iterator iterator = this.design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            object = (RelationalDesign)iterator.next();
            if (!((DesignPart)object).isLoaded()) continue;
            arrayList.add(object);
        }
        jLabel.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(arrayList.toArray());
        if (arrayList.size() > 1) {
            this.cbRelDes.setSelectedItem(this.allRelational);
        }
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        JPanel jPanel3 = this.newRow(jLabel, this.cbRelDes);
        jPanel2.add(jPanel3);
        object = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.CTLFilesDirectory"));
        ((JComponent)object).setPreferredSize(this.prefDimension);
        ((JComponent)object).setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.ParentDirForDirectoriesWithOracleLoader"));
        this.tfCTLDir = new JTextField("");
        this.tfCTLDir.setPreferredSize(this.filePrefDimension);
        this.tfCTLDir.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.ParentDirForDirectoriesWithOracleLoader"));
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.SelectDirectory"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.tfCTLDir);
        jToolBar.add(jButton);
        jToolBar.setPreferredSize(this.toolbarPrefDimension);
        jToolBar.setFloatable(false);
        jPanel3 = this.newRow((JLabel)object, jToolBar);
        jPanel2.add(jPanel3);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DB2_To_Oracle_CTLFilesDialog.this.getOutputDirName(Messages.getString("DB2_To_Oracle_CTLFilesDialog.DirectoryForControlFiles"), DB2_To_Oracle_CTLFilesDialog.this.tfCTLDir);
            }
        });
        object = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.DataFilesDirectory"));
        ((JComponent)object).setPreferredSize(this.prefDimension);
        ((JComponent)object).setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.LocationOfDataFiles"));
        this.tfDataDir = new JTextField("");
        this.tfDataDir.setPreferredSize(this.filePrefDimension);
        this.tfDataDir.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.LocationOfDataFiles"));
        jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.SelectDirectory"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        jToolBar = new JToolBar();
        jToolBar.add(this.tfDataDir);
        jToolBar.add(jButton);
        jToolBar.setPreferredSize(this.toolbarPrefDimension);
        jToolBar.setFloatable(false);
        jPanel3 = this.newRow((JLabel)object, jToolBar);
        jPanel2.add(jPanel3);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DB2_To_Oracle_CTLFilesDialog.this.getOutputDirName(Messages.getString("DB2_To_Oracle_CTLFilesDialog.DirectoryWithDataFiles"), DB2_To_Oracle_CTLFilesDialog.this.tfDataDir);
            }
        });
        object = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FileWithTableFileMappings"));
        ((JComponent)object).setPreferredSize(this.prefDimension);
        ((JComponent)object).setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.TextFileWithTableFileMappings"));
        this.tfFileMap = new JTextField("");
        this.tfFileMap.setPreferredSize(this.filePrefDimension);
        this.tfFileMap.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.TextFileWithTableFileMappings"));
        jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.SelectFile"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        jToolBar = new JToolBar();
        jToolBar.add(this.tfFileMap);
        jToolBar.add(jButton);
        jToolBar.setPreferredSize(this.toolbarPrefDimension);
        jToolBar.setFloatable(false);
        jPanel3 = this.newRow((JLabel)object, jToolBar);
        jPanel2.add(jPanel3);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DB2_To_Oracle_CTLFilesDialog.this.getInputFileName(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FileWithTableFileMappings"), DB2_To_Oracle_CTLFilesDialog.this.tfFileMap);
            }
        });
        object = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FieldSeparator"));
        ((JComponent)object).setPreferredSize(this.toolbarPrefDimension);
        ((JComponent)object).setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FieldSeparatorForTableNameFileName"));
        this.tfSeparator = new JTextField(";");
        this.tfSeparator.setPreferredSize(new Dimension(10, 19));
        this.tfSeparator.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FieldSeparatorForTableNameFileName"));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.setPreferredSize(this.toolbarPrefDimension);
        jPanel4.add(this.tfSeparator);
        jPanel3 = this.newRow((JLabel)object, jPanel4);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.title, false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public Action createOKButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DB2_To_Oracle_CTLFilesDialog.Generate")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("".equals(DB2_To_Oracle_CTLFilesDialog.this.tfCTLDir.getText().trim()) || "".equals(DB2_To_Oracle_CTLFilesDialog.this.tfDataDir.getText().trim()) || "".equals(DB2_To_Oracle_CTLFilesDialog.this.tfSeparator.getText().trim())) {
                    JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("DB2_To_Oracle_CTLFilesDialog.IncompleteData"), Messages.getString("DB2_To_Oracle_CTLFilesDialog.IncompleteData"), 0, 0, null, new String[]{Messages.getString("DB2_To_Oracle_CTLFilesDialog.Ok")}, Messages.getString("DB2_To_Oracle_CTLFilesDialog.Ok"));
                    return;
                }
                DB2_To_Oracle_CTLFilesDialog.this.generate();
            }
        };
        return abstractAction;
    }

    public Action createCancelButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("DB2_To_Oracle_CTLFilesDialog.Exit")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DB2_To_Oracle_CTLFilesDialog.this.close();
            }
        };
        return abstractAction;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private JPanel initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        jPanel.add(this.bnOK);
        jPanel.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        return jPanel;
    }

    public void generate() {
        Object object = this.cbRelDes.getSelectedItem();
        String string = this.tfCTLDir.getText().trim();
        String string2 = this.tfDataDir.getText().trim();
        String string3 = this.tfFileMap.getText().trim();
        char c = this.tfSeparator.getText().trim().charAt(0);
        if (object == this.allRelational) {
            Iterator iterator = this.design.getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                if (!relationalDesign.isLoaded()) continue;
                DB2_To_Oracle_CTLFileGenerator dB2_To_Oracle_CTLFileGenerator = new DB2_To_Oracle_CTLFileGenerator(relationalDesign, string, string2, string3, c);
                try {
                    dB2_To_Oracle_CTLFileGenerator.exportFiles();
                }
                catch (Exception exception) {}
            }
        } else {
            RelationalDesign relationalDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
            DB2_To_Oracle_CTLFileGenerator dB2_To_Oracle_CTLFileGenerator = new DB2_To_Oracle_CTLFileGenerator(relationalDesign, string, string2, string3, c);
            dB2_To_Oracle_CTLFileGenerator.exportFiles();
        }
    }

    private JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    private String getInputFileName(String string, JTextField jTextField) {
        File file;
        String string2;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("DB2_To_Oracle_CTLFilesDialog.TextFiles");
            }
        };
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        if (lastFolder != null) {
            uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
        } else {
            string2 = this.getApplicationView().getSettings().getDefaultImportPath();
            if (string2 != null && string2.length() > 0) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string2));
            } else {
                URL uRL = this.getApplicationView().getUserHomeDirectory();
                if (uRL != null) {
                    uRLChooser.setSelectedURL(uRL);
                }
            }
        }
        string2 = jTextField.getText();
        uRLChooser.setFileNameURL(string2);
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DB2_To_Oracle_CTLFilesDialog.OpenFileWithTableFileMappings"));
        if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
            lastFolder = file.getParentFile();
            jTextField.setText(file.toString());
            return file.toString();
        }
        return jTextField.getText();
    }

    private String getOutputDirName(String string, JTextField jTextField) {
        File file;
        String string2;
        URLFilter uRLFilter = new URLFilter(){

            public boolean accept(URL uRL) {
                File file = new File(uRL.getPath());
                return file.isDirectory();
            }

            public String toString() {
                return Messages.getString("DB2_To_Oracle_CTLFilesDialog.Directory");
            }
        };
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setSelectionScope(1);
        uRLChooser.setSelectionMode(0);
        uRLChooser.setShowJarsAsDirs(false);
        uRLChooser.setURLFilter(uRLFilter);
        if (lastOutFolder != null) {
            uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastOutFolder));
        } else {
            string2 = this.getApplicationView().getSettings().getDefaultSavePath();
            if (string2 != null && string2.length() > 0) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string2));
            } else {
                URL uRL = this.getApplicationView().getUserHomeDirectory();
                if (uRL != null) {
                    uRLChooser.setSelectedURL(uRL);
                }
            }
        }
        string2 = jTextField.getText();
        uRLChooser.setFileNameURL(string2);
        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), string);
        if (n == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
            lastOutFolder = file.getParentFile();
            jTextField.setText(file.toString());
            return file.toString();
        }
        return jTextField.getText();
    }

    public static void main(String[] stringArray) {
    }
}

