/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class AbstractPropertyDialog
extends JDialog
implements AbstractEditorConstants {
    protected static final String ADD_CAPTION = Messages.getString("AbstractPropertyDialog.Add");
    protected static final String REMOVE_CAPTION = Messages.getString("AbstractPropertyDialog.Remove");
    private ApplicationView appView;
    protected JTabbedPane tpane;
    protected JPanel general;
    protected JPanel comments;
    protected JPanel notes;
    protected JLabel lbName;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected JTextArea taCommentsInRDBMS;
    protected JTextArea taNotes;
    protected JScrollPane spCommentsInRDBMS;
    public static final String YES = Messages.getString("AbstractPropertyDialog.YES");
    public static final String NO = Messages.getString("AbstractPropertyDialog.NO");
    public static final String NONE = Messages.getString("AbstractPropertyDialog.NONE");
    public static final String[] YES_NO = new String[]{YES, NO};
    public static final String[] EMPTY_YES_NO = new String[]{"", YES, NO};
    public static final String[] NONE_YES_NO = new String[]{NONE, YES, NO};
    protected static final int FIELD_WIDTH = 26;
    protected static final int RIGHT_MARGIN_WIDTH = 15;
    private int dialogWidth = this.getDialogWidth();
    protected StorageDesign storageDesign;
    protected JScrollPane spComments;
    private StorageObject storageObject;
    protected String oldObjectStatus;
    private JButton bnCancel;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPropertyDialog.this.bnCancel.doClick();
        }
    };

    public AbstractPropertyDialog(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView.getFrame());
        JComponent jComponent;
        this.storageObject = storageObject;
        this.oldObjectStatus = applicationView.getXMLTransformationManager().getFilteredXMLString(storageObject);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractPropertyDialog.this.onCancel();
                AbstractPropertyDialog.this.storageObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                AbstractPropertyDialog.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.appView = applicationView;
        this.storageDesign = storageDesign;
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tpane = new JTabbedPane();
        this.general = new JPanel(new SpringLayout());
        this.initGeneralView();
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.General"), this.general);
        this.addTabs();
        this.comments = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.Comments"), this.comments);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tpane, "Center");
        JPanel jPanel2 = new JPanel();
        if (this.isEditable()) {
            JButton jButton = new JButton(Messages.getString("AbstractPropertyDialog.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setMnemonic(79);
            jPanel2.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            jComponent = new JButton(Messages.getString("AbstractPropertyDialog.Apply"));
            ((AbstractButton)jComponent).addActionListener(new ApplyAction());
            ((AbstractButton)jComponent).setMnemonic(65);
            jPanel2.add(jComponent);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jComponent.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("AbstractPropertyDialog.Cancel") : Messages.getString("AbstractPropertyDialog.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int n = 1;
        jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel2.add(this.bnCancel);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
    }

    protected int getDialogWidth() {
        return 450;
    }

    public static void equalizeButtonSizes(JButton jButton, JButton jButton2) {
        Dimension dimension = jButton.getPreferredSize();
        Dimension dimension2 = jButton2.getPreferredSize();
        if (dimension.getWidth() < dimension2.getWidth()) {
            jButton.setPreferredSize(dimension2);
        } else {
            jButton2.setPreferredSize(dimension);
        }
    }

    public String getCaption() {
        return Messages.getString("AbstractPropertyDialog.Properties");
    }

    public abstract void initProperties();

    protected abstract void setProperties();

    protected void addTabs() {
    }

    protected boolean canExit() {
        String string = this.tfName.getText().trim();
        if ("".equalsIgnoreCase(string)) {
            MessageDialogs.showErrorMessage(this, Messages.getString("AbstractPropertyDialog.NameCanNotBeEmpty"));
            this.tfName.requestFocus();
            return false;
        }
        if (this.storageObject.isTopLevelObject() && !this.allowName(string)) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("AbstractPropertyDialog.NameNotUnique"), string));
            this.tfName.requestFocus();
            return false;
        }
        return true;
    }

    protected boolean allowName(String string) {
        return this.storageObject.allowName(string, true);
    }

    protected void initGeneralView() {
        this.lbName = new JLabel(Messages.getString("AbstractPropertyDialog.Name"));
        this.general.add(this.lbName);
        this.tfName = new JTextField("", 26);
        this.general.add(this.tfName);
        this.setLabelConstraints(this.lbName, 20);
        this.setObjectConstraints(this.tfName, 20);
    }

    protected void initCommentsView() {
        this.taComments = new JTextArea();
        this.spComments = new JScrollPane(this.taComments);
        Dimension dimension = this.getPane().getPreferredSize();
        this.spComments.setPreferredSize(new Dimension(dimension.width - 20, dimension.height - 45));
        this.spComments.setBorder(BorderFactory.createEtchedBorder(0));
        this.taComments.setLineWrap(true);
        this.comments.add(this.spComments);
        this.setObjectConstraints(this.getCommentsLayout(), this.spComments, 10, 12);
    }

    protected void initNotesView() {
        this.notes = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.Notes"), this.notes);
        this.taNotes = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taNotes);
        Dimension dimension = this.getPane().getPreferredSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width - 25, dimension.height - 50));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taNotes.setLineWrap(true);
        this.notes.add(jScrollPane);
        this.setObjectConstraints((SpringLayout)this.notes.getLayout(), jScrollPane, 10, 12);
    }

    protected void initNotesView(int n) {
        this.notes = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.Notes"), this.notes);
        this.taNotes = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taNotes);
        Dimension dimension = this.getPane().getPreferredSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width - 25, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taNotes.setLineWrap(true);
        this.notes.add(jScrollPane);
        this.setObjectConstraints((SpringLayout)this.notes.getLayout(), jScrollPane, 10, 12);
    }

    protected void initCommentsView(int n) {
        this.taComments = new JTextArea();
        this.spComments = new JScrollPane(this.taComments);
        Dimension dimension = this.getPane().getPreferredSize();
        this.spComments.setPreferredSize(new Dimension(dimension.width - 25, n));
        this.spComments.setBorder(BorderFactory.createEtchedBorder(0));
        this.taComments.setLineWrap(true);
        this.comments.add(this.spComments);
        this.setObjectConstraints(this.getCommentsLayout(), this.spComments, 10, 12);
    }

    protected void initCommentsInRDBMS(int n) {
        JLabel jLabel = new JLabel(Messages.getString("AbstractPropertyDialog.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, n + 15);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        Dimension dimension = this.getPane().getPreferredSize();
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(dimension.width - 25, n));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, n + 35);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected SpringLayout getCommentsLayout() {
        return (SpringLayout)this.comments.getLayout();
    }

    protected void setLabelConstraints(JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    protected void setLabelConstraints(SpringLayout springLayout, JLabel jLabel, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(jLabel);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    protected void setLabelConstraints(SpringLayout springLayout, JLabel jLabel, int n) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setConstraint("East", Spring.constant(this.dialogWidth - 15));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setConstraint("East", Spring.constant(this.dialogWidth - 15));
        constraints.setY(Spring.constant(n));
    }

    protected void setObjectConstraints(Component component, int n, int n2) {
        SpringLayout.Constraints constraints = this.getGeneralLayout().getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    public JTabbedPane getPane() {
        return this.tpane;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public JTextArea getCommentsList() {
        return this.taComments;
    }

    public JTextArea getNotesList() {
        return this.taNotes;
    }

    public JTextArea getCommentsInRDBMSList() {
        return this.taCommentsInRDBMS;
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox) {
        jComboBox.addItem(null);
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2.equals(object)) continue;
            jComboBox.addItem(objectArray[i]);
        }
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox, ArrayList arrayList) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (arrayList.contains(object)) continue;
            jComboBox.addItem(objectArray[i]);
        }
    }

    public void setBG(Component component) {
        component.setBackground(Color.WHITE);
        if (!component.getFont().isPlain()) {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    public void selectObject(JComboBox jComboBox, StorageObject storageObject) {
        jComboBox.setSelectedItem(storageObject);
    }

    protected void initCaption(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCaption()).append(" - ").append(string);
        this.setTitle(stringBuffer.toString());
    }

    protected void setHeight(int n) {
        this.getPane().setPreferredSize(new Dimension(this.dialogWidth, n));
    }

    public StorageObject getStorageObject() {
        return this.storageObject;
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.storageObject.showModal || this.storageObject.showForFirstTime()) {
            this.setModal(true);
        }
        this.selectName();
        if (!this.isEditable()) {
            this.disableControls(this);
        }
        super.show();
        this.storageObject.setDialogVisible(true, this);
    }

    private void disableControls(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JTable || component instanceof JButton || component instanceof JList) continue;
            if (!(component instanceof JTabbedPane) && !(component instanceof JLabel)) {
                component.setEnabled(false);
            }
            if (!(component instanceof Container)) continue;
            this.disableControls((Container)component);
        }
    }

    protected void clearOnDispose() {
    }

    protected void onCancel() {
        if (this.storageObject.showForFirstTime()) {
            this.storageObject.remove();
        }
    }

    protected void postProcessingInApply() {
    }

    protected boolean isEditable() {
        if (this.getStorageObject().isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected boolean notEquals(Integer n, JIntegerField jIntegerField) {
        int n2 = jIntegerField.getIntValue();
        return n == null && n2 > 0 || n != null && n != n2;
    }

    protected boolean notEquals(String string, JTextField jTextField) {
        String string2 = jTextField.getText();
        return StringUtilities.isNotEmpty(string) && !StringUtilities.isNotEmpty(string2) || !StringUtilities.isNotEmpty(string) && StringUtilities.isNotEmpty(string2) || string != null && !string.equals(string2);
    }

    protected boolean notEquals(boolean bl, JComboBox jComboBox, Object object, Object object2) {
        Object object3 = jComboBox.getSelectedItem();
        return bl && object2.equals(object3) || !bl && object.equals(object3);
    }

    protected String translate(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray2[i];
        }
        return "";
    }

    public static String translateYesNoForDisplay(String string) {
        if ("YES".equals(string)) {
            return YES;
        }
        if ("NO".equals(string)) {
            return NO;
        }
        return string;
    }

    public static String translateYesNoForStorage(String string) {
        if (YES.equals(string)) {
            return "YES";
        }
        if (NO.equals(string)) {
            return "NO";
        }
        return string;
    }

    public static String translateNoneYesNoForDisplay(String string) {
        if ("NONE".equals(string)) {
            return NONE;
        }
        return AbstractPropertyDialog.translateYesNoForDisplay(string);
    }

    public static String translateNoneYesNoForStorage(String string) {
        if (NONE.equals(string)) {
            return "NONE";
        }
        return AbstractPropertyDialog.translateYesNoForStorage(string);
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPropertyDialog.this.clearOnDispose();
            AbstractPropertyDialog.this.onCancel();
            AbstractPropertyDialog.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractPropertyDialog.this.canExit()) {
                AbstractPropertyDialog.this.setProperties();
                AbstractPropertyDialog.this.postProcessingInApply();
                String string = AbstractPropertyDialog.this.appView.getXMLTransformationManager().getFilteredXMLString(AbstractPropertyDialog.this.storageObject);
                if (AbstractPropertyDialog.this.oldObjectStatus != null) {
                    if (!AbstractPropertyDialog.this.oldObjectStatus.equals(string)) {
                        AbstractPropertyDialog.this.storageObject.setDirty(true);
                        AbstractPropertyDialog.this.oldObjectStatus = string;
                    }
                } else {
                    AbstractPropertyDialog.this.storageObject.setDirty(true);
                }
                AbstractPropertyDialog.this.storageObject.setShowForFirstTime(false);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(AbstractPropertyDialog.this.getCaption()).append(" - ").append(AbstractPropertyDialog.this.tfName.getText());
                AbstractPropertyDialog.this.setTitle(stringBuffer.toString());
            }
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractPropertyDialog.this.canExit()) {
                AbstractPropertyDialog.this.setProperties();
                String string = AbstractPropertyDialog.this.appView.getXMLTransformationManager().getFilteredXMLString(AbstractPropertyDialog.this.storageObject);
                if (AbstractPropertyDialog.this.oldObjectStatus != null) {
                    if (!AbstractPropertyDialog.this.oldObjectStatus.equals(string)) {
                        AbstractPropertyDialog.this.storageObject.setDirty(true);
                        AbstractPropertyDialog.this.oldObjectStatus = string;
                    }
                } else {
                    AbstractPropertyDialog.this.storageObject.setDirty(true);
                }
                AbstractPropertyDialog.this.storageObject.setShowForFirstTime(false);
                AbstractPropertyDialog.this.clearOnDispose();
                AbstractPropertyDialog.this.dispose();
            }
        }
    }
}

