/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.undo.relational.TableUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.model.designrules.relational.DRColumnCaseType;
import oracle.dbtools.crest.model.designrules.relational.DRColumnMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRColumnValidCharacters;
import oracle.dbtools.crest.model.designrules.relational.DRTableCaseType;
import oracle.dbtools.crest.model.designrules.relational.DRTableMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRTableValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.IndexesCellRenderer;
import oracle.dbtools.crest.swingui.editor.TFCellEditor;
import oracle.dbtools.crest.swingui.editor.TLConstraintEditor;
import oracle.dbtools.crest.swingui.editor.relational.ApplyNamingStandardSelection;
import oracle.dbtools.crest.swingui.editor.relational.ColumnGroupExpressionPanel;
import oracle.dbtools.crest.swingui.editor.relational.ColumnGroupsTable;
import oracle.dbtools.crest.swingui.editor.relational.ColumnGroupsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.ColumnPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsCellEditor;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.FKTableModel;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.relational.IndexExpressionPanel;
import oracle.dbtools.crest.swingui.editor.relational.IndexPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.relational.IndexesTable;
import oracle.dbtools.crest.swingui.editor.relational.IndexesTableModel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.editor.relational.PKColumnsPanel;
import oracle.dbtools.crest.swingui.editor.relational.SpatialColDefPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.relational.UKColumnsPanel;
import oracle.dbtools.crest.swingui.editor.relational.UniqueKeysTableModel;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class TablePropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final String VALIDATION_RULE = Messages.getString("TablePropertiesDialogEx.ValidationRule");
    private static final String INTERVAL_STRING = " ";
    private static final String NAME = Messages.getString("TablePropertiesDialogEx.Name");
    private static final String COLUMNS_TAB_NAME = Messages.getString("TablePropertiesDialogEx.Columns");
    private static final String FOREIGN_KEY_TAB_NAME = Messages.getString("TablePropertiesDialogEx.ForeignKeys");
    private static final String INDEX_KEYS_TAB_NAME = Messages.getString("TablePropertiesDialogEx.Indexes");
    private static final String UNIQUE_KEYS_TAB_NAME = Messages.getString("TablePropertiesDialogEx.UniqueConstraints");
    private static final String PRIMARY_KEY_TAB_NAME = Messages.getString("TablePropertiesDialogEx.PrimaryKeyTabTitle");
    private static final String COLUMN_GROUP_TAB_NAME = Messages.getString("TablePropertiesDialogEx.ColumnGroups");
    private Table table;
    private JTextField tfLongName;
    private JTextField tfAbbreviation;
    private JComboBox cbSchemaObject;
    private JCheckBox chEngineer;
    private JTextField tfPKName;
    private JComboBox cbType;
    private JTextField tfScope;
    private JComboBox cbBaseOnStructuredType;
    private StructuredType st_type;
    private JPanel pnColumns;
    private JPanel pnForeignKeys;
    private JPanel pnNestedColumns;
    private JPanel pnTableLevelConstraints;
    private JPanel pnVolumes;
    private List<Column> columnsList;
    private JTable tbColumns;
    private JTable coTable;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private int counter = 0;
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();
    private List columnsListWithFK;
    private List<Index> foreignKeys;
    private List<FKIndexAssociation.FKMemento> fkList;
    private List nestedColumnsList;
    private JTable ntable;
    private TLConstraintEditor editor;
    private JTextField tfMinVolume;
    private JTextField tfExpected;
    private JTextField tfMaximum;
    private JTextField tfGrowthPercent;
    private static final String[] YMD = new String[]{Messages.getString("TablePropertiesDialogEx.Year"), Messages.getString("TablePropertiesDialogEx.Month"), Messages.getString("TablePropertiesDialogEx.Day")};
    private static final String[] YMD_INTERNAL = new String[]{"Year", "Month", "Day"};
    private JComboBox cbYearMonthDay;
    private static final String[] NF = new String[]{Messages.getString("TablePropertiesDialogEx.None"), Messages.getString("TablePropertiesDialogEx.First"), Messages.getString("TablePropertiesDialogEx.Second"), Messages.getString("TablePropertiesDialogEx.Third"), Messages.getString("TablePropertiesDialogEx.Fourth")};
    private static final String[] NF_INTERNAL = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private JComboBox cbNormalForm;
    private JTextArea taColumnComments;
    private JTextArea taColumnNotes;
    private JTextArea taColumnCommentsInRDBMS;
    private JTextField tfColumnName;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JPanel pnDType;
    private JPanel pnDTSize;
    private JPanel pnDTScale;
    private JPanel pnRef;
    private Column selectedColumn = null;
    private JCheckBox chbPK;
    private JCheckBox chbFK;
    private JCheckBox chbMandatory;
    private ActionListener chbPKActionListener;
    private ActionListener cbDatatypeActionListener;
    private boolean sizeEnabled = false;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private boolean initialUseDomainPreferredList = true;
    private boolean initialUseLogicalTypePreferredList = true;
    private List currentPreferredDomainList = new ArrayList();
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private boolean precisionEnabled = false;
    private JCheckBox chbReference;
    private JComboBox cbUnits;
    private JComboBox cbAdequatelyNormalized;
    private final Map keyMap = new HashMap();
    private JCheckBox chbIsPrimary;
    private JCheckBox chSpatialTable;
    private JCheckBox chTypeSubst;
    private JCheckBox chMarkGenerate;
    private JPanel pnSpatialProp;
    private List sList;
    private JTable sTable;
    private JButton btnAddDimension;
    private JButton btnRemoveDimension;
    private ClassificationType classType = null;
    private Table oldTable;
    private JTree tree;
    private boolean firstInit = true;
    private JPanel pnColumnsSecurity;
    private JTable tbColumnsSecurity;
    private JButton btnFKProperties;
    private JButton btnFKRemove;
    private JTextArea taFKComments;
    private JTextArea taFKNotes;
    private JCheckBox chFKMandatory;
    private JCheckBox chFKTransferable;
    private JCheckBox chFKInArc;
    private FKTableModel fkModel;
    private FKColumnsTableModel fkColumnsTableModel;
    private FKColumnsCellEditor fkColumnsCellEditor;
    private JComboBox cbReferencedTable;
    private JComboBox cbReferencedConstraint;
    private FKIndexAssociation.FKMemento selectedFK;
    private boolean fkPropertiesEnabled;
    private List<FKIndexAssociation.FKMemento> fkListForUpdate = new ArrayList<FKIndexAssociation.FKMemento>();
    private List<FKIndexAssociation.FKMemento> fkListForCreate = new ArrayList<FKIndexAssociation.FKMemento>();
    private List<FKIndexAssociation.FKMemento> fkListForRemove = new ArrayList<FKIndexAssociation.FKMemento>();
    private boolean initializingSelectedFK;
    private JTable tbForeignKeys;
    private JTable tbForeignKeyColumnsTable;
    private Set<FKIndexAssociation.FKMemento> dirtyMementos = new HashSet<FKIndexAssociation.FKMemento>();
    private boolean stealthChange = false;
    private List<Index> allIndexesList;
    private List<Index> indexesForUpdate;
    private List<Index> indexKeys;
    private JPanel pnIndexes;
    private JTable tbIndexKeys;
    private IndexExpressionPanel indexExpressionPanel;
    private JCheckBox chIndexExpression;
    private JTextArea taIndexNotes;
    private JTextArea taIndexComments;
    private JTextArea taIndexCommentsInRDBMS;
    private Index selectedIndexKey;
    private List<Index> uniqueKeys;
    private JPanel pnUniqueKeys;
    private JTable tbUniqueKeys;
    private UKColumnsPanel uniqueKeysColumnsPanel;
    private JTextArea taUniqueKeyNotes;
    private JTextArea taUniqueKeyComments;
    private JTextArea taUniqueKeyCommentsInRDBMS;
    private Index selectedUniqueKey;
    private JPanel pnPrimaryKey;
    private JTextField tfPrimaryKeyName;
    private PKColumnsPanel primaryKeyColumnsPanel;
    private JTextArea taPrimaryKeyNotes;
    private JTextArea taPrimaryKeyComments;
    private JTextArea taPrimaryKeyCommentsInRDBMS;
    private Index primaryKey;
    private JCheckBox chPrimaryKeyEngineer;
    private JCheckBox chPrimaryKeyGenerate;
    private JButton btnPKProperties;
    private JButton btnPKRemove;
    private ButtonGroup datatypeGroup;
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private String storedColumnDefaultDatatype = this.getAppView().getSettings().getColumnDefaultDatatype().trim();
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private JTable tbTableLevelConstraints;
    private List<TableLevelConstraint> tableLevelConstraints;
    private JTextArea taValidationRule;
    private TableLevelConstraint selectedTableLevelConstraint;
    private JPanel pnColumnGroups;
    private ColumnGroupExpressionPanel columnGroupExpressionPanel;
    private JTextArea taColumnGroupNotes;
    private List<Table.ColumnGroup> columnGroupList;
    private JTable tbColumnGroupTable;
    private Table.ColumnGroup lastSelectedColumnGroup;
    private Table.ColumnGroup currentSelectedColumnGroup;
    private int cgCounter = 0;
    private int currentrowIndex;
    List<Column> alteredColumnList = new ArrayList<Column>();
    private JButton btnRemoveColumnGroup;
    private List<Table.ColumnGroup> columnGroupsForRemovalList = new ArrayList<Table.ColumnGroup>();
    private TreeMap typesRDBMSSites = new TreeMap();
    private int defaultRDBMStype;
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private static final Dimension defaultSize = new Dimension(280, 20);
    private static FKMementoNameComparator FKMEMENTO_COMARATOR = new FKMementoNameComparator();
    ApplyNamingStandards applyNS;

    public TablePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertiesDialogEx.TableProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 880;
    }

    @Override
    protected int getMinimumHeight() {
        return 540;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        if (designObject instanceof Table) {
            Object object4;
            this.oldTable = (Table)designObject;
            object3 = this.getAppView().getCurrentDPV();
            if (object3 != null && ((DesignPartView)object3).getDesignPart() != designObject.getDesignPart() || object3 == null) {
                object3 = designObject.getDesignPart().getMainView();
            }
            this.table = new Table(this.oldTable.getDesignPart());
            this.oldTable.backupTo(this.table);
            this.oldTable.backupFKeysTO(this.table, (DesignPartView)object3);
            this.initDefaults();
            this.tfLongName.setText(this.table.getLongName());
            this.tfAbbreviation.setText(this.table.getAbbreviation());
            this.chEngineer.setSelected(this.table.getShouldEngineer());
            this.tfPKName.setText(this.table.getPK() != null ? this.table.getPK().getName() : "");
            this.fillComboItems(this.getDesignObject().getDesign().getDLSettings().getClassificationTypeNames(), this.cbType, false);
            this.cbType.setSelectedItem(this.getDesignObject().getDesign().getDLSettings().getClassificationTypeNameByID(this.table.getTypeID()));
            this.tfScope.setText(this.table.getScope());
            if (this.cbType.getSelectedItem() != null && ((String)this.cbType.getSelectedItem()).equalsIgnoreCase(ContainerObject.TYPE_TEMPORARY)) {
                this.tfScope.setEnabled(true);
            } else {
                this.tfScope.setEnabled(false);
                this.tfScope.setText("");
            }
            object2 = new ArrayList();
            iterator = this.table.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
            while (iterator.hasNext()) {
                object = (StructuredType)iterator.next();
                if (!object.isInstantiable() && object.getAllSubTypes().size() <= 0) continue;
                object2.add(object);
            }
            if (this.table.getBasedOnStructuredType() != null && !object2.contains(this.table.getBasedOnStructuredType())) {
                object2.add(this.table.getBasedOnStructuredType());
            }
            this.fillComboItems(object2.toArray(), this.cbBaseOnStructuredType, true);
            this.cbBaseOnStructuredType.setSelectedItem(this.table.getBasedOnStructuredType());
            if (this.table != null && (this.table.isPartOfTypeSubstHierarchy() || this.table.isReferencedByFKs())) {
                this.cbBaseOnStructuredType.setEnabled(false);
            }
            this.columnsListWithFK.clear();
            this.columnsList.clear();
            object = (Column[])this.table.getElements();
            for (int i = 0; i < ((Column[])object).length; ++i) {
                object4 = object[i];
                if (!object4.isFKColumn()) continue;
                this.columnsListWithFK.add(object4);
            }
            this.columnsList.addAll(Arrays.asList(object));
            this.alteredColumnList.addAll(this.columnsList);
            List list = this.table.getColumnGroupsSet();
            if (list != null) {
                for (Table.ColumnGroup columnGroup : list) {
                    this.columnGroupList.add(columnGroup);
                }
            }
            if (this.firstInit) {
                this.firstInit = false;
                object4 = this.table.getFKAssociations();
                for (int i = 0; i < ((FKIndexAssociation[])object4).length; ++i) {
                    if (object4[i].isDialogVisible()) {
                        this.fkList.add(((ForeignKeyPropertiesDialogEx)object4[i].getPropertiesDialog()).getFKMemento());
                        continue;
                    }
                    this.fkList.add(object4[i].getFKMemento((DesignPartView)object3));
                }
                Collections.sort(this.fkList, FKMEMENTO_COMARATOR);
            }
            this.nestedColumnsList.addAll(this.table.getNestedElements());
            this.addIndexes((Index[])this.table.getKeys());
            if (this.table.isBST()) {
                this.st_type = this.table.getBasedOnStructuredType();
                boolean bl = this.oldTable.isOidIsPK();
                this.chbIsPrimary.setSelected(bl);
            }
            for (TableLevelConstraint tableLevelConstraint : this.table.getCheckConstraints()) {
                this.tableLevelConstraints.add(tableLevelConstraint);
            }
            this.tfMinVolume.setText(this.table.getMinVolumes());
            this.tfExpected.setText(this.table.getExpectedVolumes());
            this.tfMaximum.setText(this.table.getMaxVolumes());
            this.tfGrowthPercent.setText(this.table.getGrowthPercent());
            this.cbYearMonthDay.setSelectedItem(this.translate(this.table.getGrowthType(), YMD_INTERNAL, YMD));
            this.cbNormalForm.setSelectedItem(this.translate(this.table.getNormalForm(), NF_INTERNAL, NF));
            this.cbAdequatelyNormalized.setSelectedItem(this.translate(this.table.getAdequatelyNormalized(), YES_NO_INTERNAL, YES_NO));
            this.taBeforeDrop.setText(this.table.getBeforeDrop());
            this.taBeforeCreate.setText(this.table.getBeforeCreate());
            this.taAfterCreate.setText(this.table.getAfterCreate());
            this.taEndOfScript.setText(this.table.getEndOfScript());
            this.chGenerateScript.setSelected(this.table.getShouldGenerateScript());
            this.preserveKeysStructure(this.table);
            this.chSpatialTable.setSelected(this.table.isSpatialTable());
            this.chTypeSubst.setSelected(this.table.isAllowTypeSubstitution());
            this.chMarkGenerate.setSelected(this.table.isMarkedGenerate());
            this.sList.addAll(this.table.getSpatialDefinitions());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.enableColumnOptions(this.columnsList.size() > 0 && this.coTable.getSelectedRow() > 0, 0);
            this.initPrimaryKeyProperties();
            this.initSelectedIndexKeyProperties();
            this.initSelectedUniqueKeyProperties();
            this.defaultRDBMStype = this.getAppView().getSettings().getDefaultRDBMSType();
            Iterator iterator2 = this.getDesignObject().getDesign().getDefaultRDBMSTypeSet().iterator();
            while (iterator2.hasNext()) {
                RDBMSType rDBMSType = (RDBMSType)iterator2.next();
                this.typesRDBMSSites.put(rDBMSType.getType(), rDBMSType.getName());
            }
        }
        this.fillComboItems(((RelationalDesign)this.table.getDesignPart()).getSchemaObjectSet().toArray(), this.cbSchemaObject, true);
        this.cbSchemaObject.setSelectedItem(this.table.getSchemaObject());
        this.dynamicPropertiesList.clear();
        object3 = this.table.getPropertyNames();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            iterator = this.table.getProperty((String)object2);
            object = new DynamicProperty((String)object2, (String)((Object)iterator));
            this.dynamicPropertiesList.add(object);
        }
        this.dynamicPropertiesTable.updateUI();
    }

    private void enableOidPage(boolean bl) {
        if (this.isEditable()) {
            this.chbIsPrimary.setEnabled(bl);
        }
    }

    @Override
    protected void setProperties() {
        Object object3;
        int n;
        ContainedObject[] containedObjectArray;
        TablePropertiesDialogEx.stopCellEditing(this.sTable);
        TablePropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbIndexKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbTableLevelConstraints);
        TablePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        if (this.selectedColumn != null) {
            this.initSelectedColumnOptions(this.selectedColumn, true);
        }
        this.setPreviousSelectedColumn();
        this.table.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
        this.table.setName(this.tfName.getText());
        this.table.setComment(this.taComments.getText());
        this.table.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.table.setNotes(this.taNotes.getText());
        this.table.setShouldEngineer(this.chEngineer.isSelected());
        this.table.setPKName(this.tfPKName.getText());
        this.table.setScope(this.tfScope.getText());
        this.table.setAbbreviation(this.tfAbbreviation.getText());
        this.classType = this.getDesignObject().getDesign().getDLSettings().getClassificationTypeByName((String)this.cbType.getSelectedItem());
        if (this.classType != null) {
            this.table.setTypeID(this.classType.getTypeID());
        } else {
            this.table.setTypeID("");
        }
        this.table.setBasedOnStructuredType((StructuredType)this.cbBaseOnStructuredType.getSelectedItem());
        this.table.setOidIsPK(this.chbIsPrimary.isSelected());
        this.indexesForUpdate = new ArrayList<Index>(this.allIndexesList);
        Index[] indexArray = (Index[])this.table.getKeySet().toArray();
        for (int i = 0; i < indexArray.length; ++i) {
            Index objectArray2 = indexArray[i];
            if (this.allIndexesList.contains(objectArray2) || this.foreignKeys.contains(objectArray2) || objectArray2.isOidKey() || objectArray2.isFK()) continue;
            containedObjectArray = objectArray2.getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                object3 = containedObjectArray[n];
                if (!(object3 instanceof Column)) continue;
                objectArray2.remove((Column)object3);
            }
            this.table.remove(objectArray2);
            this.indexesForUpdate.remove(objectArray2);
        }
        for (Index index : this.allIndexesList) {
            if (this.table.getKeySet().contains(index)) continue;
            this.table.add(index);
            index.getIndexMemento().id = index.getObjectID();
        }
        for (Index index : this.indexesForUpdate) {
            index.restoreFromMemento(index.getIndexMemento());
        }
        ArrayList arrayList = new ArrayList();
        if (this.table.isBST()) {
            this.primaryKey = (Index)this.table.getPK();
        }
        if (this.primaryKey != null) {
            arrayList.add(this.primaryKey);
        }
        arrayList.addAll(this.uniqueKeys);
        arrayList.addAll(this.indexKeys);
        ((IndexSet)this.table.getKeySet()).addAndApplyOrderFromList(arrayList);
        if (!this.table.isBST()) {
            Object[] objectArray = this.columnsList.toArray();
            containedObjectArray = (Column[])this.table.getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                object3 = containedObjectArray[n];
                if (this.columnsList.contains(object3) || this.columnsListWithFK.contains(object3)) continue;
                ((ContainedObject)object3).remove();
            }
            for (n = 0; n < objectArray.length; ++n) {
                object3 = objectArray[n];
                if (!(object3 instanceof Column)) continue;
                if (!this.table.getElementsCollection().contains(object3)) {
                    this.table.add((Column)object3);
                    ((Column)object3).moveToIndex(n);
                    continue;
                }
                ((Column)object3).moveToIndex(n);
            }
        } else {
            this.columnsList.clear();
            this.columnsList.addAll(Arrays.asList((Column[])this.table.getElements()));
            this.alteredColumnList.addAll(this.columnsList);
            this.removeAllIndexes();
            this.addIndexes((Index[])this.table.getKeys());
            this.initPrimaryKeyProperties();
        }
        this.table.setMinVolumes(this.tfMinVolume.getText());
        this.table.setExpectedVolumes(this.tfExpected.getText());
        this.table.setMaxVolumes(this.tfMaximum.getText());
        this.table.setGrowthPercent(this.tfGrowthPercent.getText());
        this.table.setGrowthType(this.translate((String)this.cbYearMonthDay.getSelectedItem(), YMD, YMD_INTERNAL));
        this.table.setNormalForm(this.translate((String)this.cbNormalForm.getSelectedItem(), NF, NF_INTERNAL));
        this.table.setAdequatelyNormalized(this.translate((String)this.cbAdequatelyNormalized.getSelectedItem(), YES_NO, YES_NO_INTERNAL));
        if (this.selectedTableLevelConstraint != null) {
            this.saveSelectedTableLevelConstraint();
        }
        Object[] objectArray = this.table.getCheckConstraints().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.tableLevelConstraints.contains(objectArray[i])) continue;
            ((TableLevelConstraint)objectArray[i]).remove();
        }
        for (TableLevelConstraint tableLevelConstraint : this.tableLevelConstraints) {
            this.table.addCheckConstraint(tableLevelConstraint);
        }
        this.preserveKeysStructure(this.table);
        this.setMeasurements(this.table);
        this.setChangeRequests(this.table);
        this.setResponsibleParties(this.table);
        this.setDocuments(this.table);
        Index index = this.getPKIndex();
        if (index == null && this.table.getPK() != null) {
            this.table.setPK(null);
        }
        this.table.setBeforeDrop(this.taBeforeDrop.getText());
        this.table.setBeforeCreate(this.taBeforeCreate.getText());
        this.table.setAfterCreate(this.taAfterCreate.getText());
        this.table.setEndOfScript(this.taEndOfScript.getText());
        this.table.setShouldGenerateScript(this.chGenerateScript.isSelected());
        this.tbColumns.updateUI();
        this.coTable.updateUI();
        this.tbIndexKeys.updateUI();
        this.tbForeignKeys.updateUI();
        this.table.setSpatialTable(this.chSpatialTable.isSelected());
        this.table.setAllowTypeSubstitution(this.chTypeSubst.isSelected());
        this.table.setMarkedGenerate(this.chMarkGenerate.isSelected());
        this.table.getSpatialDefinitions().clear();
        this.table.getSpatialDefinitions().addAll(this.sList);
        this.tfLongName.setText(this.table.getLongName());
        this.tfLongName.setText(this.table.getLongName());
        this.saveSelectedFKProperties();
        Object object2 = this.fkList.iterator();
        while (object2.hasNext()) {
            object3 = object2.next();
            ((FKIndexAssociation.FKMemento)object3).fk.resetFromMemento((FKIndexAssociation.FKMemento)object3);
        }
        this.savePrimaryKeyProperties();
        if (this.primaryKey != null) {
            this.primaryKey.restoreFromMemento(this.primaryKey.getIndexMemento());
        }
        this.fkListForCreate.removeAll(this.fkListForRemove);
        this.fkListForUpdate = new ArrayList<FKIndexAssociation.FKMemento>(this.fkList);
        this.fkListForUpdate.removeAll(this.fkListForCreate);
        this.fkListForUpdate.removeAll(this.fkListForRemove);
        if (this.tbColumnGroupTable != null && this.tbColumnGroupTable.getRowCount() > 0 && (object2 = this.tbColumnGroupTable.getCellEditor()) != null) {
            this.tbColumnGroupTable.getCellEditor().stopCellEditing();
        }
        this.table.clearProperties();
        for (Object object3 : this.dynamicPropertiesList) {
            this.table.setProperty(((DynamicProperty)object3).getName(), ((DynamicProperty)object3).getValue());
        }
        if (this.oldTable.showForFirstTime()) {
            ((RelationalDesign)this.oldTable.getDesignPart()).postTableCreateEdit(this.oldTable);
        }
        if (this.stealthChange || !this.oldTable.getAppView().getXMLTransformationManager().equal(this.oldTable, this.table, false) || this.fkChanges()) {
            this.applyTableUpdates();
        } else {
            this.oldTable.setMarkedGenerate(this.chMarkGenerate.isSelected());
            object2 = this.table.getKeySet().iterator();
            while (object2.hasNext()) {
                object3 = (Index)object2.next();
                Index index2 = this.oldTable.getIndexByID(((ModelIDObject)object3).getObjectID());
                if (index2 == null) continue;
                index2.setMarkedGenerate(((ModelIDObject)object3).isMarkedGenerate());
            }
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
        this.dirtyMementos.clear();
        this.stealthChange = false;
        this.checkNamingOptions();
    }

    private boolean fkChanges() {
        return !this.fkListForUpdate.isEmpty() || !this.fkListForCreate.isEmpty() || !this.fkListForRemove.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTableUpdates() {
        TableUpdateEdit tableUpdateEdit = new TableUpdateEdit(this.oldTable, this.table, this.indexesForUpdate, this.fkListForUpdate, this.fkListForCreate, this.fkListForRemove, this.table.getColumnGroupsSet());
        this.oldTable.getDesignPart().postUndoableEdit(tableUpdateEdit);
        this.oldTable.getDesignPart().getUndoManager().setLocked(true);
        try {
            tableUpdateEdit.applyUpdates();
        }
        finally {
            this.oldTable.getDesignPart().getUndoManager().setLocked(false);
        }
    }

    @Override
    protected void onApply() {
        super.onApply();
    }

    @Override
    protected boolean canExit() {
        TablePropertiesDialogEx.stopCellEditing(this.sTable);
        TablePropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbIndexKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbTableLevelConstraints);
        this.saveSelectedFKProperties();
        this.saveSelectedIndexKeyProperties();
        this.saveSelectedUniqueKeyProperties();
        this.savePrimaryKeyProperties();
        this.saveSelectedTableLevelConstraint();
        this.saveColumnGroupProperties(this.lastSelectedColumnGroup);
        if (this.selectedColumn != null) {
            this.initSelectedColumnOptions(this.selectedColumn, true);
        }
        this.setPreviousSelectedColumn();
        for (Table.ColumnGroup object : this.columnGroupsForRemovalList) {
            this.table.removeColumnGroup(object);
        }
        if (super.canExit()) {
            if (this.primaryKey != null && (!StringUtilities.isNotEmpty(this.primaryKey.getName()) || this.primaryKeyColumnsPanel.getSelectedColumns().isEmpty())) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TablePropertiesDialogEx.IncompletePKDefinition"), PRIMARY_KEY_TAB_NAME, 0);
                return false;
            }
            if (this.fkPropertiesEnabled) {
                for (FKIndexAssociation.FKMemento fKMemento : this.fkList) {
                    if (FKUtilities.checkRequiredProperties((Component)Ide.getMainWindow(), FKUtilities.getFKColumns(fKMemento, this.columnsList), fKMemento.fk, fKMemento.mandatory, fKMemento.transferable)) continue;
                    return false;
                }
            }
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        for (Index designObject : this.uniqueKeys) {
            if (!designObject.getIndexMemento().columns.isEmpty()) continue;
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TablePropertiesDialogEx.IncompleteUKDefinition"), designObject.getName()), Messages.getString("TablePropertiesDialogEx.UKColumnsAssignment"), 0);
            return false;
        }
        for (Index index : this.indexKeys) {
            IndexMemento indexMemento = index.getIndexMemento();
            if (StringUtilities.isNotEmpty(indexMemento.expression) || !indexMemento.columns.isEmpty()) continue;
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TablePropertiesDialogEx.IncompleteIxDefinition"), index.getName()), Messages.getString("TablePropertiesDialogEx.IxColumnsAssignment"), 0);
            return false;
        }
        for (TableLevelConstraint tableLevelConstraint : this.tableLevelConstraints) {
            if (StringUtilities.isNotEmpty(tableLevelConstraint.getName()) && StringUtilities.isNotEmpty(tableLevelConstraint.getRule())) continue;
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TablePropertiesDialogEx.IncompleteTLCDefinition"), tableLevelConstraint.getName()), Messages.getString("TablePropertiesDialogEx.TLCColumnsAssignment"), 0);
            return false;
        }
        return true;
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRTableMaxNameLength(), this.oldTable);
        this.checkDesignRule(new DRTableCaseType(), this.oldTable);
        this.checkDesignRule(new DRTableValidCharacters(), this.oldTable);
        DRColumnMaxNameLength dRColumnMaxNameLength = new DRColumnMaxNameLength();
        DRColumnCaseType dRColumnCaseType = new DRColumnCaseType();
        DRColumnValidCharacters dRColumnValidCharacters = new DRColumnValidCharacters();
        for (Column column : this.columnsList) {
            this.checkDesignRule(dRColumnMaxNameLength, column);
            this.checkDesignRule(dRColumnCaseType, column);
            this.checkDesignRule(dRColumnValidCharacters, column);
        }
    }

    private void preserveKeysStructure(ContainerWithKeyObject containerWithKeyObject) {
        this.keyMap.clear();
        KeyObject[] keyObjectArray = containerWithKeyObject.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
            ContainedObject[] containedObjectArray = keyObjectArray[i].getElements();
            for (int j = 0; j < containedObjectArray.length; ++j) {
                arrayList.add(containedObjectArray[j]);
            }
            this.keyMap.put(keyObjectArray[i], arrayList);
        }
    }

    @Override
    protected String getHelpIndex() {
        return "TABLE_PROPERTIES_DIALOG";
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    private void initGeneral() {
        this.lbName.setPreferredSize(defaultSize);
        JLabel jLabel = new JLabel(LB_LONG_NAME);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfLongName));
        JLabel jLabel2 = new JLabel(ABBREVIATION);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfAbbreviation));
        JLabel jLabel3 = new JLabel(LB_ENGINEER);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chEngineer = new JCheckBox();
        this.chEngineer.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chEngineer));
        JLabel jLabel4 = new JLabel(LB_PK_NAME);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfPKName = new JTextField();
        this.tfPKName.setEditable(false);
        this.tfPKName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfPKName));
        JLabel jLabel5 = new JLabel(LB_CL_TYPE);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox();
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.cbType.setMaximumRowCount(8);
        this.cbType.addActionListener(new TypeListener());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbType));
        JLabel jLabel6 = new JLabel(LB_TEMP_TABLE_SCOPE);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.tfScope = new JTextField();
        this.tfScope.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.tfScope));
        JLabel jLabel7 = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType = new JComboBox();
        this.cbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.cbBaseOnStructuredType));
        this.cbBaseOnStructuredType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem();
                if (object != null) {
                    if (TablePropertiesDialogEx.this.st_type != null) {
                        TablePropertiesDialogEx.this.deleteAllIndexes();
                        TablePropertiesDialogEx.this.tbIndexKeys.updateUI();
                    }
                    if (TablePropertiesDialogEx.this.isEditable()) {
                        TablePropertiesDialogEx.this.bnCOAdd.setEnabled(false);
                        TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                    }
                } else if (TablePropertiesDialogEx.this.isEditable()) {
                    TablePropertiesDialogEx.this.bnCOAdd.setEnabled(true);
                    TablePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                }
                TablePropertiesDialogEx.this.st_type = (StructuredType)object;
                boolean bl = TablePropertiesDialogEx.this.st_type != null;
                TablePropertiesDialogEx.this.enableOidPage(bl);
                TablePropertiesDialogEx.this.chTypeSubst.setEnabled(bl && TablePropertiesDialogEx.this.table.getSubTypeSubstitutions().size() == 0);
                TablePropertiesDialogEx.this.enableColumnOptions(true, 3);
            }
        });
        JLabel jLabel8 = new JLabel(SCHEMA);
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject = new JComboBox();
        this.cbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.cbSchemaObject));
        JLabel jLabel9 = new JLabel(Messages.getString("TablePropertiesDialogEx.RegisterAsSpatialTable"));
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.chSpatialTable = new JCheckBox();
        this.chSpatialTable.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel9, this.chSpatialTable));
        JLabel jLabel10 = new JLabel(Messages.getString("TablePropertiesDialogEx.OidIsPrimaryKey"));
        jLabel10.setPreferredSize(this.getDefaultSize());
        this.chbIsPrimary = new JCheckBox();
        this.chbIsPrimary.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel10, this.chbIsPrimary));
        JLabel jLabel11 = new JLabel(Messages.getString("TablePropertiesDialogEx.AllowTypeSubstitution"));
        jLabel11.setPreferredSize(this.getDefaultSize());
        this.chTypeSubst = new JCheckBox();
        this.chTypeSubst.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel11, this.chTypeSubst));
        JLabel jLabel12 = new JLabel(Messages.getString("TablePropertiesDialogEx.GenerateInDDL"));
        jLabel12.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel12, this.chMarkGenerate));
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedColumn();
        String string = component.getName();
        if (string.equals(PRIMARY_KEY_TAB_NAME)) {
            this.primaryKeyColumnsPanel.init(this.columnsList);
        } else if (string.equals(UNIQUE_KEYS_TAB_NAME)) {
            if (!this.selectFirstRow(this.tbUniqueKeys, this.uniqueKeys)) {
                this.uniqueKeysColumnsPanel.init(this.columnsList);
            }
        } else if (string.equals(INDEX_KEYS_TAB_NAME)) {
            if (!this.selectFirstRow(this.tbIndexKeys, this.indexKeys)) {
                this.indexExpressionPanel.init(this.columnsList);
            }
        } else if (string.equals(FOREIGN_KEY_TAB_NAME)) {
            this.selectFirstRow(this.tbForeignKeys, this.fkList);
        } else if (string.equals(COLUMNS_TAB_NAME)) {
            this.selectFirstRow(this.coTable, this.columnsList);
        } else if (string.equals(COLUMN_GROUP_TAB_NAME)) {
            this.columnGroupExpressionPanel.init(this.columnsList);
        }
        super.showComponent(component);
    }

    protected boolean selectFirstRow(JTable jTable, List list) {
        if (jTable.getSelectedRow() == -1 && list.size() > 0) {
            jTable.updateUI();
            jTable.changeSelection(0, 1, false, false);
            jTable.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getColumnsPanel());
        this.addToTree(defaultMutableTreeNode, this.getPrimaryKeyPanel());
        this.addToTree(defaultMutableTreeNode, this.getUniqueKeysPanel());
        this.addToTree(defaultMutableTreeNode, this.getIndexesPanel());
        this.addToTree(defaultMutableTreeNode, this.getTableLevelConstraintsPanel());
        this.addToTree(defaultMutableTreeNode, this.getForeignKeysPanel());
        this.addToTree(defaultMutableTreeNode, this.getNestedColumnsPanel());
        this.addToTree(defaultMutableTreeNode, this.getVolumesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSpatialPanel());
        this.addToTree(defaultMutableTreeNode, this.getColumnGroupsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getScriptPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
                if (treePath != null) {
                    String string;
                    String string2 = ((JPanel)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).getName();
                    if (string2.equals(UNIQUE_KEYS_TAB_NAME)) {
                        TablePropertiesDialogEx.this.saveSelectedUniqueKeyProperties();
                    }
                    if ((string = ((JPanel)((DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent()).getUserObject()).getName()).equals(INDEX_KEYS_TAB_NAME)) {
                        TablePropertiesDialogEx.this.initSelectedIndexKeyProperties();
                    }
                    if (TablePropertiesDialogEx.this.isEditable() && string.equals(PRIMARY_KEY_TAB_NAME)) {
                        TablePropertiesDialogEx.this.btnPKRemove.setEnabled(TablePropertiesDialogEx.this.primaryKey != null);
                    }
                }
            }
        });
    }

    private void updateAllowNullsStatus(Column column, boolean bl) {
        boolean bl2 = column.getNullsAllowed();
        column.setNullsAllowed(!bl);
        if (column.isFKColumn()) {
            TablePropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        }
        if (bl2 && bl) {
            List list = ((Table)column.getContainerWithKeyObject()).getFKeysOnColumn(column);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object : list) {
                if (!"SET NULL".equals(((FKIndexAssociation)object).getDeleteRule()) || ((FKIndexAssociation)object).hasColumnWithAllowNulls()) continue;
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                Object object;
                object = Messages.getString("TablePropertiesDialogEx.DeleteRuleWillChange");
                for (FKIndexAssociation fKIndexAssociation : arrayList) {
                    object = (String)object + "\n" + fKIndexAssociation.getName();
                }
                int n = JOptionPane.showConfirmDialog(null, object, Messages.getString("TablePropertiesDialogEx.FKDeleteRuleChange"), 2);
                if (n != 0) {
                    column.setNullsAllowed(true);
                } else {
                    for (FKIndexAssociation fKIndexAssociation : arrayList) {
                        fKIndexAssociation.setDeleteRule("RESTRICT");
                    }
                }
            }
        }
    }

    private void updatePKStatus(Column column, boolean bl, String string, String string2, String string3) {
        Index index;
        if (bl) {
            if (column.isInFKinArc()) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TablePropertiesDialogEx.ColumnBelongsToFKInARC"), Messages.getString("TablePropertiesDialogEx.ColumnInFKInArc"), 0);
                return;
            }
            if (column.isInOptionalFK()) {
                int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("TablePropertiesDialogEx.TheColumnBelongsToOptionalFK"), Messages.getString("TablePropertiesDialogEx.ColumnInOptionalFK"), 0);
                if (n != 0) {
                    return;
                }
                for (FKIndexAssociation fKIndexAssociation : column.getAllFKs()) {
                    if (fKIndexAssociation.isMandatory()) continue;
                    fKIndexAssociation.setMandatory(true);
                    fKIndexAssociation.resetEdgeParams();
                }
            }
        }
        if ((index = this.getPKIndex()) == null && bl) {
            index = this.createAndAddIndex(PRIMARY_CONSTRAINT, string, string2);
            if (!StringUtilities.isNotEmpty(string3)) {
                string3 = this.table.getDesign().getDLSettings().getNamingStandardRule().getPkConstr();
                string3 = string3.replaceAll("\\{table\\}", string);
                string3 = string3.replaceAll("\\{table abbr\\}", string2);
                string3 = string3.replaceAll("\\{column\\}", column.getName());
                string3 = string3.replaceAll("\\{column abbr\\}", column.getAbbreviation().trim());
            }
            index.setName(string3);
        }
        if (index != null) {
            if (!bl) {
                index.remove(column);
            } else {
                if (!index.contains(column)) {
                    index.add(column);
                }
                if (column.getNullsAllowed()) {
                    column.setNullsAllowed(false);
                }
            }
        }
        this.initPrimaryKeyProperties();
    }

    protected JPanel getColumnsPanel() {
        Serializable serializable;
        Serializable serializable2;
        if (this.pnColumns == null) {
            this.pnColumns = new JPanel(new BorderLayout());
            this.columnsList = new ArrayList<Column>();
            this.columnsListWithFK = new ArrayList();
            serializable2 = new DataModel();
            this.tbColumns = new ColumnTable((TableModel)((Object)serializable2));
            this.tbColumns.setSelectionMode(1);
            serializable = this.tbColumns.getColumnModel().getColumn(0);
            ((TableColumn)serializable).setPreferredWidth(30);
            ((TableColumn)serializable).setMaxWidth(50);
            ((TableColumn)serializable).setMinWidth(25);
            serializable = this.tbColumns.getColumnModel().getColumn(1);
            ((TableColumn)serializable).setPreferredWidth(295);
            serializable = this.tbColumns.getColumnModel().getColumn(2);
            ((TableColumn)serializable).setCellRenderer(new DataTypeCellRenderer());
            ((TableColumn)serializable).setPreferredWidth(275);
            serializable = this.tbColumns.getColumnModel().getColumn(3);
            ((TableColumn)serializable).setMaxWidth(20);
            ((TableColumn)serializable).setMinWidth(20);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            serializable = this.tbColumns.getColumnModel().getColumn(4);
            ((TableColumn)serializable).setMaxWidth(20);
            ((TableColumn)serializable).setMinWidth(20);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            serializable = this.tbColumns.getColumnModel().getColumn(5);
            ((TableColumn)serializable).setMaxWidth(20);
            ((TableColumn)serializable).setMinWidth(20);
            ((TableColumn)serializable).setCellRenderer(new StatusCellRenderer());
            serializable = this.tbColumns.getColumnModel().getColumn(6);
            ((TableColumn)serializable).setPreferredWidth(190);
            serializable = this.tbColumns.getColumnModel().getColumn(7);
            ((TableColumn)serializable).setPreferredWidth(220);
            serializable = this.tbColumns.getColumnModel().getColumn(8);
            ((TableColumn)serializable).setPreferredWidth(180);
            JScrollPane jScrollPane = new JScrollPane(this.tbColumns);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnColumns.add(jPanel);
        }
        serializable2 = new JTabbedPane();
        ((JTabbedPane)serializable2).addTab(Messages.getString("TablePropertiesDialogEx.Details"), this.createExtendedColumnPanel());
        ((JTabbedPane)serializable2).addTab(Messages.getString("TablePropertiesDialogEx.Overview"), this.pnColumns);
        ((JTabbedPane)serializable2).addTab(ColumnPropertiesDialogEx.SECURITY, this.createColumnsSecurityPanel());
        serializable = this.createPage(COLUMNS_TAB_NAME);
        ((Container)serializable).add((Component)serializable2);
        ((JTabbedPane)serializable2).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TablePropertiesDialogEx.this.setPreviousSelectedColumn();
            }
        });
        return serializable;
    }

    private void setColumnSelected() {
        int n = this.coTable.getSelectedRow();
        if (n != -1 && this.columnsList.size() > 0 && n < this.columnsList.size()) {
            Column column = this.columnsList.get(n);
            this.initSelectedColumnOptions(column, true);
        }
    }

    private JPanel createExtendedColumnPanel() {
        Object object;
        Object object2;
        Object object3;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.coTable = new JTable(new ColumnModel());
        this.coTable.setSelectionMode(2);
        TableColumn tableColumn = this.coTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(25);
        this.coTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TablePropertiesDialogEx.this.setColumnSelected();
                if (mouseEvent.getClickCount() == 2) {
                    TablePropertiesDialogEx.this.showColumnPropertiesDialog();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.coTable);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setPreferredSize(new Dimension(250, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_PROPERTIES);
        jButton.addActionListener(new COPropertiesAction());
        if (this.isEditable()) {
            object3 = new MoveUpDownListJTable(this.columnsList, this.coTable);
            object2 = "<html><body>" + Messages.getString("TablePropertiesDialogEx.AddTip1") + "<p>" + Messages.getString("TablePropertiesDialogEx.AddTip2") + "<p>" + Messages.getString("TablePropertiesDialogEx.AddTip3") + "</body>" + "</html>";
            this.bnCOAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.setToolTipText((String)object2);
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.setToolTipText(BTN_REMOVE);
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.setToolTipText(BTN_MOVE_UP);
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction((MoveUpDownListJTable)object3));
            this.bnCODown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.setToolTipText(BTN_MOVE_DOWN);
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction((MoveUpDownListJTable)object3));
            this.bnCOCopy = new JButton(gUIConfiguration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.setToolTipText(Messages.getString("TablePropertiesDialogEx.CopySelectedColumns"));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(gUIConfiguration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.setToolTipText(Messages.getString("TablePropertiesDialogEx.PasteCopiedColumnsAtTheEnd"));
            this.bnCOPaste.addActionListener(new COPasteAction());
            this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (TablePropertiesDialogEx.this.columnsList.isEmpty()) {
                        TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        jButton.setEnabled(false);
                        TablePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        TablePropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        if (TablePropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem() != null) {
                            TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            TablePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            TablePropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else {
                            TablePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                            TablePropertiesDialogEx.this.bnCOUp.setEnabled(true);
                            TablePropertiesDialogEx.this.bnCODown.setEnabled(true);
                        }
                        jButton.setEnabled(true);
                        TablePropertiesDialogEx.this.setColumnSelected();
                    }
                }
            });
            this.coTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TablePropertiesDialogEx.this.columnsList.isEmpty()) {
                        TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                        jButton.setEnabled(false);
                        TablePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                        TablePropertiesDialogEx.this.bnCODown.setEnabled(false);
                    } else {
                        if (TablePropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem() != null) {
                            TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            TablePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            TablePropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else {
                            TablePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                            TablePropertiesDialogEx.this.bnCOUp.setEnabled(true);
                            TablePropertiesDialogEx.this.bnCODown.setEnabled(true);
                        }
                        jButton.setEnabled(true);
                    }
                }
            });
            object = this.coTable.getSelectionModel();
            object.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                        if (TablePropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem() == null) {
                            if (listSelectionModel.isSelectionEmpty()) {
                                TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                                jButton.setEnabled(false);
                            } else {
                                TablePropertiesDialogEx.this.bnCORemove.setEnabled(true);
                                jButton.setEnabled(true);
                            }
                        } else {
                            TablePropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            TablePropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            TablePropertiesDialogEx.this.bnCODown.setEnabled(false);
                        }
                    }
                }
            });
        }
        object3 = new JToolBar(0);
        ((JToolBar)object3).setFloatable(false);
        ((Container)object3).add(jButton);
        if (this.isEditable()) {
            ((JToolBar)object3).addSeparator();
            ((Container)object3).add(this.bnCOAdd);
            ((Container)object3).add(this.bnCORemove);
            ((Container)object3).add(this.bnCOUp);
            ((Container)object3).add(this.bnCODown);
            ((JToolBar)object3).addSeparator();
            ((Container)object3).add(this.bnCOCopy);
            ((Container)object3).add(this.bnCOPaste);
        }
        jPanel2.add((Component)object3);
        object2 = new JPanel(new BorderLayout());
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertiesDialogEx.ColumnsL")));
        ((Container)object2).add((Component)jPanel2, "North");
        ((Container)object2).add(jScrollPane);
        jPanel.add((Component)object2, "Center");
        this.coTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    TablePropertiesDialogEx.this.deleteColumn(TablePropertiesDialogEx.this.coTable);
                }
            }
        });
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertiesDialogEx.ColumnProperties")));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(60, 20);
        Dimension dimension2 = new Dimension(120, 20);
        JLabel jLabel = new JLabel(LB_NAME);
        jLabel.setPreferredSize(dimension2);
        this.tfColumnName = new JTextField();
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    TablePropertiesDialogEx.this.moveUp();
                } else if (keyEvent.getKeyCode() == 40) {
                    TablePropertiesDialogEx.this.moveDown();
                }
            }
        });
        Dimension dimension3 = new Dimension(180, 20);
        Dimension dimension4 = new Dimension(260, 20);
        this.tfColumnName.setPreferredSize(dimension4);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.createRow(jLabel, this.tfColumnName), "North");
        jPanel4.add((Component)new JPanel(), "Center");
        jPanel3.add((Component)jPanel4, "North");
        RBActionListener rBActionListener = new RBActionListener();
        this.rbDomain = new JRadioButton(LB_DOMAIN);
        this.rbLogical = new JRadioButton(Messages.getString("TablePropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("TablePropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("TablePropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("TablePropertiesDialogEx.Collection"));
        this.rbDomain.addActionListener(rBActionListener);
        this.rbLogical.addActionListener(rBActionListener);
        this.rbDistinct.addActionListener(rBActionListener);
        this.rbStructured.addActionListener(rBActionListener);
        this.rbCollection.addActionListener(rBActionListener);
        this.datatypeGroup = new ButtonGroup();
        this.datatypeGroup.add(this.rbDomain);
        this.datatypeGroup.add(this.rbLogical);
        this.datatypeGroup.add(this.rbDistinct);
        this.datatypeGroup.add(this.rbStructured);
        this.datatypeGroup.add(this.rbCollection);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 0));
        jPanel5.add(this.rbDomain);
        jPanel5.add(this.rbLogical);
        jPanel5.add(this.rbDistinct);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 0));
        jPanel6.add(this.rbStructured);
        jPanel6.add(this.rbCollection);
        jPanel6.add(new JPanel());
        JLabel jLabel2 = new JLabel(LB_DATATYPE);
        jLabel2.setPreferredSize(dimension2);
        JPanel jPanel7 = new JPanel(new GridLayout(0, 1));
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(dimension2);
        jPanel7.add(this.createRow(jLabel2, jPanel5));
        jPanel7.add(this.createRow(jLabel3, jPanel6));
        jPanel3.add((Component)jPanel7, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 10));
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel8, "Center");
        jPanel3.add((Component)jPanel9, "South");
        JLabel jLabel4 = new JLabel(LB_TYPE);
        jLabel4.setPreferredSize(dimension2);
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setPreferredSize(dimension3);
        this.cbDatatype.setMaximumRowCount(20);
        JLabel jLabel5 = new JLabel(Messages.getString("TablePropertiesDialogEx.Preferred"));
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setPreferredSize(new Dimension(jLabel5.getPreferredSize().width + 10, jLabel5.getPreferredSize().height));
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JPanel(), "North");
        jPanel4.add((Component)this.createRow(jLabel4, this.cbDatatype), "Center");
        jPanel4.add((Component)this.createRow(jLabel5, this.chbUsePreferredList), "East");
        jPanel8.add((Component)jPanel4, "North");
        this.pnDType = new JPanel(new BorderLayout());
        this.pnDType.setPreferredSize(new Dimension(200, 50));
        JLabel jLabel6 = new JLabel(' ' + LB_SIZE);
        jLabel6.setHorizontalAlignment(2);
        jLabel6.setPreferredSize(dimension2);
        this.ifDTSize = new JTextField();
        this.ifDTSize.setPreferredSize(dimension4);
        this.pnDTSize = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTSize.add(this.createRow(jLabel6, this.ifDTSize));
        this.pnDType.add((Component)this.pnDTSize, "North");
        jPanel8.add((Component)this.pnDType, "Center");
        JLabel jLabel7 = new JLabel(Messages.getString("TablePropertiesDialogEx.Units"));
        jLabel7.setHorizontalAlignment(2);
        jLabel7.setPreferredSize(dimension2);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(new Dimension(60, 20));
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)this.createRow(jLabel7, this.cbUnits), "West");
        jPanel10.add((Component)new JPanel(), "Center");
        this.pnDTSize.add(jPanel10);
        this.cbDatatypeActionListener = new ActionListener(){
            LogicalDatatype sel;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                String string = null;
                if (TablePropertiesDialogEx.this.rbLogical.isSelected()) {
                    TablePropertiesDialogEx.this.updateLogicalDatatypeOptions();
                    this.sel = (LogicalDatatype)TablePropertiesDialogEx.this.cbDatatype.getSelectedItem();
                    if (this.sel != null) {
                        if (TablePropertiesDialogEx.this.selectedColumn != null && !TablePropertiesDialogEx.this.selectedColumn.isOid()) {
                            string = this.sel.getName();
                            Design design = TablePropertiesDialogEx.this.getDesignObject().getDesign();
                            LogicalDatatype logicalDatatype = (LogicalDatatype)design.getLogicalDatatypeSet().getByName(string);
                            MDDataType mDDataType = logicalDatatype.createDataType(design.getSelectedRDBMSType().getName(), new HashMap());
                            String string2 = mDDataType.getName();
                            bl = LogicalDatatype.canBeUsedForPK(string2);
                        } else if (TablePropertiesDialogEx.this.selectedColumn != null) {
                            bl = true;
                        }
                    }
                } else if (TablePropertiesDialogEx.this.rbStructured.isSelected()) {
                    if (TablePropertiesDialogEx.this.selectedColumn != null && !TablePropertiesDialogEx.this.selectedColumn.isOid()) {
                        bl = false;
                        string = Messages.getString("TablePropertiesDialogEx.Structured");
                    }
                } else if (TablePropertiesDialogEx.this.rbCollection.isSelected()) {
                    bl = false;
                    string = Messages.getString("TablePropertiesDialogEx.Collection");
                }
                if (!bl) {
                    TablePropertiesDialogEx.this.removeSelectedColumnFromPK(string);
                    TablePropertiesDialogEx.this.removeSelectedColumnFromUK(string);
                } else {
                    TablePropertiesDialogEx.this.chbPK.setEnabled(TablePropertiesDialogEx.this.isEditable());
                }
                TablePropertiesDialogEx.this.initSelectedUniqueKeyProperties();
                TablePropertiesDialogEx.this.uniqueKeysColumnsPanel.refresh();
            }
        };
        this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
        JLabel jLabel8 = new JLabel(LB_PRECISION);
        jLabel8.setHorizontalAlignment(2);
        jLabel8.setPreferredSize(dimension2);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setPreferredSize(dimension4);
        this.pnDTScale = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTScale.add(this.createRow(jLabel8, this.ifDTPrecision));
        JLabel jLabel9 = new JLabel(LB_SCALE);
        jLabel9.setHorizontalAlignment(2);
        jLabel9.setPreferredSize(dimension2);
        this.ifDTScale = new JIntegerField();
        this.ifDTScale.setPreferredSize(dimension4);
        this.pnDTScale.add(this.createRow(jLabel9, this.ifDTScale));
        this.pnRef = new JPanel(new GridLayout(0, 1, 0, 10));
        JLabel jLabel10 = new JLabel("");
        jLabel10.setHorizontalAlignment(0);
        jLabel10.setPreferredSize(dimension);
        this.chbReference = new JCheckBox(Messages.getString("TablePropertiesDialogEx.Reference"));
        this.ifDTSize.setPreferredSize(dimension4);
        this.pnRef.add(this.createRow(jLabel10, this.chbReference));
        JPanel jPanel11 = new JPanel(new GridLayout(0, 1));
        jPanel9.add((Component)jPanel11, "South");
        jPanel11.add(new JPanel());
        this.chbPK = new JCheckBox(Messages.getString("TablePropertiesDialogEx.PK"));
        this.chbPKActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TablePropertiesDialogEx.this.selectedColumn != null) {
                    TablePropertiesDialogEx.this.updatePKStatus(TablePropertiesDialogEx.this.selectedColumn, TablePropertiesDialogEx.this.chbPK.isSelected(), TablePropertiesDialogEx.this.tfName.getText().trim(), TablePropertiesDialogEx.this.tfAbbreviation.getText().trim(), null);
                    if (TablePropertiesDialogEx.this.chbPK.isSelected()) {
                        TablePropertiesDialogEx.this.chbMandatory.setSelected(true);
                        TablePropertiesDialogEx.this.chbMandatory.setEnabled(false);
                    } else if (!TablePropertiesDialogEx.this.selectedColumn.isFKElement()) {
                        TablePropertiesDialogEx.this.chbMandatory.setEnabled(true);
                    }
                }
            }
        };
        this.chbPK.addActionListener(this.chbPKActionListener);
        this.chbFK = new JCheckBox(Messages.getString("TablePropertiesDialogEx.FK"));
        this.chbFK.setEnabled(false);
        this.chbMandatory = new JCheckBox(Messages.getString("TablePropertiesDialogEx.Mandatory"));
        this.chbMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TablePropertiesDialogEx.this.selectedColumn != null) {
                    TablePropertiesDialogEx.this.updateAllowNullsStatus(TablePropertiesDialogEx.this.selectedColumn, TablePropertiesDialogEx.this.chbMandatory.isSelected());
                }
            }
        });
        JPanel jPanel12 = new JPanel(new GridLayout(1, 0));
        jPanel12.add(this.chbPK);
        jPanel12.add(this.chbFK);
        jPanel12.add(this.chbMandatory);
        jLabel3 = new JLabel("");
        jLabel3.setPreferredSize(dimension);
        jPanel11.add(this.createRow(jLabel3, jPanel12));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.taColumnComments = new JTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnNotes = new JTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        this.taColumnCommentsInRDBMS = new JTextArea();
        this.taColumnCommentsInRDBMS.setLineWrap(true);
        this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
        jTabbedPane.addTab(Messages.getString("TablePropertiesDialogEx.Comments"), new JScrollPane(this.taColumnComments));
        jTabbedPane.addTab(Messages.getString("TablePropertiesDialogEx.CommentsInRDBMS"), new JScrollPane(this.taColumnCommentsInRDBMS));
        jTabbedPane.addTab(Messages.getString("TablePropertiesDialogEx.Notes"), new JScrollPane(this.taColumnNotes));
        jTabbedPane.setPreferredSize(new Dimension(300, 100));
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel13.add(jPanel3);
        ((Container)object).add((Component)jPanel13, "North");
        ((Container)object).add((Component)jTabbedPane, "Center");
        jPanel.add((Component)object, "East");
        this.updateDTComboBox();
        return jPanel;
    }

    private void removeSelectedColumnFromPK(String string) {
        if (this.primaryKey != null && this.primaryKey.contains(this.selectedColumn)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TablePropertiesDialogEx.PKColumnRemoved"), string), Messages.getString("TablePropertiesDialogEx.PKColumnsAssignment"), 2);
        }
        this.chbPK.setSelected(false);
        this.chbPK.setEnabled(false);
        this.chbPKActionListener.actionPerformed(null);
    }

    private void removeSelectedColumnFromUK(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Index index : this.uniqueKeys) {
            IndexMemento indexMemento = index.getIndexMemento();
            if (!indexMemento.contains(this.selectedColumn)) continue;
            indexMemento.remove(this.selectedColumn);
            this.logIndexColumnRemoved(indexMemento.name, stringBuilder);
        }
        if (stringBuilder.length() > 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TablePropertiesDialogEx.UKColumnRemoved"), string, stringBuilder.toString()), Messages.getString("TablePropertiesDialogEx.UKColumnsAssignment"), 2);
        }
    }

    private void logIndexColumnRemoved(String string, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    private JPanel createColumnsSecurityPanel() {
        if (this.pnColumnsSecurity == null) {
            this.pnColumnsSecurity = new JPanel(new BorderLayout());
            JComboBox<String> jComboBox = new JComboBox<String>(EMPTY_STRING_YES_NO);
            this.tbColumnsSecurity = new SecurityTable(new SecurityPropertiesDataModel());
            this.tbColumnsSecurity.setSelectionMode(0);
            TableColumn tableColumn = this.tbColumnsSecurity.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn.setMaxWidth(50);
            tableColumn.setMinWidth(25);
            tableColumn = this.tbColumnsSecurity.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            tableColumn = this.tbColumnsSecurity.getColumnModel().getColumn(2);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
            tableColumn = this.tbColumnsSecurity.getColumnModel().getColumn(3);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
            tableColumn = this.tbColumnsSecurity.getColumnModel().getColumn(4);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
            JScrollPane jScrollPane = new JScrollPane(this.tbColumnsSecurity);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnColumnsSecurity.add(jPanel);
        }
        return this.pnColumnsSecurity;
    }

    private void moveUp() {
        int n = this.coTable.getSelectedRow();
        if (n > 0) {
            this.coTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            this.setColumnSelected();
        }
    }

    private void moveDown() {
        int n = this.coTable.getSelectedRow();
        if (n > -1) {
            if (n < this.columnsList.size() - 1) {
                this.coTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                this.setColumnSelected();
            } else if (!ApplicationView.IS_VIEWER && n == this.columnsList.size() - 1) {
                this.addColumn(null);
            }
        }
    }

    private void updateLogicalDatatypeOptions() {
        this.ifDTSize.setText("");
        this.ifDTPrecision.setText("");
        this.ifDTScale.setText("");
        this.cbUnits.setSelectedIndex(0);
        this.cbUnits.setEnabled(false);
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        this.sizeEnabled = false;
        this.precisionEnabled = false;
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbDatatype.getSelectedItem();
        if (logicalDatatype != null) {
            Map map = logicalDatatype.getLTDefaultValues();
            if (map != null) {
                this.precisionDefaultValue = (String)map.get("precision_default_value");
                this.sizeDefaultValue = (String)map.get("size_default_value");
                this.scaleDefaultValue = (String)map.get("scale_default_value");
            }
            Map map2 = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.table.getSelectedRDBMSType().getName(), map2);
            if (mDDataType instanceof MDImplicitSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.ifDTPrecision.setText(this.precisionDefaultValue);
                this.ifDTPrecision.setEnabled(false);
                this.ifDTScale.setText(this.scaleDefaultValue);
                this.ifDTScale.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
            } else if (mDDataType instanceof MDPackedSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.add((Component)this.pnDTScale, "North");
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = true;
                try {
                    if (mDDataType.getPrecision() != 0) {
                        this.ifDTPrecision.setText("" + mDDataType.getPrecision());
                    }
                    if (this.isEditable()) {
                        this.ifDTPrecision.setEnabled(true);
                        if (this.ifDTPrecision.getText().trim().length() == 0) {
                            this.ifDTPrecision.setText(this.precisionDefaultValue);
                        }
                    }
                }
                catch (Exception exception) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.getScale() != 0) {
                        this.ifDTScale.setText("" + mDDataType.getScale());
                    }
                    if (this.isEditable()) {
                        this.ifDTScale.setEnabled(true);
                        if (this.ifDTScale.getText().trim().length() == 0) {
                            this.ifDTScale.setText(this.scaleDefaultValue);
                        }
                    }
                }
                catch (Exception exception) {
                    this.ifDTScale.setEnabled(false);
                }
            } else {
                try {
                    if (mDDataType.hasSize()) {
                        if (!mDDataType.getSize().equalsIgnoreCase("0")) {
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                            String string = mDDataType.getSize();
                            String[] stringArray = string.split(INTERVAL_STRING);
                            this.ifDTSize.setText(stringArray[0]);
                            if (stringArray.length == 2) {
                                this.cbUnits.setSelectedItem(stringArray[1]);
                            }
                        } else {
                            this.ifDTSize.setText(this.sizeDefaultValue);
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                        }
                        if (this.isEditable()) {
                            this.ifDTSize.setEnabled(true);
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTSize, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = true;
                        this.precisionEnabled = false;
                    } else {
                        this.ifDTSize.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTSize.setEnabled(false);
                }
                try {
                    if (mDDataType.hasPrecision()) {
                        if (mDDataType.getPrecision() != 0) {
                            this.ifDTPrecision.setText("" + mDDataType.getPrecision());
                        }
                        if (this.isEditable()) {
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTPrecision.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (mDDataType.hasScale()) {
                        if (mDDataType.getScale() != 0) {
                            this.ifDTScale.setText("" + mDDataType.getScale());
                        }
                        if (this.isEditable()) {
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTScale.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    this.ifDTScale.setEnabled(false);
                }
            }
        }
    }

    private void setPreviousSelectedColumn() {
        if (this.selectedColumn != null) {
            String string;
            int n = 0;
            String string2 = string = this.tfColumnName.getText();
            while (this.columnExists(string2) && !this.selectedColumn.getName().equalsIgnoreCase(this.tfColumnName.getText())) {
                string2 = string.concat("_").concat(Integer.toString(++n));
            }
            this.selectedColumn.setName(string2);
            if (this.rbDomain.isSelected()) {
                Object object = this.cbDatatype.getSelectedItem();
                if (object instanceof Domain) {
                    Domain domain = (Domain)object;
                    this.selectedColumn.setUse((short)0);
                    this.selectedColumn.setDomain(domain);
                    if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                        this.selectedColumn.setUseDomainConstraints(true);
                    }
                }
            } else if (this.rbLogical.isSelected()) {
                int n2;
                this.selectedColumn.setDataTypeParameter("size", "");
                this.selectedColumn.setDataTypeParameter("precision", "");
                this.selectedColumn.setDataTypeParameter("scale", "");
                this.selectedColumn.setUse((short)1);
                this.selectedColumn.setLogicalDatatype((LogicalDatatype)this.cbDatatype.getSelectedItem());
                Map map = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                String string3 = (String)map.get("precision_default_value");
                int n3 = string3 != "" && string3 != null ? new Integer((String)map.get("precision_default_value")) : 0;
                String string4 = (String)map.get("size_default_value");
                String string5 = (String)map.get("scale_default_value");
                int n4 = n2 = string5 != "" && string5 != null ? new Integer((String)map.get("scale_default_value")) : 0;
                if (this.sizeEnabled) {
                    String string6 = this.ifDTSize.getText();
                    if (!string6.equals("") && !string6.equals(string4)) {
                        if (this.cbUnits.getSelectedIndex() > 0) {
                            this.selectedColumn.setDataTypeParameter("size", string6 + ' ' + this.cbUnits.getSelectedItem());
                        } else {
                            this.selectedColumn.setDataTypeParameter("size", string6);
                        }
                    } else {
                        this.selectedColumn.setDataTypeParameter("size", "");
                        this.selectedColumn.setDataTypeParameter("precision", "");
                        this.selectedColumn.setDataTypeParameter("scale", "");
                    }
                } else if (this.precisionEnabled) {
                    this.selectedColumn.setDataTypeParameter("size", "");
                    if (this.ifDTPrecision.getIntValue() != n3 || this.ifDTScale.getIntValue() != n2) {
                        this.selectedColumn.setDataTypeParameter("precision", String.valueOf(this.ifDTPrecision.getIntValue()));
                        this.selectedColumn.setDataTypeParameter("scale", String.valueOf(this.ifDTScale.getIntValue()));
                    } else {
                        this.selectedColumn.setDataTypeParameter("precision", "");
                        this.selectedColumn.setDataTypeParameter("scale", "");
                    }
                }
            } else if (this.rbDistinct.isSelected()) {
                this.selectedColumn.setUse((short)2);
                this.selectedColumn.setDistinctType((DistinctType)this.cbDatatype.getSelectedItem());
            } else if (this.rbStructured.isSelected()) {
                this.selectedColumn.setUse((short)3);
                this.selectedColumn.setStructuredType((StructuredType)this.cbDatatype.getSelectedItem());
                this.selectedColumn.setReference(this.chbReference.isSelected());
            } else if (this.rbCollection.isSelected()) {
                this.selectedColumn.setUse((short)4);
                this.selectedColumn.setCollectionType((CollectionType)this.cbDatatype.getSelectedItem());
            }
            this.selectedColumn.setComment(this.taColumnComments.getText());
            this.selectedColumn.setCommentInRDBMS(this.taColumnCommentsInRDBMS.getText());
            this.selectedColumn.setNotes(this.taColumnNotes.getText());
            this.coTable.updateUI();
            this.tbColumns.updateUI();
        }
    }

    private void initSelectedColumnOptions(Column column, boolean bl) {
        if (bl && this.selectedColumn == column) {
            return;
        }
        if (bl) {
            this.setPreviousSelectedColumn();
        }
        this.selectedColumn = column;
        this.enableColumnOptions(this.isEditable(), 3);
        this.tfColumnName.setText(column.getName());
        short s = column.getUse();
        switch (s) {
            case 0: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(column.getDomain());
                break;
            }
            case 1: {
                this.rbLogical.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(column.getLogicalDatatype());
                try {
                    if (this.isEditable()) {
                        this.cbUnits.setEnabled(true);
                    }
                    String string = column.getSize();
                    String[] stringArray = string.split(INTERVAL_STRING);
                    this.ifDTSize.setText(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.cbUnits.setSelectedItem(stringArray[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.ifDTPrecision.setValue(Integer.parseInt(column.getPrecision()) > 0 ? Integer.valueOf(Integer.parseInt(column.getPrecision())) : null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.ifDTScale.setValue(Integer.parseInt(column.getScale()) != 0 ? Integer.valueOf(Integer.parseInt(column.getScale())) : null);
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                this.rbDistinct.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(column.getDistinctType());
                break;
            }
            case 3: {
                this.rbStructured.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(column.getStructuredType());
                this.chbReference.setSelected(column.isReference());
                break;
            }
            case 4: {
                this.rbCollection.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(column.getCollectionType());
                break;
            }
            default: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(column.getDomain());
            }
        }
        this.chbPK.setSelected(this.isPK(column));
        this.chbFK.setSelected(column.isFKElement());
        this.chbMandatory.setSelected(!column.getNullsAllowed());
        this.taColumnComments.setText(column.getComment());
        this.taColumnCommentsInRDBMS.setText(column.getCommentInRDBMS());
        this.taColumnNotes.setText(column.getNotes());
        this.disableFKColumnOptions(column);
        if (this.isPK(column) || column.isFKElement()) {
            this.chbMandatory.setEnabled(false);
        }
        this.coTable.updateUI();
        this.tfColumnName.selectAll();
        this.tfColumnName.requestFocus();
    }

    private boolean isPK(ContainedObject containedObject) {
        for (KeyObject keyObject : this.allIndexesList) {
            if (!keyObject.isPK() || !keyObject.contains(containedObject)) continue;
            return true;
        }
        return false;
    }

    private void enableColumnOptions(boolean bl, int n) {
        boolean bl2 = this.cbBaseOnStructuredType.getSelectedItem() != null;
        boolean bl3 = bl && !bl2;
        this.tfColumnName.setEnabled(bl3);
        this.rbDomain.setEnabled(bl3);
        this.rbLogical.setEnabled(bl3);
        if (n == 0) {
            this.rbStructured.setEnabled(bl3);
            this.rbDistinct.setEnabled(bl3);
            this.rbCollection.setEnabled(bl3);
        } else if (n == 1 || n == 2 || n == 3) {
            if (this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(bl3);
            } else {
                this.rbStructured.setEnabled(false);
            }
            if (this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(bl3);
            } else {
                this.rbDistinct.setEnabled(false);
            }
            if (this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(bl3);
            } else {
                this.rbCollection.setEnabled(false);
            }
            if (this.rbStructured.isSelected() && !this.rbStructured.isEnabled() || this.rbDistinct.isSelected() && !this.rbDistinct.isEnabled() || this.rbCollection.isSelected() && !this.rbCollection.isEnabled()) {
                this.rbDomain.setSelected(true);
            }
        }
        this.cbDatatype.setEnabled(bl3);
        this.ifDTSize.setEnabled(bl3);
        this.cbUnits.setEnabled(bl3);
        this.ifDTPrecision.setEnabled(bl3);
        this.ifDTScale.setEnabled(bl3);
        this.chbPK.setEnabled(bl3);
        this.chbMandatory.setEnabled(bl);
        this.taColumnComments.setEnabled(bl);
        this.taColumnCommentsInRDBMS.setEnabled(bl);
        this.taColumnNotes.setEnabled(bl);
        this.chbReference.setEnabled(bl);
        if (!bl) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.tfColumnName.setText("");
            this.ifDTSize.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.taColumnComments.setText("");
            this.taColumnCommentsInRDBMS.setText("");
            this.taColumnNotes.setText("");
        }
    }

    private void disableFKColumnOptions(Column column) {
        if (this.isEditable()) {
            boolean bl = !column.isFKElement();
            boolean bl2 = this.cbBaseOnStructuredType.getSelectedItem() != null;
            boolean bl3 = bl && !bl2;
            this.rbDomain.setEnabled(bl3);
            this.rbLogical.setEnabled(bl3);
            if (bl && this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(bl3);
            } else {
                this.rbStructured.setEnabled(false);
            }
            if (bl && this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(bl3);
            } else {
                this.rbDistinct.setEnabled(false);
            }
            if (bl && this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(bl3);
            } else {
                this.rbCollection.setEnabled(false);
            }
            this.cbDatatype.setEnabled(bl3);
            this.ifDTSize.setEnabled(bl3);
            this.cbUnits.setEnabled(bl3);
            this.ifDTPrecision.setEnabled(bl3);
            this.ifDTScale.setEnabled(bl3);
            this.chbMandatory.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDTComboBox() {
        block61: {
            block62: {
                block60: {
                    this.cbDatatype.removeAllItems();
                    this.pnDType.removeAll();
                    this.pnDType.updateUI();
                    if (!this.rbDomain.isSelected()) break block60;
                    Domain domain = null;
                    if (this.selectedColumn != null) {
                        domain = this.selectedColumn.getDomain();
                    }
                    if (domain == null) {
                        domain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> arrayList = new ArrayList<Domain>();
                        List list = this.getCurrentPreferredDomains();
                        arrayList.addAll(list);
                        if (list.size() > 0) {
                            for (Domain domain2 : list) {
                                if (domain == null) continue;
                                if (!domain2.getObjectID().equalsIgnoreCase(domain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(domain)) continue;
                                    this.additionalPreferredDomains.add(domain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(domain)) {
                                    this.additionalPreferredDomains.remove(domain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(domain)) {
                            this.additionalPreferredDomains.add(domain);
                        }
                        arrayList.addAll(this.additionalPreferredDomains);
                        for (Domain domain2 : arrayList) {
                            this.cbDatatype.addItem(domain2);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = domain2;
                            }
                            if (!((Object)domain2).toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = domain2;
                        }
                        this.cbDatatype.setSelectedItem(domain);
                        this.getAppView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator iterator = this.getDesignObject().getDesign().getDomainSet().iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.cbDatatype.addItem(e);
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        this.cbDatatype.setSelectedItem(domain);
                        this.getAppView().getSettings().setUsePreferredDomains(false);
                    }
                    break block61;
                }
                if (!this.rbLogical.isSelected()) break block62;
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                try {
                    String[] stringArray;
                    this.cbDatatype.removeActionListener(this.cbDatatypeActionListener);
                    this.selLogicalDatatype = null;
                    if (this.selectedColumn != null) {
                        this.selLogicalDatatype = this.selectedColumn.getLogicalDatatype();
                        string = this.selectedColumn.getDataTypeParameter("size");
                        string2 = this.selectedColumn.getDataTypeParameter("precision");
                        string3 = this.selectedColumn.getDataTypeParameter("scale");
                        stringArray = string.split(INTERVAL_STRING);
                        if (stringArray.length == 2) {
                            string = stringArray[0];
                            string4 = stringArray[1];
                        }
                    }
                    if (this.initialUseLogicalTypePreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                        this.initialUseLogicalTypePreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        stringArray = new ArrayList();
                        List list = this.getCurrentPreferredLogicalDatatypes();
                        stringArray.addAll(list);
                        if (list.size() > 0) {
                            for (LogicalDatatype logicalDatatype : list) {
                                if (this.selLogicalDatatype == null) continue;
                                if (!logicalDatatype.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                    this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                    continue;
                                }
                                if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                    this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                            this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                        }
                        stringArray.addAll(this.additionalPreferredLogicalTypes);
                        for (Object e : stringArray) {
                            this.cbDatatype.addItem(e);
                            if (this.logicalDefaultDataType == null) {
                                this.logicalDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
                    } else {
                        stringArray = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                        while (stringArray.hasNext()) {
                            Object e = stringArray.next();
                            this.cbDatatype.addItem(e);
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
                    }
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                }
                catch (Throwable throwable) {
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(string != null && string != "" ? string : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue((long)Integer.parseInt(string2 != null && string2 != "" ? string2 : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue((long)Integer.parseInt(string3 != null && string3 != "" ? string3 : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(string4);
                    }
                    throw throwable;
                }
                if (this.ifDTSize.isEnabled()) {
                    try {
                        this.ifDTSize.setText(string != null && string != "" ? string : null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTPrecision.isEnabled()) {
                    try {
                        this.ifDTPrecision.setValue((long)Integer.parseInt(string2 != null && string2 != "" ? string2 : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTScale.isEnabled()) {
                    try {
                        this.ifDTScale.setValue((long)Integer.parseInt(string3 != null && string3 != "" ? string3 : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.cbUnits.isEnabled()) {
                    this.cbUnits.setSelectedItem(string4);
                }
                break block61;
            }
            if (this.rbDistinct.isSelected()) {
                Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbDatatype.addItem(iterator.next());
                }
            } else if (this.rbStructured.isSelected()) {
                Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbDatatype.addItem(iterator.next());
                }
                this.pnDType.add(this.pnRef);
                this.chbReference.setSelected(false);
            } else if (this.rbCollection.isSelected()) {
                Iterator iterator = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                while (iterator.hasNext()) {
                    this.cbDatatype.addItem(iterator.next());
                }
            }
        }
        this.cbDatatype.updateUI();
    }

    private void deleteColumn(JTable jTable) {
        this.deleteTableRow(this.coTable, this.columnsList);
        this.tbColumns.clearSelection();
        this.tbColumns.updateUI();
        this.coTable.clearSelection();
        this.coTable.updateUI();
        this.selectedColumn = null;
        this.enableColumnOptions(this.columnsList.size() > 0 && this.coTable.getSelectedRow() > 0, 2);
        this.initSelectedFKOptions();
    }

    private void showColumnPropertiesDialog() {
        int n = this.coTable.getSelectedRow();
        if (n != -1) {
            Column column;
            this.setPreviousSelectedColumn();
            if (this.columnsList.size() > 0 && n < this.columnsList.size() && !(column = this.columnsList.get(n)).isDialogVisible()) {
                column.showModal = true;
                ColumnPropertiesDialogEx columnPropertiesDialogEx = new ColumnPropertiesDialogEx((Dialog)this, this.getAppView(), column, this.chbUsePreferredList.isSelected());
                columnPropertiesDialogEx.initProperties(column);
                columnPropertiesDialogEx.show();
                if (this.selectedColumn != null) {
                    this.initSelectedColumnOptions(this.selectedColumn, false);
                }
            }
        }
    }

    private void addColumn(ActionEvent actionEvent) {
        boolean bl = false;
        boolean bl2 = false;
        if (actionEvent != null) {
            bl = (actionEvent.getModifiers() & 1) == 1;
            bl2 = (actionEvent.getModifiers() & 2) == 2;
        }
        int n = this.coTable.getSelectedRow();
        int n2 = this.columnsList.size();
        Column column = new Column(this.table.getDesignPart());
        column.setObjectID(new GUID().toString());
        column.setName(this.generateColumnName());
        column.setDesign(this.table.getDesign());
        column.setContainer(this.table);
        column.setDesignObjectSet(this.table.getColumnSet());
        int n3 = n2;
        if (n > -1) {
            if (bl) {
                if (n2 == 0) {
                    this.columnsList.add(column);
                } else {
                    this.columnsList.add(n, column);
                    n3 = n;
                }
            } else if (bl2) {
                if (n2 == 0 || n2 - 1 == n) {
                    this.columnsList.add(column);
                } else {
                    this.columnsList.add(n + 1, column);
                    n3 = n + 1;
                }
            } else {
                this.columnsList.add(column);
            }
        } else {
            this.columnsList.add(column);
        }
        this.tbColumns.updateUI();
        this.tbColumnsSecurity.updateUI();
        this.coTable.updateUI();
        this.tbColumns.changeSelection(n3, 1, false, false);
        this.tbColumnsSecurity.changeSelection(n3, 1, false, false);
        this.coTable.changeSelection(n3, 1, false, false);
        this.initSelectedColumnOptions(column, true);
        Enumeration<AbstractButton> enumeration = this.datatypeGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().trim().equalsIgnoreCase(this.storedColumnDefaultDatatype)) continue;
            jRadioButton.setSelected(true);
            this.updateDTComboBox();
            this.setDefaultDatatype();
        }
        this.enableColumnOptions(true, 1);
        this.alteredColumnList.add(column);
    }

    private void setDefaultDatatype() {
        if (this.rbDomain.isSelected()) {
            this.cbDatatype.setSelectedItem(this.domainDefaultDataType);
        } else if (this.rbLogical.isSelected()) {
            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
        }
    }

    private void coCopyColumns() {
        this.getAppView().clearCopiedObjects();
        int[] nArray = this.coTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= -1 || n >= this.columnsList.size()) continue;
            this.getAppView().addCopiedObject(this.columnsList.get(n));
        }
        this.bnCOPaste.setEnabled(this.getAppView().getCopiedObjects().size() > 0);
    }

    private void coPasteColumns() {
        List list = this.getAppView().getCopiedObjects();
        for (Object e : list) {
            if (!(e instanceof Column)) continue;
            Column column = (Column)e;
            Column column2 = new Column(this.table.getDesignPart());
            column2.setName(this.generatePastedColumnName(column.getName()));
            String string = column2.getName();
            column2.setDesign(this.table.getDesign());
            column2.setContainer(this.table);
            column2.setDesignObjectSet(this.table.getColumnSet());
            column.copy(column2);
            column2.setName(string);
            this.columnsList.add(column2);
            this.alteredColumnList.add(column2);
        }
        if (list.size() > 0) {
            this.coTable.updateUI();
            this.tbColumns.updateUI();
            this.tbColumns.changeSelection(this.columnsList.size() - 1, 1, false, false);
            this.coTable.changeSelection(this.columnsList.size() - 1, 1, false, false);
        }
    }

    protected String generateColumnName() {
        String string = "Column";
        int n = 0;
        int n2 = this.columnsList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.columnExists(string2)) {
            n = ++this.counter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    protected String generatePastedColumnName(String string) {
        void var4_6;
        if (!this.columnExists(string)) {
            return string;
        }
        int n = 0;
        for (Column object2 : this.columnsList) {
            String string2 = object2.getName();
            if (string2.indexOf(string) < 0) continue;
            ++n;
        }
        String string3 = string.concat("_").concat(Integer.toString(n));
        while (this.columnExists((String)var4_6)) {
            String string4 = string.concat("_").concat(Integer.toString(++n));
        }
        return var4_6;
    }

    private boolean columnExists(String string) {
        for (int i = 0; i < this.columnsList.size(); ++i) {
            Column column = this.columnsList.get(i);
            if (!string.equalsIgnoreCase(column.getName())) continue;
            return true;
        }
        return false;
    }

    protected JPanel getForeignKeysPanel() {
        if (this.pnForeignKeys == null) {
            this.pnForeignKeys = this.createPage(FOREIGN_KEY_TAB_NAME);
            this.fkList = new ArrayList<FKIndexAssociation.FKMemento>();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.createFKContentsPanel(), "Center");
            jPanel.add((Component)this.createFKToolbarPanel(), "North");
            this.pnForeignKeys.add(jPanel);
        }
        return this.pnForeignKeys;
    }

    private JPanel createFKToolbarPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnFKProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        this.btnFKProperties.setToolTipText(BTN_PROPERTIES);
        this.btnFKProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.saveSelectedFKProperties();
                TablePropertiesDialogEx.this.showFKPropertiesDialog();
            }
        });
        this.btnFKProperties.setEnabled(false);
        if (this.isEditable()) {
            this.tbForeignKeys.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    TablePropertiesDialogEx.this.changeFKButtonsStatus();
                }
            });
        }
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.addFKColumn(actionEvent);
            }
        });
        this.btnFKRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.btnFKRemove.setToolTipText(BTN_REMOVE);
        this.btnFKRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.removeFKColumn();
            }
        });
        this.btnFKRemove.setEnabled(false);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(this.btnFKProperties);
        if (this.isEditable()) {
            jToolBar.addSeparator();
            jToolBar.add(jButton);
            jToolBar.add(this.btnFKRemove);
        }
        jPanel.add(jToolBar);
        return jPanel;
    }

    private void addFKColumn(ActionEvent actionEvent) {
        TablePropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        FKIndexAssociation fKIndexAssociation = new FKIndexAssociation(this.table);
        fKIndexAssociation.setName(FKUtilities.generateFKName(this.oldTable, null, this.fkList));
        FKIndexAssociation.FKMemento fKMemento = fKIndexAssociation.getFKMemento(null);
        this.fkList.add(fKMemento);
        this.fkListForCreate.add(fKMemento);
        this.tbForeignKeys.updateUI();
        this.tbForeignKeys.changeSelection(this.fkList.size() - 1, 1, false, false);
        this.tbForeignKeys.requestFocus();
        this.dirtyMementos.add(fKMemento);
    }

    private void removeFKColumn() {
        FKIndexAssociation.FKMemento fKMemento = this.fkList.get(this.tbForeignKeys.getSelectedRow());
        if (!this.fkListForCreate.remove(fKMemento)) {
            this.fkListForRemove.add(fKMemento);
        }
        this.fkList.remove(this.tbForeignKeys.getSelectedRow());
        this.dirtyMementos.remove(fKMemento);
        fKMemento = null;
        this.tbForeignKeys.clearSelection();
        this.tbForeignKeys.updateUI();
        this.setFKPropertiesEnabled(false);
    }

    private void deleteTableRow(JTable jTable, List list) {
        Column column;
        TablePropertiesDialogEx.stopCellEditing(jTable);
        int[] nArray = jTable.getSelectedRows();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == -1 || list.size() <= 0 || n >= list.size() || (column = list.get(n)) instanceof Column && column.isFKColumn()) continue;
            arrayList.add(column);
        }
        for (Object e : arrayList) {
            column = (Column)e;
            list.remove(column);
            this.primaryKeyColumnsPanel.removeSelectedColumn(column);
            this.uniqueKeysColumnsPanel.removeSelectedColumn(column);
            this.indexExpressionPanel.getIndexColumnsPanel().removeSelectedColumn(column);
            this.initSelectedFKOptions();
            this.tbForeignKeys.updateUI();
        }
    }

    private void changeFKButtonsStatus() {
        int n = this.tbForeignKeys.getSelectedRow();
        boolean bl = n < this.fkList.size() && n != -1;
        this.btnFKProperties.setEnabled(bl);
        this.btnFKRemove.setEnabled(bl);
    }

    private JPanel createFKContentsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)this.createFKTopPanel(), "North");
        jPanel2.add((Component)this.createFKBottomPanel(), "Center");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel createFKTopPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)this.createFKNamesTable(), "North");
        jPanel.add((Component)this.createFKPropertiesPanel(), "Center");
        return jPanel;
    }

    private JPanel createFKPropertiesPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        this.cbReferencedTable = new JComboBox();
        this.cbReferencedTable.setPreferredSize(this.getDefaultSize());
        this.cbReferencedTable.setMaximumRowCount(8);
        this.cbReferencedTable.setEnabled(false);
        this.cbReferencedTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Table table = (Table)TablePropertiesDialogEx.this.cbReferencedTable.getSelectedItem();
                if (table != null) {
                    List list = table.getPKandUKConstraints();
                    if (list != null) {
                        TablePropertiesDialogEx.this.fillComboItems(list.toArray(), TablePropertiesDialogEx.this.cbReferencedConstraint, false);
                    } else {
                        TablePropertiesDialogEx.this.cbReferencedConstraint.removeAllItems();
                    }
                    if (!TablePropertiesDialogEx.this.initializingSelectedFK && TablePropertiesDialogEx.this.selectedFK != null) {
                        TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbForeignKeys);
                        ((TablePropertiesDialogEx)TablePropertiesDialogEx.this).selectedFK.name = FKUtilities.generateFKName(TablePropertiesDialogEx.this.table, table, TablePropertiesDialogEx.this.fkList);
                        TablePropertiesDialogEx.this.fkModel.fireTableCellUpdated(TablePropertiesDialogEx.this.tbForeignKeys.getSelectedRow(), 1);
                    }
                } else {
                    TablePropertiesDialogEx.this.cbReferencedConstraint.removeAllItems();
                    TablePropertiesDialogEx.this.cbReferencedConstraint.setSelectedItem(null);
                    if (!TablePropertiesDialogEx.this.initializingSelectedFK && TablePropertiesDialogEx.this.selectedFK != null) {
                        TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbForeignKeys);
                        ((TablePropertiesDialogEx)TablePropertiesDialogEx.this).selectedFK.name = FKUtilities.generateFKName(TablePropertiesDialogEx.this.table, null, TablePropertiesDialogEx.this.fkList);
                        TablePropertiesDialogEx.this.fkModel.fireTableCellUpdated(TablePropertiesDialogEx.this.tbForeignKeys.getSelectedRow(), 1);
                    }
                }
                if (!TablePropertiesDialogEx.this.initializingSelectedFK) {
                    TablePropertiesDialogEx.this.saveSelectedFKProperties();
                    TablePropertiesDialogEx.this.dirtyMementos.add(TablePropertiesDialogEx.this.selectedFK);
                }
            }
        });
        this.addRowToPanel(jPanel, Messages.getString("TablePropertiesDialogEx.ReferencedTable"), this.cbReferencedTable);
        this.cbReferencedConstraint = new JComboBox();
        this.cbReferencedConstraint.setPreferredSize(this.getDefaultSize());
        this.cbReferencedConstraint.setMaximumRowCount(8);
        this.cbReferencedConstraint.setEnabled(false);
        this.cbReferencedConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TablePropertiesDialogEx.this.initializingSelectedFK) {
                    TablePropertiesDialogEx.this.refreshFKColumnsTableData();
                    TablePropertiesDialogEx.this.dirtyMementos.add(TablePropertiesDialogEx.this.selectedFK);
                }
            }
        });
        this.cbReferencedConstraint.setRenderer(new IndexesCellRenderer());
        this.addRowToPanel(jPanel, Messages.getString("TablePropertiesDialogEx.ReferencedConstraint"), this.cbReferencedConstraint);
        jPanel.add(this.createCheckboxesPanel());
        return jPanel;
    }

    private void refreshFKColumnsTableData() {
        Column[] columnArray = null;
        Index index = (Index)this.cbReferencedConstraint.getSelectedItem();
        if (index != null) {
            columnArray = new Column[index.getElements().length];
        }
        this.fkColumnsTableModel.init(columnArray, index);
        this.fkColumnsCellEditor.init(columnArray, index);
        this.fkColumnsTableModel.fireTableDataChanged();
    }

    private JPanel createCheckboxesPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 10, 10));
        this.chFKMandatory = new JCheckBox();
        this.chFKMandatory.setPreferredSize(this.getDefaultSize());
        this.chFKMandatory.setEnabled(false);
        this.chFKMandatory.setText(Messages.getString("TablePropertiesDialogEx.Mandatory"));
        this.chFKMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.stealthChange = true;
            }
        });
        jPanel.add(this.chFKMandatory);
        this.chFKTransferable = new JCheckBox();
        this.chFKTransferable.setPreferredSize(this.getDefaultSize());
        this.chFKTransferable.setEnabled(false);
        this.chFKTransferable.setText(Messages.getString("TablePropertiesDialogEx.Transferable"));
        this.chFKTransferable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.stealthChange = true;
            }
        });
        jPanel.add(this.chFKTransferable);
        this.chFKInArc = new JCheckBox();
        this.chFKInArc.setPreferredSize(this.getDefaultSize());
        this.chFKInArc.setEnabled(false);
        this.chFKInArc.setText(Messages.getString("TablePropertiesDialogEx.InArc"));
        this.chFKInArc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.stealthChange = true;
            }
        });
        jPanel.add(this.chFKInArc);
        return jPanel;
    }

    private JScrollPane createFKNamesTable() {
        this.fkModel = new FKTableModel(this.fkList);
        this.tbForeignKeys = new ForeignKeyTable(this.fkModel);
        this.tbForeignKeys.setSelectionMode(0);
        if (!this.isEditable()) {
            this.tbForeignKeys.setEnabled(false);
        }
        TableColumn tableColumn = this.tbForeignKeys.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn = this.tbForeignKeys.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new TFCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.tbForeignKeys.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.tbForeignKeys.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(new FKDeleteRuleCB());
        tableColumn.setPreferredWidth(100);
        tableColumn = this.tbForeignKeys.getColumnModel().getColumn(4);
        tableColumn.setCellEditor(new StealthCBCellEditor());
        tableColumn.setPreferredWidth(40);
        this.tbForeignKeys.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && TablePropertiesDialogEx.this.btnFKProperties.isEnabled()) {
                    TablePropertiesDialogEx.this.showFKPropertiesDialog();
                }
            }
        });
        this.tbForeignKeys.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (!TablePropertiesDialogEx.this.fkPropertiesEnabled) {
                        if (TablePropertiesDialogEx.this.isEditable()) {
                            TablePropertiesDialogEx.this.setFKPropertiesEnabled(true);
                        } else {
                            TablePropertiesDialogEx.this.setFKPropertiesEnabled(false);
                            TablePropertiesDialogEx.this.fillComboItems(((RelationalDesign)TablePropertiesDialogEx.this.getDesignObject().getDesignPart()).getTableSet().toArray(), TablePropertiesDialogEx.this.cbReferencedTable, true);
                        }
                    }
                    TablePropertiesDialogEx.this.saveSelectedFKProperties();
                    TablePropertiesDialogEx.this.fkModel.fireTableCellUpdated(listSelectionEvent.getFirstIndex(), 2);
                    TablePropertiesDialogEx.this.fkModel.fireTableCellUpdated(listSelectionEvent.getLastIndex(), 2);
                    TablePropertiesDialogEx.this.selectedFK = TablePropertiesDialogEx.this.initSelectedFKOptions();
                }
            }
        });
        this.fkColumnsTableModel = new FKColumnsTableModel();
        this.tbForeignKeys.setPreferredScrollableViewportSize(new Dimension(500, 80));
        JScrollPane jScrollPane = new JScrollPane(this.tbForeignKeys);
        return jScrollPane;
    }

    private void setFKPropertiesEnabled(boolean bl) {
        this.cbReferencedTable.setEnabled(bl);
        this.cbReferencedConstraint.setEnabled(bl);
        this.chFKMandatory.setEnabled(bl);
        this.chFKTransferable.setEnabled(bl);
        this.taFKComments.setEnabled(bl);
        this.taFKNotes.setEnabled(bl);
        if (bl) {
            this.fillComboItems(((RelationalDesign)this.getDesignObject().getDesignPart()).getTableSet().toArray(), this.cbReferencedTable, true);
        } else {
            this.cbReferencedTable.setSelectedItem(null);
        }
        this.fkPropertiesEnabled = bl;
    }

    private void showFKPropertiesDialog() {
        if (!this.dirtyMementos.contains(this.selectedFK)) {
            int n = this.tbForeignKeys.getSelectedRow();
            if (n != -1 && !this.fkList.isEmpty() && n < this.fkList.size()) {
                TablePropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
                FKIndexAssociation.FKMemento fKMemento = this.fkList.get(n);
                FKIndexAssociation fKIndexAssociation = fKMemento.fk;
                if (!fKIndexAssociation.isDialogVisible()) {
                    fKIndexAssociation.showModal = this.table.showModal;
                    if (fKIndexAssociation.showPropertyDialog(fKMemento, this)) {
                        this.tbForeignKeys.updateUI();
                        this.initSelectedFKOptions();
                    }
                }
            }
        } else {
            String string = FKUtilities.containsEmptyColumns(this.selectedFK) ? "TablePropertiesDialogEx.IncompleteFKdefinition" : "TablePropertiesDialogEx.FKModified";
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), FKUtilities.formatMessage(string, this.selectedFK.name), FKUtilities.formatMessage("TablePropertiesDialogEx.FKColumnsAssignment", this.selectedFK.name), 0);
        }
    }

    private void saveSelectedFKProperties() {
        if (this.selectedFK != null) {
            Index index;
            this.selectedFK.remoteTable = (Table)this.cbReferencedTable.getSelectedItem();
            this.selectedFK.remoteKey = index = (Index)this.cbReferencedConstraint.getSelectedItem();
            if (index != null) {
                this.selectedFK.remoteKeyID = index.getObjectID();
            }
            this.selectedFK.columns.clear();
            Column[] columnArray = this.fkColumnsTableModel.getFkColumns();
            if (columnArray != null) {
                for (int i = 0; i < columnArray.length; ++i) {
                    this.selectedFK.columns.add(columnArray[i] != null ? columnArray[i].getObjectID() : null);
                }
            }
            this.selectedFK.mandatory = this.chFKMandatory.isSelected();
            this.selectedFK.transferable = this.chFKTransferable.isSelected();
            this.selectedFK.notes = this.taFKNotes.getText();
            this.selectedFK.comments = this.taFKComments.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKIndexAssociation.FKMemento initSelectedFKOptions() {
        try {
            this.initializingSelectedFK = true;
            int n = this.tbForeignKeys.getSelectedRow();
            if (n != -1 && this.fkList.size() > 0 && n < this.fkList.size()) {
                Object object;
                FKIndexAssociation.FKMemento fKMemento = this.fkList.get(n);
                Index index = fKMemento.remoteKey;
                Table table = fKMemento.remoteTable;
                if (table != null) {
                    object = FKUtilities.getFKColumns(fKMemento, this.columnsList);
                    this.fkColumnsTableModel.init((Column[])object, index);
                    this.fkColumnsCellEditor.init((Column[])object, index);
                    this.fkColumnsTableModel.fireTableDataChanged();
                } else {
                    this.fkColumnsTableModel.init(null, null);
                    this.fkColumnsCellEditor.init(null, null);
                    this.fkColumnsTableModel.fireTableDataChanged();
                }
                this.cbReferencedTable.setSelectedItem(table);
                this.cbReferencedConstraint.setSelectedItem(index);
                this.chFKMandatory.setSelected(fKMemento.mandatory);
                this.chFKTransferable.setSelected(fKMemento.transferable);
                this.chFKInArc.setSelected(fKMemento.arc != null);
                this.taFKNotes.setText(fKMemento.notes);
                this.taFKComments.setText(fKMemento.comments);
                object = fKMemento;
                return object;
            }
            FKIndexAssociation.FKMemento fKMemento = null;
            return fKMemento;
        }
        finally {
            this.initializingSelectedFK = false;
        }
    }

    private JPanel createFKBottomPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        this.fkColumnsTableModel = new FKColumnsTableModel();
        this.tbForeignKeyColumnsTable = new JTable(this.fkColumnsTableModel);
        if (!this.isEditable()) {
            this.tbForeignKeyColumnsTable.setEnabled(false);
        }
        this.fkColumnsCellEditor = new FKColumnsCellEditor(this.columnsList){

            @Override
            public void onSelectedColumnChanged(Column column) {
                column.setNullsAllowed(!((TablePropertiesDialogEx)TablePropertiesDialogEx.this).selectedFK.mandatory);
                if (column == TablePropertiesDialogEx.this.selectedColumn) {
                    TablePropertiesDialogEx.this.setPreviousSelectedColumn();
                    TablePropertiesDialogEx.this.initSelectedColumnOptions(column, false);
                }
            }
        };
        JComboBox jComboBox = (JComboBox)this.fkColumnsCellEditor.getComponent();
        jComboBox.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbForeignKeyColumnsTable);
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TablePropertiesDialogEx.this.initializingSelectedFK) {
                    TablePropertiesDialogEx.this.dirtyMementos.add(TablePropertiesDialogEx.this.selectedFK);
                }
            }
        });
        this.tbForeignKeyColumnsTable.getColumnModel().getColumn(1).setCellEditor(this.fkColumnsCellEditor);
        this.tbForeignKeyColumnsTable.setPreferredScrollableViewportSize(new Dimension(80, 80));
        jPanel.add(new JScrollPane(this.tbForeignKeyColumnsTable));
        this.taFKComments = new JTextArea();
        this.taFKComments.addFocusListener(new FocusListener(){
            String oldComments = "";

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.oldComments = TablePropertiesDialogEx.this.taFKComments.getText();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!this.oldComments.equals(TablePropertiesDialogEx.this.taFKComments.getText())) {
                    TablePropertiesDialogEx.this.stealthChange = true;
                }
            }
        });
        this.taFKNotes = new JTextArea();
        this.taFKNotes.addFocusListener(new FocusListener(){
            String oldNotes = "";

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.oldNotes = TablePropertiesDialogEx.this.taFKNotes.getText();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!this.oldNotes.equals(TablePropertiesDialogEx.this.taFKNotes.getText())) {
                    TablePropertiesDialogEx.this.stealthChange = true;
                }
            }
        });
        jPanel.add(this.createNotesCommentsTabbedPane(this.taFKNotes, this.taFKComments, null));
        return jPanel;
    }

    protected JTabbedPane createNotesCommentsTabbedPane(JTextArea jTextArea, JTextArea jTextArea2, JTextArea jTextArea3) {
        return this.createNotesCommentsTabbedPane(jTextArea, jTextArea2, jTextArea3, false);
    }

    protected JTabbedPane createNotesCommentsTabbedPane(JTextArea jTextArea, JTextArea jTextArea2, JTextArea jTextArea3, boolean bl) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (jTextArea != null) {
            jTextArea.setEnabled(bl);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTabbedPane.addTab(Messages.getString("TablePropertiesDialogEx.Notes"), new JScrollPane(jTextArea));
        }
        if (jTextArea2 != null) {
            jTextArea2.setEnabled(bl);
            jTextArea2.setLineWrap(true);
            jTextArea2.setWrapStyleWord(true);
            jTabbedPane.addTab(Messages.getString("TablePropertiesDialogEx.Comments"), new JScrollPane(jTextArea2));
        }
        if (jTextArea3 != null) {
            jTextArea3.setEnabled(bl);
            jTextArea3.setLineWrap(true);
            jTextArea3.setWrapStyleWord(true);
            jTabbedPane.addTab(Messages.getString("TablePropertiesDialogEx.CommentsInRDBMS"), new JScrollPane(jTextArea3));
        }
        return jTabbedPane;
    }

    protected JPanel getPrimaryKeyPanel() {
        if (this.pnPrimaryKey == null) {
            this.pnPrimaryKey = this.createPage(PRIMARY_KEY_TAB_NAME);
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.add(this.createPrimaryKeyContentsPanel());
            jPanel.add((Component)this.createPrimaryKeyToolbarPanel(this.primaryKey), "North");
            this.pnPrimaryKey.add(jPanel);
        }
        return this.pnPrimaryKey;
    }

    private JPanel createPrimaryKeyContentsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k.RDBMS_TYPE || this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k5.RDBMS_TYPE;
        this.primaryKeyColumnsPanel = new PKColumnsPanel((Index)((Table)this.getDesignObject()).getPK(), this.isEditable(), this.getPreferredIconSize(), bl){

            @Override
            public void onAddColumn(Column column) {
                String string = TablePropertiesDialogEx.this.table.getName();
                String string2 = TablePropertiesDialogEx.this.table.getAbbreviation();
                String string3 = TablePropertiesDialogEx.this.tfPrimaryKeyName.getText();
                if (TablePropertiesDialogEx.this.primaryKey == null) {
                    if (StringUtilities.isNotEmpty(string3)) {
                        TablePropertiesDialogEx.this.primaryKey = TablePropertiesDialogEx.this.createAndAddIndex(AbstractEditorConstants.PRIMARY_CONSTRAINT, string3);
                    } else {
                        TablePropertiesDialogEx.this.primaryKey = TablePropertiesDialogEx.this.createAndAddIndex(AbstractEditorConstants.PRIMARY_CONSTRAINT, string, string2);
                        TablePropertiesDialogEx.this.tfPrimaryKeyName.setText(TablePropertiesDialogEx.this.primaryKey.getName());
                    }
                }
                TablePropertiesDialogEx.this.updatePKStatus(column, true, string, string2, TablePropertiesDialogEx.this.primaryKey.getName());
            }

            @Override
            public void onRemoveColumn(Column column) {
                TablePropertiesDialogEx.this.updatePKStatus(column, false, TablePropertiesDialogEx.this.table.getName(), TablePropertiesDialogEx.this.table.getAbbreviation(), null);
            }
        };
        jPanel.add((Component)this.primaryKeyColumnsPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        this.chPrimaryKeyEngineer = new JCheckBox();
        this.chPrimaryKeyEngineer.setPreferredSize(this.getDefaultSize());
        this.chPrimaryKeyEngineer.setText(Messages.getString("TablePropertiesDialogEx.Engineer"));
        this.chPrimaryKeyEngineer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.stealthChange = true;
            }
        });
        jPanel2.add((Component)this.chPrimaryKeyEngineer, "West");
        this.chPrimaryKeyGenerate = new JCheckBox();
        this.chPrimaryKeyGenerate.setPreferredSize(this.getDefaultSize());
        this.chPrimaryKeyGenerate.setText(Messages.getString("TablePropertiesDialogEx.Generate"));
        this.chPrimaryKeyGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.stealthChange = true;
            }
        });
        jPanel2.add(this.chPrimaryKeyGenerate);
        this.taPrimaryKeyNotes = new JTextArea();
        this.taPrimaryKeyComments = new JTextArea();
        this.taPrimaryKeyCommentsInRDBMS = new JTextArea();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(this.createNotesCommentsTabbedPane(this.taPrimaryKeyNotes, this.taPrimaryKeyComments, this.taPrimaryKeyCommentsInRDBMS, true));
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.tfPrimaryKeyName = new JTextField();
        this.tfPrimaryKeyName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TablePropertiesDialogEx.this.primaryKey != null) {
                    TablePropertiesDialogEx.this.primaryKey.setName(TablePropertiesDialogEx.this.tfPrimaryKeyName.getText());
                }
            }
        });
        this.addRowToPanel(jPanel4, NAME, this.tfPrimaryKeyName, null, "North");
        jPanel4.add(jPanel);
        return jPanel4;
    }

    protected JPanel getUniqueKeysPanel() {
        if (this.pnUniqueKeys == null) {
            this.uniqueKeys = new ArrayList<Index>();
            this.tbUniqueKeys = new IndexesTable(new UniqueKeysTableModel(this.uniqueKeys, (Component)Ide.getMainWindow())){

                @Override
                public void onDeleteKeyPressed() {
                    TablePropertiesDialogEx.this.deleteSelectedIndex(AbstractEditorConstants.UNIQUE_CONSTRAINT);
                }

                @Override
                public void onSelectionChanged() {
                    TablePropertiesDialogEx.this.saveSelectedUniqueKeyProperties();
                    TablePropertiesDialogEx.this.initSelectedUniqueKeyProperties();
                }
            };
            TableColumn tableColumn = this.tbUniqueKeys.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            tableColumn = this.tbUniqueKeys.getColumnModel().getColumn(2);
            tableColumn.setCellEditor(new StealthCBCellEditor());
            tableColumn.setPreferredWidth(40);
            tableColumn = this.tbUniqueKeys.getColumnModel().getColumn(3);
            tableColumn.setCellEditor(new StealthCBCellEditor());
            tableColumn.setPreferredWidth(40);
            this.pnUniqueKeys = this.createPage(UNIQUE_KEYS_TAB_NAME);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.createUKContentsPanel());
            jPanel.add((Component)this.createIndexToolbarPanel(UNIQUE_CONSTRAINT, this.uniqueKeys, this.tbUniqueKeys), "North");
            this.pnUniqueKeys.add(jPanel);
        }
        return this.pnUniqueKeys;
    }

    private JPanel createUKContentsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k.RDBMS_TYPE || this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k5.RDBMS_TYPE;
        this.uniqueKeysColumnsPanel = new UKColumnsPanel(null, this.isEditable(), this.getPreferredIconSize(), bl);
        jPanel.add((Component)this.uniqueKeysColumnsPanel, "North");
        this.taUniqueKeyNotes = new JTextArea();
        this.taUniqueKeyComments = new JTextArea();
        this.taUniqueKeyCommentsInRDBMS = new JTextArea();
        jPanel.add(this.createNotesCommentsTabbedPane(this.taUniqueKeyNotes, this.taUniqueKeyComments, this.taUniqueKeyCommentsInRDBMS));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JScrollPane(this.tbUniqueKeys), "North");
        jPanel2.add(jPanel);
        return jPanel2;
    }

    protected JPanel getIndexesPanel() {
        if (this.pnIndexes == null) {
            this.allIndexesList = new ArrayList<Index>();
            this.indexKeys = new ArrayList<Index>();
            this.foreignKeys = new ArrayList<Index>();
            this.tbIndexKeys = new IndexesTable(new IndexesTableModel(this.indexKeys, (Component)Ide.getMainWindow())){

                @Override
                public void onDeleteKeyPressed() {
                    TablePropertiesDialogEx.this.deleteSelectedIndex(AbstractEditorConstants.PLAIN_INDEX);
                }

                @Override
                public void onSelectionChanged() {
                    TablePropertiesDialogEx.this.saveSelectedIndexKeyProperties();
                    TablePropertiesDialogEx.this.initSelectedIndexKeyProperties();
                }
            };
            TableColumn tableColumn = this.tbIndexKeys.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(200);
            tableColumn = this.tbIndexKeys.getColumnModel().getColumn(2);
            tableColumn.setCellEditor(new StealthCBCellEditor());
            tableColumn.setPreferredWidth(60);
            tableColumn = this.tbIndexKeys.getColumnModel().getColumn(3);
            tableColumn.setCellEditor(new StealthCBCellEditor());
            tableColumn.setPreferredWidth(60);
            tableColumn = this.tbIndexKeys.getColumnModel().getColumn(4);
            tableColumn.setCellEditor(new StealthCBCellEditor());
            tableColumn.setPreferredWidth(80);
            tableColumn = this.tbIndexKeys.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(60);
            this.pnIndexes = this.createPage(INDEX_KEYS_TAB_NAME);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.createIXContentsPanel());
            jPanel.add((Component)this.createIndexToolbarPanel(PLAIN_INDEX, this.indexKeys, this.tbIndexKeys), "North");
            this.pnIndexes.add(jPanel);
        }
        return this.pnIndexes;
    }

    protected JPanel createIndexToolbarPanel(final String string, final List<Index> list, final JTable jTable) {
        Object object;
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        jButton.setToolTipText(BTN_PROPERTIES);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.showIndexPropertiesDialog(string);
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            object = new MoveUpDownListJTable(list, jTable);
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_ADD);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TablePropertiesDialogEx.this.createAndAddIndex(string, TablePropertiesDialogEx.this.tfName.getText(), TablePropertiesDialogEx.this.tfAbbreviation.getText());
                }
            });
            final JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton3.setToolTipText(BTN_REMOVE);
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TablePropertiesDialogEx.this.deleteSelectedIndex(string);
                    jButton3.setEnabled(false);
                }
            });
            JButton jButton4 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            jButton4.setToolTipText(BTN_MOVE_UP);
            jButton4.addActionListener(new MoveUpDownListJTable.MoveUpAction((MoveUpDownListJTable)object));
            JButton jButton5 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            jButton5.setToolTipText(BTN_MOVE_DOWN);
            jButton5.addActionListener(new MoveUpDownListJTable.MoveDownAction((MoveUpDownListJTable)object));
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (list.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        int n = jTable.getSelectedRow();
                        if (n > -1 && n < list.size()) {
                            KeyObject keyObject = (KeyObject)list.get(n);
                            if (keyObject.isOidKey()) {
                                jButton3.setEnabled(false);
                                jButton.setEnabled(false);
                            } else {
                                jButton3.setEnabled(true);
                                jButton.setEnabled(true);
                            }
                        }
                    }
                }
            });
            jTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (list.isEmpty()) {
                        jButton3.setEnabled(false);
                        jButton.setEnabled(false);
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setEnabled(true);
                    }
                }
            });
            jTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Index index;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && jTable.getSelectedRow() != -1) {
                        TablePropertiesDialogEx.this.showIndexPropertiesDialog(AbstractEditorConstants.PLAIN_INDEX);
                    } else if (mouseEvent.getClickCount() == 1 && (n = jTable.getSelectedRow()) != -1 && list.size() > 0 && n < list.size() && (index = (Index)list.get(n)).isSpatialIndex()) {
                        jButton3.setEnabled(false);
                    }
                }
            });
            jToolBar.addSeparator();
            jToolBar.add(jButton2);
            jToolBar.add(jButton3);
            jToolBar.add(jButton4);
            jToolBar.add(jButton5);
        }
        object = new JPanel(new GridLayout(1, 2));
        ((JComponent)object).setPreferredSize(new Dimension(325, 35));
        ((Container)object).add(jToolBar);
        return object;
    }

    private void loadColumnGroupsColumns(Table.ColumnGroup columnGroup) {
        List list = this.table.getColumnGroupsSet();
        for (Table.ColumnGroup columnGroup2 : list) {
            List<String> list2 = columnGroup2.getColumns();
            for (String string : list2) {
                for (Column column : this.columnsList) {
                    if (!column.getObjectID().equalsIgnoreCase(string) || !this.alteredColumnList.contains(column)) continue;
                    this.alteredColumnList.remove(this.alteredColumnList.indexOf(column));
                }
            }
        }
        this.columnGroupExpressionPanel.init(columnGroup, this.columnsList, this.alteredColumnList);
        this.taColumnGroupNotes.setText(columnGroup.getNote());
    }

    private void saveColumnGroupProperties(Table.ColumnGroup columnGroup) {
        if (columnGroup != null) {
            ArrayList arrayList = (ArrayList)this.columnGroupExpressionPanel.getSelectedColumns();
            Iterator iterator = arrayList.iterator();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                arrayList2.add(((Column)iterator.next()).getObjectID());
            }
            columnGroup.getColumns().clear();
            columnGroup.getColumns().addAll(arrayList2);
            columnGroup.setNote(this.taColumnGroupNotes.getText());
            columnGroup.setName(columnGroup.getName());
            if (columnGroup.getColumns().size() > 0) {
                this.table.addColumnGroup(columnGroup);
            } else {
                this.table.removeColumnGroup(columnGroup);
            }
        }
    }

    protected JPanel getColumnGroupsPanel() {
        if (this.pnColumnGroups == null) {
            this.columnGroupList = new ArrayList<Table.ColumnGroup>();
            this.tbColumnGroupTable = new ColumnGroupsTable(new ColumnGroupsTableModel(this.columnGroupList, (Component)Ide.getMainWindow())){

                @Override
                public void onDeleteKeyPressed() {
                }

                @Override
                public void onSelectionChanged() {
                    TablePropertiesDialogEx.this.currentrowIndex = TablePropertiesDialogEx.this.tbColumnGroupTable.getSelectedRow();
                    JList jList = TablePropertiesDialogEx.this.columnGroupExpressionPanel.getColumnGroupColumnsPanel().getAllColumnsList();
                    if (TablePropertiesDialogEx.this.currentrowIndex > -1) {
                        jList.setEnabled(true);
                        TablePropertiesDialogEx.this.taColumnGroupNotes.setEnabled(true);
                    } else {
                        jList.setEnabled(false);
                        TablePropertiesDialogEx.this.taColumnGroupNotes.setEnabled(false);
                        jList.clearSelection();
                    }
                    TablePropertiesDialogEx.this.currentSelectedColumnGroup = ((ColumnGroupsTableModel)TablePropertiesDialogEx.this.tbColumnGroupTable.getModel()).getColumnGroupList().get(TablePropertiesDialogEx.this.tbColumnGroupTable.getSelectedRow());
                    if (TablePropertiesDialogEx.this.lastSelectedColumnGroup != null) {
                        TablePropertiesDialogEx.this.saveColumnGroupProperties(TablePropertiesDialogEx.this.lastSelectedColumnGroup);
                    }
                    TablePropertiesDialogEx.this.loadColumnGroupsColumns(TablePropertiesDialogEx.this.currentSelectedColumnGroup);
                    TablePropertiesDialogEx.this.lastSelectedColumnGroup = TablePropertiesDialogEx.this.currentSelectedColumnGroup;
                    TablePropertiesDialogEx.this.btnRemoveColumnGroup.setEnabled(true);
                    TablePropertiesDialogEx.this.columnGroupExpressionPanel.updateUI();
                }
            };
            if (!this.isEditable()) {
                this.tbColumnGroupTable.setEnabled(false);
            }
            this.pnColumnGroups = this.createPage(COLUMN_GROUP_TAB_NAME);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.createColumnGroupsContentsPanel());
            jPanel.add((Component)this.createColumnGroupToolbarPanel(this.columnGroupList, this.tbColumnGroupTable), "North");
            this.pnColumnGroups.add(jPanel);
        }
        return this.pnColumnGroups;
    }

    protected JPanel createColumnGroupToolbarPanel(final List<Table.ColumnGroup> list, JTable jTable) {
        JComponent jComponent;
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        final JList jList = this.columnGroupExpressionPanel.getColumnGroupColumnsPanel().getAllColumnsList();
        final List<Column> list2 = this.columnGroupExpressionPanel.getSelectedColumns();
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jComponent.setToolTipText(BTN_ADD);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TablePropertiesDialogEx.this.createAndAddColumngroup(TablePropertiesDialogEx.this.tfName.getText(), TablePropertiesDialogEx.this.tfAbbreviation.getText());
                    TablePropertiesDialogEx.this.tbColumnGroupTable.getSelectionModel().setSelectionInterval(TablePropertiesDialogEx.this.tbColumnGroupTable.getRowCount() - 1, TablePropertiesDialogEx.this.tbColumnGroupTable.getRowCount() - 1);
                    if (TablePropertiesDialogEx.this.columnGroupList.size() > 0) {
                        jList.setEnabled(true);
                    } else {
                        jList.setEnabled(false);
                    }
                }
            });
            this.btnRemoveColumnGroup = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.btnRemoveColumnGroup.setToolTipText(BTN_REMOVE);
            this.btnRemoveColumnGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCellEditor tableCellEditor = TablePropertiesDialogEx.this.tbColumnGroupTable.getCellEditor();
                    if (tableCellEditor != null) {
                        TablePropertiesDialogEx.this.tbColumnGroupTable.getCellEditor().stopCellEditing();
                    }
                    int[] nArray = TablePropertiesDialogEx.this.tbColumnGroupTable.getSelectedRows();
                    List<Table.ColumnGroup> list = ((ColumnGroupsTableModel)TablePropertiesDialogEx.this.tbColumnGroupTable.getModel()).getColumnGroupList();
                    for (int i = 0; i < nArray.length; ++i) {
                        Table.ColumnGroup columnGroup = list.get(nArray[i]);
                        TablePropertiesDialogEx.this.columnGroupsForRemovalList.add(columnGroup);
                    }
                    list.removeAll(TablePropertiesDialogEx.this.columnGroupsForRemovalList);
                    if (list.size() > 0) {
                        TablePropertiesDialogEx.this.tbColumnGroupTable.setRowSelectionInterval(0, 0);
                        jList.setEnabled(true);
                    } else {
                        list2.clear();
                        jList.clearSelection();
                        jList.setEnabled(false);
                    }
                    TablePropertiesDialogEx.this.columnGroupExpressionPanel.updateUI();
                    TablePropertiesDialogEx.this.tbColumnGroupTable.updateUI();
                }
            });
            jTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (list.isEmpty()) {
                        TablePropertiesDialogEx.this.btnRemoveColumnGroup.setEnabled(false);
                    } else {
                        TablePropertiesDialogEx.this.btnRemoveColumnGroup.setEnabled(true);
                    }
                }
            });
            jToolBar.add(jComponent);
            jToolBar.add(this.btnRemoveColumnGroup);
        }
        jComponent = new JPanel(new GridLayout(1, 2));
        jComponent.setPreferredSize(new Dimension(325, 35));
        jComponent.add(jToolBar);
        return jComponent;
    }

    protected JPanel createPrimaryKeyToolbarPanel(Index index) {
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnPKProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        this.btnPKProperties.setToolTipText(BTN_PROPERTIES);
        this.btnPKProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.showIndexPropertiesDialog(AbstractEditorConstants.PRIMARY_CONSTRAINT);
            }
        });
        this.btnPKProperties.setEnabled(false);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(this.btnPKProperties);
        if (this.isEditable()) {
            this.btnPKRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.btnPKRemove.setToolTipText(BTN_REMOVE);
            this.btnPKRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TablePropertiesDialogEx.this.deleteSelectedIndex(AbstractEditorConstants.PRIMARY_CONSTRAINT);
                }
            });
            this.btnPKRemove.setEnabled(false);
            jToolBar.addSeparator();
            jToolBar.add(this.btnPKRemove);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    private void initSelectedIndexKeyProperties() {
        boolean bl;
        this.selectedIndexKey = this.getSelectedIndexKey();
        this.indexExpressionPanel.init(this.selectedIndexKey, this.columnsList);
        boolean bl2 = bl = this.selectedIndexKey != null;
        if (bl) {
            IndexMemento indexMemento = this.selectedIndexKey.getIndexMemento();
            this.chIndexExpression.setSelected(StringUtilities.isNotEmpty(indexMemento.expression));
            this.taIndexNotes.setText(indexMemento.notes);
            this.taIndexComments.setText(indexMemento.comments);
            this.taIndexCommentsInRDBMS.setText(indexMemento.comments_in_rdbms);
        }
        this.setIndexPropertiesEnabled(bl);
    }

    private void initSelectedUniqueKeyProperties() {
        boolean bl;
        this.selectedUniqueKey = this.getSelectedUniqueKey();
        this.uniqueKeysColumnsPanel.init(this.selectedUniqueKey, this.columnsList);
        boolean bl2 = bl = this.selectedUniqueKey != null;
        if (bl) {
            IndexMemento indexMemento = this.selectedUniqueKey.getIndexMemento();
            this.taUniqueKeyNotes.setText(indexMemento.notes);
            this.taUniqueKeyComments.setText(indexMemento.comments);
            this.taUniqueKeyCommentsInRDBMS.setText(indexMemento.comments_in_rdbms);
        }
        this.setUniqueKeyPropertiesEnabled(bl);
    }

    private void initPrimaryKeyProperties() {
        if (this.primaryKey != null) {
            this.primaryKeyColumnsPanel.init(this.primaryKey, this.columnsList);
            this.tfPrimaryKeyName.setText(this.primaryKey.getName());
            this.chPrimaryKeyEngineer.setSelected(this.primaryKey.getShouldEngineer());
            this.chPrimaryKeyGenerate.setSelected(this.primaryKey.isMarkedGenerate());
            this.taPrimaryKeyNotes.setText(this.primaryKey.getNotes());
            this.taPrimaryKeyComments.setText(this.primaryKey.getComment());
            this.taPrimaryKeyCommentsInRDBMS.setText(this.primaryKey.getCommentInRDBMS());
        } else {
            this.primaryKeyColumnsPanel.init(this.columnsList);
            this.tfPrimaryKeyName.setText(null);
            this.chPrimaryKeyEngineer.setSelected(false);
            this.chPrimaryKeyGenerate.setSelected(false);
            this.taPrimaryKeyNotes.setText(null);
            this.taPrimaryKeyComments.setText(null);
            this.taPrimaryKeyCommentsInRDBMS.setText(null);
        }
    }

    private void saveSelectedIndexKeyProperties() {
        if (this.selectedIndexKey != null) {
            IndexMemento indexMemento = this.selectedIndexKey.getIndexMemento();
            indexMemento.columns.clear();
            if (this.chIndexExpression.isSelected()) {
                indexMemento.expression = this.indexExpressionPanel.getIndexExpressionText();
            } else {
                indexMemento.expression = "";
                for (Column column : this.indexExpressionPanel.getSelectedColumns()) {
                    List<IndexMemento.ColWr> list = indexMemento.columns;
                    IndexMemento indexMemento2 = indexMemento;
                    indexMemento2.getClass();
                    list.add(indexMemento2.new IndexMemento.ColWr(column.getObjectID(), this.selectedIndexKey.getColumnSortOrder(column)));
                }
            }
            indexMemento.notes = this.taIndexNotes.getText();
            indexMemento.comments = this.taIndexComments.getText();
            indexMemento.comments_in_rdbms = this.taIndexCommentsInRDBMS.getText();
        }
    }

    private void saveSelectedUniqueKeyProperties() {
        if (this.selectedUniqueKey != null) {
            IndexMemento indexMemento = this.selectedUniqueKey.getIndexMemento();
            indexMemento.columns.clear();
            indexMemento.expression = "";
            for (Column column : this.uniqueKeysColumnsPanel.getSelectedColumns()) {
                List<IndexMemento.ColWr> list = indexMemento.columns;
                IndexMemento indexMemento2 = indexMemento;
                indexMemento2.getClass();
                list.add(indexMemento2.new IndexMemento.ColWr(column.getObjectID(), this.selectedUniqueKey.getColumnSortOrder(column)));
            }
            indexMemento.notes = this.taUniqueKeyNotes.getText();
            indexMemento.comments = this.taUniqueKeyComments.getText();
            indexMemento.comments_in_rdbms = this.taUniqueKeyCommentsInRDBMS.getText();
        }
    }

    private void savePrimaryKeyProperties() {
        if (this.primaryKey != null) {
            this.primaryKey.setName(this.tfPrimaryKeyName.getText());
            IndexMemento indexMemento = this.primaryKey.getIndexMemento();
            indexMemento.columns.clear();
            for (Column column : this.primaryKeyColumnsPanel.getSelectedColumns()) {
                List<IndexMemento.ColWr> list = indexMemento.columns;
                IndexMemento indexMemento2 = indexMemento;
                indexMemento2.getClass();
                list.add(indexMemento2.new IndexMemento.ColWr(column.getObjectID(), this.primaryKey.getColumnSortOrder(column)));
            }
            indexMemento.engineer = this.chPrimaryKeyEngineer.isSelected();
            indexMemento.generate_in_DDL = this.chPrimaryKeyGenerate.isSelected();
            indexMemento.notes = this.taPrimaryKeyNotes.getText();
            indexMemento.comments = this.taPrimaryKeyComments.getText();
            indexMemento.comments_in_rdbms = this.taPrimaryKeyCommentsInRDBMS.getText();
        }
    }

    private void saveSelectedTableLevelConstraint() {
        if (this.selectedTableLevelConstraint != null) {
            this.selectedTableLevelConstraint.setRule(this.taValidationRule.getText());
        }
    }

    private void setIndexPropertiesEnabled(boolean bl) {
        this.chIndexExpression.setEnabled(bl);
        this.taIndexNotes.setEnabled(bl);
        this.taIndexComments.setEnabled(bl);
        this.taIndexCommentsInRDBMS.setEnabled(bl);
    }

    private void setUniqueKeyPropertiesEnabled(boolean bl) {
        this.taUniqueKeyNotes.setEnabled(bl);
        this.taUniqueKeyComments.setEnabled(bl);
        this.taUniqueKeyCommentsInRDBMS.setEnabled(bl);
    }

    private JPanel createIXContentsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.indexExpressionPanel = new IndexExpressionPanel(null, this.isEditable(), this.getPreferredIconSize(), true);
        jPanel2.add((Component)this.indexExpressionPanel, "North");
        this.taIndexNotes = new JTextArea();
        this.taIndexComments = new JTextArea();
        this.taIndexCommentsInRDBMS = new JTextArea();
        jPanel2.add(this.createNotesCommentsTabbedPane(this.taIndexNotes, this.taIndexComments, this.taIndexCommentsInRDBMS));
        this.chIndexExpression = new JCheckBox();
        this.chIndexExpression.setPreferredSize(this.getDefaultSize());
        this.chIndexExpression.setEnabled(false);
        this.chIndexExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertiesDialogEx.this.indexExpressionPanel.showExpressionPanel(TablePropertiesDialogEx.this.chIndexExpression.isSelected());
            }
        });
        this.addRowToPanel(jPanel, LB_INDEX_EXPRESSION, this.chIndexExpression, null, "North");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JScrollPane(this.tbIndexKeys), "North");
        jPanel3.add(jPanel);
        return jPanel3;
    }

    private JPanel createColumnGroupsContentsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.columnGroupExpressionPanel = new ColumnGroupExpressionPanel(null, this.isEditable(), this.getPreferredIconSize(), false);
        jPanel2.add((Component)this.columnGroupExpressionPanel, "North");
        this.taColumnGroupNotes = new JTextArea();
        jPanel2.add(this.createNotesCommentsTabbedPane(this.taColumnGroupNotes, null, null));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JScrollPane(this.tbColumnGroupTable), "North");
        jPanel3.add(jPanel);
        return jPanel3;
    }

    private void showIndexPropertiesDialog(String string) {
        Index index = null;
        if (PRIMARY_CONSTRAINT.equals(string)) {
            index = this.primaryKey;
        } else if (UNIQUE_CONSTRAINT.equals(string)) {
            TablePropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
            this.saveSelectedUniqueKeyProperties();
            index = this.getSelectedUniqueKey();
        } else {
            TablePropertiesDialogEx.stopCellEditing(this.tbIndexKeys);
            this.saveSelectedIndexKeyProperties();
            index = this.getSelectedIndexKey();
        }
        if (index != null && !index.isDialogVisible()) {
            index.showModal = true;
            IndexPropertiesDialogEx indexPropertiesDialogEx = new IndexPropertiesDialogEx((Dialog)this, this.getAppView(), index);
            indexPropertiesDialogEx.setColumnsList(this.columnsList);
            indexPropertiesDialogEx.initProperties(index.getIndexMemento());
            indexPropertiesDialogEx.show();
            if (index.isPK()) {
                this.initPrimaryKeyProperties();
            } else if (index.isUnique()) {
                this.tbUniqueKeys.updateUI();
                this.initSelectedUniqueKeyProperties();
            } else {
                this.tbIndexKeys.updateUI();
                this.initSelectedIndexKeyProperties();
            }
        }
    }

    private Index getSelectedIndexKey() {
        int n = this.tbIndexKeys.getSelectedRow();
        if (n != -1 && this.indexKeys.size() > 0 && n < this.indexKeys.size()) {
            return this.indexKeys.get(n);
        }
        return null;
    }

    private Index getSelectedUniqueKey() {
        int n = this.tbUniqueKeys.getSelectedRow();
        if (n != -1 && this.uniqueKeys.size() > 0 && n < this.uniqueKeys.size()) {
            return this.uniqueKeys.get(n);
        }
        return null;
    }

    private Table.ColumnGroup getSelectedColumnGroup() {
        return ((ColumnGroupsTableModel)this.tbColumnGroupTable.getModel()).getColumnGroupList().get(this.tbColumnGroupTable.getSelectedRow());
    }

    private void deleteAllIndexes() {
        this.deleteIndexes(PRIMARY_CONSTRAINT, true);
        this.deleteIndexes(UNIQUE_CONSTRAINT, true);
        this.deleteIndexes(PLAIN_INDEX, true);
    }

    private void deleteSelectedIndex(String string) {
        this.deleteIndexes(string, false);
    }

    private void deleteIndexes(String string, boolean bl) {
        if (PRIMARY_CONSTRAINT.equals(string)) {
            if (this.primaryKey != null) {
                this.removeIndex(this.primaryKey);
                this.initPrimaryKeyProperties();
            }
        } else {
            List<Index> list;
            JTable jTable;
            if (UNIQUE_CONSTRAINT.equals(string)) {
                jTable = this.tbUniqueKeys;
                list = this.uniqueKeys;
            } else {
                jTable = this.tbIndexKeys;
                list = this.indexKeys;
            }
            TablePropertiesDialogEx.stopCellEditing(jTable);
            if (bl) {
                for (Index index : list) {
                    this.removeIndex(index);
                }
            } else {
                this.removeIndex(list.get(jTable.getSelectedRow()));
            }
            jTable.clearSelection();
            jTable.updateUI();
        }
    }

    private String generateIndexName(String string, String string2, String string3) {
        String string4;
        if (PRIMARY_CONSTRAINT.equals(string)) {
            string4 = ApplyNamingStandards.createPK_Name(string2, this.table.getDesign().getDLSettings().getNamingStandardRule(), this.table.getDesignPart().getName(), string3);
        } else if (UNIQUE_CONSTRAINT.equals(string)) {
            Object[] objectArray = this.uniqueKeys.toArray();
            int n = objectArray.length;
            String string5 = null;
            while (!(string4 = ApplyNamingStandards.createUK_Name(null, n, this.table.getDesign().getDLSettings().getNamingStandardRule(), this.table.getDesignPart().getName(), string2, string3)).equals(string5)) {
                string5 = string4;
                ++n;
                if (this.hasInd_Name(objectArray, string4)) continue;
                break;
            }
        } else {
            Object[] objectArray = this.indexKeys.toArray();
            int n = objectArray.length;
            String string6 = null;
            while (!(string4 = ApplyNamingStandards.createIndexName(string2, n, this.table.getDesign().getDLSettings().getNamingStandardRule(), this.table.getDesignPart().getName(), string3)).equals(string6)) {
                string6 = string4;
                ++n;
                if (this.hasInd_Name(objectArray, string4)) continue;
            }
        }
        return string4;
    }

    private Index createAndAddIndex(String string, String string2, String string3) {
        String string4 = this.generateIndexName(string, string2, string3);
        return this.createAndAddIndex(string, string4);
    }

    private Index createAndAddIndex(String string, String string2) {
        Index index = new Index(this.table.getDesignPart());
        index.setName(string2);
        this.table.add(index);
        if (PRIMARY_CONSTRAINT.equals(string)) {
            index.setPK(true);
            this.addIndex(index);
        } else if (UNIQUE_CONSTRAINT.equals(string)) {
            index.setUnique(true);
            this.addIndex(index);
            TablePropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
            this.tbUniqueKeys.updateUI();
            this.tbUniqueKeys.changeSelection(this.uniqueKeys.size() - 1, 1, false, false);
            this.tbUniqueKeys.requestFocus();
        } else {
            this.addIndex(index);
            TablePropertiesDialogEx.stopCellEditing(this.tbIndexKeys);
            this.tbIndexKeys.updateUI();
            this.tbIndexKeys.changeSelection(this.indexKeys.size() - 1, 1, false, false);
            this.tbIndexKeys.requestFocus();
        }
        return index;
    }

    private Index getPKIndex() {
        for (Index index : this.allIndexesList) {
            if (!index.isPK()) continue;
            return index;
        }
        return null;
    }

    private Table.ColumnGroup createAndAddColumngroup(String string, String string2) {
        Table table = this.table;
        table.getClass();
        Table.ColumnGroup columnGroup = table.new Table.ColumnGroup("");
        columnGroup.setName(this.generateColumnGroupName());
        this.columnGroupList.add(columnGroup);
        this.tbColumnGroupTable.updateUI();
        return columnGroup;
    }

    protected String generateColumnGroupName() {
        String string = "ColumnGroup";
        int n = 0;
        int n2 = this.columnGroupList.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.columnGroupExists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean columnGroupExists(String string) {
        for (int i = 0; i < this.columnGroupList.size(); ++i) {
            Table.ColumnGroup columnGroup = this.columnGroupList.get(i);
            if (!string.equalsIgnoreCase(columnGroup.getName())) continue;
            return true;
        }
        return false;
    }

    protected JPanel getNestedColumnsPanel() {
        if (this.pnNestedColumns == null) {
            this.pnNestedColumns = this.createPage(Messages.getString("TablePropertiesDialogEx.NestedColumns"));
            this.nestedColumnsList = new ArrayList();
            NestedDataModel nestedDataModel = new NestedDataModel();
            this.ntable = new JTable(nestedDataModel);
            this.ntable.setSelectionMode(0);
            TableColumn tableColumn = this.ntable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(400);
            tableColumn = this.ntable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            this.ntable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Column column;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TablePropertiesDialogEx.this.ntable.getSelectedRow()) != -1 && TablePropertiesDialogEx.this.nestedColumnsList.size() > 0 && n < TablePropertiesDialogEx.this.nestedColumnsList.size() && !(column = (Column)TablePropertiesDialogEx.this.nestedColumnsList.get(n)).isDialogVisible()) {
                        column.showModal = ((TablePropertiesDialogEx)TablePropertiesDialogEx.this).table.showModal;
                        column.showPropertyDialog();
                    }
                }
            });
            this.ntable.getColumnModel().getColumn(2);
            JScrollPane jScrollPane = new JScrollPane(this.ntable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            final JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            this.ntable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (TablePropertiesDialogEx.this.nestedColumnsList.isEmpty()) {
                        jButton.setEnabled(false);
                    } else {
                        jButton.setEnabled(true);
                    }
                }
            });
            this.ntable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TablePropertiesDialogEx.this.nestedColumnsList.isEmpty()) {
                        jButton.setEnabled(false);
                    } else {
                        jButton.setEnabled(true);
                    }
                }
            });
            jButton.addActionListener(new ColumnPropertiesAction());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnNestedColumns.add(jPanel2);
        }
        return this.pnNestedColumns;
    }

    protected JPanel getTableLevelConstraintsPanel() {
        if (this.pnTableLevelConstraints == null) {
            this.pnTableLevelConstraints = this.createPage(Messages.getString("TablePropertiesDialogEx.TableLevelConstraints"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_ADD);
            jButton.addActionListener(new AddConstraintAction());
            final JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_REMOVE);
            jButton2.addActionListener(new RemoveConstraintAction());
            jButton2.setEnabled(false);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(jButton);
                jToolBar.add(jButton2);
            }
            jPanel2.add(jToolBar);
            this.tableLevelConstraints = new ArrayList<TableLevelConstraint>();
            final DefaultTableModel defaultTableModel = new DefaultTableModel(){

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public String getColumnName(int n) {
                    if (n == 1) {
                        return NAME;
                    }
                    if (n == 2) {
                        return VALIDATION_RULE;
                    }
                    return TablePropertiesDialogEx.INTERVAL_STRING;
                }

                @Override
                public int getRowCount() {
                    return TablePropertiesDialogEx.this.tableLevelConstraints.size();
                }

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    if (n2 == 0) {
                        return new Integer(n + 1);
                    }
                    if (n2 == 1) {
                        return ((TableLevelConstraint)TablePropertiesDialogEx.this.tableLevelConstraints.get(n)).getName();
                    }
                    if (n2 == 2) {
                        return ((TableLevelConstraint)TablePropertiesDialogEx.this.tableLevelConstraints.get(n)).getRule();
                    }
                    return new Integer(n * n2);
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return n2 == 1;
                }

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    if (n2 == 1) {
                        ((TableLevelConstraint)TablePropertiesDialogEx.this.tableLevelConstraints.get(n)).setName((String)object);
                    }
                }
            };
            this.tbTableLevelConstraints = new JTable(defaultTableModel);
            TableColumn tableColumn = this.tbTableLevelConstraints.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn.setMaxWidth(50);
            tableColumn.setMinWidth(25);
            this.tbTableLevelConstraints.setPreferredScrollableViewportSize(new Dimension(500, 160));
            this.tbTableLevelConstraints.setSelectionMode(0);
            this.tbTableLevelConstraints.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (TablePropertiesDialogEx.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                        int n = TablePropertiesDialogEx.this.tbTableLevelConstraints.getSelectedRow();
                        if (n == -1) {
                            jButton2.setEnabled(false);
                        } else {
                            jButton2.setEnabled(true);
                            if (TablePropertiesDialogEx.this.selectedTableLevelConstraint != null) {
                                TablePropertiesDialogEx.this.saveSelectedTableLevelConstraint();
                                defaultTableModel.fireTableCellUpdated(listSelectionEvent.getFirstIndex(), 2);
                                defaultTableModel.fireTableCellUpdated(listSelectionEvent.getLastIndex(), 2);
                            }
                            TablePropertiesDialogEx.this.selectedTableLevelConstraint = (TableLevelConstraint)TablePropertiesDialogEx.this.tableLevelConstraints.get(n);
                            TablePropertiesDialogEx.this.taValidationRule.setText(TablePropertiesDialogEx.this.selectedTableLevelConstraint.getRule());
                        }
                    }
                }
            });
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(VALIDATION_RULE));
            this.taValidationRule = new JTextArea();
            jPanel3.add(new JScrollPane(this.taValidationRule));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)new JScrollPane(this.tbTableLevelConstraints), "North");
            jPanel4.add(jPanel3);
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnTableLevelConstraints.add((Component)jPanel, "Center");
            this.tbTableLevelConstraints.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127) {
                        TablePropertiesDialogEx.this.deleteConstraint();
                    }
                }
            });
        }
        return this.pnTableLevelConstraints;
    }

    private void editClick() {
        TableLevelConstraint tableLevelConstraint = this.tableLevelConstraints.get(this.tbTableLevelConstraints.getSelectedRow());
        if (tableLevelConstraint != null) {
            this.getTLConstraintEditor().setName(tableLevelConstraint.getName());
            this.getTLConstraintEditor().setRule(tableLevelConstraint.getRule());
            if (this.getTLConstraintEditor().showDialog()) {
                tableLevelConstraint.setName(this.getTLConstraintEditor().getName());
                tableLevelConstraint.setRule(this.getTLConstraintEditor().getRule());
                this.tbTableLevelConstraints.repaint();
            }
        }
    }

    private TLConstraintEditor getTLConstraintEditor() {
        if (this.editor == null) {
            this.editor = new TLConstraintEditor(this.table.getDesign().getAppView(), this.table.getDesignPart(), !this.isEditable());
        }
        return this.editor;
    }

    private void deleteConstraint() {
        this.tableLevelConstraints.remove(this.tbTableLevelConstraints.getSelectedRow());
        this.selectedTableLevelConstraint = null;
        this.taValidationRule.setText(null);
        this.tbTableLevelConstraints.clearSelection();
        this.tbTableLevelConstraints.updateUI();
    }

    protected JPanel getVolumesPanel() {
        if (this.pnVolumes == null) {
            this.pnVolumes = this.createPage(Messages.getString("TablePropertiesDialogEx.VolumeProperties"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.setBorder(BorderFactory.createTitledBorder(LB_VOLUMES));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_MIN_VOLUME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfMinVolume = new JTextField();
            this.tfMinVolume.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel, this.tfMinVolume));
            JLabel jLabel2 = new JLabel(LB_EXPECTED);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfExpected = new JTextField();
            this.tfExpected.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel2, this.tfExpected));
            JLabel jLabel3 = new JLabel(LB_MAXIMUM);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.tfMaximum = new JTextField();
            this.tfMaximum.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel3, this.tfMaximum));
            jPanel2.add((Component)jPanel3, "North");
            JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jPanel6 = new JPanel(new BorderLayout(10, 10));
            jPanel6.setBorder(BorderFactory.createTitledBorder(LB_GROWTH_RATE));
            JLabel jLabel4 = new JLabel(LB_GROWTH_PERCENT);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.tfGrowthPercent = new JTextField();
            this.tfGrowthPercent.setPreferredSize(this.getDefaultSize());
            jPanel5.add(this.createRow(jLabel4, this.tfGrowthPercent));
            JLabel jLabel5 = new JLabel(LB_YEAR_MONTH_DAY);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbYearMonthDay = new JComboBox<String>(YMD);
            this.cbYearMonthDay.setPreferredSize(this.getDefaultSize());
            this.cbYearMonthDay.setMaximumRowCount(8);
            jPanel5.add(this.createRow(jLabel5, this.cbYearMonthDay));
            JPanel jPanel7 = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jPanel8 = new JPanel(new BorderLayout(10, 10));
            JLabel jLabel6 = new JLabel(LB_NORMAL_FORM);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.cbNormalForm = new JComboBox<String>(NF);
            this.cbNormalForm.setPreferredSize(this.getDefaultSize());
            this.cbNormalForm.setMaximumRowCount(8);
            jPanel7.add((Component)this.createRow(jLabel6, this.cbNormalForm), "North");
            JLabel jLabel7 = new JLabel(LB_ADEQUATELY_NORMALIZED);
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.cbAdequatelyNormalized = new JComboBox<String>(YES_NO);
            this.cbAdequatelyNormalized.setPreferredSize(this.getDefaultSize());
            this.cbAdequatelyNormalized.setMaximumRowCount(8);
            jPanel7.add((Component)this.createRow(jLabel7, this.cbAdequatelyNormalized), "Center");
            jPanel6.add((Component)jPanel5, "North");
            jPanel4.add((Component)jPanel6, "North");
            jPanel8.add((Component)jPanel7, "North");
            jPanel4.add((Component)jPanel8, "Center");
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnVolumes.add((Component)jPanel, "Center");
        }
        return this.pnVolumes;
    }

    private void restoreKeysStructure(ContainerWithKeyObject containerWithKeyObject) {
        KeyObject[] keyObjectArray = containerWithKeyObject.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            int n;
            List list;
            if (keyObjectArray[i].isFK() || (list = (List)this.keyMap.get(keyObjectArray[i])) == null) continue;
            List list2 = (List)keyObjectArray[i].getElementsCollection();
            ContainedObject[] containedObjectArray = keyObjectArray[i].getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                if (list.indexOf(containedObjectArray[n]) >= 0) continue;
                list2.remove(containedObjectArray[n]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContainedObject containedObject = (ContainedObject)list.get(n);
                if (n == list2.indexOf(containedObject)) continue;
                list2.remove(containedObject);
                list2.add(n, containedObject);
            }
        }
        Index index = this.getPKIndex();
        if (index == null && containerWithKeyObject.getPK() != null) {
            containerWithKeyObject.setPK(null);
        }
    }

    protected void removeIndexElements() {
        this.restoreKeysStructure(this.table);
        Iterator iterator = this.table.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            SpatialColumnDefObject spatialColumnDefObject = index.getSpatialColumnDefiniton();
            if (spatialColumnDefObject == null) continue;
            spatialColumnDefObject.setSpatialIndex(index);
        }
    }

    @Override
    protected void onCancel() {
        this.removeIndexElements();
        super.onCancel();
    }

    private JPanel getSpatialPanel() {
        if (this.pnSpatialProp == null) {
            this.pnSpatialProp = this.createPage(Messages.getString("TablePropertiesDialogEx.SpatialProperties"));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            this.sList = new ArrayList();
            this.sTable = new JTable(new SpatialTableModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TablePropertiesDialogEx.this.sTable.getSelectedRow()) > -1 && TablePropertiesDialogEx.this.sList.size() > 0 && n < TablePropertiesDialogEx.this.sList.size()) {
                        TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbUniqueKeys);
                        TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbIndexKeys);
                        SpatialColumnDefObject spatialColumnDefObject = (SpatialColumnDefObject)TablePropertiesDialogEx.this.sList.get(n);
                        SpatialColDefPropertiesDialog spatialColDefPropertiesDialog = new SpatialColDefPropertiesDialog(TablePropertiesDialogEx.this.getAppView(), TablePropertiesDialogEx.this.table, TablePropertiesDialogEx.this.columnsList, TablePropertiesDialogEx.this.allIndexesList, !TablePropertiesDialogEx.this.isEditable());
                        spatialColDefPropertiesDialog.initProperties(spatialColumnDefObject);
                        spatialColDefPropertiesDialog.showDialog();
                        TablePropertiesDialogEx.this.tbIndexKeys.updateUI();
                        TablePropertiesDialogEx.this.sTable.updateUI();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
            jPanel3.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("TablePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TablePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n > -1 && TablePropertiesDialogEx.this.sList.size() > 0 && n < TablePropertiesDialogEx.this.sList.size()) {
                        TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbIndexKeys);
                        TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbUniqueKeys);
                        SpatialColumnDefObject spatialColumnDefObject = (SpatialColumnDefObject)TablePropertiesDialogEx.this.sList.get(n);
                        SpatialColDefPropertiesDialog spatialColDefPropertiesDialog = new SpatialColDefPropertiesDialog(TablePropertiesDialogEx.this.getAppView(), TablePropertiesDialogEx.this.table, TablePropertiesDialogEx.this.columnsList, TablePropertiesDialogEx.this.allIndexesList, !TablePropertiesDialogEx.this.isEditable());
                        spatialColDefPropertiesDialog.initProperties(spatialColumnDefObject);
                        spatialColDefPropertiesDialog.showDialog();
                        TablePropertiesDialogEx.this.tbIndexKeys.updateUI();
                        TablePropertiesDialogEx.this.sTable.updateUI();
                    }
                }
            });
            if (this.isEditable()) {
                this.btnAddDimension = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddDimension.setToolTipText(Messages.getString("TablePropertiesDialogEx.Add"));
                this.btnAddDimension.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SpatialColumnDefObject spatialColumnDefObject = new SpatialColumnDefObject(TablePropertiesDialogEx.this.table);
                        spatialColumnDefObject.setName(spatialColumnDefObject.createName(TablePropertiesDialogEx.this.sList.size() + 1));
                        TablePropertiesDialogEx.this.sList.add(spatialColumnDefObject);
                        TablePropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemoveDimension = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveDimension.setToolTipText(Messages.getString("TablePropertiesDialogEx.Remove"));
                this.btnRemoveDimension.setEnabled(false);
                this.btnRemoveDimension.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = TablePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && TablePropertiesDialogEx.this.sList.size() > 0 && n < TablePropertiesDialogEx.this.sList.size()) {
                            TablePropertiesDialogEx.this.sList.remove(n);
                            TablePropertiesDialogEx.this.btnRemoveDimension.setEnabled(false);
                            TablePropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                this.sTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        TablePropertiesDialogEx.this.btnRemoveDimension.setEnabled(TablePropertiesDialogEx.this.sTable.getSelectedRow() > -1);
                    }
                });
            }
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jToolBar.addSeparator();
                jToolBar.add(this.btnAddDimension);
                jToolBar.add(this.btnRemoveDimension);
            }
            jPanel3.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 100));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertiesDialogEx.SpatialProperties")));
            jPanel4.add((Component)jPanel3, "North");
            jPanel4.add(jScrollPane);
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnSpatialProp.add(jPanel);
        }
        return this.pnSpatialProp;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 190;
    }

    private boolean hasInd_Name(Object[] objectArray, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof DesignObject) || !((DesignObject)objectArray[i]).getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTableCheck_Name(List<TableLevelConstraint> list, String string) {
        for (TableLevelConstraint tableLevelConstraint : list) {
            if (!(tableLevelConstraint instanceof TableLevelConstraint) || !tableLevelConstraint.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addEditModeButtons() {
        JButton jButton = new JButton(new AbstractAction(Messages.getString("TablePropertiesDialogEx.NamingRules")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyNamingStandardSelection applyNamingStandardSelection = new ApplyNamingStandardSelection(TablePropertiesDialogEx.this.getAppView(), (RelationalDesign)TablePropertiesDialogEx.this.table.getDesignPart());
                ((JDialog)applyNamingStandardSelection.getDialog()).setTitle(Messages.getString("TablePropertiesDialogEx.ApplyNamingRules"));
                if (TablePropertiesDialogEx.this.applyNS != null) {
                    applyNamingStandardSelection.chbColumnCHC.setSelected(TablePropertiesDialogEx.this.applyNS.applyToColumnCHC);
                    applyNamingStandardSelection.chbFK.setSelected(TablePropertiesDialogEx.this.applyNS.applyToFK);
                    applyNamingStandardSelection.chbIndex.setSelected(TablePropertiesDialogEx.this.applyNS.applyToIndex);
                    applyNamingStandardSelection.chbPK.setSelected(TablePropertiesDialogEx.this.applyNS.applyToPK);
                    applyNamingStandardSelection.chbCHC.setSelected(TablePropertiesDialogEx.this.applyNS.applyToTableCHC);
                    applyNamingStandardSelection.chbUC.setSelected(TablePropertiesDialogEx.this.applyNS.applyToUC);
                    applyNamingStandardSelection.chbColumnFK.setSelected(TablePropertiesDialogEx.this.applyNS.applyToFKColumn);
                }
                applyNamingStandardSelection.getDialog().setVisible(true);
                if (applyNamingStandardSelection.applyNamingRules) {
                    if (TablePropertiesDialogEx.this.applyNS == null) {
                        TablePropertiesDialogEx.this.applyNS = new ApplyNamingStandards(TablePropertiesDialogEx.this.table.getDesign().getDLSettings().getNamingStandardRule());
                    }
                    TablePropertiesDialogEx.this.applyNS.applyToColumnCHC = applyNamingStandardSelection.chbColumnCHC.isSelected();
                    TablePropertiesDialogEx.this.applyNS.applyToFK = applyNamingStandardSelection.chbFK.isSelected();
                    TablePropertiesDialogEx.this.applyNS.applyToIndex = applyNamingStandardSelection.chbIndex.isSelected();
                    TablePropertiesDialogEx.this.applyNS.applyToPK = applyNamingStandardSelection.chbPK.isSelected();
                    TablePropertiesDialogEx.this.applyNS.applyToTableCHC = applyNamingStandardSelection.chbCHC.isSelected();
                    TablePropertiesDialogEx.this.applyNS.applyToUC = applyNamingStandardSelection.chbUC.isSelected();
                    TablePropertiesDialogEx.this.applyNS.applyToFKColumn = applyNamingStandardSelection.chbColumnFK.isSelected();
                    TablePropertiesDialogEx.this.applyNamingRules(TablePropertiesDialogEx.this.applyNS);
                }
            }
        });
        jButton.setMnemonic(78);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.pnButtons.add(jButton);
    }

    private void applyNamingRules(ApplyNamingStandards applyNamingStandards) {
        Object object;
        Object object2;
        TablePropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbIndexKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
        TablePropertiesDialogEx.stopCellEditing(this.tbTableLevelConstraints);
        String string = this.tfName.getText();
        String string2 = this.tfAbbreviation.getText();
        if (applyNamingStandards.applyToColumnCHC) {
            for (Column column : this.columnsList) {
                applyNamingStandards.applyToColumnCheckConstraint(column, string, string2);
            }
        }
        int n = 0;
        if (applyNamingStandards.applyToFK) {
            object2 = applyNamingStandards.getNamingStandardRule();
            for (FKIndexAssociation.FKMemento object3 : this.fkList) {
                if (object3.remoteTable == null) continue;
                object = ApplyNamingStandards.createFK_Name(string, object3.remoteTable, object3.remoteKey, n, (NamingStandardRule)object2, object3.fk.getDesignPart().getName(), string2);
                object3.name = object;
                ++n;
            }
        }
        if (applyNamingStandards.applyToIndex) {
            n = 0;
            object2 = this.indexKeys.iterator();
            while (object2.hasNext()) {
                Index index = (Index)object2.next();
                applyNamingStandards.applyToIndex(index, n, string, string2);
                ++n;
            }
        }
        if (applyNamingStandards.applyToPK && (object2 = this.getPK(this.allIndexesList)) != null) {
            ApplyNamingStandards.applyToPK(object2, applyNamingStandards.getNamingStandardRule(), string, string2);
            this.initPrimaryKeyProperties();
        }
        if (applyNamingStandards.applyToTableCHC) {
            n = 0;
            for (TableLevelConstraint tableLevelConstraint : this.tableLevelConstraints) {
                applyNamingStandards.applyToTableCheckConstraint(tableLevelConstraint, n, string, string2);
                ++n;
            }
        }
        if (applyNamingStandards.applyToUC) {
            n = 0;
            for (Index index : this.uniqueKeys) {
                applyNamingStandards.applyToUK(index, n, string, string2);
                ++n;
            }
        }
        if (applyNamingStandards.applyToFKColumn) {
            object2 = applyNamingStandards.getNamingStandardRule();
            for (FKIndexAssociation.FKMemento fKMemento : this.fkList) {
                if (fKMemento.remoteTable == null) continue;
                object = fKMemento.columns;
                ContainedObject[] containedObjectArray = fKMemento.remoteKey.getElements();
                for (int i = 0; i < object.size(); ++i) {
                    FKUtilities.getColumn((String)object.get(i), this.columnsList).setName(ApplyNamingStandards.createFKColumnName((Column)containedObjectArray[i], (NamingStandardRule)object2));
                }
            }
        }
        this.tbForeignKeys.updateUI();
        this.tbIndexKeys.updateUI();
        this.tbUniqueKeys.updateUI();
        this.tbTableLevelConstraints.updateUI();
    }

    private Index getPK(List list) {
        for (Index index : list) {
            if (!index.isPK()) continue;
            return index;
        }
        return null;
    }

    private List getUC_List(List list) {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        for (Index index : list) {
            if (!index.getIndexState().equals(UNIQUE_CONSTRAINT)) continue;
            arrayList.add(index);
        }
        return arrayList;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = TablePropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (TablePropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            TablePropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            TablePropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_Table(this.getTableForIA(), null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    private Table getTableForIA() {
        Table table = (Table)((RelationalDesign)this.oldTable.getDesignPart()).getTableSet().getObjectByID(this.oldTable.getObjectID());
        if (table == null) {
            table = this.oldTable;
        }
        return table;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private void removeIndex(Index index) {
        this.allIndexesList.remove(index);
        if (index.isPK()) {
            this.primaryKey = null;
            this.btnPKProperties.setEnabled(false);
            this.btnPKRemove.setEnabled(false);
        } else if (index.isUnique()) {
            this.uniqueKeys.remove(index);
        } else {
            this.indexKeys.remove(index);
        }
    }

    private void removeAllIndexes() {
        this.allIndexesList.clear();
        this.primaryKey = null;
        this.uniqueKeys.clear();
        this.indexKeys.clear();
        this.foreignKeys.clear();
        this.btnPKProperties.setEnabled(false);
        this.btnPKRemove.setEnabled(false);
    }

    private void addIndex(Index index) {
        this.allIndexesList.add(index);
        if (index.isPK()) {
            this.primaryKey = index;
            this.btnPKProperties.setEnabled(true);
            if (this.isEditable()) {
                this.btnPKRemove.setEnabled(true);
            }
        } else if (index.isUnique()) {
            this.uniqueKeys.add(index);
        } else if (index.isFK()) {
            this.foreignKeys.add(index);
        } else {
            this.indexKeys.add(index);
        }
    }

    private void addIndexes(Index[] indexArray) {
        for (Index index : indexArray) {
            this.addIndex(index);
        }
    }

    public boolean containsElement(ComboBoxModel comboBoxModel, Object object) {
        int n = comboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (!e.equals(object)) continue;
            return true;
        }
        return false;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator iterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            PreferredDomain preferredDomain = new PreferredDomain();
            preferredDomain.setObjectId(domain.getObjectID());
            List<PreferredDomain> list = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain preferredDomain2 : list) {
                if (!preferredDomain.getObjectId().equalsIgnoreCase(preferredDomain2.getObjectId())) continue;
                this.currentPreferredDomainList.add(domain);
            }
        }
        return this.currentPreferredDomainList;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator iterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            List<LogicalDatatype> list = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype logicalDatatype2 : list) {
                if (!logicalDatatype.getObjectID().equalsIgnoreCase(logicalDatatype2.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(logicalDatatype);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    static class FKMementoNameComparator
    implements Comparator {
        FKMementoNameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((FKIndexAssociation.FKMemento)object).name.compareTo(((FKIndexAssociation.FKMemento)object2).name);
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.setPreviousSelectedColumn();
            TablePropertiesDialogEx.this.updateDTComboBox();
        }
    }

    class FKDeleteRuleCB
    extends DefaultCellEditor {
        JComboBox cbox;

        FKDeleteRuleCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            FKIndexAssociation.FKMemento fKMemento = (FKIndexAssociation.FKMemento)TablePropertiesDialogEx.this.fkList.get(n);
            if (this.hasColumnWithAllowNulls(fKMemento)) {
                this.cbox.setModel(new DefaultComboBoxModel<String>(fKMemento.fk.getDeleteRuleChoices()));
            } else {
                this.cbox.setModel(new DefaultComboBoxModel<String>(FKIndexAssociation.DELETE_RULES_WITHOUT_NULL));
            }
            this.cbox.setSelectedItem(fKMemento.deleteRule);
            return this.cbox;
        }

        private boolean hasColumnWithAllowNulls(FKIndexAssociation.FKMemento fKMemento) {
            for (String string : fKMemento.columns) {
                Column column = (Column)fKMemento.table.getElementByID(string);
                if (column == null || !column.getNullsAllowed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            TablePropertiesDialogEx.this.stealthChange = true;
            return super.stopCellEditing();
        }
    }

    class StealthCBCellEditor
    extends DefaultCellEditor {
        StealthCBCellEditor() {
            super(new JCheckBox());
        }

        @Override
        public boolean stopCellEditing() {
            TablePropertiesDialogEx.this.stealthChange = true;
            return super.stopCellEditing();
        }
    }

    public class SpatialTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return NAME;
            }
            if (n == 1) {
                return Messages.getString("TablePropertiesDialogEx.SpatialColumnFunctionExpression");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SpatialColumnDefObject spatialColumnDefObject = (SpatialColumnDefObject)TablePropertiesDialogEx.this.sList.get(n);
            if (n2 == 0) {
                return spatialColumnDefObject.getName();
            }
            if (n2 == 1) {
                if (spatialColumnDefObject.isFunction()) {
                    return spatialColumnDefObject.getFuncExpression();
                }
                if (spatialColumnDefObject.getSpatialColumn() != null) {
                    return spatialColumnDefObject.getSpatialColumn();
                }
                return "";
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SpatialColumnDefObject spatialColumnDefObject = (SpatialColumnDefObject)TablePropertiesDialogEx.this.sList.get(n);
            if (n2 == 0) {
                spatialColumnDefObject.setName((String)object);
            }
        }
    }

    class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DataTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Column column = (Column)object;
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(column.getDatatypeText());
            return this;
        }
    }

    class StatusCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        StatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(0);
            this.setEnabled(false);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    private class RemoveConstraintAction
    implements ActionListener {
        private RemoveConstraintAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.deleteConstraint();
        }
    }

    private class AddConstraintAction
    implements ActionListener {
        private AddConstraintAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TablePropertiesDialogEx.this.tfName.getText();
            int n = TablePropertiesDialogEx.this.tableLevelConstraints.size();
            String string2 = "";
            String string3 = null;
            while (!(string2 = ApplyNamingStandards.createTableCheckName(string, n, TablePropertiesDialogEx.this.table.getDesign().getDLSettings().getNamingStandardRule(), TablePropertiesDialogEx.this.table.getDesignPart().getName(), TablePropertiesDialogEx.this.table.getAbbreviation())).equals(string3)) {
                string3 = string2;
                ++n;
                if (TablePropertiesDialogEx.this.hasTableCheck_Name(TablePropertiesDialogEx.this.tableLevelConstraints, string2)) continue;
            }
            TablePropertiesDialogEx.this.getTLConstraintEditor().clear();
            TablePropertiesDialogEx.this.getTLConstraintEditor().setName(string2);
            if (TablePropertiesDialogEx.this.getTLConstraintEditor().showDialog()) {
                TableLevelConstraint tableLevelConstraint = TablePropertiesDialogEx.this.table.createCheckConstraint(TablePropertiesDialogEx.this.getTLConstraintEditor().getName(), TablePropertiesDialogEx.this.getTLConstraintEditor().getRule());
                TablePropertiesDialogEx.this.tableLevelConstraints.add(tableLevelConstraint);
                TablePropertiesDialogEx.this.tbTableLevelConstraints.changeSelection(TablePropertiesDialogEx.this.tableLevelConstraints.size() - 1, 1, false, false);
                TablePropertiesDialogEx.this.tbTableLevelConstraints.updateUI();
            }
        }
    }

    public class NestedDataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TablePropertiesDialogEx.this.nestedColumnsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return NAME;
            }
            if (n == 1) {
                return Messages.getString("TablePropertiesDialogEx.DataType");
            }
            if (n == 2) {
                return Messages.getString("TablePropertiesDialogEx.PK");
            }
            if (n == 3) {
                return Messages.getString("TablePropertiesDialogEx.FK");
            }
            if (n == 4) {
                return Messages.getString("TablePropertiesDialogEx.M");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)TablePropertiesDialogEx.this.nestedColumnsList.get(n);
            if (n2 == 0) {
                return column.getName();
            }
            if (n2 == 1) {
                if (column.getDataType() instanceof StructuredType && column.isReference()) {
                    return "REF " + column.getDataType().toString();
                }
                return column.getDataType().toString();
            }
            if (n2 == 2) {
                return column.isPKElement();
            }
            if (n2 == 3) {
                return column.isFKElement();
            }
            if (n2 == 4) {
                return !column.getNullsAllowed();
            }
            return new Integer(n * n2);
        }
    }

    class ForeignKeyTable
    extends JTable {
        ForeignKeyTable(TableModel tableModel) {
            super(tableModel);
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.coPasteColumns();
            TablePropertiesDialogEx.this.setColumnSelected();
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.setPreviousSelectedColumn();
            TablePropertiesDialogEx.this.coCopyColumns();
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.deleteColumn(TablePropertiesDialogEx.this.coTable);
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.addColumn(actionEvent);
        }
    }

    private class COPropertiesAction
    implements ActionListener {
        private COPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.showColumnPropertiesDialog();
        }
    }

    private class ColumnPropertiesAction
    implements ActionListener {
        private ColumnPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertiesDialogEx.this.tbColumns.getSelectedRow();
            if (n != -1 && TablePropertiesDialogEx.this.columnsList.size() > 0 && n < TablePropertiesDialogEx.this.columnsList.size()) {
                TablePropertiesDialogEx.stopCellEditing(TablePropertiesDialogEx.this.tbColumns);
                Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
                if (!column.isDialogVisible()) {
                    column.showModal = ((TablePropertiesDialogEx)TablePropertiesDialogEx.this).table.showModal || TablePropertiesDialogEx.this.table.showForFirstTime();
                    ColumnPropertiesDialogEx columnPropertiesDialogEx = new ColumnPropertiesDialogEx((Dialog)TablePropertiesDialogEx.this, TablePropertiesDialogEx.this.getAppView(), column, TablePropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    columnPropertiesDialogEx.initProperties(column);
                    columnPropertiesDialogEx.show();
                }
            }
        }
    }

    private class RBActionListener
    implements ActionListener {
        private RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertiesDialogEx.this.updateDTComboBox();
            TablePropertiesDialogEx.this.setDefaultDatatype();
        }
    }

    class SecurityTable
    extends JTable {
        SecurityTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.convertColumnIndexToModel(this.columnAtPoint(mouseEvent.getPoint()));
            if (n == 2) {
                return ColumnPropertiesDialogEx.CONTAINS_PII;
            }
            if (n == 3) {
                return ColumnPropertiesDialogEx.CONTAINS_SENSITIVE_INFORMATION;
            }
            if (n == 4) {
                return ColumnPropertiesDialogEx.MASK_DATA;
            }
            return super.getToolTipText();
        }
    }

    class ColumnTable
    extends JTable {
        ColumnTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            int n3 = this.convertColumnIndexToModel(n2);
            Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
            if (n3 == 3) {
                TableModel tableModel = this.getModel();
                boolean bl = (Boolean)tableModel.getValueAt(n, 3);
                if (!bl) {
                    string = MessageFormat.format(Messages.getString("TablePropertiesDialogEx.ColumnDoesntBelongToFK"), column.getName());
                } else {
                    Index index = TablePropertiesDialogEx.this.getPKIndex();
                    String string2 = "";
                    if (index != null) {
                        string2 = "<html><body>" + MessageFormat.format(Messages.getString("TablePropertiesDialogEx.PrimaryKey"), index.getName()) + "<p>" + Messages.getString("TablePropertiesDialogEx.PKColumnsL");
                        for (Column column2 : index.getElementsCollection()) {
                            string2 = string2 + "<p>" + "  " + column2.getName();
                        }
                        string2 = string2 + "</body>" + "</html>";
                    }
                    string = string2;
                }
            } else if (n3 != 5) {
                string = super.getToolTipText(mouseEvent);
            }
            return string;
        }
    }

    public class SecurityPropertiesDataModel
    extends AbstractColumnModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2 || n2 == 3 || n2 == 4) {
                return true;
            }
            return super.isCellEditable(n, n2);
        }

        @Override
        public String getColumnName(int n) {
            if (n == 2) {
                return ColumnPropertiesDialogEx.CONTAINS_PII_SHORT;
            }
            if (n == 3) {
                return ColumnPropertiesDialogEx.CONTAINS_SENSITIVE_INFORMATION_MINIMAL;
            }
            if (n == 4) {
                return ColumnPropertiesDialogEx.MASK_DATA_MINIMAL;
            }
            return super.getColumnName(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
            if (n2 == 2) {
                Boolean bl = column.isContainsPII();
                return bl == null ? "" : (bl != false ? AbstractPropertiesDialog.YES : AbstractPropertiesDialog.NO);
            }
            if (n2 == 3) {
                Boolean bl = column.isContainsSensitiveInformation();
                return bl == null ? "" : (bl != false ? AbstractPropertiesDialog.YES : AbstractPropertiesDialog.NO);
            }
            if (n2 == 4) {
                Boolean bl = column.isMaskData();
                return bl == null ? "" : (bl != false ? AbstractPropertiesDialog.YES : AbstractPropertiesDialog.NO);
            }
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
            if (n2 == 2) {
                column.setContainsPII(object.equals(AbstractPropertiesDialog.YES) ? Boolean.TRUE : (object.equals(AbstractPropertiesDialog.NO) ? Boolean.FALSE : null));
            } else if (n2 == 3) {
                column.setContainsSensitiveInformation(object.equals(AbstractPropertiesDialog.YES) ? Boolean.TRUE : (object.equals(AbstractPropertiesDialog.NO) ? Boolean.FALSE : null));
            } else if (n2 == 4) {
                column.setMaskData(object.equals(AbstractPropertiesDialog.YES) ? Boolean.TRUE : (object.equals(AbstractPropertiesDialog.NO) ? Boolean.FALSE : null));
            }
        }
    }

    public class DataModel
    extends AbstractColumnModel {
        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 2) {
                return Messages.getString("TablePropertiesDialogEx.DataType");
            }
            if (n == 3) {
                return Messages.getString("TablePropertiesDialogEx.PK");
            }
            if (n == 4) {
                return Messages.getString("TablePropertiesDialogEx.FK");
            }
            if (n == 5) {
                return Messages.getString("TablePropertiesDialogEx.M");
            }
            if (n == 6) {
                return Messages.getString("TablePropertiesDialogEx.Comments");
            }
            if (n == 7) {
                return Messages.getString("TablePropertiesDialogEx.CommentsInRDBMS");
            }
            if (n == 8) {
                return Messages.getString("TablePropertiesDialogEx.Notes");
            }
            return super.getColumnName(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
            if (n2 == 2) {
                return column;
            }
            if (n2 == 3) {
                Index index = TablePropertiesDialogEx.this.getPKIndex();
                if (index != null) {
                    return index.contains(column);
                }
                return Boolean.FALSE;
            }
            if (n2 == 4) {
                return column.isFKElement();
            }
            if (n2 == 5) {
                return !column.getNullsAllowed();
            }
            if (n2 == 6) {
                return column.getComment();
            }
            if (n2 == 7) {
                return column.getCommentInRDBMS();
            }
            if (n2 == 8) {
                return column.getNotes();
            }
            return super.getValueAt(n, n2);
        }
    }

    public class ColumnModel
    extends AbstractColumnModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 2) {
                return Messages.getString("TablePropertiesDialogEx.DataType");
            }
            return super.getColumnName(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
            if (n2 == 2) {
                return column.getGenericDatatypeString();
            }
            return super.getValueAt(n, n2);
        }
    }

    public abstract class AbstractColumnModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return TablePropertiesDialogEx.this.columnsList.size();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TablePropertiesDialogEx.INTERVAL_STRING;
            }
            if (n == 1) {
                return NAME;
            }
            return "";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)TablePropertiesDialogEx.this.columnsList.get(n);
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (n2 == 1) {
                return column.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertiesDialogEx.this.cbType.getSelectedItem() != null && ((String)TablePropertiesDialogEx.this.cbType.getSelectedItem()).equalsIgnoreCase(ContainerObject.TYPE_TEMPORARY)) {
                TablePropertiesDialogEx.this.tfScope.setEnabled(true);
            } else {
                TablePropertiesDialogEx.this.tfScope.setEnabled(false);
                TablePropertiesDialogEx.this.tfScope.setText("");
            }
        }
    }
}

