/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SpatialColDefPropertiesDialog
extends CustomDialog {
    private JDialog dialog;
    private JButton bnOK;
    private JPanel general;
    private List sList;
    private JTable sTable;
    private JButton btnAddDimension;
    private JButton btnRemoveDimension;
    private static final int FIELD_WIDTH = 180;
    private static final int FIELD_HEIGHT = 20;
    private static final Dimension defaultSize = new Dimension(180, 20);
    private JComboBox cbSpatialColumn;
    private JCheckBox chFunction;
    private JButton btnFuncExpression;
    private JTextField ifSystemID;
    private Index spatialIndex;
    private Table table;
    private List columnsList;
    private List indexesList;
    private JTextField tfName;
    private SpatialColumnDefObject spDefinition;
    private Object sType;
    private boolean readOnly = false;
    private JComboBox cbIndex;
    private List wrList = new ArrayList();

    public SpatialColDefPropertiesDialog(ApplicationView applicationView, Table table, List list, List list2, boolean bl) {
        super(applicationView);
        Object object;
        Object object22;
        this.table = table;
        this.columnsList = list;
        this.indexesList = list2;
        this.readOnly = bl;
        for (Object object22 : list2) {
            object = new WR((Index)object22);
            this.wrList.add(object);
        }
        this.general = new JPanel(new BorderLayout(10, 10));
        this.setLayout(new BorderLayout());
        this.initGeneralView();
        this.add((Component)this.general, "Center");
        object22 = new JPanel(new FlowLayout(2));
        ((JComponent)object22).setBorder(BorderFactory.createEtchedBorder());
        if (!bl) {
            this.bnOK = new JButton(Messages.getString("SpatialColDefPropertiesDialog.OK"));
            this.bnOK.addActionListener(new OKAction());
            this.bnOK.setMnemonic(79);
            this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            ((Container)object22).add(this.bnOK);
        }
        object = new JButton(!bl ? Messages.getString("SpatialColDefPropertiesDialog.Cancel") : Messages.getString("SpatialColDefPropertiesDialog.Close"));
        ((AbstractButton)object).setMnemonic(67);
        ((AbstractButton)object).addActionListener(new CancelAction());
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setMnemonic(72);
        ((JComponent)object).setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        ((Container)object22).add((Component)object);
        ((Container)object22).add(jButton);
        this.add((Component)object22, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.getCaption(), true);
            this.dialog.getContentPane().add(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.setSize(new Dimension(400, 400));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = SpatialColDefPropertiesDialog.this.dialog.getWidth();
                    int n2 = SpatialColDefPropertiesDialog.this.dialog.getHeight();
                    n = Math.max(400, n);
                    n2 = Math.max(400, n2);
                    SpatialColDefPropertiesDialog.this.dialog.setSize(n, n2);
                }
            });
            CommonUtil.centerOnScreen(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void initProperties(Object object) {
        if (object instanceof SpatialColumnDefObject) {
            this.spDefinition = (SpatialColumnDefObject)object;
            this.tfName.setText(this.spDefinition.getName());
            this.updateSpatialColumns();
            this.cbSpatialColumn.setSelectedItem(this.spDefinition.getSpatialColumn());
            this.chFunction.setSelected(this.spDefinition.isFunction());
            this.btnFuncExpression.setText(this.spDefinition.getFuncExpression());
            this.ifSystemID.setText(this.spDefinition.getSystemID());
            this.sList.addAll(this.spDefinition.getTableDimensions());
            this.fillComboItems(this.wrList.toArray(), this.cbIndex, true);
            if (this.spDefinition.getSpatialIndex() != null) {
                this.spatialIndex = this.spDefinition.getSpatialIndex();
                WR wR = this.getWR(this.wrList, this.spatialIndex);
                if (wR != null) {
                    this.cbIndex.setSelectedItem(wR);
                }
            }
            this.enableSpatialComponents();
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "SPATIAL_COLUMN_DEF_DIALOG";
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    public String getCaption() {
        return Messages.getString("SpatialColDefPropertiesDialog.SpatialDefinitionProperties");
    }

    private void initGeneralView() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SpatialColDefPropertiesDialog.SpatialDefinition")));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
        JLabel jLabel = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.NameL"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfName = new JTextField();
        this.tfName.setEnabled(!this.readOnly);
        jPanel3.add(this.createRow(jLabel, this.tfName));
        JLabel jLabel2 = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.SpatialColumn"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbSpatialColumn = new JComboBox();
        this.cbSpatialColumn.setEnabled(!this.readOnly);
        this.cbSpatialColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpatialColDefPropertiesDialog.this.enableSpatialComponents();
            }
        });
        jPanel3.add(this.createRow(jLabel2, this.cbSpatialColumn));
        JLabel jLabel3 = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.UseFunction"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chFunction = new JCheckBox();
        this.chFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpatialColDefPropertiesDialog.this.enableSpatialComponents();
            }
        });
        this.chFunction.setPreferredSize(this.getDefaultSize());
        this.chFunction.setEnabled(!this.readOnly);
        jPanel3.add(this.createRow(jLabel3, this.chFunction));
        JLabel jLabel4 = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.FunctionExpressionL"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.btnFuncExpression = new JButton();
        this.btnFuncExpression.setPreferredSize(this.getDefaultSize());
        this.btnFuncExpression.setHorizontalAlignment(0);
        this.btnFuncExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringEditor stringEditor = new StringEditor(SpatialColDefPropertiesDialog.this.getApplicationView(), SpatialColDefPropertiesDialog.this.btnFuncExpression.getText(), Messages.getString("SpatialColDefPropertiesDialog.FunctionExpression"), SpatialColDefPropertiesDialog.this.readOnly);
                stringEditor.setModal(true);
                stringEditor.show();
                if (!stringEditor.cancel) {
                    SpatialColDefPropertiesDialog.this.btnFuncExpression.setText(stringEditor.getText());
                }
            }
        });
        jPanel3.add(this.createRow(jLabel4, this.btnFuncExpression));
        JLabel jLabel5 = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.CoordinateSystemID"));
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.ifSystemID = new JTextField();
        this.ifSystemID.setPreferredSize(this.getPreferredSize());
        this.ifSystemID.setEnabled(!this.readOnly);
        jPanel3.add(this.createRow(jLabel5, this.ifSystemID));
        JLabel jLabel6 = new JLabel(Messages.getString("SpatialColDefPropertiesDialog.SpatialIndexName"));
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbIndex = new JComboBox();
        this.cbIndex.setPreferredSize(this.getDefaultSize());
        jPanel3.add(this.createRow(jLabel6, this.cbIndex));
        jPanel2.add((Component)jPanel3, "North");
        this.sList = new ArrayList();
        this.sTable = new JTable(new SpatialTableModel());
        this.sTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.sTable);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("SpatialColDefPropertiesDialog.DimensionalInformation")));
        if (!this.readOnly) {
            this.btnAddDimension = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.btnAddDimension.setToolTipText(Messages.getString("SpatialColDefPropertiesDialog.Add"));
            this.btnAddDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SpatialColumnDefObject.TableDimension tableDimension = SpatialColDefPropertiesDialog.this.spDefinition.new SpatialColumnDefObject.TableDimension();
                    SpatialColDefPropertiesDialog.this.sList.add(tableDimension);
                    SpatialColDefPropertiesDialog.this.sTable.updateUI();
                    if (SpatialColDefPropertiesDialog.this.sList.size() == 4) {
                        SpatialColDefPropertiesDialog.this.btnAddDimension.setEnabled(false);
                    }
                }
            });
            this.btnRemoveDimension = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.btnRemoveDimension.setToolTipText(Messages.getString("SpatialColDefPropertiesDialog.Remove"));
            this.btnRemoveDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SpatialColDefPropertiesDialog.this.sTable.getSelectedRow();
                    if (n != -1 && SpatialColDefPropertiesDialog.this.sList.size() > 0 && n < SpatialColDefPropertiesDialog.this.sList.size()) {
                        SpatialColDefPropertiesDialog.this.sList.remove(n);
                        SpatialColDefPropertiesDialog.this.spDefinition.getTableDimensions().remove(n);
                        SpatialColDefPropertiesDialog.this.sTable.updateUI();
                        if (!SpatialColDefPropertiesDialog.this.btnAddDimension.isEnabled() && SpatialColDefPropertiesDialog.this.sList.size() < 4) {
                            SpatialColDefPropertiesDialog.this.btnAddDimension.setEnabled(true);
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnAddDimension);
            jToolBar.add(this.btnRemoveDimension);
            jPanel4.add(jToolBar);
            jPanel5.add((Component)jPanel4, "North");
        }
        jScrollPane.setPreferredSize(new Dimension(325, 100));
        jPanel5.add(jScrollPane);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel5, "Center");
        this.general.add(jPanel);
    }

    private Dimension getDefaultSize() {
        return defaultSize;
    }

    private void setProperties() {
        int n = this.sTable.getEditingColumn();
        int n2 = this.sTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            this.sTable.getCellEditor(n2, n).stopCellEditing();
        }
        this.spDefinition.setName(this.tfName.getText());
        if (this.spatialIndex != null && !this.indexesList.contains(this.spatialIndex)) {
            this.indexesList.add(this.spatialIndex);
        }
        Index index = null;
        WR wR = (WR)this.cbIndex.getSelectedItem();
        if (wR != null) {
            index = wR.index;
        }
        if (this.spatialIndex != null && index != this.spatialIndex) {
            this.spatialIndex.setSpatialIndex(false);
            this.spatialIndex.setSpatialColumnDefiniton(null);
            this.spatialIndex.getIndexMemento().spatial = false;
        }
        this.spatialIndex = index;
        if (this.spatialIndex != null) {
            this.spatialIndex.setSpatialIndex(true);
            this.spatialIndex.setSpatialColumnDefiniton(this.spDefinition);
            this.spatialIndex.getIndexMemento().spatial = true;
            this.spatialIndex.setIndexExpression("");
        }
        this.spDefinition.setSpatialIndex(this.spatialIndex);
        if (this.cbSpatialColumn.isEnabled()) {
            Column column = (Column)this.cbSpatialColumn.getSelectedItem();
            this.spDefinition.setSpatialColumn(column);
            this.spDefinition.setFunction(false);
            this.spDefinition.setFuncExpression("");
            if (this.spatialIndex != null) {
                this.spatialIndex.getIndexMemento().expression = "";
                this.spatialIndex.getIndexMemento().columns.clear();
                if (column != null) {
                    this.spatialIndex.getIndexMemento().add(column);
                }
            }
        } else {
            this.spDefinition.setFunction(this.chFunction.isSelected());
            this.spDefinition.setFuncExpression(this.btnFuncExpression.getText().trim());
            if (this.spatialIndex != null) {
                this.spatialIndex.getIndexMemento().expression = this.btnFuncExpression.getText().trim();
                this.spatialIndex.getIndexMemento().columns.clear();
                this.spatialIndex.setIndexExpression(this.btnFuncExpression.getText().trim());
            }
            this.spDefinition.setSpatialColumn(null);
        }
        this.spDefinition.setSystemID(this.ifSystemID.getText());
        this.spDefinition.setTableDimensions(this.sList);
    }

    private void onCancel() {
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void enableSpatialComponents() {
        Object object = this.cbSpatialColumn.getSelectedItem();
        if (object != null) {
            this.chFunction.setEnabled(false);
            this.btnFuncExpression.setEnabled(false);
        } else {
            this.chFunction.setEnabled(!this.readOnly);
            this.btnFuncExpression.setEnabled(this.chFunction.isSelected());
            this.cbSpatialColumn.setEnabled(!this.readOnly ? !this.chFunction.isSelected() : false);
        }
    }

    protected JPanel createRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add(component, "Center");
        return jPanel;
    }

    private void updateSpatialColumns() {
        this.cbSpatialColumn.removeAllItems();
        this.fillComboItems(this.getSpatialColumnsList().toArray(), this.cbSpatialColumn, true);
        this.cbSpatialColumn.setSelectedItem(this.spDefinition.getSpatialColumn());
    }

    private List getSpatialColumnsList() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Iterator iterator = this.columnsList.iterator();
        if (this.sType == null) {
            this.sType = this.table.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
        }
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            Datatype datatype = column.getDataType();
            if (datatype != this.sType) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    protected void fillComboItems(Object[] objectArray, JComboBox jComboBox, boolean bl) {
        jComboBox.removeAllItems();
        if (bl) {
            jComboBox.addItem(null);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    private WR getWR(List list, Index index) {
        for (WR wR : list) {
            if (wR.index != index) continue;
            return wR;
        }
        return null;
    }

    class WR {
        Index index;

        WR(Index index) {
            this.index = index;
        }

        public String toString() {
            return this.index.getIndexMemento().name;
        }
    }

    public class SpatialTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return SpatialColDefPropertiesDialog.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SpatialColDefPropertiesDialog.Name");
            }
            if (n == 1) {
                return Messages.getString("SpatialColDefPropertiesDialog.LowBoundary");
            }
            if (n == 2) {
                return Messages.getString("SpatialColDefPropertiesDialog.UpperBoundary");
            }
            if (n == 3) {
                return Messages.getString("SpatialColDefPropertiesDialog.Tolerance");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !SpatialColDefPropertiesDialog.this.readOnly;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SpatialColumnDefObject.TableDimension tableDimension = (SpatialColumnDefObject.TableDimension)SpatialColDefPropertiesDialog.this.sList.get(n);
            if (n2 == 0) {
                return tableDimension.getName();
            }
            if (n2 == 1) {
                return tableDimension.getLowBoundary();
            }
            if (n2 == 2) {
                return tableDimension.getUpperBoundary();
            }
            if (n2 == 3) {
                return tableDimension.getTolerance();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SpatialColumnDefObject.TableDimension tableDimension = (SpatialColumnDefObject.TableDimension)SpatialColDefPropertiesDialog.this.sList.get(n);
            if (n2 == 0) {
                tableDimension.setName((String)object);
            } else if (n2 == 1) {
                tableDimension.setLowBoundary((String)object);
            } else if (n2 == 2) {
                tableDimension.setUpperBoundary((String)object);
            } else if (n2 == 3) {
                tableDimension.setTolerance((String)object);
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpatialColDefPropertiesDialog.this.onCancel();
            SpatialColDefPropertiesDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpatialColDefPropertiesDialog.this.setProperties();
            SpatialColDefPropertiesDialog.this.close();
        }
    }
}

