/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class SchemaObjectPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = -3640605097703231194L;
    private static final String INDEXES_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Indexes");
    private static final String TABLES_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Tables");
    private static final String VIEWS_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Views");
    private SchemaObject schemaObject;
    private JPanel pnTables;
    private JPanel pnViews;
    private JPanel pnIndexes;
    private JButton buttonTableAdd;
    private JButton buttonTableRemove;
    private JButton buttonIndexAdd;
    private JButton buttonIndexRemove;
    private JButton buttonViewAdd;
    private JButton buttonViewRemove;
    private DefaultListModel selectedTablesModel;
    private DefaultListModel allTablesModel;
    private JList allTablesList;
    private JList selectedTablesList;
    private DefaultListModel selectedViewsModel;
    private DefaultListModel allViewsModel;
    private JList allViewsList;
    private JList selectedViewsList;
    private DefaultListModel selectedIndexesModel;
    private DefaultListModel allIndexesModel;
    private JList allIndexesList;
    private JList selectedIndexesList;
    private RelationalDesign rd = (RelationalDesign)this.getDesignObject().getDesignPart();
    private TableSet allTablesSet;
    private TableViewSet allViewsSet;
    private GlobalIndexSet allIndexesSet;

    public SchemaObjectPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertiesDialogEx.SchemaProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "SCHEMA_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof SchemaObject) {
            Object object;
            Object object2;
            Object object3;
            this.schemaObject = (SchemaObject)designObject;
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.taCommentsInRDBMS.setText(this.schemaObject.getCommentInRDBMS());
            this.taComments.setText(this.schemaObject.getComment());
            this.taNotes.setText(this.schemaObject.getNotes());
            this.tfName.setText(this.schemaObject.getName());
            this.allTablesSet = this.rd.getTableSet();
            Iterator iterator = this.allTablesSet.iterator();
            while (iterator.hasNext()) {
                object3 = (Table)iterator.next();
                if (designObject == ((ContainerObject)object3).getSchemaObject()) {
                    this.selectedTablesModel.addElement(object3);
                    continue;
                }
                this.allTablesModel.addElement(object3);
            }
            this.sort(this.selectedTablesModel);
            this.sort(this.allTablesModel);
            this.allViewsSet = this.rd.getTableViewSet();
            object3 = this.allViewsSet.iterator();
            while (object3.hasNext()) {
                object2 = (TableView)object3.next();
                if (designObject == ((ContainerObject)object2).getSchemaObject()) {
                    this.selectedViewsModel.addElement(object2);
                    continue;
                }
                this.allViewsModel.addElement(object2);
            }
            this.sort(this.selectedViewsModel);
            this.sort(this.allViewsModel);
            this.allIndexesSet = this.rd.getGlobalIndexSet();
            object2 = this.allIndexesSet.iterator();
            while (object2.hasNext()) {
                object = (Index)object2.next();
                if (designObject == ((ContainerObject)object).getSchemaObject()) {
                    this.selectedIndexesModel.addElement(object);
                    continue;
                }
                if (((KeyObject)object).isUnique() || ((KeyObject)object).isFK() || ((KeyObject)object).isPK()) continue;
                this.allIndexesModel.addElement(object);
            }
            this.sort(this.selectedIndexesModel);
            this.sort(this.allIndexesModel);
            this.dynamicPropertiesList.clear();
            object = this.schemaObject.getPropertyNames();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = this.schemaObject.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getTablesPanel());
        this.addToTree(defaultMutableTreeNode, this.getViewsPanel());
        this.addToTree(defaultMutableTreeNode, this.getIndexesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
    }

    protected JPanel getTablesPanel() {
        if (this.pnTables == null) {
            this.pnTables = this.createPage(TABLES_TAB_NAME);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllTables")));
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        this.allTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SchemaObjectPropertiesDialogEx.this.allTablesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonTableAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonTableAdd.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allTablesList);
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedTables")));
        this.selectedTablesModel = new DefaultListModel();
        this.selectedTablesList = new JList(this.selectedTablesModel);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SchemaObjectPropertiesDialogEx.this.selectedTablesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonTableRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonTableRemove.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedTablesList);
        jPanel3.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initTablesPanelAddRemoveButtons(jPanel);
        this.pnTables.add(jPanel);
        return this.pnTables;
    }

    private void initTablesPanelAddRemoveButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonTableAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonTableAdd.addActionListener(new AddTable());
        this.buttonTableAdd.setEnabled(false);
        this.buttonTableAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonTableRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonTableRemove.setEnabled(false);
        this.buttonTableRemove.addActionListener(new RemoveTable());
        this.buttonTableRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        jPanel2.add((Component)this.buttonTableAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.buttonTableRemove, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getIndexesPanel() {
        if (this.pnIndexes == null) {
            this.pnIndexes = this.createPage(INDEXES_TAB_NAME);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllIndexes")));
        this.allIndexesModel = new DefaultListModel();
        this.allIndexesList = new JList(this.allIndexesModel);
        this.allIndexesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SchemaObjectPropertiesDialogEx.this.allIndexesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexAdd.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allIndexesList);
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedIndexes")));
        this.selectedIndexesModel = new DefaultListModel();
        this.selectedIndexesList = new JList(this.selectedIndexesModel);
        this.selectedIndexesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SchemaObjectPropertiesDialogEx.this.selectedIndexesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexRemove.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedIndexesList);
        jPanel3.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initIndexesPanelAddRemoveButtons(jPanel);
        this.pnIndexes.add(jPanel);
        return this.pnIndexes;
    }

    private void initIndexesPanelAddRemoveButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonIndexAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonIndexAdd.addActionListener(new AddIndex());
        this.buttonIndexAdd.setEnabled(false);
        this.buttonIndexAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonIndexRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonIndexRemove.setEnabled(false);
        this.buttonIndexRemove.addActionListener(new RemoveIndex());
        this.buttonIndexRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        jPanel2.add((Component)this.buttonIndexAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.buttonIndexRemove, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getViewsPanel() {
        if (this.pnViews == null) {
            this.pnViews = this.createPage(VIEWS_TAB_NAME);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllViews")));
        this.allViewsModel = new DefaultListModel();
        this.allViewsList = new JList(this.allViewsModel);
        this.allViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SchemaObjectPropertiesDialogEx.this.allViewsList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonViewAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonViewAdd.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.allViewsList);
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedViews")));
        this.selectedViewsModel = new DefaultListModel();
        this.selectedViewsList = new JList(this.selectedViewsModel);
        this.selectedViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SchemaObjectPropertiesDialogEx.this.selectedViewsList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonViewRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonViewRemove.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedViewsList);
        jPanel3.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initViewsPanelAddRemoveButtons(jPanel);
        this.pnViews.add(jPanel);
        return this.pnViews;
    }

    private void initViewsPanelAddRemoveButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonViewAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonViewAdd.addActionListener(new AddView());
        this.buttonViewAdd.setEnabled(false);
        this.buttonViewAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonViewRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonViewRemove.setEnabled(false);
        this.buttonViewRemove.addActionListener(new RemoveView());
        this.buttonViewRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        jPanel2.add((Component)this.buttonViewAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.buttonViewRemove, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void setProperties() {
        Object object2;
        int n;
        this.schemaObject.setName(this.tfName.getText());
        this.schemaObject.setComment(this.taComments.getText());
        this.schemaObject.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.schemaObject.setNotes(this.taNotes.getText());
        for (n = 0; n < this.selectedTablesList.getModel().getSize(); ++n) {
            object2 = (Table)this.selectedTablesList.getModel().getElementAt(n);
            ((ContainerObject)object2).setSchemaObject(this.schemaObject);
            ((DesignObject)object2).fireNameChangedNoDirty();
        }
        for (n = 0; n < this.selectedViewsList.getModel().getSize(); ++n) {
            object2 = (TableView)this.selectedViewsList.getModel().getElementAt(n);
            ((ContainerObject)object2).setSchemaObject(this.schemaObject);
            ((DesignObject)object2).fireNameChangedNoDirty();
        }
        for (n = 0; n < this.selectedIndexesList.getModel().getSize(); ++n) {
            object2 = (Index)this.selectedIndexesList.getModel().getElementAt(n);
            ((ContainerObject)object2).setSchemaObject(this.schemaObject);
        }
        for (n = 0; n < this.allTablesList.getModel().getSize(); ++n) {
            object2 = (Table)this.allTablesList.getModel().getElementAt(n);
            if (((ContainerObject)object2).getSchemaObject() != this.schemaObject) continue;
            ((ContainerObject)object2).setSchemaObject(null);
            ((DesignObject)object2).fireNameChangedNoDirty();
        }
        for (n = 0; n < this.allViewsList.getModel().getSize(); ++n) {
            object2 = (TableView)this.allViewsList.getModel().getElementAt(n);
            if (((ContainerObject)object2).getSchemaObject() != this.schemaObject) continue;
            ((ContainerObject)object2).setSchemaObject(null);
            ((DesignObject)object2).fireNameChangedNoDirty();
        }
        for (n = 0; n < this.allIndexesList.getModel().getSize(); ++n) {
            object2 = (Index)this.allIndexesList.getModel().getElementAt(n);
            if (((ContainerObject)object2).getSchemaObject() != this.schemaObject) continue;
            ((ContainerObject)object2).setSchemaObject(null);
        }
        this.setMeasurements(this.schemaObject);
        this.setChangeRequests(this.schemaObject);
        this.setResponsibleParties(this.schemaObject);
        this.setDocuments(this.schemaObject);
        SchemaObjectPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.schemaObject.clearProperties();
        for (Object object2 : this.dynamicPropertiesList) {
            this.schemaObject.setProperty(((DynamicProperty)object2).getName(), ((DynamicProperty)object2).getValue());
        }
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                if (defaultListModel.get(j).toString().compareTo(defaultListModel.get(j - 1).toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class RemoveView
    implements ActionListener {
        private RemoveView() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SchemaObjectPropertiesDialogEx.this.selectedViewsList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allViewsModel.contains(objectArray[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedViewsModel.removeElement(objectArray[i]);
                SchemaObjectPropertiesDialogEx.this.allViewsModel.addElement(objectArray[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allViewsModel);
        }
    }

    private class AddView
    implements ActionListener {
        private AddView() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SchemaObjectPropertiesDialogEx.this.allViewsList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedViewsModel.contains(objectArray[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedViewsModel.addElement(objectArray[i]);
                SchemaObjectPropertiesDialogEx.this.allViewsModel.removeElement(objectArray[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedViewsModel);
        }
    }

    private class RemoveIndex
    implements ActionListener {
        private RemoveIndex() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SchemaObjectPropertiesDialogEx.this.selectedIndexesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allIndexesModel.contains(objectArray[i])) continue;
                SchemaObjectPropertiesDialogEx.this.allIndexesModel.addElement(objectArray[i]);
                SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.removeElement(objectArray[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allIndexesModel);
        }
    }

    private class AddIndex
    implements ActionListener {
        private AddIndex() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SchemaObjectPropertiesDialogEx.this.allIndexesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.contains(objectArray[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.addElement(objectArray[i]);
                SchemaObjectPropertiesDialogEx.this.allIndexesModel.removeElement(objectArray[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedIndexesModel);
        }
    }

    private class RemoveTable
    implements ActionListener {
        private RemoveTable() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SchemaObjectPropertiesDialogEx.this.selectedTablesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allTablesModel.contains(objectArray[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedTablesModel.removeElement(objectArray[i]);
                SchemaObjectPropertiesDialogEx.this.allTablesModel.addElement(objectArray[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allTablesModel);
        }
    }

    private class AddTable
    implements ActionListener {
        private AddTable() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SchemaObjectPropertiesDialogEx.this.allTablesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedTablesModel.contains(objectArray[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedTablesModel.addElement(objectArray[i]);
                SchemaObjectPropertiesDialogEx.this.allTablesModel.removeElement(objectArray[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedTablesModel);
        }
    }
}

