/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractNamingStandards;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class KeysNamingStandards
extends AbstractNamingStandards {
    protected JCheckBox chbPK;
    protected JCheckBox chbFK;
    protected JCheckBox chbCHC;
    protected JCheckBox chbUC;
    protected JCheckBox chbIndex;
    protected JCheckBox chbColumnCHC;
    protected JCheckBox chbColumnFK;
    protected RelationalDesign relational;
    protected ApplyNamingStandards applyNS;

    public KeysNamingStandards(ApplicationView applicationView, RelationalDesign relationalDesign) {
        super(applicationView);
        this.relational = relationalDesign;
    }

    @Override
    protected JPanel initGeneralPanel() {
        JPanel jPanel = super.initGeneralPanel();
        this.chbPK = new JCheckBox(Messages.getString("KeysNamingStandards.PrimaryKeys"), true);
        this.chbFK = new JCheckBox(Messages.getString("KeysNamingStandards.ForeignKeys"), true);
        this.chbCHC = new JCheckBox(Messages.getString("KeysNamingStandards.CheckConstraints"), true);
        this.chbUC = new JCheckBox(Messages.getString("KeysNamingStandards.UniqueConstraints"), true);
        this.chbIndex = new JCheckBox(Messages.getString("KeysNamingStandards.Indexes"), true);
        this.chbColumnCHC = new JCheckBox(Messages.getString("KeysNamingStandards.ColumnCheckConstraints"), true);
        this.chbColumnFK = new JCheckBox(Messages.getString("KeysNamingStandards.ColumnForeignKeys"), true);
        this.generalPanelContents.add(this.chbPK);
        this.generalPanelContents.add(this.chbFK);
        this.generalPanelContents.add(this.chbCHC);
        this.generalPanelContents.add(this.chbUC);
        this.generalPanelContents.add(this.chbIndex);
        this.generalPanelContents.add(this.chbColumnCHC);
        this.generalPanelContents.add(this.chbColumnFK);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() {
        try {
            ApplicationView.canLogging = false;
            this.applyNS = new ApplyNamingStandards(this.getDesign().getDLSettings().getNamingStandardRule(), this.chbColumnCHC.isSelected(), this.chbFK.isSelected(), this.chbIndex.isSelected(), this.chbPK.isSelected(), this.chbCHC.isSelected(), this.chbUC.isSelected(), this.chbColumnFK.isSelected());
            Set<Column> set = this.getFirstLevelColumns();
            for (DesignObject designObject : set) {
                this.applyColumnsNamingStandards((Column)designObject);
            }
            Iterator iterator = this.relational.getTableSet().iterator();
            while (iterator.hasNext()) {
                DesignObject designObject;
                designObject = (Table)iterator.next();
                this.applyNS.apply((Table)designObject);
            }
        }
        finally {
            ApplicationView.canLogging = true;
            if (this.relational != null) {
                this.relational.sortCollections();
            }
        }
    }

    private Set<Column> getFirstLevelColumns() {
        HashSet<Column> hashSet = new HashSet<Column>();
        Iterator iterator = this.relational.getColumnSet().iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.isFKColumn() || column.getDelegate().isFKColumn()) continue;
            hashSet.add(column);
        }
        return hashSet;
    }

    protected void applyColumnsNamingStandards(Column column) {
        Table table = (Table)column.getParent();
        this.applyNS.apply(table);
        for (Column column2 : this.getReferencingColumns(column)) {
            this.applyColumnsNamingStandards(column2);
        }
    }

    protected Set<Column> getReferencingColumns(Column column) {
        HashSet<Column> hashSet = new HashSet<Column>();
        Iterator iterator = this.relational.getColumnSet().iterator();
        while (iterator.hasNext()) {
            Column column2 = (Column)iterator.next();
            if (column2.getDelegate() != column) continue;
            hashSet.add(column2);
        }
        return hashSet;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.getString("KeysNamingStandards.ApplyNamingStandardsToKeysAndConstraints");
    }

    @Override
    protected Dimension getDialogPreferredSize() {
        return new Dimension(300, 200);
    }
}

