/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ForeignKeyPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = 6498069064076573019L;
    private FKIndexAssociation newFKIass;
    private FKIndexAssociation oldFKIass;
    private JTextField tfLongName;
    private JComboBox cbIndexPkUk;
    private JComboBox cbDeleteRule;
    private JComboBox cbSourceTableSynonym;
    private JComboBox cbTargetTableSynonym;
    private JCheckBox chMarkGenerate;
    private JCheckBox chMandatory;
    private JCheckBox chTransferable;
    private JCheckBox chInArc;
    private Column[] fkColumns;
    private JTable columnsTable;
    private JPanel pnColumns;
    private JTree tree;
    private FKIndexAssociation.FKMemento mem;
    private FKIndexAssociation.FKMemento memBackup;
    private static final Dimension defaultSize = new Dimension(200, 20);
    private DesignObject obj;
    private static final Logger LOGGER = new Logger(ForeignKeyPropertiesDialogEx.class);
    private KeyObject currentKey = null;
    private Action statusChanged = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StorageDesign storageDesign = ((RelationalDesign)ForeignKeyPropertiesDialogEx.this.oldFKIass.getDesignPart()).getStorageDesign();
            Object object = ForeignKeyPropertiesDialogEx.this.cbDeleteRule.getSelectedItem();
            ForeignKeyPropertiesDialogEx.this.cbDeleteRule.removeAllItems();
            if (!ForeignKeyPropertiesDialogEx.this.chTransferable.isSelected()) {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(storageDesign.getFKDeleteRulesNonTransferable(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                if ("CASCADE".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("CASCADE");
                } else {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("RESTRICT");
                }
            } else if (ForeignKeyPropertiesDialogEx.this.chMandatory.isSelected()) {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(storageDesign.getFKDeleteRulesMandatory(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                if ("SET NULL".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("RESTRICT");
                } else if ("SET DEFAULT".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(storageDesign.getValidFKRule("SET DEFAULT"));
                } else {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(storageDesign.getValidFKRule((String)object));
                }
            } else {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(storageDesign.getFKDeleteRules(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(storageDesign.getValidFKRule((String)object));
            }
        }
    };

    public ForeignKeyPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
        this.obj = designObject;
    }

    public ForeignKeyPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject, FKIndexAssociation.FKMemento fKMemento) {
        super(dialog, applicationView, fKMemento.fk);
        this.initGeneral();
        this.obj = designObject;
        this.mem = fKMemento;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ForeignKeyPropertiesDialogEx.ForeignKeyProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof FKIndexAssociation) {
            this.oldFKIass = (FKIndexAssociation)designObject;
            this.obj.setShowForFirstTime(true);
            this.newFKIass = new FKIndexAssociation(this.oldFKIass.getDesignPart());
            this.newFKIass.setContainerWithKeyObject(this.oldFKIass.getContainerWithKeyObject());
            this.initDefaults(false);
            this.initSummaryExtras();
            this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getName());
            Object[] objectArray = ((RelationalDesign)this.oldFKIass.getDesignPart()).getGlobalIndexSet().getPKUK();
            Arrays.sort(objectArray, ModelObjectSet.LONG_NAME_COMPARATOR);
            this.fillComboItems(objectArray, this.cbIndexPkUk, false);
            this.cbIndexPkUk.setSelectedItem(this.oldFKIass.getKeyObject());
            this.currentKey = this.oldFKIass.getKeyObject();
            if (this.oldFKIass != null && (this.oldFKIass.getContainerWithKeyObject().getBasedOnStructuredType() != null || this.oldFKIass.getRemoteTable().getBasedOnStructuredType() != null)) {
                this.cbIndexPkUk.setEnabled(false);
            }
            this.cbIndexPkUk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KeyObject keyObject = (KeyObject)ForeignKeyPropertiesDialogEx.this.cbIndexPkUk.getSelectedItem();
                    if (ForeignKeyPropertiesDialogEx.this.currentKey != keyObject) {
                        ForeignKeyPropertiesDialogEx.this.currentKey = keyObject;
                        ForeignKeyPropertiesDialogEx.this.initParentChildColumns(keyObject);
                        ForeignKeyPropertiesDialogEx.this.columnsTable.updateUI();
                        TopView topView = (TopView)ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.getSelectedItem();
                        TopViewCollection topViewCollection = keyObject.getContainerWithKeyObject().getViewsForDPV(topView.getDesignPartView());
                        ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setModel(new DefaultComboBoxModel<Object>(topViewCollection.toArray()));
                        if (topViewCollection.size() > 0) {
                            ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setSelectedItem(topViewCollection.get(0));
                        }
                    }
                }
            });
            StorageDesign storageDesign = ((RelationalDesign)this.oldFKIass.getDesignPart()).getStorageDesign();
            if (!this.oldFKIass.isTransferable()) {
                this.fillComboItems(storageDesign.getFKDeleteRulesNonTransferable(), this.cbDeleteRule, false);
            } else if (this.oldFKIass.isMandatory()) {
                this.fillComboItems(storageDesign.getFKDeleteRulesMandatory(), this.cbDeleteRule, false);
            } else {
                this.fillComboItems(storageDesign.getFKDeleteRules(), this.cbDeleteRule, false);
            }
            this.cbDeleteRule.setSelectedItem(storageDesign.getValidFKRule(this.oldFKIass.getDeleteRule()));
            DesignPartView designPartView = this.getAppView().getCurrentDPV();
            if (this.oldFKIass.getRemoteTable().getDesignPart() != designPartView.getDesignPart()) {
                designPartView = this.oldFKIass.getRemoteTable().getDesignPart().getMainView();
            }
            this.fillComboItems(this.oldFKIass.getRemoteTable().getViewsForDPV(designPartView).toArray(), this.cbSourceTableSynonym, false);
            this.cbSourceTableSynonym.setSelectedItem(this.oldFKIass.getSourceTV(designPartView));
            designPartView = this.getAppView().getCurrentDPV();
            if (this.oldFKIass.getContainerWithKeyObject().getDesignPart() != designPartView.getDesignPart()) {
                designPartView = this.oldFKIass.getContainerWithKeyObject().getDesignPart().getMainView();
            }
            this.fillComboItems(this.oldFKIass.getContainerWithKeyObject().getViewsForDPV(designPartView).toArray(), this.cbTargetTableSynonym, false);
            this.cbTargetTableSynonym.setSelectedItem(this.oldFKIass.getTargetTV(designPartView));
            this.chMarkGenerate.setSelected(this.oldFKIass.getLocalFKIndex().isMarkedGenerate());
            this.chMandatory.setSelected(this.oldFKIass.isMandatory());
            this.chTransferable.setSelected(this.oldFKIass.isTransferable());
            this.chInArc.setSelected(this.oldFKIass.isInArc());
            this.initParentChildColumns();
            if (this.oldFKIass.isInArc() || FKUtilities.hasPKColumnsOnly(this.oldFKIass)) {
                this.chMandatory.setEnabled(false);
            }
            this.chMandatory.addActionListener(this.statusChanged);
            this.chTransferable.addActionListener(this.statusChanged);
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.oldFKIass.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.oldFKIass.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void initDefaults(FKIndexAssociation.FKMemento fKMemento) {
        this.tfName.setText(fKMemento.name);
        this.taComments.setText(fKMemento.comments);
        this.taNotes.setText(fKMemento.notes);
        this.tfObjectID.setText(fKMemento.id);
        this.tfCreationTime.setText(this.oldFKIass.getCreationTime());
        this.tfCreator.setText(this.oldFKIass.getCreator().getName());
        this.tfDesign.setText(this.oldFKIass.getOwnerDesignName());
        if (this.oldFKIass.getGenerator() != null) {
            this.tfGeneratorName.setText(this.oldFKIass.getGeneratorLongName());
        } else {
            this.tfGeneratorName.setText(NONE);
        }
        this.tfLastChangedBy.setText(this.oldFKIass.getChanger().getName());
        this.tfLastChangedTime.setText(this.oldFKIass.getChangeTime());
    }

    public void initProperties(FKIndexAssociation.FKMemento fKMemento) {
        this.oldFKIass = fKMemento.fk;
        this.mem = fKMemento;
        FKIndexAssociation fKIndexAssociation = fKMemento.fk;
        fKIndexAssociation.getClass();
        this.memBackup = fKIndexAssociation.new FKIndexAssociation.FKMemento(fKMemento.fk);
        fKMemento.copyTo(this.memBackup);
        this.obj.setShowForFirstTime(false);
        this.initDefaults(fKMemento);
        this.initSummaryExtras();
        this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getName());
        Object[] objectArray = ((RelationalDesign)this.oldFKIass.getDesignPart()).getGlobalIndexSet().getPKUK();
        Arrays.sort(objectArray, ModelObjectSet.LONG_NAME_COMPARATOR);
        this.fillComboItems(objectArray, this.cbIndexPkUk, false);
        this.cbIndexPkUk.setSelectedItem(fKMemento.remoteKey);
        this.currentKey = fKMemento.remoteKey;
        if (this.oldFKIass != null && (this.oldFKIass.getContainerWithKeyObject().getBasedOnStructuredType() != null || fKMemento.remoteTable.getBasedOnStructuredType() != null)) {
            this.cbIndexPkUk.setEnabled(false);
        }
        this.cbIndexPkUk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyObject keyObject = (KeyObject)ForeignKeyPropertiesDialogEx.this.cbIndexPkUk.getSelectedItem();
                if (ForeignKeyPropertiesDialogEx.this.currentKey != keyObject) {
                    ForeignKeyPropertiesDialogEx.this.currentKey = keyObject;
                    ForeignKeyPropertiesDialogEx.this.initParentChildColumns(keyObject);
                    ForeignKeyPropertiesDialogEx.this.columnsTable.updateUI();
                    TopView topView = (TopView)ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.getSelectedItem();
                    TopViewCollection topViewCollection = keyObject.getContainerWithKeyObject().getViewsForDPV(topView.getDesignPartView());
                    ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setModel(new DefaultComboBoxModel<Object>(topViewCollection.toArray()));
                    if (topViewCollection.size() > 0) {
                        ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setSelectedItem(topViewCollection.get(0));
                    }
                }
            }
        });
        StorageDesign storageDesign = ((RelationalDesign)this.oldFKIass.getDesignPart()).getStorageDesign();
        if (!fKMemento.mandatory) {
            this.fillComboItems(storageDesign.getFKDeleteRulesNonTransferable(), this.cbDeleteRule, false);
        } else if (this.oldFKIass.isMandatory()) {
            this.fillComboItems(storageDesign.getFKDeleteRulesMandatory(), this.cbDeleteRule, false);
        } else {
            this.fillComboItems(storageDesign.getFKDeleteRules(), this.cbDeleteRule, false);
        }
        this.cbDeleteRule.setSelectedItem(storageDesign.getValidFKRule(fKMemento.deleteRule));
        DesignPartView designPartView = this.getAppView().getCurrentDPV();
        Table table = this.oldFKIass.getRemoteTable();
        if (designPartView != null && table != null && this.oldFKIass.getRemoteTable().getDesignPart() != designPartView.getDesignPart() || designPartView == null) {
            designPartView = this.oldFKIass.getRemoteTable().getDesignPart().getMainView();
        }
        this.fillComboItems(fKMemento.remoteTable.getViewsForDPV(designPartView).toArray(), this.cbSourceTableSynonym, false);
        this.cbSourceTableSynonym.setSelectedItem(fKMemento.sourceTV);
        this.fillComboItems(this.oldFKIass.getContainerWithKeyObject().getViewsForDPV(designPartView).toArray(), this.cbTargetTableSynonym, false);
        this.cbTargetTableSynonym.setSelectedItem(fKMemento.targetTV);
        this.chMarkGenerate.setSelected(fKMemento.generate_in_DDL);
        this.chMandatory.setSelected(fKMemento.mandatory);
        this.chTransferable.setSelected(fKMemento.transferable);
        this.chInArc.setSelected(fKMemento.arc != null);
        this.initParentChildColumns();
        if (this.oldFKIass.isInArc() || FKUtilities.hasPKColumnsOnly(this.oldFKIass)) {
            this.chMandatory.setEnabled(false);
        }
        this.chMandatory.addActionListener(this.statusChanged);
        this.chTransferable.addActionListener(this.statusChanged);
        this.dynamicPropertiesList.clear();
        Iterator iterator = this.oldFKIass.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.oldFKIass.getProperty(string);
            DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
            this.dynamicPropertiesList.add(dynamicProperty);
        }
        this.dynamicPropertiesTable.updateUI();
    }

    private void initParentChildColumns() {
        if (this.mem != null) {
            Index index;
            this.fkColumns = FKUtilities.getFKColumns(this.mem);
            if (this.fkColumns.length == 0 && (index = this.mem.fk.getRemoteIndex()) != null && index.getElementsCollection().size() > 0) {
                this.fkColumns = new Column[index.getElementsCollection().size()];
            }
        } else {
            this.fkColumns = new Column[this.oldFKIass.getLocalFKIndex().getElements().length];
            Column[] columnArray = (Column[])this.oldFKIass.getLocalFKIndex().getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                this.fkColumns[i] = columnArray[i];
            }
        }
    }

    private void initParentChildColumns(KeyObject keyObject) {
        this.fkColumns = new Column[keyObject.getElements().length];
    }

    public boolean changed() {
        return this.mem != null && !this.mem.equals(this.memBackup);
    }

    @Override
    protected void setProperties() {
        try {
            ForeignKeyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
            if (this.mem != null) {
                Object object2;
                this.mem.name = this.tfName.getText();
                this.mem.comments = this.taComments.getText();
                this.mem.notes = this.taNotes.getText();
                this.mem.remoteKey = (Index)this.cbIndexPkUk.getSelectedItem();
                this.mem.deleteRule = (String)this.cbDeleteRule.getSelectedItem();
                this.mem.sourceTV = (TVTable)this.cbSourceTableSynonym.getSelectedItem();
                this.mem.targetTV = (TVTable)this.cbTargetTableSynonym.getSelectedItem();
                this.mem.generate_in_DDL = this.chMarkGenerate.isSelected();
                this.mem.mandatory = this.chMandatory.isSelected();
                this.mem.transferable = this.chTransferable.isSelected();
                this.mem.columns.clear();
                for (int i = 0; i < this.fkColumns.length; ++i) {
                    this.mem.columns.add(this.fkColumns[i].getObjectID());
                }
                this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getName());
                this.mem.fk.clearProperties();
                for (Object object2 : this.dynamicPropertiesList) {
                    this.mem.fk.setProperty(((DynamicProperty)object2).getName(), ((DynamicProperty)object2).getValue());
                }
                object2 = new FKUpdateEdit(this.mem.fk, this.mem);
                ((FKUpdateEdit)object2).applyUpdates();
                this.mem.fk.getDesignPart().postUndoableEdit((UndoableEdit)object2);
            } else {
                Object object3;
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.obj;
                fKIndexAssociation.setName(this.tfName.getText());
                fKIndexAssociation.setComment(this.taComments.getText());
                fKIndexAssociation.setNotes(this.taNotes.getText());
                fKIndexAssociation.setKeyObject((Index)this.cbIndexPkUk.getSelectedItem());
                fKIndexAssociation.setDeleteRule((String)this.cbDeleteRule.getSelectedItem());
                fKIndexAssociation.setSourceTopView((TVTable)this.cbSourceTableSynonym.getSelectedItem());
                fKIndexAssociation.setTargetTopView((TVTable)this.cbTargetTableSynonym.getSelectedItem());
                fKIndexAssociation.setMarkedGenerate(this.chMarkGenerate.isSelected());
                fKIndexAssociation.setMandatory(this.chMandatory.isSelected());
                fKIndexAssociation.setTransferable(this.chTransferable.isSelected());
                fKIndexAssociation.changeKeyObject((KeyObject)this.cbIndexPkUk.getSelectedItem(), this.fkColumns);
                fKIndexAssociation.clearProperties();
                for (Object object3 : this.dynamicPropertiesList) {
                    fKIndexAssociation.setProperty(((DynamicProperty)object3).getName(), ((DynamicProperty)object3).getValue());
                }
                object3 = new FKUpdateEdit(fKIndexAssociation, this.mem);
                ((FKUpdateEdit)object3).apply();
                fKIndexAssociation.getDesignPart().postUndoableEdit((UndoableEdit)object3);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error setting FK's properties!", exception);
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getColumnsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "FOREIGN_KEY_PROPERTIES_DIALOG";
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    private void initGeneral() {
        this.lbName.setPreferredSize(defaultSize);
        JLabel jLabel = new JLabel(LB_TABLE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfLongName));
        JLabel jLabel2 = new JLabel(LB_INDEX_PK_UK);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbIndexPkUk = new JComboBox();
        this.cbIndexPkUk.setPreferredSize(this.getDefaultSize());
        this.cbIndexPkUk.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbIndexPkUk));
        JLabel jLabel3 = new JLabel(LB_DELETE_RULE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbDeleteRule = new JComboBox();
        this.cbDeleteRule.setPreferredSize(this.getDefaultSize());
        this.cbDeleteRule.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbDeleteRule));
        JLabel jLabel4 = new JLabel(LB_SOURCE_TABLE_SYNONYM);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbSourceTableSynonym = new JComboBox();
        this.cbSourceTableSynonym.setPreferredSize(this.getDefaultSize());
        this.cbSourceTableSynonym.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbSourceTableSynonym));
        JLabel jLabel5 = new JLabel(LB_TARGET_TABLE_SYNONYM);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.cbTargetTableSynonym = new JComboBox();
        this.cbTargetTableSynonym.setPreferredSize(this.getDefaultSize());
        this.cbTargetTableSynonym.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbTargetTableSynonym));
        JLabel jLabel6 = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.Mandatory"));
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.chMandatory = new JCheckBox();
        this.chMandatory.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.chMandatory));
        JLabel jLabel7 = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.TransferableUpdatable"));
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.chTransferable = new JCheckBox();
        this.chTransferable.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.chTransferable));
        JLabel jLabel8 = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.GenerateInDDL"));
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.chMarkGenerate));
        JLabel jLabel9 = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.InArc"));
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.chInArc = new JCheckBox();
        this.chInArc.setPreferredSize(this.getDefaultSize());
        this.chInArc.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel9, this.chInArc));
    }

    protected JTable getColumnsTable() {
        if (this.columnsTable == null) {
            this.columnsTable = new JTable(new SwaperTableModel());
            this.columnsTable.getColumnModel().getColumn(1).setCellEditor(new ColumnSwapCB());
        }
        return this.columnsTable;
    }

    protected JPanel getColumnsPanel() {
        if (this.pnColumns == null) {
            this.pnColumns = this.createPage(Messages.getString("ForeignKeyPropertiesDialogEx.AssociatedColumns"));
            this.pnColumns.add(new JScrollPane(this.getColumnsTable()));
        }
        return this.pnColumns;
    }

    public boolean hasColumnWithAllowNulls() {
        for (int i = 0; i < this.fkColumns.length; ++i) {
            if (this.fkColumns[i] == null || !this.fkColumns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            return FKUtilities.checkRequiredProperties((Component)Ide.getMainWindow(), this.fkColumns, this.oldFKIass, this.chMandatory.isSelected(), this.chTransferable.isSelected());
        }
        return false;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = ForeignKeyPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (ForeignKeyPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            ForeignKeyPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            ForeignKeyPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_FKAssociation(this.getFK_ForIA(), null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    private FKIndexAssociation getFK_ForIA() {
        String string = this.oldFKIass.getObjectID();
        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)((RelationalDesign)this.oldFKIass.getDesignPart()).getFKIndexAssociationSet().getObjectByID(string);
        if (fKIndexAssociation == null) {
            fKIndexAssociation = this.oldFKIass;
        }
        return fKIndexAssociation;
    }

    @Override
    protected int getMinimumHeight() {
        return 430;
    }

    public FKIndexAssociation.FKMemento getFKMemento() {
        return this.mem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCancel() {
        if (this.obj.showForFirstTime()) {
            try {
                if (this.obj instanceof FKIndexAssociation) {
                    ((FKIndexAssociation)this.obj).setSilentRemove(true);
                }
                this.obj.remove();
            }
            finally {
                if (this.obj instanceof FKIndexAssociation) {
                    ((FKIndexAssociation)this.obj).setSilentRemove(false);
                }
            }
        }
        this.mem = this.memBackup;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    @Deprecated
    class ColumnSwapCB
    extends DefaultCellEditor {
        JComboBox cbox;

        ColumnSwapCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Column column = (Column)ForeignKeyPropertiesDialogEx.this.currentKey.getElement(n);
            this.cbox.setModel(new DefaultComboBoxModel<Column>(ForeignKeyPropertiesDialogEx.this.oldFKIass.getCompatibleColumns(column)));
            if (n < ForeignKeyPropertiesDialogEx.this.fkColumns.length) {
                this.cbox.setSelectedItem(ForeignKeyPropertiesDialogEx.this.fkColumns[n]);
            }
            return this.cbox;
        }
    }

    @Deprecated
    class SwaperTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2492399919912325068L;
        final String[] COL_NAMES = new String[]{Messages.getString("ForeignKeyPropertiesDialogEx.ParentColumn"), Messages.getString("ForeignKeyPropertiesDialogEx.ChildColumn")};

        SwaperTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (ForeignKeyPropertiesDialogEx.this.currentKey != null && ForeignKeyPropertiesDialogEx.this.currentKey.getElements() != null) {
                return ForeignKeyPropertiesDialogEx.this.currentKey.getElements().length;
            }
            return 0;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ForeignKeyPropertiesDialogEx.this.currentKey.getElements()[n];
            }
            if (ForeignKeyPropertiesDialogEx.this.fkColumns.length > 0 && n < ForeignKeyPropertiesDialogEx.this.fkColumns.length) {
                return ForeignKeyPropertiesDialogEx.this.fkColumns[n];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                ((ForeignKeyPropertiesDialogEx)ForeignKeyPropertiesDialogEx.this).fkColumns[n] = (Column)object;
            }
        }
    }
}

