/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class FKUtilities {
    public static String generateFKName(FKIndexAssociation fKIndexAssociation, int n) {
        Table table = (Table)fKIndexAssociation.getSourceObject();
        Table table2 = (Table)fKIndexAssociation.getTargetObject();
        String string = table2.getName();
        NamingStandardRule namingStandardRule = table2.getDesign().getDLSettings().getNamingStandardRule();
        String string2 = table2.getDesignPart().getName();
        String string3 = table2.getAbbreviation();
        return ApplyNamingStandards.createFK_Name(string, table, n, namingStandardRule, string2, string3);
    }

    public static String generateFKName(Table table, Table table2, List<FKIndexAssociation.FKMemento> list) {
        String string = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDLSettings().getNamingStandardRule();
        String string2 = table.getDesignPart().getName();
        String string3 = table.getAbbreviation();
        String string4 = "";
        String string5 = null;
        int n = list.size();
        while (!(string4 = ApplyNamingStandards.createFK_Name(string, table2, n, namingStandardRule, string2, string3)).equals(string5)) {
            string5 = string4;
            ++n;
            if (FKUtilities.hasFK_Name(list, string4)) continue;
        }
        return string4;
    }

    public static boolean hasFK_Name(List<FKIndexAssociation.FKMemento> list, String string) {
        for (FKIndexAssociation.FKMemento fKMemento : list) {
            if (!fKMemento.name.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static String generateFKName(Table table, Table table2, KeyObject keyObject) {
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        int n = fKIndexAssociationArray.length - 1;
        String string = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDLSettings().getNamingStandardRule();
        String string2 = table.getDesignPart().getName();
        String string3 = table.getAbbreviation();
        String string4 = "";
        String string5 = null;
        while (!(string4 = ApplyNamingStandards.createFK_Name(string, table2, keyObject, n, namingStandardRule, string2, string3)).equals(string5)) {
            string5 = string4;
            ++n;
            if (FKUtilities.hasFK_Name(fKIndexAssociationArray, string4)) continue;
        }
        return string4;
    }

    public static boolean hasFK_Name(FKIndexAssociation[] fKIndexAssociationArray, String string) {
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (!fKIndexAssociationArray[i].getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean compatibleColumns(Column column, Column column2) {
        if (column.isOid() && column.getContainerWithKeyObject().getBasedOnStructuredType() != null) {
            return column2.isRefToStructuredType(column.getContainerWithKeyObject().getBasedOnStructuredType());
        }
        return column.getDataType().getName().equalsIgnoreCase(column2.getDataType().getName());
    }

    public static boolean hasPKColumns(FKIndexAssociation fKIndexAssociation) {
        KeyObject keyObject = fKIndexAssociation.getContainerWithKeyObject().getPK();
        if (keyObject != null && fKIndexAssociation.getLocalFKIndex() != null) {
            for (ContainedObject containedObject : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                if (!keyObject.contains(containedObject)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPKColumnsOnly(FKIndexAssociation fKIndexAssociation) {
        KeyObject keyObject = fKIndexAssociation.getContainerWithKeyObject().getPK();
        if (keyObject == null) {
            return false;
        }
        if (keyObject != null && fKIndexAssociation.getLocalFKIndex() != null) {
            for (ContainedObject containedObject : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                if (keyObject.contains(containedObject)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasPKColumnsOnly(FKIndexAssociation fKIndexAssociation, Column[] columnArray) {
        KeyObject keyObject = fKIndexAssociation.getContainerWithKeyObject().getPK();
        if (keyObject == null) {
            return false;
        }
        if (keyObject != null && fKIndexAssociation.getLocalFKIndex() != null) {
            for (Column column : columnArray) {
                if (keyObject.contains(column)) continue;
                return false;
            }
        }
        return true;
    }

    public static Column[] getCompatibleColumns(ContainerWithKeyObject containerWithKeyObject, Column column) {
        return FKUtilities.getCompatibleColumns(containerWithKeyObject.getElementsCollection(), column);
    }

    public static Column[] getCompatibleColumns(Collection<Column> collection, Column column) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column2 : collection) {
            if (!FKUtilities.compatibleColumns(column, column2)) continue;
            arrayList.add(column2);
        }
        return arrayList.toArray(new Column[0]);
    }

    public static boolean hasMandatoryColumns(Column[] columnArray) {
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRequiredProperties(Component component, Column[] columnArray, FKIndexAssociation fKIndexAssociation, boolean bl, boolean bl2) {
        int n;
        if (columnArray == null || columnArray.length == 0) {
            JOptionPane.showMessageDialog(component, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.IncompleteFKdefinition", fKIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsAssignment"), 0);
            return false;
        }
        for (n = 0; n < columnArray.length; ++n) {
            if (columnArray[n] != null) continue;
            JOptionPane.showMessageDialog(component, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.IncompleteFKdefinition", fKIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsAssignment"), 0);
            return false;
        }
        if (FKUtilities.hasPKColumnsOnly(fKIndexAssociation, columnArray) && !bl) {
            JOptionPane.showMessageDialog(component, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.FKCannotBeOptional", fKIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsInPK"), 0);
            return false;
        }
        if (FKUtilities.hasMandatoryColumns(columnArray) && !bl) {
            n = JOptionPane.showConfirmDialog(component, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.FKIsOptional", fKIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.MandatoryFKColumns"), 0);
            return n == 0;
        }
        for (n = 0; n < columnArray.length; ++n) {
            for (FKIndexAssociation fKIndexAssociation2 : columnArray[n].getAllFKs()) {
                if (fKIndexAssociation2 == fKIndexAssociation || fKIndexAssociation2.isTransferable() == bl2) continue;
                JOptionPane.showMessageDialog(component, MessageFormat.format(FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.Column", fKIndexAssociation.getName()), columnArray[n].getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnCollisionalUsage"), 0);
                return false;
            }
        }
        return true;
    }

    public static String formatMessage(String string, String string2) {
        return MessageFormat.format(Messages.getString(string), string2);
    }

    public static Column[] getFKColumns(FKIndexAssociation.FKMemento fKMemento) {
        return FKUtilities.getFKColumns(fKMemento, null);
    }

    public static Column[] getFKColumns(FKIndexAssociation.FKMemento fKMemento, List<Column> list) {
        Column[] columnArray = new Column[fKMemento.columns.size()];
        for (int i = 0; i < fKMemento.columns.size(); ++i) {
            String string = fKMemento.columns.get(i);
            Column column = null;
            if (string != null && (column = (Column)fKMemento.table.getElementByID(string)) == null && list != null) {
                column = FKUtilities.getColumn(string, list);
            }
            columnArray[i] = column;
        }
        return columnArray;
    }

    public static Column[] getFKColumnsFromTable(FKIndexAssociation.FKMemento fKMemento, Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < fKMemento.columns.size(); ++i) {
            String string = fKMemento.columns.get(i);
            Column column = null;
            if (string == null || (column = (Column)table.getElementByID(string)) == null) continue;
            arrayList.add(column);
        }
        return arrayList.toArray(new Column[0]);
    }

    public static Column getColumn(String string, List<Column> list) {
        for (Column column : list) {
            if (!string.equals(column.getObjectID())) continue;
            return column;
        }
        return null;
    }

    public static boolean containsEmptyColumns(FKIndexAssociation.FKMemento fKMemento) {
        if (fKMemento.columns.isEmpty()) {
            return true;
        }
        for (String string : fKMemento.columns) {
            if (string != null && !string.equals("")) continue;
            return true;
        }
        return false;
    }
}

