/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKColumnsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3606942481591565508L;
    final String[] COL_NAMES = new String[]{Messages.getString("FKColumnsTableModel.ReferencedColumn"), Messages.getString("FKColumnsTableModel.Column")};
    private Column[] fkColumns;
    private KeyObject currentKey;

    public FKColumnsTableModel() {
        this(null, null);
    }

    public Column[] getFkColumns() {
        return this.fkColumns;
    }

    public FKColumnsTableModel(Column[] columnArray, KeyObject keyObject) {
        this.fkColumns = columnArray;
        this.currentKey = keyObject;
    }

    public void init(KeyObject keyObject) {
        this.currentKey = keyObject;
    }

    public void init(Column[] columnArray, KeyObject keyObject) {
        this.fkColumns = columnArray;
        this.currentKey = keyObject;
    }

    @Override
    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        if (this.currentKey != null && this.currentKey.getElements() != null) {
            return this.currentKey.getElements().length;
        }
        return 0;
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int n) {
        return this.COL_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.currentKey.getElements()[n];
        }
        if (this.fkColumns != null && this.fkColumns.length > 0 && n < this.fkColumns.length) {
            return this.fkColumns[n];
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            this.fkColumns[n] = (Column)object;
        }
    }
}

