/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;

public class FKColumnsCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -238454750200950513L;
    private JComboBox cbox = (JComboBox)this.getComponent();
    private Column[] fkColumns;
    private KeyObject referencedKey;
    private Collection<Column> referencingTableColumns;

    public FKColumnsCellEditor(Collection<Column> collection) {
        super(new JComboBox());
        this.cbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Column column = (Column)FKColumnsCellEditor.this.cbox.getSelectedItem();
                if (column != null) {
                    FKColumnsCellEditor.this.onSelectedColumnChanged(column);
                }
            }
        });
        this.referencingTableColumns = collection;
    }

    public void init(KeyObject keyObject) {
        this.referencedKey = keyObject;
        ((JComboBox)this.getComponent()).setSelectedItem(null);
    }

    public void init(Column[] columnArray, KeyObject keyObject) {
        this.fkColumns = columnArray;
        this.init(keyObject);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Column column = (Column)this.referencedKey.getElement(n);
        this.cbox.setModel(new DefaultComboBoxModel<Column>(FKUtilities.getCompatibleColumns(this.referencingTableColumns, column)));
        if (this.fkColumns != null && this.fkColumns.length > n) {
            this.cbox.setSelectedItem(this.fkColumns[n]);
        }
        return this.cbox;
    }

    public void onSelectedColumnChanged(Column column) {
    }
}

