/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKArcPropertiesDialogEx
extends AbstractPropertiesDialog {
    private FKArc arc;
    private JTextField tfTable;
    private JPanel pnFKeys;
    private List rList;
    private JTable rTable;
    private JCheckBox chGenerateInDDL;
    private JCheckBox chMandatory;

    public FKArcPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKArcPropertiesDialogEx.ArcProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "ARC_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof FKArc) {
            Object object;
            this.arc = (FKArc)designObject;
            this.initDefaults(false);
            this.tfTable.setText(this.arc.getTable().getName());
            Object[] objectArray = this.arc.getFkeys().toArray();
            Arrays.sort(objectArray, new FKeyComparator());
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                this.rList.add(object);
            }
            this.chMandatory.setSelected(this.arc.isMandatory());
            this.chGenerateInDDL.setSelected(this.arc.isMarkedGenerate());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.arc.getPropertyNames();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = this.arc.getProperty((String)object);
                DynamicProperty dynamicProperty = new DynamicProperty((String)object, string);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_TABLE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfTable = new JTextField();
        this.tfTable.setPreferredSize(this.getDefaultSize());
        this.tfTable.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfTable));
        JLabel jLabel2 = new JLabel(LB_MANDATORY);
        this.chMandatory = new JCheckBox();
        String string = Messages.getString("FKArcPropertiesDialogEx.OneFKRreferenceShouldBeValid");
        jLabel2.setToolTipText(string);
        this.chMandatory.setToolTipText(string);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chMandatory.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chMandatory));
        JLabel jLabel3 = new JLabel(LB_GENERATE);
        this.chGenerateInDDL = new JCheckBox();
        String string2 = Messages.getString("FKArcPropertiesDialogEx.TriggersThatForceArcConstraintIncluded");
        jLabel3.setToolTipText(string2);
        this.chGenerateInDDL.setToolTipText(string2);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chGenerateInDDL.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chGenerateInDDL));
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getFKeysPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.arc.setName(this.tfName.getText());
        this.arc.setComment(this.taComments.getText());
        this.arc.setNotes(this.taNotes.getText());
        this.arc.setMandatory(this.chMandatory.isSelected());
        this.arc.setMarkedGenerate(this.chGenerateInDDL.isSelected());
        FKArcPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.arc.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.arc.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    protected JPanel getFKeysPanel() {
        if (this.pnFKeys == null) {
            this.pnFKeys = this.createPage(Messages.getString("FKArcPropertiesDialogEx.ForeignKeys"));
            this.rList = new ArrayList();
            this.rTable = new JTable(new FKeyModel());
            this.rTable.setSelectionMode(0);
            this.rTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    FKIndexAssociation fKIndexAssociation;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = FKArcPropertiesDialogEx.this.rTable.getSelectedRow()) != -1 && FKArcPropertiesDialogEx.this.rList.size() > 0 && n < FKArcPropertiesDialogEx.this.rList.size() && !(fKIndexAssociation = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(n)).isDialogVisible()) {
                        fKIndexAssociation.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.rTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FKIndexAssociation fKIndexAssociation;
                    int n = FKArcPropertiesDialogEx.this.rTable.getSelectedRow();
                    if (n != -1 && FKArcPropertiesDialogEx.this.rList.size() > 0 && n < FKArcPropertiesDialogEx.this.rList.size() && !(fKIndexAssociation = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(n)).isDialogVisible()) {
                        fKIndexAssociation.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnFKeys.add(jPanel2);
        }
        return this.pnFKeys;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class FKeyModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return FKArcPropertiesDialogEx.this.rList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("FKArcPropertiesDialogEx.FKName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(n);
            if (n2 == 0) {
                return fKIndexAssociation.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class FKeyComparator
    implements Comparator {
        private FKeyComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((FKIndexAssociation)object).getName().compareTo(((FKIndexAssociation)object2).getName());
        }
    }
}

