/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class ColumnGroupsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6357265181047614176L;
    protected static final String[] COLUMN_NAMES = new String[]{" ", Messages.getString("ColumnGroupsTable.Name")};
    protected List<Table.ColumnGroup> columnGroupList;
    protected Component parent;

    public ColumnGroupsTableModel(List<Table.ColumnGroup> list, Component component) {
        this.columnGroupList = list;
        this.parent = component;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.columnGroupList.size();
    }

    public String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnNames()[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Table.ColumnGroup columnGroup = this.columnGroupList.get(n);
        if (n2 == 0) {
            return new Integer(n + 1);
        }
        if (n2 == 1) {
            return columnGroup.getName();
        }
        return new Integer(n + 1);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Table.ColumnGroup columnGroup = this.columnGroupList.get(n);
        if (n2 == 1) {
            columnGroup.setName(object.toString());
        }
    }

    public void clearList() {
        this.columnGroupList.clear();
    }

    public List<Table.ColumnGroup> getColumnGroupList() {
        return this.columnGroupList;
    }

    public void setColumnGroupList(List<Table.ColumnGroup> list) {
        this.columnGroupList = list;
    }
}

