/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.relational.AbstractColumnGroupsPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class ColumnGroupColumnsPanel
extends AbstractColumnGroupsPanel {
    private static final long serialVersionUID = 7046246439014784518L;
    private static final int PREFERRED_HEIGHT = 145;
    private static final int PREFERRED_WIDTH = 145;
    private static final String COLUMNS = Messages.getString("ColumnGroupColumnsPanel.Columns");
    private JPanel mainPanel;
    private JButton btnAddColumns;
    private JButton btnRemoveColumns;
    private JList allColumnsList;
    private JPanel buttonsPanel;
    private JToolBar toolBar;
    private DefaultListModel allColumnsModel;
    private List<Column> selectedColumnsList;
    private JPanel pnSelected;
    private JTable selectedColumnsTable;
    private JScrollPane selectedColumnsScrollPane;
    private JScrollPane allColumnsScrollPane;
    private JPanel pnAttributes;

    public ColumnGroupColumnsPanel(Table.ColumnGroup columnGroup, boolean bl, int n, boolean bl2) {
        super(columnGroup, bl, n, bl2);
    }

    @Override
    protected void init(List<Column> list) {
        this.allColumnsModel.clear();
        for (Column column : list) {
            if (this.selectedColumnsList.contains(column)) continue;
            this.allColumnsModel.addElement(column);
        }
    }

    @Override
    public void init(Table.ColumnGroup columnGroup, List<Column> list, List<Column> list2) {
        this.selectedColumnsList.clear();
        List<String> list3 = columnGroup.getColumns();
        for (int i = 0; i < list3.size(); ++i) {
            String string = list3.get(i);
            for (Column column : list) {
                if (!column.getObjectID().equalsIgnoreCase(string)) continue;
                this.selectedColumnsList.add(column);
            }
        }
        this.init(list2);
        ((SelectedColumnsModel)this.selectedColumnsTable.getModel()).fireTableDataChanged();
    }

    public List<Column> getSelectedColumns() {
        return this.selectedColumnsList;
    }

    @Override
    protected void createUIComponents() {
        this.setLayout(new BorderLayout(0, 10));
        this.setName(COLUMNS);
        this.setBorder(BorderFactory.createTitledBorder(COLUMNS));
        this.selectedColumnsList = new ArrayList<Column>();
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setEnabled(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.buttonsSize));
        this.btnRemoveColumns = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.buttonsSize));
        this.buttonsPanel = new JPanel();
        this.toolBar = new JToolBar(1);
        this.toolBar.add(this.btnAddColumns);
        this.toolBar.add(this.btnRemoveColumns);
        this.buttonsPanel.add(this.toolBar);
        this.selectedColumnsTable = new JTable(new SelectedColumnsModel());
        this.selectedColumnsScrollPane = new JScrollPane(this.selectedColumnsTable);
        this.selectedColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnSelected = new JPanel(new BorderLayout());
        this.pnSelected.add(this.selectedColumnsScrollPane);
        this.allColumnsScrollPane = new JScrollPane(this.allColumnsList);
        this.allColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnAttributes = new JPanel(new BorderLayout());
        this.pnAttributes.add(this.allColumnsScrollPane);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        this.mainPanel.add(this.pnAttributes);
        this.mainPanel.add(this.buttonsPanel);
        this.mainPanel.add(this.pnSelected);
        this.add(this.mainPanel);
    }

    @Override
    protected void initUIComponents() {
        this.allColumnsList.getSelectionModel().addListSelectionListener(new AllColumnsListSelectionListener());
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new SelectedColumnsListSelectionListener());
        this.initColumnsButtons(this.mainPanel);
        this.initSelectedColumnsList(this.mainPanel);
    }

    private void initSelectedColumnsList(JPanel jPanel) {
        TableColumn tableColumn = this.selectedColumnsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(220);
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        });
    }

    private void initColumnsButtons(JPanel jPanel) {
        this.toolBar.setFloatable(false);
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("ColumnGroupColumnsPanel.Add"));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("ColumnGroupColumnsPanel.Remove"));
    }

    public void onAddColumn(Column column) {
    }

    public void onRemoveColumn(Column column) {
    }

    private boolean moveToIndex(Object object, int n) {
        if (this.selectedColumnsList.contains(object) && this.selectedColumnsList.size() > n && n >= 0) {
            this.selectedColumnsList.remove(object);
            this.selectedColumnsList.add(n, (Column)object);
            return true;
        }
        return false;
    }

    public JTable getSelectedColumnsTable() {
        return this.selectedColumnsTable;
    }

    public void setSelectedColumnsTable(JTable jTable) {
        this.selectedColumnsTable = jTable;
    }

    public JScrollPane getAllColumnsScrollPane() {
        return this.allColumnsScrollPane;
    }

    public void setAllColumnsScrollPane(JScrollPane jScrollPane) {
        this.allColumnsScrollPane = jScrollPane;
    }

    public JList getAllColumnsList() {
        return this.allColumnsList;
    }

    public void setAllColumnsList(JList jList) {
        this.allColumnsList = jList;
    }

    public List<Column> getSelectedColumnsList() {
        return this.selectedColumnsList;
    }

    public void setSelectedColumnsList(List<Column> list) {
        this.selectedColumnsList = list;
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < ColumnGroupColumnsPanel.this.selectedColumnsList.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = ColumnGroupColumnsPanel.this.selectedColumnsList.get(n);
                    ColumnGroupColumnsPanel.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
                ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = ColumnGroupColumnsPanel.this.selectedColumnsList.get(n);
                    ColumnGroupColumnsPanel.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
                ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        }
    }

    public class SelectedColumnsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8480891404209029651L;
        private String[] COL_NAMES = new String[]{Messages.getString("ColumnGroupColumnsPanel.Column")};

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ColumnGroupColumnsPanel.this.selectedColumnsList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Column column = (Column)ColumnGroupColumnsPanel.this.selectedColumnsList.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)ColumnGroupColumnsPanel.this.selectedColumnsList.get(n);
            if (n2 == 0) {
                return column.getName();
            }
            return "";
        }

        public void clearList() {
            ColumnGroupColumnsPanel.this.selectedColumnsList.clear();
        }
    }

    private class SelectedColumnsListSelectionListener
    implements ListSelectionListener {
        private SelectedColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ColumnGroupColumnsPanel.this.editable && !listSelectionEvent.getValueIsAdjusting()) {
                if (ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionListener
    implements ListSelectionListener {
        private AllColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ColumnGroupColumnsPanel.this.editable && !listSelectionEvent.getValueIsAdjusting()) {
                if (ColumnGroupColumnsPanel.this.allColumnsList.getSelectedIndex() == -1) {
                    ColumnGroupColumnsPanel.this.btnAddColumns.setEnabled(false);
                } else {
                    ColumnGroupColumnsPanel.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            for (n = 0; n < nArray.length; ++n) {
                Column column = (Column)ColumnGroupColumnsPanel.this.selectedColumnsList.get(nArray[n]);
                if (ColumnGroupColumnsPanel.this.allColumnsModel.contains(column)) continue;
                ColumnGroupColumnsPanel.this.allColumnsModel.addElement(column);
                ColumnGroupColumnsPanel.this.allColumnsList.setSelectedValue(column, true);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                ColumnGroupColumnsPanel.this.onRemoveColumn((Column)ColumnGroupColumnsPanel.this.selectedColumnsList.remove(nArray[n]));
            }
            ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
            ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().clearSelection();
        }
    }

    public class AddColumnsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ColumnGroupColumnsPanel.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = ColumnGroupColumnsPanel.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Column column = (Column)objectArray[i];
                    if (ColumnGroupColumnsPanel.this.selectedColumnsList.contains(column)) continue;
                    ColumnGroupColumnsPanel.this.selectedColumnsList.add(column);
                    ColumnGroupColumnsPanel.this.allColumnsModel.removeElement(column);
                }
            }
            ColumnGroupColumnsPanel.this.allColumnsList.getSelectionModel().clearSelection();
            ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
            ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(ColumnGroupColumnsPanel.this.selectedColumnsTable.getRowCount() - 1, ColumnGroupColumnsPanel.this.selectedColumnsTable.getRowCount() - 1);
        }
    }
}

