/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.AddStructureDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class TransformationFlowPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JPanel pnGeneral;
    private JPanel pnGeneralGrid;
    private JTextField tfSynonym;
    private JButton bnSource;
    private TransformationFlow flow;
    private JButton bnDestination;
    private JLabel lbLoggingFlow;
    private JCheckBox chbLoggingFlow;
    private JCheckBox chbCRUDCreate;
    private JCheckBox chbCRUDRead;
    private JCheckBox chbCRUDUpdate;
    private JCheckBox chbCRUDDelete;
    private JPanel pnInfoStructure;
    private ArrayList isList;
    private JTable istable;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private JPanel pnExternalData;
    private ArrayList edList;
    private JTable edtable;
    private JButton btnExProperties;
    private JPanel pnSystemObjective;
    private JTextArea taSystemObjective;

    public TransformationFlowPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    @Override
    public String getCaption() {
        return Messages.getString("TransformationFlowPropertiesDialogEx.TransformationFlowProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof TransformationFlow) {
            this.flow = (TransformationFlow)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.flow.getSynonym());
            String string = this.flow.getSource() != null ? this.flow.getSource().getName() : Messages.getString("TransformationFlowPropertiesDialogEx.NONE");
            this.bnSource.setText(string);
            String string2 = this.flow.getDestination() != null ? this.flow.getDestination().getName() : Messages.getString("TransformationFlowPropertiesDialogEx.NONE");
            this.bnDestination.setText(string2);
            this.chbLoggingFlow.setSelected(this.flow.isLogging());
            this.taSystemObjective.setText(this.flow.getSystemObjective());
            this.chbCRUDCreate.setSelected(this.flow.isOpCreate());
            this.chbCRUDRead.setSelected(this.flow.isOpRead());
            this.chbCRUDUpdate.setSelected(this.flow.isOpUpdate());
            this.chbCRUDDelete.setSelected(this.flow.isOpDelete());
            if (this.flow.isConnecedTotCompositeProc() || !this.flow.isConnectedToInfoStore()) {
                this.disableCRUD();
            }
            if (this.flow.isConnecedTotCompositeProc()) {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
            }
            if (this.flow.getTargetProcessObject() instanceof InfoStore) {
                this.chbCRUDRead.setEnabled(false);
            }
            if (this.flow.getSourceProcessObject() instanceof InfoStore) {
                this.chbCRUDCreate.setEnabled(false);
                this.chbCRUDUpdate.setEnabled(false);
                this.chbCRUDDelete.setEnabled(false);
                this.chbCRUDRead.setSelected(true);
                this.chbCRUDRead.setEnabled(false);
            }
            if (!this.flow.getExternalData().isEmpty()) {
                this.enableComponents(true);
            } else {
                this.enableComponents(false);
            }
            this.isList.addAll(this.flow.getInfoStructures());
            this.edList.addAll(this.flow.getExternalData());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.flow.getPropertyNames();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = this.flow.getProperty(string3);
                DynamicProperty dynamicProperty = new DynamicProperty(string3, string4);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.flow.setName(this.tfName.getText());
        this.flow.setNotes(this.taNotes.getText());
        this.flow.setComment(this.taComments.getText());
        this.flow.setSynonym(this.tfSynonym.getText());
        this.flow.setLogging(this.chbLoggingFlow.isSelected());
        this.flow.setOpCreate(this.chbCRUDCreate.isSelected());
        this.flow.setOpRead(this.chbCRUDRead.isSelected());
        this.flow.setOpUpdate(this.chbCRUDUpdate.isSelected());
        this.flow.setOpDelete(this.chbCRUDDelete.isSelected());
        this.flow.setSystemObjective(this.taSystemObjective.getText());
        this.flow.getInfoStructures().clear();
        for (Object object : this.isList) {
            this.flow.addInfoStructure((InfoStructure)object);
        }
        if (this.flow.getTopView() != null) {
            ((TVFlow)this.flow.getTopView()).displayLabels();
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        TransformationFlowPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.flow.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.flow.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getInfoStructuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getExternalDataPanel());
        this.addToTree(defaultMutableTreeNode, this.getSystemObjectivePanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_FLOW_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.General"));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(jLabel, this.tfName));
            JLabel jLabel2 = new JLabel(LB_SYNOMYM);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfSynonym = new JTextField();
            this.tfSynonym.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(jLabel2, this.tfSynonym));
            JLabel jLabel3 = new JLabel(LB_SOURCE);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.bnSource = new JButton();
            this.bnSource.setPreferredSize(this.getDefaultSize());
            this.bnSource.setFont(this.bnSource.getFont().deriveFont(0));
            this.bnSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TransformationFlowPropertiesDialogEx.this.flow.getSource() != null) {
                        TransformationFlowPropertiesDialogEx.this.flow.getSource().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(jLabel3, this.bnSource));
            JLabel jLabel4 = new JLabel(LB_DESTINATION);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.bnDestination = new JButton();
            this.bnDestination.setPreferredSize(this.getDefaultSize());
            this.bnDestination.setFont(this.bnDestination.getFont().deriveFont(0));
            this.bnDestination.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TransformationFlowPropertiesDialogEx.this.flow.getDestination() != null) {
                        TransformationFlowPropertiesDialogEx.this.flow.getDestination().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(jLabel4, this.bnDestination));
            this.lbLoggingFlow = new JLabel(Messages.getString("TransformationFlowPropertiesDialogEx.LoggingFlow"));
            this.lbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.chbLoggingFlow = new JCheckBox();
            this.chbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(this.lbLoggingFlow, this.chbLoggingFlow));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 10, 10));
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("TransformationFlowPropertiesDialogEx.Operations")));
            this.chbCRUDCreate = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Create"));
            this.chbCRUDRead = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Read"));
            this.chbCRUDUpdate = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Update"));
            this.chbCRUDDelete = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Delete"));
            jPanel3.add(this.chbCRUDCreate);
            jPanel3.add(this.chbCRUDRead);
            jPanel3.add(this.chbCRUDUpdate);
            jPanel3.add(this.chbCRUDDelete);
            jPanel2.add((Component)jPanel3, "North");
            jPanel.add((Component)this.pnGeneralGrid, "North");
            jPanel.add((Component)jPanel2, "Center");
            this.pnGeneral.add((Component)jPanel, "Center");
        }
        return this.pnGeneral;
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructure == null) {
            this.pnInfoStructure = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TransformationFlowPropertiesDialogEx.this.istable.getSelectedRow()) != -1 && TransformationFlowPropertiesDialogEx.this.isList.size() > 0 && n < TransformationFlowPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)TransformationFlowPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.istable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TransformationFlowPropertiesDialogEx.this.istable.getSelectedRow();
                    if (n != -1 && TransformationFlowPropertiesDialogEx.this.isList.size() > 0 && n < TransformationFlowPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)TransformationFlowPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddStructureDialog addStructureDialog = new AddStructureDialog(TransformationFlowPropertiesDialogEx.this.getAppView(), TransformationFlowPropertiesDialogEx.this.flow.getDesignPart(), TransformationFlowPropertiesDialogEx.this.isList);
                        addStructureDialog.show();
                        TransformationFlowPropertiesDialogEx.this.istable.updateUI();
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = TransformationFlowPropertiesDialogEx.this.istable.getSelectedRow();
                        if (n != -1 && TransformationFlowPropertiesDialogEx.this.isList.size() > 0 && n < TransformationFlowPropertiesDialogEx.this.isList.size()) {
                            TransformationFlowPropertiesDialogEx.this.isList.remove(n);
                            TransformationFlowPropertiesDialogEx.this.istable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnInfoStructure.add(jPanel2);
        }
        return this.pnInfoStructure;
    }

    private JPanel getExternalDataPanel() {
        if (this.pnExternalData == null) {
            this.pnExternalData = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.ExternalData"));
            this.edList = new ArrayList();
            this.edtable = new JTable(new ExternalDataModel());
            this.edtable.setSelectionMode(0);
            this.edtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TransformationFlowPropertiesDialogEx.this.edtable.getSelectedRow()) != -1 && TransformationFlowPropertiesDialogEx.this.edList.size() > 0 && n < TransformationFlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)TransformationFlowPropertiesDialogEx.this.edList.get(n);
                        externalData.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.edtable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnExProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnExProperties.setToolTipText(Messages.getString("TransformationFlowPropertiesDialogEx.Properties"));
            this.btnExProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TransformationFlowPropertiesDialogEx.this.edtable.getSelectedRow();
                    if (n != -1 && TransformationFlowPropertiesDialogEx.this.edList.size() > 0 && n < TransformationFlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)TransformationFlowPropertiesDialogEx.this.edList.get(n);
                        externalData.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnExProperties);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 305));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnExternalData.add(jPanel2);
        }
        return this.pnExternalData;
    }

    private JPanel getSystemObjectivePanel() {
        if (this.pnSystemObjective == null) {
            this.pnSystemObjective = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.SystemObjective"));
            this.taSystemObjective = new JTextArea();
            this.pnSystemObjective.add(new JScrollPane(this.taSystemObjective));
        }
        return this.pnSystemObjective;
    }

    private void disableCRUD() {
        this.chbCRUDCreate.setEnabled(false);
        this.chbCRUDRead.setEnabled(false);
        this.chbCRUDUpdate.setEnabled(false);
        this.chbCRUDDelete.setEnabled(false);
    }

    private void enableComponents(boolean bl) {
        if (this.isEditable()) {
            this.edtable.setEnabled(bl);
            this.btnExProperties.setEnabled(bl);
            this.istable.setEnabled(!bl);
            this.btnProperties.setEnabled(!bl);
            this.btnAdd.setEnabled(!bl);
            this.btnRemove.setEnabled(!bl);
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return TransformationFlowPropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.ExternalDatas");
            }
            if (n == 1) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExternalData externalData = (ExternalData)TransformationFlowPropertiesDialogEx.this.edList.get(n);
            if (n2 == 0) {
                return externalData.getName();
            }
            if (n2 == 1) {
                return externalData.getSynonym();
            }
            if (n2 == 2) {
                return externalData.getType() != null ? externalData.getType().getName() : "";
            }
            return new Integer(n * n2);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        private InfoStructuresModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TransformationFlowPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.InformationStructures");
            }
            if (n == 1) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InfoStructure infoStructure = (InfoStructure)TransformationFlowPropertiesDialogEx.this.isList.get(n);
            if (n2 == 0) {
                return infoStructure.getName();
            }
            if (n2 == 1) {
                return infoStructure.getSynonym();
            }
            return new Integer(n * n2);
        }
    }
}

