/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AbstractFieldEditor;
import oracle.dbtools.crest.swingui.editor.CommonEditor;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.TransformationPropertiesDialogEx;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TranformationTaskPropertiesDialog
extends CustomDialog
implements AbstractEditorConstants,
CommonEditor {
    private TransformationTask task;
    private JTabbedPane tpane;
    protected JPanel generalPanel = new JPanel(new GridLayout(0, 1));
    protected JPanel rpPanel = new JPanel();
    protected JPanel docPanel = new JPanel();
    protected JLabel lbName;
    protected JTextField tfName;
    protected static final int FIELD_WIDTH = 150;
    protected static final int FIELD_HEIGHT = 20;
    protected JButton btnComment;
    private JButton bnCancel;
    private JCheckBox chbVisible;
    public String commentField = "";
    protected JTable docTable;
    protected List docList = new ArrayList();
    protected JTable rpTable;
    protected List rpList = new ArrayList();
    protected JScrollPane rpPane;
    protected JScrollPane docPane;
    private JPanel sourcePanel;
    private JPanel targetPanel;
    private JPanel primaryPanel;
    private JList selectedSourcesList;
    private JList allSourcesList;
    private DefaultListModel allSourcesModel;
    private DefaultListModel selectedSourcesModel;
    private JButton btnAddSources;
    private JButton btnRemoveSources;
    private JList selectedTargetsList;
    private JList allTargetsList;
    private DefaultListModel allTargetsModel;
    private DefaultListModel selectedTargetsModel;
    private JButton btnAddTargets;
    private JButton btnRemoveTargets;
    private DefaultListModel primaryModel;
    private JList primaryList;
    private JDialog dialog;
    private JButton bnOK;

    public TranformationTaskPropertiesDialog(ApplicationView applicationView, TransformationTask transformationTask) {
        super(applicationView);
        this.task = transformationTask;
        this.setLayout(new BorderLayout());
        this.tpane = new JTabbedPane();
        this.tpane.setPreferredSize(new Dimension(400, 280));
        this.initGeneralView(this.tpane, this.generalPanel, Messages.getString("TranformationTaskPropertiesDialog.General"));
        this.add((Component)this.tpane, "Center");
        JPanel jPanel = new JPanel();
        this.bnOK = new JButton(BTN_OK);
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        JButton jButton = new JButton(BTN_APPLY);
        jButton.addActionListener(new ApplyAction());
        jButton.setMnemonic(65);
        this.bnCancel = new JButton(BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        JButton jButton2 = new JButton(this.getHelpAction());
        jButton2.setMnemonic(72);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnOK);
        jPanel.add(jButton);
        jPanel.add(this.bnCancel);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "South");
    }

    public String getCaption() {
        return Messages.getString("TranformationTaskPropertiesDialog.TransformationPackageProperties");
    }

    @Override
    protected void close() {
        this.task.setDialogVisible(false, null);
        this.getDialog().dispose();
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.getContentPane().add(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_TASK_PROPERTIES_DIALOG";
    }

    protected void initGeneralView(JTabbedPane jTabbedPane, JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        jPanel2.add((Component)new JPanel(), gridBagConstraints);
        jTabbedPane.addTab(string, null, new JScrollPane(jPanel2));
        JLabel jLabel = new JLabel(LB_NAME);
        jLabel.setPreferredSize(new Dimension(150, 20));
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(jLabel.getPreferredSize());
        JPanel jPanel3 = this.newRow(jLabel, this.tfName);
        this.generalPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel(LB_COMMENT);
        jLabel2.setPreferredSize(jLabel.getPreferredSize());
        this.btnComment = new JButton();
        this.btnComment.setPreferredSize(jLabel.getPreferredSize());
        this.btnComment.setHorizontalAlignment(2);
        this.btnComment.setFont(new Font(this.btnComment.getFont().getName(), 0, this.btnComment.getFont().getSize()));
        jPanel3 = this.newRow(jLabel2, this.btnComment);
        this.generalPanel.add(jPanel3);
        JLabel jLabel3 = new JLabel(LB_VISIBLE);
        jLabel3.setPreferredSize(jLabel.getPreferredSize());
        this.chbVisible = new JCheckBox();
        this.chbVisible.setPreferredSize(jLabel.getPreferredSize());
        jPanel3 = this.newRow(jLabel3, this.chbVisible);
        this.generalPanel.add(jPanel3);
        this.initSourcesTab();
        this.initTargetsTab();
        this.initPrimaryTab();
    }

    protected JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public void initProperties(ModelIDObject modelIDObject) {
        if (modelIDObject instanceof TransformationTask) {
            InfoStore infoStore;
            this.task = (TransformationTask)modelIDObject;
            this.tfName.setText(this.task.getName());
            this.btnComment.setText(this.task.getComment());
            this.btnComment.setHorizontalAlignment(0);
            this.btnComment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFieldEditor abstractFieldEditor = new AbstractFieldEditor(TranformationTaskPropertiesDialog.this.getApplicationView(), TranformationTaskPropertiesDialog.this.task, 1, TranformationTaskPropertiesDialog.this);
                    abstractFieldEditor.show();
                }
            });
            ((JDialog)this.getDialog()).setTitle(this.task.getName());
            this.task.setDialogVisible(true, (JDialog)this.getDialog());
            this.chbVisible.setSelected(this.task.isMainViewVisible());
            Iterator iterator = this.task.getInfoStoreSet().iterator();
            List list = this.task.getSources();
            while (iterator.hasNext()) {
                infoStore = (InfoStore)iterator.next();
                if (list.contains(infoStore)) {
                    this.selectedSourcesModel.addElement(infoStore);
                    continue;
                }
                this.allSourcesModel.addElement(infoStore);
            }
            Iterator iterator2 = this.task.getInfoStoreSet().iterator();
            List list2 = this.task.getTargets();
            while (iterator2.hasNext()) {
                infoStore = (InfoStore)iterator2.next();
                if (list2.contains(infoStore)) {
                    this.selectedTargetsModel.addElement(infoStore);
                    continue;
                }
                this.allTargetsModel.addElement(infoStore);
            }
            Iterator iterator3 = this.task.getTransformationSet().iterator();
            while (iterator3.hasNext()) {
                Transformation transformation = (Transformation)iterator3.next();
                if (!transformation.isPrimary()) continue;
                this.primaryModel.addElement(transformation);
            }
        }
    }

    private void initPrimaryTab() {
        this.primaryPanel = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.PrimaryTransformations"), this.primaryPanel);
        this.initPrimaryList();
    }

    private void initPrimaryList() {
        this.primaryModel = new DefaultListModel();
        this.primaryList = new JList(this.primaryModel);
        this.primaryList.addMouseListener(new PrimaryListener());
        JScrollPane jScrollPane = new JScrollPane(this.primaryList);
        jScrollPane.setPreferredSize(new Dimension(400, 233));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.primaryPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPrimaryLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSourcesLayout() {
        return (SpringLayout)this.sourcePanel.getLayout();
    }

    protected SpringLayout getPrimaryLayout() {
        return (SpringLayout)this.primaryPanel.getLayout();
    }

    private void initSourcesTab() {
        this.sourcePanel = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.Sources"), this.sourcePanel);
        this.initAllSourcesList();
        this.initSourcesButtons();
        this.initSelectedSourcesList();
    }

    private void initAllSourcesList() {
        JLabel jLabel = new JLabel(Messages.getString("TranformationTaskPropertiesDialog.AllSources"));
        this.sourcePanel.add(jLabel);
        this.allSourcesModel = new DefaultListModel();
        this.allSourcesList = new JList(this.allSourcesModel);
        ListSelectionModel listSelectionModel = this.allSourcesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSourcesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSourcesList);
        jScrollPane.setPreferredSize(new Dimension(162, 223));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.sourcePanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getSourcesLayout(), jLabel, 12, 4);
        CommonUtil.setObjectConstraints(this.getSourcesLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedSourcesList() {
        JLabel jLabel = new JLabel(Messages.getString("TranformationTaskPropertiesDialog.SelectedSources"));
        this.sourcePanel.add(jLabel);
        this.selectedSourcesModel = new DefaultListModel();
        this.selectedSourcesList = new JList(this.selectedSourcesModel);
        ListSelectionModel listSelectionModel = this.selectedSourcesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSourcesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSourcesList);
        jScrollPane.setPreferredSize(new Dimension(162, 223));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.sourcePanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getSourcesLayout(), jLabel, 262, 4);
        CommonUtil.setObjectConstraints(this.getSourcesLayout(), jScrollPane, 250, 22);
    }

    private void initSourcesButtons() {
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddSources = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddSources.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Add"));
        this.btnAddSources.addActionListener(new AddSourcesActionListener());
        this.btnAddSources.setEnabled(false);
        this.sourcePanel.add(this.btnAddSources);
        CommonUtil.setObjectConstraints(this.getSourcesLayout(), this.btnAddSources, 186, 100);
        this.btnRemoveSources = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveSources.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Remove"));
        this.btnRemoveSources.setEnabled(false);
        this.btnRemoveSources.addActionListener(new RemoveSourcesActionListener());
        this.btnAddSources.setPreferredSize(this.btnRemoveSources.getPreferredSize());
        this.sourcePanel.add(this.btnRemoveSources);
        CommonUtil.setObjectConstraints(this.getSourcesLayout(), this.btnRemoveSources, 186, 130);
    }

    protected SpringLayout getTargetsLayout() {
        return (SpringLayout)this.targetPanel.getLayout();
    }

    private void initTargetsTab() {
        this.targetPanel = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.Targets"), this.targetPanel);
        this.initAllTargetsList();
        this.initTargetsButtons();
        this.initSelectedTargetsList();
    }

    private void initAllTargetsList() {
        JLabel jLabel = new JLabel(Messages.getString("TranformationTaskPropertiesDialog.AllTargets"));
        this.targetPanel.add(jLabel);
        this.allTargetsModel = new DefaultListModel();
        this.allTargetsList = new JList(this.allTargetsModel);
        ListSelectionModel listSelectionModel = this.allTargetsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllTargetsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allTargetsList);
        jScrollPane.setPreferredSize(new Dimension(162, 223));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.targetPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getTargetsLayout(), jLabel, 12, 4);
        CommonUtil.setObjectConstraints(this.getTargetsLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedTargetsList() {
        JLabel jLabel = new JLabel(Messages.getString("TranformationTaskPropertiesDialog.SelectedTargets"));
        this.targetPanel.add(jLabel);
        this.selectedTargetsModel = new DefaultListModel();
        this.selectedTargetsList = new JList(this.selectedTargetsModel);
        ListSelectionModel listSelectionModel = this.selectedTargetsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTargetsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedTargetsList);
        jScrollPane.setPreferredSize(new Dimension(162, 223));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.targetPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getTargetsLayout(), jLabel, 262, 4);
        CommonUtil.setObjectConstraints(this.getTargetsLayout(), jScrollPane, 250, 22);
    }

    private void initTargetsButtons() {
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddTargets = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddTargets.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Add"));
        this.btnAddTargets.addActionListener(new AddTargetsActionListener());
        this.btnAddTargets.setEnabled(false);
        this.targetPanel.add(this.btnAddTargets);
        CommonUtil.setObjectConstraints(this.getTargetsLayout(), this.btnAddTargets, 186, 100);
        this.btnRemoveTargets = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveTargets.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Remove"));
        this.btnRemoveTargets.setEnabled(false);
        this.btnRemoveTargets.addActionListener(new RemoveTargetsActionListener());
        this.btnAddTargets.setPreferredSize(this.btnRemoveTargets.getPreferredSize());
        this.targetPanel.add(this.btnRemoveTargets);
        CommonUtil.setObjectConstraints(this.getTargetsLayout(), this.btnRemoveTargets, 186, 130);
    }

    @Override
    public String getCommentField() {
        if (this.commentField.equalsIgnoreCase("")) {
            this.commentField = this.task.getComment();
        }
        return this.commentField;
    }

    @Override
    public void setCommentField(String string) {
        this.commentField = string;
        this.btnComment.setText(string);
    }

    @Override
    public String getNotesField() {
        return null;
    }

    @Override
    public String getSynonymField() {
        return null;
    }

    @Override
    public void setNotesField(String string) {
    }

    @Override
    public void setSynonymField(String string) {
    }

    protected void setProperties() {
        this.task.setName(this.tfName.getText());
        this.task.setComment(this.getCommentField());
        Object[] objectArray = this.selectedSourcesModel.toArray();
        this.task.removeAllSources();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof InfoStore)) continue;
            this.task.addSource((InfoStore)object);
        }
        Object[] objectArray2 = this.selectedTargetsModel.toArray();
        this.task.removeAllTargets();
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            if (!(object instanceof InfoStore)) continue;
            this.task.addTarget((InfoStore)object);
        }
        this.task.setMainViewVisible(this.chbVisible.isSelected());
    }

    private class SelectedTargetsListSelectionHandler
    implements ListSelectionListener {
        private SelectedTargetsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.selectedTargetsList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnRemoveTargets.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnRemoveTargets.setEnabled(true);
                }
            }
        }
    }

    private class AllTargetsListSelectionHandler
    implements ListSelectionListener {
        private AllTargetsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.allTargetsList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnAddTargets.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnAddTargets.setEnabled(true);
                }
            }
        }
    }

    private class RemoveTargetsActionListener
    implements ActionListener {
        private RemoveTargetsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TranformationTaskPropertiesDialog.this.selectedTargetsModel.isEmpty()) {
                Object[] objectArray = TranformationTaskPropertiesDialog.this.selectedTargetsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TranformationTaskPropertiesDialog.this.allTargetsModel.contains(object)) continue;
                    TranformationTaskPropertiesDialog.this.allTargetsModel.addElement(object);
                    TranformationTaskPropertiesDialog.this.selectedTargetsModel.removeElement(object);
                }
            }
        }
    }

    private class AddTargetsActionListener
    implements ActionListener {
        private AddTargetsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TranformationTaskPropertiesDialog.this.allTargetsModel.isEmpty()) {
                Object[] objectArray = TranformationTaskPropertiesDialog.this.allTargetsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TranformationTaskPropertiesDialog.this.selectedTargetsModel.contains(object)) continue;
                    TranformationTaskPropertiesDialog.this.selectedTargetsModel.addElement(object);
                    TranformationTaskPropertiesDialog.this.allTargetsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSourcesListSelectionHandler
    implements ListSelectionListener {
        private SelectedSourcesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.selectedSourcesList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnRemoveSources.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnRemoveSources.setEnabled(true);
                }
            }
        }
    }

    private class AllSourcesListSelectionHandler
    implements ListSelectionListener {
        private AllSourcesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.allSourcesList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnAddSources.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnAddSources.setEnabled(true);
                }
            }
        }
    }

    private class RemoveSourcesActionListener
    implements ActionListener {
        private RemoveSourcesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TranformationTaskPropertiesDialog.this.selectedSourcesModel.isEmpty()) {
                Object[] objectArray = TranformationTaskPropertiesDialog.this.selectedSourcesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TranformationTaskPropertiesDialog.this.allSourcesModel.contains(object)) continue;
                    TranformationTaskPropertiesDialog.this.allSourcesModel.addElement(object);
                    TranformationTaskPropertiesDialog.this.selectedSourcesModel.removeElement(object);
                }
            }
        }
    }

    private class AddSourcesActionListener
    implements ActionListener {
        private AddSourcesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TranformationTaskPropertiesDialog.this.allSourcesModel.isEmpty()) {
                Object[] objectArray = TranformationTaskPropertiesDialog.this.allSourcesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TranformationTaskPropertiesDialog.this.selectedSourcesModel.contains(object)) continue;
                    TranformationTaskPropertiesDialog.this.selectedSourcesModel.addElement(object);
                    TranformationTaskPropertiesDialog.this.allSourcesModel.removeElement(object);
                }
            }
        }
    }

    private class PrimaryListener
    extends MouseAdapter {
        private PrimaryListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Transformation transformation;
            if (mouseEvent.getClickCount() == 2 && (transformation = (Transformation)TranformationTaskPropertiesDialog.this.primaryList.getSelectedValue()) != null && !transformation.isDialogVisible()) {
                TransformationPropertiesDialogEx transformationPropertiesDialogEx = new TransformationPropertiesDialogEx(TranformationTaskPropertiesDialog.this.task.getDesign().getAppView(), transformation);
                transformationPropertiesDialogEx.initProperties(transformation);
                transformationPropertiesDialogEx.show();
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TranformationTaskPropertiesDialog.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TranformationTaskPropertiesDialog.this.setProperties();
            TranformationTaskPropertiesDialog.this.task.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TranformationTaskPropertiesDialog.this.setProperties();
            TranformationTaskPropertiesDialog.this.task.setDirty(true);
            TranformationTaskPropertiesDialog.this.close();
        }
    }
}

