/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.ExternalDataPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;

public class StorePropertiesDialogEx
extends AbstractPropertiesDialog {
    private InfoStore store;
    private JTextField tfSynonym;
    private JComboBox cbType;
    private JComboBox cbRDBMS;
    private JTextField tfObjectType;
    private JTextField tfImplementationName;
    private JTextField tfScope;
    private List aList;
    private List eList;
    private List ifList;
    private JPanel pnAttributes;
    private JTable aTable;
    private EntityTable eTable;
    private JPanel pnEntity;
    private JPanel pnProcess;
    private List pList;
    private JTable pTable;
    private JTable iftable;
    private JPanel pnInfoFlow;
    private JPanel pnSystemObjective;
    private JEditorPane editorPane;
    private JTextField tfOwner;
    private JPanel pnDataFile;
    private JPanel pnDataFileGrid;
    private JTextField tfSource;
    private JTextField tfFileName;
    private JTextField tfLocation;
    private JComboBox cbFileType;
    private JCharField tfFieldSeparator;
    private JComboBox cbTransferType;
    private JCheckBox chSelfDescribing;
    private JIntegerField tfSkipRecords;
    private JCharField tfTextDelimiter;
    private JPanel pnDataElement;
    private List dList;
    private JTable edTable;
    private List newExtDatas;
    private JButton btnDEAdd;
    private JButton btnDERemove;
    private JButton btnDEProperties;

    public StorePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(InfoStore.INFOSTORE_TYPES_DISPLAY);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbType));
        JLabel jLabel3 = new JLabel(LB_RDBMS_TYPE);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbRDBMS = new JComboBox<Object>(this.getRDBMSSites());
        this.cbRDBMS.setFont(this.cbRDBMS.getFont().deriveFont(0));
        this.cbRDBMS.setPreferredSize(this.getDefaultSize());
        this.cbRDBMS.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbRDBMS));
        JLabel jLabel4 = new JLabel(LB_OBJECT_TYPE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfObjectType = new JTextField();
        this.tfObjectType.setPreferredSize(this.getDefaultSize());
        this.tfObjectType.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfObjectType));
        JLabel jLabel5 = new JLabel(LB_IMPLEMENTATION_NAME);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.tfImplementationName = new JTextField();
        this.tfImplementationName.setPreferredSize(this.getDefaultSize());
        this.tfImplementationName.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.tfImplementationName));
        JLabel jLabel6 = new JLabel(LB_SCOPE);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.tfScope = new JTextField();
        this.tfScope.setPreferredSize(this.getDefaultSize());
        this.tfScope.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.tfScope));
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                String string = InfoStore.INFOSTORE_TYPES_INTERNAL[n];
                if (string.equalsIgnoreCase("RDBMS")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setSelectedItem(StorePropertiesDialogEx.this.getDesignObject().getDesign().getSelectedRDBMSSite());
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(true);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(true);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(false);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(false);
                    StorePropertiesDialogEx.this.enableControls();
                } else if (string.equalsIgnoreCase("Object")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(false);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(true);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(true);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(false);
                    StorePropertiesDialogEx.this.enableControls();
                } else if (string.equalsIgnoreCase("Temporary")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(false);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(false);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(false);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(true);
                    StorePropertiesDialogEx.this.enableControls();
                } else if (string.equalsIgnoreCase("File")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(false);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(false);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(false);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(false);
                    StorePropertiesDialogEx.this.enableControls();
                }
            }
        });
    }

    private Object[] getRDBMSSites() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getDesignObject().getDesign().getRDBMSSiteSet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((RDBMSSite)iterator.next()).getName());
        }
        return arrayList.toArray();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StorePropertiesDialogEx.InformationStoreProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof InfoStore) {
            this.store = (InfoStore)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.store.getSynonym());
            this.cbType.setSelectedItem(this.translate(this.store.getType(), InfoStore.INFOSTORE_TYPES_INTERNAL, InfoStore.INFOSTORE_TYPES_DISPLAY));
            this.cbRDBMS.setSelectedItem(this.store.getRdbmsSite());
            this.tfObjectType.setText(this.store.getObjectType());
            this.tfImplementationName.setText(this.store.getImplementationName());
            this.tfScope.setText(this.store.getScope());
            this.aList.addAll(this.store.getAttributes());
            this.ifList.addAll(this.store.getIncomingFlows());
            this.ifList.addAll(this.store.getOutgoingFlows());
            this.pList.addAll(this.store.getProcesses());
            this.editorPane.setText(this.store.getSystemObjective());
            this.tfOwner.setText(this.store.getOwner());
            this.tfSource.setText(this.store.getSource());
            this.tfFileName.setText(this.store.getFileName());
            this.tfLocation.setText(this.store.getLocation());
            this.cbFileType.setSelectedItem(this.translate(this.store.getFileType(), InfoStore.FILE_TYPES_INTERNAL, InfoStore.FILE_TYPES_DISPLAY));
            this.tfFieldSeparator.setText(this.store.getFieldSeparator());
            this.cbTransferType.setSelectedItem(this.translate(this.store.getTransferType(), InfoStore.TRANSFER_TYPES_INTERNAL, InfoStore.TRANSFER_TYPES_DISPLAY));
            this.tfSkipRecords.setValue((long)this.store.getSkipRecords());
            this.tfTextDelimiter.setText(this.store.getTextDelimiter());
            this.chSelfDescribing.setSelected(this.store.isSelfDescribing());
            this.dList.addAll(this.store.getDatas());
            this.updateEntityList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.store.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.store.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.store.setName(this.tfName.getText());
        this.store.setNotes(this.taNotes.getText());
        this.store.setComment(this.taComments.getText());
        this.store.setSynonym(this.tfSynonym.getText());
        this.store.setSystemObjective(this.editorPane.getText());
        this.store.setType(this.translate((String)this.cbType.getSelectedItem(), InfoStore.INFOSTORE_TYPES_DISPLAY, InfoStore.INFOSTORE_TYPES_INTERNAL));
        if ("RDBMS".equalsIgnoreCase(InfoStore.INFOSTORE_TYPES_INTERNAL[this.cbType.getSelectedIndex()])) {
            this.store.setRdbmsSite((String)this.cbRDBMS.getSelectedItem());
        }
        if (this.tfObjectType.isEnabled()) {
            this.store.setObjectType(this.tfObjectType.getText());
        } else {
            this.store.setObjectType("");
        }
        if (this.tfImplementationName.isEnabled()) {
            this.store.setImplementationName(this.tfImplementationName.getText());
        } else {
            this.store.setImplementationName("");
        }
        if (this.tfScope.isEnabled()) {
            this.store.setScope(this.tfScope.getText());
        } else {
            this.store.setScope("");
        }
        if ("File".equalsIgnoreCase(InfoStore.INFOSTORE_TYPES_INTERNAL[this.cbType.getSelectedIndex()])) {
            this.store.setOwner(this.tfOwner.getText());
            this.store.setSource(this.tfSource.getText());
            this.store.setFileName(this.tfFileName.getText());
            this.store.setLocation(this.tfLocation.getText());
            this.store.setFileType(this.translate((String)this.cbFileType.getSelectedItem(), InfoStore.FILE_TYPES_DISPLAY, InfoStore.FILE_TYPES_INTERNAL));
            this.store.setFieldSeparator(this.tfFieldSeparator.getText());
            this.store.setTransferType(this.translate((String)this.cbTransferType.getSelectedItem(), InfoStore.TRANSFER_TYPES_DISPLAY, InfoStore.TRANSFER_TYPES_INTERNAL));
            this.store.setSelfDescribing(this.chSelfDescribing.isSelected());
            this.store.setSkipRecords(this.tfSkipRecords.getIntValue());
            this.store.setTextDelimiter(this.tfTextDelimiter.getText());
            this.store.getDatas().clear();
            for (Object object : this.dList) {
                this.store.addData((ExternalData)object);
            }
        } else {
            this.store.setOwner("");
            this.store.setSource("");
            this.store.setFileName("");
            this.store.setLocation("");
            this.store.setFileType("");
            this.store.setFieldSeparator("");
            this.store.setTransferType("");
            this.store.setSelfDescribing(false);
            this.store.setSkipRecords(0);
            this.store.setTextDelimiter("");
            this.store.getDatas().clear();
        }
        this.store.getEntityImplementations().clear();
        for (int i = 0; i < this.eList.size(); ++i) {
            Object object;
            object = (Entity)this.eList.get(i);
            Object object2 = ((JComboBox)this.eTable.getModel().getValueAt(i, 1)).getSelectedItem();
            this.store.addEntityImpl((Entity)object, object2);
        }
        this.updateEntityList();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.newExtDatas.clear();
        StorePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.store.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.store.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEntityPanel());
        this.addToTree(defaultMutableTreeNode, this.getProcessPanel());
        this.addToTree(defaultMutableTreeNode, this.getInformationFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getSystemObjectivePanel());
        this.addToTree(defaultMutableTreeNode, this.getDataFileSpecPanel());
        this.addToTree(defaultMutableTreeNode, this.getDataElementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INFORMATION_STORE_PROPERTIES_DIALOG";
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("StorePropertiesDialogEx.Attributes"));
            this.aList = new ArrayList();
            this.aTable = new JTable(new AttributesModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = StorePropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && StorePropertiesDialogEx.this.aList.size() > 0 && n < StorePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)StorePropertiesDialogEx.this.aList.get(n);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.aTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = StorePropertiesDialogEx.this.aTable.getSelectedRow();
                    if (n > -1 && StorePropertiesDialogEx.this.aList.size() > 0 && n < StorePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)StorePropertiesDialogEx.this.aList.get(n);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnAttributes.add(jPanel2);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("StorePropertiesDialogEx.Entities"));
            this.eList = new ArrayList();
            this.eTable = new EntityTable();
            this.eTable.setSelectionMode(0);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = StorePropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && StorePropertiesDialogEx.this.eList.size() > 0 && n < StorePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)StorePropertiesDialogEx.this.eList.get(n);
                        entity.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.eTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = StorePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (n != -1 && StorePropertiesDialogEx.this.eList.size() > 0 && n < StorePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)StorePropertiesDialogEx.this.eList.get(n);
                        entity.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnEntity.add(jPanel2);
        }
        return this.pnEntity;
    }

    private JPanel getProcessPanel() {
        if (this.pnProcess == null) {
            this.pnProcess = this.createPage(Messages.getString("StorePropertiesDialogEx.Processes"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ProcessTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = StorePropertiesDialogEx.this.pTable.getSelectedRow()) != -1 && StorePropertiesDialogEx.this.pList.size() > 0 && n < StorePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)StorePropertiesDialogEx.this.pList.get(n);
                        process.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.pTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = StorePropertiesDialogEx.this.pTable.getSelectedRow();
                    if (n != -1 && StorePropertiesDialogEx.this.pList.size() > 0 && n < StorePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)StorePropertiesDialogEx.this.pList.get(n);
                        process.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnProcess.add(jPanel2);
        }
        return this.pnProcess;
    }

    private JPanel getInformationFlowsPanel() {
        if (this.pnInfoFlow == null) {
            this.pnInfoFlow = this.createPage(Messages.getString("StorePropertiesDialogEx.InformationFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new InformationFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = StorePropertiesDialogEx.this.iftable.getSelectedRow()) != -1 && StorePropertiesDialogEx.this.ifList.size() > 0 && n < StorePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)StorePropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.iftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = StorePropertiesDialogEx.this.iftable.getSelectedRow();
                    if (n != -1 && StorePropertiesDialogEx.this.ifList.size() > 0 && n < StorePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)StorePropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnInfoFlow.add(jPanel2);
        }
        return this.pnInfoFlow;
    }

    private JPanel getSystemObjectivePanel() {
        if (this.pnSystemObjective == null) {
            this.pnSystemObjective = this.createPage(Messages.getString("StorePropertiesDialogEx.SystemObjective"));
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(340, 140));
            JScrollPane jScrollPane = new JScrollPane(this.editorPane);
            jScrollPane.setPreferredSize(new Dimension(335, 343));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnSystemObjective.add(jPanel);
        }
        return this.pnSystemObjective;
    }

    private JPanel getDataFileSpecPanel() {
        if (this.pnDataFile == null) {
            this.pnDataFile = this.createPage(Messages.getString("StorePropertiesDialogEx.DataFileSpecification"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnDataFileGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_OWNER);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfOwner = new JTextField();
            this.tfOwner.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel, this.tfOwner));
            JLabel jLabel2 = new JLabel(LB_SOURCE);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfSource = new JTextField();
            this.tfSource.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel2, this.tfSource));
            JLabel jLabel3 = new JLabel(LB_FILE_NAME);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.tfFileName = new JTextField();
            this.tfFileName.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel3, this.tfFileName));
            JLabel jLabel4 = new JLabel(LB_LOCATION);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.tfLocation = new JTextField();
            this.tfLocation.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel4, this.tfLocation));
            JLabel jLabel5 = new JLabel(LB_FILE_TYPE);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbFileType = new JComboBox<String>(InfoStore.FILE_TYPES_DISPLAY);
            this.cbFileType.setFont(this.cbFileType.getFont().deriveFont(0));
            this.cbFileType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel5, this.cbFileType));
            JLabel jLabel6 = new JLabel(LB_FIELD_SEPARATOR);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.tfFieldSeparator = new JCharField();
            this.tfFieldSeparator.setPreferredSize(new Dimension(20, 20));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setPreferredSize(new Dimension(30, 20));
            jPanel2.add((Component)this.tfFieldSeparator, "West");
            this.pnDataFileGrid.add(this.createRow(jLabel6, jPanel2));
            JLabel jLabel7 = new JLabel(LB_TRANSFER_TYPE);
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.cbTransferType = new JComboBox<String>(InfoStore.TRANSFER_TYPES_DISPLAY);
            this.cbTransferType.setFont(this.cbTransferType.getFont().deriveFont(0));
            this.cbTransferType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel7, this.cbTransferType));
            JLabel jLabel8 = new JLabel(LB_SELF_DESCRIBING);
            jLabel8.setPreferredSize(this.getDefaultSize());
            this.chSelfDescribing = new JCheckBox();
            this.pnDataFileGrid.add(this.createRow(jLabel8, this.chSelfDescribing));
            JLabel jLabel9 = new JLabel(LB_SKIP_RECORDS);
            jLabel9.setPreferredSize(this.getDefaultSize());
            this.tfSkipRecords = new JIntegerField();
            this.tfSkipRecords.setPreferredSize(new Dimension(20, 20));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setPreferredSize(new Dimension(30, 20));
            jPanel3.add((Component)this.tfSkipRecords, "West");
            this.pnDataFileGrid.add(this.createRow(jLabel9, jPanel3));
            JLabel jLabel10 = new JLabel(LB_TEXT_DELIMITER);
            jLabel10.setPreferredSize(this.getDefaultSize());
            this.tfTextDelimiter = new JCharField();
            this.tfTextDelimiter.setPreferredSize(new Dimension(20, 20));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setPreferredSize(new Dimension(20, 20));
            jPanel4.add((Component)this.tfTextDelimiter, "West");
            this.pnDataFileGrid.add(this.createRow(jLabel10, jPanel4));
            jPanel.add((Component)this.pnDataFileGrid, "North");
            this.pnDataFile.add((Component)jPanel, "Center");
        }
        return this.pnDataFile;
    }

    private JPanel getDataElementsPanel() {
        if (this.pnDataElement == null) {
            this.pnDataElement = this.createPage(Messages.getString("StorePropertiesDialogEx.DataElements"));
            this.dList = new ArrayList();
            this.newExtDatas = new ArrayList();
            this.edTable = new JTable(new ExternalDataModel());
            this.edTable.setSelectionMode(0);
            this.edTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = StorePropertiesDialogEx.this.edTable.getSelectedRow()) > -1 && StorePropertiesDialogEx.this.dList.size() > 0 && n < StorePropertiesDialogEx.this.dList.size()) {
                        ExternalData externalData = (ExternalData)StorePropertiesDialogEx.this.dList.get(n);
                        ExternalDataPropertiesDialog externalDataPropertiesDialog = new ExternalDataPropertiesDialog(StorePropertiesDialogEx.this.store.getDesign().getAppView(), externalData);
                        externalDataPropertiesDialog.initProperties(externalData);
                        externalDataPropertiesDialog.setModal(true);
                        externalDataPropertiesDialog.show();
                        StorePropertiesDialogEx.this.edTable.updateUI();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.edTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnDEProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDEProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDEProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = StorePropertiesDialogEx.this.edTable.getSelectedRow();
                    if (n > -1 && StorePropertiesDialogEx.this.dList.size() > 0 && n < StorePropertiesDialogEx.this.dList.size()) {
                        ExternalData externalData = (ExternalData)StorePropertiesDialogEx.this.dList.get(n);
                        ExternalDataPropertiesDialog externalDataPropertiesDialog = new ExternalDataPropertiesDialog(StorePropertiesDialogEx.this.store.getDesign().getAppView(), externalData);
                        externalDataPropertiesDialog.initProperties(externalData);
                        externalDataPropertiesDialog.setModal(true);
                        externalDataPropertiesDialog.show();
                        StorePropertiesDialogEx.this.edTable.updateUI();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnDEProperties);
            if (this.isEditable()) {
                this.btnDEAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnDEAdd.setToolTipText(BTN_ADD);
                this.btnDEAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExternalData externalData = StorePropertiesDialogEx.this.store.getDesign().getProcessModel().createExternalData();
                        externalData.setType(StorePropertiesDialogEx.this.store.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        StorePropertiesDialogEx.this.newExtDatas.add(externalData);
                        StorePropertiesDialogEx.this.dList.add(externalData);
                        StorePropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                this.btnDERemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnDERemove.setToolTipText(BTN_REMOVE);
                this.btnDERemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = StorePropertiesDialogEx.this.edTable.getSelectedRow();
                        if (n != -1 && StorePropertiesDialogEx.this.dList.size() > 0 && n < StorePropertiesDialogEx.this.dList.size()) {
                            StorePropertiesDialogEx.this.dList.remove(n);
                            StorePropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnDEAdd);
                jToolBar.add(this.btnDERemove);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnDataElement.add(jPanel2);
        }
        return this.pnDataElement;
    }

    private void enableControls() {
        if (this.isEditable()) {
            boolean bl = "File".equalsIgnoreCase(InfoStore.INFOSTORE_TYPES_INTERNAL[this.cbType.getSelectedIndex()]);
            this.tfOwner.setEnabled(bl);
            this.tfSource.setEnabled(bl);
            this.tfFileName.setEnabled(bl);
            this.tfLocation.setEnabled(bl);
            this.cbFileType.setEnabled(bl);
            this.tfFieldSeparator.setEnabled(bl);
            this.cbTransferType.setEnabled(bl);
            this.chSelfDescribing.setEnabled(bl);
            this.tfSkipRecords.setEnabled(bl);
            this.tfTextDelimiter.setEnabled(bl);
            this.tfOwner.repaint();
            this.btnDEProperties.setEnabled(bl);
            this.btnDEAdd.setEnabled(bl);
            this.btnDERemove.setEnabled(bl);
            this.edTable.setEnabled(bl);
        }
    }

    private void updateEntityList() {
        this.eList.clear();
        this.eTable.clearTable();
        for (Attribute attribute : this.aList) {
            if (this.eList.contains(attribute.getContainer())) continue;
            this.eList.add(attribute.getContainer());
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(attribute.getContainer());
            JLNComboBox jLNComboBox = new JLNComboBox();
            List list = this.store.getImplementationsForEntity((Entity)attribute.getContainer());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jLNComboBox.addItem(iterator.next());
            }
            jLNComboBox.setSelectedItem(this.store.getEntityImpl((Entity)attribute.getContainer()));
            vector.addElement(jLNComboBox);
            Object[] objectArray = vector.toArray();
            ((ComboModel)this.eTable.getModel()).addRow(objectArray);
        }
        this.eTable.updateUI();
    }

    @Override
    protected int getMinimumHeight() {
        return 420;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.dList.size();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Messages.getString("StorePropertiesDialogEx.ExternalDatas");
                }
                case 1: {
                    return Messages.getString("StorePropertiesDialogEx.Type");
                }
                case 2: {
                    return Messages.getString("StorePropertiesDialogEx.StartingPosition");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExternalData externalData = (ExternalData)StorePropertiesDialogEx.this.dList.get(n);
            switch (n2) {
                case 0: {
                    return externalData.getName();
                }
                case 1: {
                    if (externalData.isStructured()) {
                        return externalData.getRecordStructure() != null ? externalData.getRecordStructure().getName() : "";
                    }
                    return externalData.getType();
                }
                case 2: {
                    return Integer.toString(externalData.getStartingPos());
                }
            }
            return new Integer(n * n2);
        }
    }

    private class InformationFlowsModel
    extends AbstractTableModel {
        private InformationFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StorePropertiesDialogEx.InformationFlows");
            }
            if (n == 1) {
                return Messages.getString("StorePropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)StorePropertiesDialogEx.this.ifList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            return new Integer(n * n2);
        }
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private ProcessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StorePropertiesDialogEx.Processes");
            }
            if (n == 1) {
                return Messages.getString("StorePropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("StorePropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process process = (Process)StorePropertiesDialogEx.this.pList.get(n);
            if (n2 == 0) {
                return process.getName();
            }
            if (n2 == 1) {
                return process.getSynonym();
            }
            if (n2 == 2) {
                return process.getProcessTypeName();
            }
            return new Integer(n * n2);
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.combo = (JComboBox)object;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StorePropertiesDialogEx.Entity");
            }
            if (n == 1) {
                return Messages.getString("StorePropertiesDialogEx.Table");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class EntityTable
    extends JTable {
        ComboModel dataModel;

        public EntityTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return super.getCellRenderer(n, n2);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        private AttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("StorePropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Attribute attribute = (Attribute)StorePropertiesDialogEx.this.aList.get(n);
            if (n2 == 0) {
                return attribute.getLongName();
            }
            return new Integer(n * n2);
        }
    }
}

