/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;

public class RecordStructurePropertiesDialogEx
extends AbstractPropertiesDialog {
    private List edList;
    private RecordStructure recordStructure;
    private JTable edTable;
    private JPanel pnDataElements;
    private List newExtDatas = new ArrayList();

    public RecordStructurePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    @Override
    public String getCaption() {
        return Messages.getString("RecordStructurePropertiesDialogEx.RecordStructureProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof RecordStructure) {
            this.recordStructure = (RecordStructure)designObject;
            this.initDefaults(false);
            this.edList.addAll(this.recordStructure.getExtDatas());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.recordStructure.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.recordStructure.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.recordStructure.setName(this.tfName.getText());
        this.recordStructure.setNotes(this.taNotes.getText());
        this.recordStructure.setComment(this.taComments.getText());
        for (Object object : this.recordStructure.getExtDatas()) {
            if (this.edList.contains(object)) continue;
            ((AbstractProcessObject)object).remove();
        }
        this.recordStructure.getExtDatas().clear();
        for (Object object : this.edList) {
            this.recordStructure.addExtData((ExternalData)object);
        }
        this.newExtDatas.clear();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        RecordStructurePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.recordStructure.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.recordStructure.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getDataElementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "RECORD_STRUCTURE_PROPERTIES_DIALOG";
    }

    private JPanel getDataElementsPanel() {
        if (this.pnDataElements == null) {
            JComponent jComponent;
            this.pnDataElements = this.createPage(Messages.getString("RecordStructurePropertiesDialogEx.DataElements"));
            this.edList = new ArrayList();
            this.edTable = new JTable(new ExternalDataModel());
            this.edTable.setSelectionMode(0);
            this.edTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = RecordStructurePropertiesDialogEx.this.edTable.getSelectedRow()) > -1 && RecordStructurePropertiesDialogEx.this.edList.size() > 0 && n < RecordStructurePropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)RecordStructurePropertiesDialogEx.this.edList.get(n);
                        externalData.showModal = ((RecordStructurePropertiesDialogEx)RecordStructurePropertiesDialogEx.this).recordStructure.showModal || RecordStructurePropertiesDialogEx.this.recordStructure.showForFirstTime();
                        externalData.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.edTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RecordStructurePropertiesDialogEx.this.edTable.getSelectedRow();
                    if (n > -1 && RecordStructurePropertiesDialogEx.this.edList.size() > 0 && n < RecordStructurePropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)RecordStructurePropertiesDialogEx.this.edList.get(n);
                        externalData.showModal = ((RecordStructurePropertiesDialogEx)RecordStructurePropertiesDialogEx.this).recordStructure.showModal || RecordStructurePropertiesDialogEx.this.recordStructure.showForFirstTime();
                        externalData.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExternalData externalData = RecordStructurePropertiesDialogEx.this.recordStructure.getDesign().getProcessModel().createExternalData();
                        externalData.setType(RecordStructurePropertiesDialogEx.this.recordStructure.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        externalData.setOwner(RecordStructurePropertiesDialogEx.this.recordStructure);
                        RecordStructurePropertiesDialogEx.this.newExtDatas.add(externalData);
                        RecordStructurePropertiesDialogEx.this.edList.add(externalData);
                        RecordStructurePropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = RecordStructurePropertiesDialogEx.this.edTable.getSelectedRow();
                        if (n != -1 && RecordStructurePropertiesDialogEx.this.edList.size() > 0 && n < RecordStructurePropertiesDialogEx.this.edList.size()) {
                            RecordStructurePropertiesDialogEx.this.edList.remove(n);
                            RecordStructurePropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 175));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnDataElements.add(jComponent);
        }
        return this.pnDataElements;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return RecordStructurePropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Messages.getString("RecordStructurePropertiesDialogEx.ExternalDatas");
                }
                case 1: {
                    return Messages.getString("RecordStructurePropertiesDialogEx.Type");
                }
                case 2: {
                    return Messages.getString("RecordStructurePropertiesDialogEx.StartingPosition");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExternalData externalData = (ExternalData)RecordStructurePropertiesDialogEx.this.edList.get(n);
            switch (n2) {
                case 0: {
                    return externalData.getName();
                }
                case 1: {
                    if (externalData.isStructured()) {
                        return externalData.getRecordStructure() != null ? externalData.getRecordStructure().getName() : "";
                    }
                    return externalData.getType();
                }
                case 2: {
                    return Integer.toString(externalData.getStartingPos());
                }
            }
            return new Integer(n * n2);
        }
    }
}

