/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.EventPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.NewEventDialog;
import oracle.dbtools.crest.swingui.editor.process.SelectSourceElementsDialog;
import oracle.dbtools.crest.swingui.editor.process.SelectTransformationTaskDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ProcessPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Process process;
    private JTextField tfSynonym;
    private JTextField tfFilterCondition;
    private JTextField tfJoinCondition;
    private JComboBox cbType;
    private static final String[] TYPES = new String[]{Messages.getString("ProcessPropertiesDialogEx.Primitive"), Messages.getString("ProcessPropertiesDialogEx.Composite"), Messages.getString("ProcessPropertiesDialogEx.UseTransformationTask")};
    private TransformationTask transformationTask;
    private JButton btnTransformationTask;
    private List paramsWrappers;
    private InputParamsModel inputParamsModel;
    private JPanel pnMode;
    private JComboBox cbMode;
    private JIntegerField ifMinTransactions;
    private JComboBox cbTimeUnit;
    private JIntegerField ifResponseTime;
    private JComboBox cbResponseTimeUnit;
    private JIntegerField ifFreqTimes;
    private JComboBox cbFreqTimeUnit;
    private JComboBox cbPriority;
    private JPanel pnFreqPriority;
    private JRadioButton rbNoPeaks;
    private JCheckBox chb_12_1_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.121am"));
    private JCheckBox chb_1_2_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.12am"));
    private JCheckBox chb_2_3_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.23am"));
    private JCheckBox chb_3_4_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.34am"));
    private JCheckBox chb_4_5_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.45am"));
    private JCheckBox chb_5_6_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.56am"));
    private JCheckBox chb_6_7_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.67am"));
    private JCheckBox chb_7_8_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.78am"));
    private JCheckBox chb_8_9_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.89am"));
    private JCheckBox chb_9_10_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.910am"));
    private JCheckBox chb_10_11_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1011am"));
    private JCheckBox chb_11_12_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1112am"));
    private JCheckBox chb_12_1_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.121pm"));
    private JCheckBox chb_1_2_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.12pm"));
    private JCheckBox chb_2_3_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.23pm"));
    private JCheckBox chb_3_4_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.34pm"));
    private JCheckBox chb_4_5_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.45pm"));
    private JCheckBox chb_5_6_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.56pm"));
    private JCheckBox chb_6_7_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.67pm"));
    private JCheckBox chb_7_8_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.78pm"));
    private JCheckBox chb_8_9_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.89pm"));
    private JCheckBox chb_9_10_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.910pm"));
    private JCheckBox chb_10_11_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1011pm"));
    private JCheckBox chb_11_12_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1112pm"));
    private JCheckBox[] CHB_PEAKS = new JCheckBox[]{this.chb_12_1_AM, this.chb_1_2_AM, this.chb_2_3_AM, this.chb_3_4_AM, this.chb_4_5_AM, this.chb_5_6_AM, this.chb_6_7_AM, this.chb_7_8_AM, this.chb_8_9_AM, this.chb_9_10_AM, this.chb_10_11_AM, this.chb_11_12_AM, this.chb_12_1_PM, this.chb_1_2_PM, this.chb_2_3_PM, this.chb_3_4_PM, this.chb_4_5_PM, this.chb_5_6_PM, this.chb_6_7_PM, this.chb_7_8_PM, this.chb_8_9_PM, this.chb_9_10_PM, this.chb_10_11_PM, this.chb_11_12_PM};
    private JPanel pnPeakPanel;
    private JPanel pnCHB;
    private JPanel pnCol1;
    private JPanel pnCol2;
    private JPanel pnCol3;
    private CheckboxListener chbListener;
    private List isList;
    private JTable etable;
    private List eList;
    private JTable fetable;
    private List feList;
    private JTable istable;
    private JPanel pnInfoStructures;
    private JPanel pnEvents;
    private JTable iftable;
    private JTable oftable;
    private List ifList;
    private List ofList;
    private JPanel pnIncomingFlows;
    private JPanel pnOutgoingFlows;
    private JTable attrTable;
    private JTable entTable;
    private List attrList;
    private List entList;
    private JPanel pnAttributes;
    private JPanel pnEntity;
    private JEditorPane editorPane;
    private JPanel pnFootNote;
    private JTable inParamTable;
    private JPanel pnTaskInParamsMapping;
    private List sList;
    private JTable sTable;
    private JButton btnProperties;
    private JButton btnAdd;
    private JTable tbTarget;
    private List targets = new ArrayList();
    private JButton btnRemove;
    private JComboBox cbTransformationTypes;
    private JPanel pnSourceTargetMapping;
    private JComboBox cbParentDiagram;

    public ProcessPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(Messages.getString("ProcessPropertiesDialogEx.SourcesFilterCondition"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfFilterCondition = new JTextField();
        this.tfFilterCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfFilterCondition));
        JLabel jLabel3 = new JLabel(Messages.getString("ProcessPropertiesDialogEx.SourcesJoinCondition"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfJoinCondition = new JTextField();
        this.tfJoinCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfJoinCondition));
        this.initType();
        JLabel jLabel4 = new JLabel(Messages.getString("ProcessPropertiesDialogEx.ParentDiagram"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbParentDiagram = new JComboBox();
        this.cbParentDiagram.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbParentDiagram));
    }

    @Override
    public String getCaption() {
        return Messages.getString("ProcessPropertiesDialogEx.ProcessProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Process) {
            this.process = (Process)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.process.getSynonym());
            this.tfFilterCondition.setText(this.process.getFilterCondition());
            this.tfJoinCondition.setText(this.process.getJoinCondition());
            this.cbType.setSelectedIndex(this.process.getType());
            if (this.process.isComposite() && this.process.getDiagram().getMainView().getTopviewsList().size() > 0) {
                this.cbType.setEnabled(false);
            }
            String string = "";
            this.transformationTask = this.process.getTransformationTask();
            if (this.transformationTask != null) {
                string = this.transformationTask.getTransformationPackage().getName() + "." + this.transformationTask.getName();
            }
            this.btnTransformationTask.setText(string);
            if ("".equalsIgnoreCase(string)) {
                this.btnTransformationTask.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.SetTransformationTask"));
            } else {
                this.btnTransformationTask.setToolTipText(string);
            }
            this.initParentDiagrams();
            this.cbParentDiagram.setSelectedItem(this.process.getDesignPart());
            this.updateType();
            this.initMode();
            this.initFreqPriority();
            this.initPeaks();
            this.isList.addAll(this.process.getInfoStructures());
            this.eList.addAll(this.process.getEvents());
            this.feList.addAll(this.process.getFlowEvents());
            this.ifList.addAll(this.process.getIncomingFlows());
            this.ofList.addAll(this.process.getOutgoingFlows());
            this.attrList.addAll(this.process.getProcessedAttributes(false));
            this.entList.addAll(this.process.getProcessedEntities(false));
            this.editorPane.setText(this.process.getFootNote());
            this.setUpSourcesColumn(this.inParamTable.getColumnModel().getColumn(1));
            this.makeWrapperList();
            this.initSourceTargetMapping();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.process.getPropertyNames();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = this.process.getProperty(string2);
                DynamicProperty dynamicProperty = new DynamicProperty(string2, string3);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        Object object2;
        this.process.setName(this.tfName.getText());
        this.process.setNotes(this.taNotes.getText());
        this.process.setComment(this.taComments.getText());
        this.process.setSynonym(this.tfSynonym.getText());
        this.process.setFilterCondition(this.tfFilterCondition.getText());
        this.process.setJoinCondition(this.tfJoinCondition.getText());
        this.process.setTransformationTask(this.transformationTask);
        if (this.cbType.isEnabled()) {
            this.process.setType(this.cbType.getSelectedIndex());
        }
        this.process.setFootNote(this.editorPane.getText());
        this.process.setFrequencyTimes(this.ifFreqTimes.getIntValue());
        this.process.setFrequencyTimeUnit(Process.FREQUENCY_TIME_UNITS[this.cbFreqTimeUnit.getSelectedIndex()]);
        this.process.setPriority(Process.PRIORITY[this.cbPriority.getSelectedIndex()]);
        int n = this.cbMode.getSelectedIndex();
        this.process.setMode(Process.MODES[n]);
        if (this.process.getType() != 1) {
            this.setSourceTargetInfo();
        }
        switch (n) {
            case 1: {
                this.process.setBatchMinimumTransactions(this.ifMinTransactions.getIntValue());
                this.process.setBatchTimeUnit(Process.BATCH_TIME_UNITS[this.cbTimeUnit.getSelectedIndex()]);
                break;
            }
            case 2: {
                this.process.setInteractiveLongestResponseTime(this.ifResponseTime.getIntValue());
                this.process.setInteractiveResponseTimeUnit(Process.INTERACTIVE_RESPONSE_TIME_UNITS[this.cbResponseTimeUnit.getSelectedIndex()]);
            }
        }
        for (int i = 0; i < this.CHB_PEAKS.length; ++i) {
            this.process.getPeakPeriods()[i] = this.CHB_PEAKS[i].isSelected();
        }
        Iterator iterator = this.eList.iterator();
        this.process.clearEvents(this.process);
        while (iterator.hasNext()) {
            object2 = (Event)iterator.next();
            this.process.addEvent((Event)object2);
            ((Event)object2).addProcess(this.process);
        }
        if (this.process.getType() == 0) {
            this.setSourceTargetInfo();
        }
        this.updateType();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.process.getParamsWrappers().clear();
        this.process.getParamsWrappers().addAll(this.paramsWrappers);
        ProcessPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.process.clearProperties();
        for (Object object2 : this.dynamicPropertiesList) {
            this.process.setProperty(((DynamicProperty)object2).getName(), ((DynamicProperty)object2).getValue());
        }
        object2 = (DataFlowDesign)this.cbParentDiagram.getSelectedItem();
        if (object2 != null && object2 != this.process.getDesignPart()) {
            TopView topView = this.process.getDesignPart().getMainView().getViewFor(this.process);
            Rectangle rectangle = null;
            if (topView != null && topView.getCellView() != null) {
                rectangle = topView.getCellView().getBounds().getBounds();
            }
            this.process.remove(true);
            this.process.getDesignPart().setDirty(true);
            ((DataFlowDesign)object2).getProcessSet().addProcess(this.process);
            this.process.setSegmentedStorageName(null);
            TopView topView2 = ((DataFlowDesign)object2).getMainView().getViewFor(this.process);
            if (topView2 != null) {
                topView2.getCellView().setNewBounds(rectangle);
            }
            ((DataFlowDesign)object2).setDirty(true);
            if (this.process.getDiagram() != null) {
                this.process.getDiagram().setDirty(true);
            }
        }
    }

    private void initParentDiagrams() {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.process.isComposite()) {
            hashMap.put(this.process.getDiagram().getObjectID(), this.process.getDiagram().getObjectID());
            object2 = this.process.getDiagram().getAllProcesses();
            object = object2.iterator();
            while (object.hasNext()) {
                Process process = (Process)object.next();
                if (!process.isComposite()) continue;
                hashMap.put(process.getDiagram().getObjectID(), process.getDiagram().getObjectID());
            }
        }
        object2 = this.process.getDesign().getProcessModel().getDataFlowDesigns().iterator();
        while (object2.hasNext()) {
            object = (DataFlowDesign)object2.next();
            if (hashMap.get(((ModelIDObject)object).getObjectID()) != null) continue;
            this.cbParentDiagram.addItem(object);
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getFootNotePanel());
        this.addToTree(defaultMutableTreeNode, this.getModePanel());
        this.addToTree(defaultMutableTreeNode, this.getFreqPriorityPanel());
        this.addToTree(defaultMutableTreeNode, this.getPeakPeriodsPanel());
        this.addToTree(defaultMutableTreeNode, this.getInfoStructuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getEventsPanel());
        this.addToTree(defaultMutableTreeNode, this.getIncomingFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getOutgoingFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEntityPanel());
        this.addToTree(defaultMutableTreeNode, this.getTaskInParamsMappingPanel());
        this.addToTree(defaultMutableTreeNode, this.getSourceTargetMappingPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "PROCESS_PROPERTIES_DIALOG";
    }

    private void initType() {
        if (this.getDesignObject() != null && this.getDesignObject() instanceof Process) {
            this.process = (Process)this.getDesignObject();
            JLabel jLabel = new JLabel(LB_TYPE);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.cbType = new JComboBox<String>(TYPES);
            this.cbType.setFont(this.cbType.getFont().deriveFont(0));
            this.cbType.setPreferredSize(this.getDefaultSize());
            this.addRowToGeneralPanel(this.createRow(jLabel, this.cbType));
            JLabel jLabel2 = new JLabel(Messages.getString("ProcessPropertiesDialogEx.UseTransformationTask"));
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.btnTransformationTask = new JButton();
            this.btnTransformationTask.setPreferredSize(this.getDefaultSize());
            this.btnTransformationTask.setHorizontalAlignment(0);
            this.btnTransformationTask.setEnabled(this.isEditable());
            this.btnTransformationTask.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectTransformationTaskDialog selectTransformationTaskDialog = new SelectTransformationTaskDialog(ProcessPropertiesDialogEx.this.getAppView(), ProcessPropertiesDialogEx.this.transformationTask, ProcessPropertiesDialogEx.this.process);
                    selectTransformationTaskDialog.setVisible(true);
                    if (ProcessPropertiesDialogEx.this.transformationTask != selectTransformationTaskDialog.getTransformationTask()) {
                        ProcessPropertiesDialogEx.this.transformationTask = selectTransformationTaskDialog.getTransformationTask();
                        ProcessPropertiesDialogEx.this.makeWrapperList();
                        ProcessPropertiesDialogEx.this.inputParamsModel.dataChanged();
                    }
                    String string = "";
                    if (ProcessPropertiesDialogEx.this.transformationTask != null) {
                        string = ProcessPropertiesDialogEx.this.transformationTask.getTransformationPackage().getName() + "." + ProcessPropertiesDialogEx.this.transformationTask.getName();
                    }
                    ProcessPropertiesDialogEx.this.btnTransformationTask.setText(string);
                    if ("".equalsIgnoreCase(string)) {
                        ProcessPropertiesDialogEx.this.btnTransformationTask.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.SetTransformationTask"));
                    } else {
                        ProcessPropertiesDialogEx.this.btnTransformationTask.setToolTipText(string);
                    }
                    if (ProcessPropertiesDialogEx.this.transformationTask != null) {
                        ProcessPropertiesDialogEx.this.cbType.setSelectedIndex(2);
                    } else {
                        ProcessPropertiesDialogEx.this.cbType.setSelectedIndex(0);
                    }
                }
            });
            this.addRowToGeneralPanel(this.createRow(jLabel2, this.btnTransformationTask));
        }
    }

    private void makeWrapperList() {
        ArrayList arrayList = this.process.getTransformationTask() == this.transformationTask ? this.process.getParamsWrappers() : new ArrayList();
        this.paramsWrappers.clear();
        if (this.transformationTask != null) {
            for (ParameterObject parameterObject : this.transformationTask.getInputParameters()) {
                Process.ParamWrapper paramWrapper = this.findWrapper(arrayList, parameterObject);
                if (paramWrapper == null) {
                    Process process = this.process;
                    process.getClass();
                    this.paramsWrappers.add(process.new Process.ParamWrapper(parameterObject));
                    continue;
                }
                if (paramWrapper.getMappedObject() != null) {
                    // empty if block
                }
                this.paramsWrappers.add(paramWrapper);
            }
        }
    }

    private Process.ParamWrapper findWrapper(List list, ParameterObject parameterObject) {
        for (Process.ParamWrapper paramWrapper : list) {
            if (paramWrapper.getParam() != parameterObject) continue;
            return paramWrapper;
        }
        return null;
    }

    private void updateType() {
        if (this.process.getType() == 0 || this.process.getType() == 1) {
            this.btnTransformationTask.setEnabled(false);
        }
    }

    private JPanel getModePanel() {
        if (this.pnMode == null) {
            this.pnMode = this.createPage(Messages.getString("ProcessPropertiesDialogEx.Mode"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.InteractiveBatch")));
            JLabel jLabel = new JLabel(LB_MODE);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.cbMode = new JComboBox<String>(Process.MODES_DISPLAY);
            this.cbMode.setFont(this.cbMode.getFont().deriveFont(0));
            this.cbMode.setPreferredSize(this.getDefaultSize());
            this.cbMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.cbMode.getSelectedIndex();
                    switch (n) {
                        case 0: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, false);
                            break;
                        }
                        case 1: {
                            ProcessPropertiesDialogEx.this.SetModeControls(true, false);
                            break;
                        }
                        case 2: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, true);
                            break;
                        }
                        case 3: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, false);
                            break;
                        }
                        default: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, false);
                        }
                    }
                }
            });
            jPanel2.add((Component)this.createRow(jLabel, this.cbMode), "North");
            JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
            jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.MinimumAcceptableThroughput")));
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel2 = new JLabel(LB_MIN_TRANSACT);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.ifMinTransactions = new JIntegerField();
            this.ifMinTransactions.setPreferredSize(this.getDefaultSize());
            jPanel5.add(this.createRow(jLabel2, this.ifMinTransactions));
            JLabel jLabel3 = new JLabel(LB_TIME_UNIT);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbTimeUnit = new JComboBox<String>(Process.BATCH_TIME_UNITS_DISPLAY);
            this.cbTimeUnit.setFont(this.cbTimeUnit.getFont().deriveFont(0));
            this.cbTimeUnit.setPreferredSize(this.getDefaultSize());
            jPanel5.add(this.createRow(jLabel3, this.cbTimeUnit));
            jPanel4.add((Component)jPanel5, "North");
            JPanel jPanel6 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel7 = new JPanel(new BorderLayout(10, 10));
            jPanel7.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.LongestAcceptableResponseTime")));
            JPanel jPanel8 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel4 = new JLabel(LB_LONGEST_TIME);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.ifResponseTime = new JIntegerField();
            this.ifResponseTime.setPreferredSize(this.getDefaultSize());
            jPanel8.add(this.createRow(jLabel4, this.ifResponseTime));
            JLabel jLabel5 = new JLabel(LB_RESPONSE_TIME_UNIT);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbResponseTimeUnit = new JComboBox<String>(Process.INTERACTIVE_RESPONSE_TIME_UNITS_DISPLAY);
            this.cbResponseTimeUnit.setFont(this.cbResponseTimeUnit.getFont().deriveFont(0));
            this.cbResponseTimeUnit.setPreferredSize(this.getDefaultSize());
            jPanel8.add(this.createRow(jLabel5, this.cbResponseTimeUnit));
            jPanel7.add((Component)jPanel8, "North");
            jPanel6.add((Component)jPanel7, "North");
            jPanel3.add((Component)jPanel4, "North");
            jPanel3.add((Component)jPanel6, "Center");
            jPanel2.add(jPanel3);
            jPanel.add((Component)jPanel2, "Center");
            this.pnMode.add(jPanel);
        }
        return this.pnMode;
    }

    private void SetModeControls(boolean bl, boolean bl2) {
        this.ifMinTransactions.setEnabled(bl);
        this.cbTimeUnit.setEnabled(bl);
        this.ifResponseTime.setEnabled(bl2);
        this.cbResponseTimeUnit.setEnabled(bl2);
    }

    private void initMode() {
        this.ifMinTransactions.setValue((long)this.process.getBatchMinimumTransactions());
        this.cbTimeUnit.setSelectedItem(this.translate(this.process.getBatchTimeUnit(), Process.BATCH_TIME_UNITS, Process.BATCH_TIME_UNITS_DISPLAY));
        this.ifResponseTime.setValue((long)this.process.getInteractiveLongestResponseTime());
        this.cbResponseTimeUnit.setSelectedItem(this.translate(this.process.getInteractiveResponseTimeUnit(), Process.INTERACTIVE_RESPONSE_TIME_UNITS, Process.INTERACTIVE_RESPONSE_TIME_UNITS_DISPLAY));
        this.cbMode.setSelectedItem(this.translate(this.process.getMode(), Process.MODES, Process.MODES_DISPLAY));
    }

    private JPanel getFreqPriorityPanel() {
        if (this.pnFreqPriority == null) {
            this.pnFreqPriority = this.createPage(Messages.getString("ProcessPropertiesDialogEx.FrequencyPriority"));
            JPanel jPanel = new JPanel(new BorderLayout(0, 20));
            JPanel jPanel2 = new JPanel(new BorderLayout(20, 20));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.ExpectedFrequency")));
            JLabel jLabel = new JLabel(LB_FREQ_TIMES);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.ifFreqTimes = new JIntegerField();
            this.ifFreqTimes.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel, this.ifFreqTimes));
            JLabel jLabel2 = new JLabel(LB_FREQ_TIME_UNIT);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.cbFreqTimeUnit = new JComboBox<String>(Process.FREQUENCY_TIME_UNITS_DISPLAY);
            this.cbFreqTimeUnit.setFont(this.cbFreqTimeUnit.getFont().deriveFont(0));
            this.cbFreqTimeUnit.setPreferredSize(this.getDefaultSize());
            this.cbFreqTimeUnit.setMaximumRowCount(Process.FREQUENCY_TIME_UNITS_DISPLAY.length);
            jPanel3.add(this.createRow(jLabel2, this.cbFreqTimeUnit));
            jPanel2.add((Component)jPanel3, "North");
            JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel5 = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 10, 10));
            jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.Priority")));
            JLabel jLabel3 = new JLabel(LB_PRIORITY);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbPriority = new JComboBox<String>(Process.PRIORITY_DISPLAY);
            this.cbPriority.setFont(this.cbPriority.getFont().deriveFont(0));
            this.cbPriority.setPreferredSize(this.getDefaultSize());
            jPanel6.add(this.createRow(jLabel3, this.cbPriority));
            jPanel5.add((Component)jPanel6, "North");
            jPanel4.add((Component)jPanel5, "North");
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnFreqPriority.add((Component)jPanel, "Center");
        }
        return this.pnFreqPriority;
    }

    private void initFreqPriority() {
        this.ifFreqTimes.setValue((long)this.process.getFrequencyTimes());
        this.cbFreqTimeUnit.setSelectedItem(this.translate(this.process.getFrequencyTimeUnit(), Process.FREQUENCY_TIME_UNITS, Process.FREQUENCY_TIME_UNITS_DISPLAY));
        this.cbPriority.setSelectedItem(this.translate(this.process.getPriority(), Process.PRIORITY, Process.PRIORITY_DISPLAY));
    }

    private JPanel getPeakPeriodsPanel() {
        if (this.pnPeakPanel == null) {
            this.pnPeakPanel = this.createPage(Messages.getString("ProcessPropertiesDialogEx.PeakPeriods"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.rbNoPeaks = new JRadioButton(RB_NO_PEAKS);
            this.rbNoPeaks.setFont(this.rbNoPeaks.getFont().deriveFont(0));
            this.rbNoPeaks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < ProcessPropertiesDialogEx.this.CHB_PEAKS.length; ++i) {
                        ProcessPropertiesDialogEx.this.CHB_PEAKS[i].setSelected(false);
                    }
                }
            });
            jPanel.add((Component)this.rbNoPeaks, "North");
            this.pnCHB = new JPanel(new GridLayout(0, 3));
            this.pnCol1 = new JPanel(new GridLayout(0, 1));
            this.pnCol2 = new JPanel(new GridLayout(0, 1));
            this.pnCol3 = new JPanel(new GridLayout(0, 1));
            this.chbListener = new CheckboxListener();
            this.pnCHB.add(this.pnCol1);
            this.pnCHB.add(this.pnCol2);
            this.pnCHB.add(this.pnCol3);
            jPanel.add(this.pnCHB);
            this.pnPeakPanel.add(jPanel);
        }
        return this.pnPeakPanel;
    }

    private void setNoPeaks() {
        boolean bl = true;
        for (int i = 0; i < this.CHB_PEAKS.length; ++i) {
            if (!this.CHB_PEAKS[i].isSelected()) continue;
            bl = false;
            break;
        }
        this.rbNoPeaks.setSelected(bl);
    }

    private void initPeaks() {
        int n;
        for (n = 0; n < 8; ++n) {
            this.CHB_PEAKS[n].setFont(this.CHB_PEAKS[n].getFont().deriveFont(0));
            this.pnCol1.add(this.CHB_PEAKS[n]);
            this.CHB_PEAKS[n].addItemListener(this.chbListener);
            this.CHB_PEAKS[n].setSelected(this.process.getPeakPeriods()[n]);
        }
        for (n = 8; n < 16; ++n) {
            this.CHB_PEAKS[n].setFont(this.CHB_PEAKS[n].getFont().deriveFont(0));
            this.pnCol2.add(this.CHB_PEAKS[n]);
            this.CHB_PEAKS[n].addItemListener(this.chbListener);
            this.CHB_PEAKS[n].setSelected(this.process.getPeakPeriods()[n]);
        }
        for (n = 16; n < 24; ++n) {
            this.CHB_PEAKS[n].setFont(this.CHB_PEAKS[n].getFont().deriveFont(0));
            this.pnCol3.add(this.CHB_PEAKS[n]);
            this.CHB_PEAKS[n].addItemListener(this.chbListener);
            this.CHB_PEAKS[n].setSelected(this.process.getPeakPeriods()[n]);
        }
        this.setNoPeaks();
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructures == null) {
            this.pnInfoStructures = this.createPage(Messages.getString("ProcessPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.istable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.isList.size() > 0 && n < ProcessPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)ProcessPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.istable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.istable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.isList.size() > 0 && n < ProcessPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)ProcessPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnInfoStructures.add(jPanel2);
        }
        return this.pnInfoStructures;
    }

    private JPanel getEventsPanel() {
        if (this.pnEvents == null) {
            JComponent jComponent;
            JComponent jComponent2;
            this.pnEvents = this.createPage(Messages.getString("ProcessPropertiesDialogEx.Events"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.eList = new ArrayList();
            this.etable = new JTable(new EventModel());
            this.etable.setSelectionMode(0);
            this.etable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.etable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.eList.size() > 0 && n < ProcessPropertiesDialogEx.this.eList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.eList.get(n);
                        event.showModal = ((ProcessPropertiesDialogEx)ProcessPropertiesDialogEx.this).process.showModal || ProcessPropertiesDialogEx.this.process.showForFirstTime();
                        EventPropertiesDialogEx eventPropertiesDialogEx = new EventPropertiesDialogEx((Dialog)ProcessPropertiesDialogEx.this, ProcessPropertiesDialogEx.this.getAppView(), event);
                        eventPropertiesDialogEx.initProperties(event);
                        eventPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.etable);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.etable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.eList.size() > 0 && n < ProcessPropertiesDialogEx.this.eList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.eList.get(n);
                        event.showModal = ((ProcessPropertiesDialogEx)ProcessPropertiesDialogEx.this).process.showModal || ProcessPropertiesDialogEx.this.process.showForFirstTime();
                        EventPropertiesDialogEx eventPropertiesDialogEx = new EventPropertiesDialogEx((Dialog)ProcessPropertiesDialogEx.this, ProcessPropertiesDialogEx.this.getAppView(), event);
                        eventPropertiesDialogEx.initProperties(event);
                        eventPropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent2.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NewEventDialog newEventDialog = new NewEventDialog(ProcessPropertiesDialogEx.this.getAppView(), ProcessPropertiesDialogEx.this.process.getDesignPart(), ProcessPropertiesDialogEx.this.eList);
                        newEventDialog.setVisible(true);
                        ProcessPropertiesDialogEx.this.etable.updateUI();
                    }
                });
                jComponent = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_REMOVE);
                jComponent.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ProcessPropertiesDialogEx.this.etable.getSelectedRow();
                        if (n != -1 && ProcessPropertiesDialogEx.this.eList.size() > 0 && n < ProcessPropertiesDialogEx.this.eList.size()) {
                            ProcessPropertiesDialogEx.this.eList.remove(n);
                            ProcessPropertiesDialogEx.this.etable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent2);
                jToolBar.add(jComponent);
            }
            jPanel2.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 100));
            jComponent2 = new JPanel(new BorderLayout());
            jComponent2.add((Component)jPanel2, "North");
            jComponent2.add(jScrollPane);
            this.feList = new ArrayList();
            this.fetable = new JTable(new FlowEventModel());
            this.fetable.setSelectionMode(0);
            this.fetable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.fetable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.feList.size() > 0 && n < ProcessPropertiesDialogEx.this.feList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.feList.get(n);
                        event.showPropertyDialog();
                    }
                }
            });
            jComponent = new JScrollPane(this.fetable);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
            jPanel3.setPreferredSize(new Dimension(325, 30));
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton2.setToolTipText(BTN_PROPERTIES);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.fetable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.feList.size() > 0 && n < ProcessPropertiesDialogEx.this.feList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.feList.get(n);
                        event.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar2 = new JToolBar(0);
            jToolBar2.setFloatable(false);
            jToolBar2.add(jButton2);
            jToolBar2.addSeparator();
            jPanel3.add(jToolBar2);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.FlowEvents")));
            jPanel4.add((Component)jPanel3, "North");
            jPanel4.add(jComponent);
            jPanel.add((Component)jComponent2, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnEvents.add(jPanel);
        }
        return this.pnEvents;
    }

    private JPanel getIncomingFlowsPanel() {
        if (this.pnIncomingFlows == null) {
            this.pnIncomingFlows = this.createPage(Messages.getString("ProcessPropertiesDialogEx.IncomingFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new IncomingFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.iftable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.ifList.size() > 0 && n < ProcessPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.iftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.iftable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.ifList.size() > 0 && n < ProcessPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnIncomingFlows.add(jPanel2);
        }
        return this.pnIncomingFlows;
    }

    private JPanel getOutgoingFlowsPanel() {
        if (this.pnOutgoingFlows == null) {
            this.pnOutgoingFlows = this.createPage(Messages.getString("ProcessPropertiesDialogEx.OutgoingFlows"));
            this.ofList = new ArrayList();
            this.oftable = new JTable(new OutgoingFlowsModel());
            this.oftable.setSelectionMode(0);
            this.oftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.oftable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.ofList.size() > 0 && n < ProcessPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ofList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.oftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.oftable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.ofList.size() > 0 && n < ProcessPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ofList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnOutgoingFlows.add(jPanel2);
        }
        return this.pnOutgoingFlows;
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("ProcessPropertiesDialogEx.ProcessedAttributes"));
            this.attrList = new ArrayList();
            this.attrTable = new JTable(new AttributesModel());
            this.attrTable.setSelectionMode(0);
            TableColumn tableColumn = this.attrTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(200);
            this.attrTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.attrTable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.attrList.size() > 0 && n < ProcessPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.attrList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.attrTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.attrTable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.attrList.size() > 0 && n < ProcessPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.attrList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnAttributes.add(jPanel2);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("ProcessPropertiesDialogEx.ProcessedEntities"));
            this.entList = new ArrayList();
            this.entTable = new JTable(new EntityModel());
            this.entTable.setSelectionMode(0);
            TableColumn tableColumn = this.entTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(200);
            this.entTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.entTable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.entList.size() > 0 && n < ProcessPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.entList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.entTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.entTable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.entList.size() > 0 && n < ProcessPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.entList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnEntity.add(jPanel2);
        }
        return this.pnEntity;
    }

    private JPanel getFootNotePanel() {
        if (this.pnFootNote == null) {
            this.pnFootNote = this.createPage(Messages.getString("ProcessPropertiesDialogEx.Footnote"));
            JScrollPane jScrollPane = new JScrollPane(this.getEditorPane());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnFootNote.add(jPanel);
        }
        return this.pnFootNote;
    }

    protected JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(280, 140));
        }
        return this.editorPane;
    }

    private JPanel getTaskInParamsMappingPanel() {
        if (this.pnTaskInParamsMapping == null) {
            this.pnTaskInParamsMapping = this.createPage(Messages.getString("ProcessPropertiesDialogEx.TaskInputParamsMapping"));
            this.paramsWrappers = new ArrayList();
            this.inputParamsModel = new InputParamsModel();
            this.inParamTable = new JTable(this.inputParamsModel);
            this.inParamTable.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.inParamTable);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.pnTaskInParamsMapping.add(jPanel);
        }
        return this.pnTaskInParamsMapping;
    }

    private void setUpSourcesColumn(TableColumn tableColumn) {
        JComboBox jComboBox = new JComboBox();
        Iterator iterator = this.process.getSourceElements().iterator();
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.ClickForComboBox"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    private JPanel getSourceTargetMappingPanel() {
        if (this.pnSourceTargetMapping == null) {
            this.pnSourceTargetMapping = this.createPage(Messages.getString("ProcessPropertiesDialogEx.SourceTargetMapping"));
            this.sList = new ArrayList();
            JPanel jPanel = new JPanel(new BorderLayout());
            this.sTable = new JTable(new SourceElementsModel());
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ProcessPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && ProcessPropertiesDialogEx.this.sList.size() > 0 && n < ProcessPropertiesDialogEx.this.sList.size()) {
                        DesignObject designObject = (DesignObject)ProcessPropertiesDialogEx.this.sList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectSourceElementsDialog selectSourceElementsDialog = new SelectSourceElementsDialog(ProcessPropertiesDialogEx.this.getAppView(), ProcessPropertiesDialogEx.this.process, ProcessPropertiesDialogEx.this.sList);
                        selectSourceElementsDialog.setVisible(true);
                        ProcessPropertiesDialogEx.this.sTable.updateUI();
                        int n = ProcessPropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (n != -1 && !selectSourceElementsDialog.cancel && n != -1) {
                            TargetElement targetElement = (TargetElement)ProcessPropertiesDialogEx.this.targets.get(n);
                            targetElement.getSources().clear();
                            for (DesignObject designObject : ProcessPropertiesDialogEx.this.sList) {
                                targetElement.addSource(designObject);
                            }
                        }
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ProcessPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && ProcessPropertiesDialogEx.this.sList.size() > 0 && n < ProcessPropertiesDialogEx.this.sList.size()) {
                            ProcessPropertiesDialogEx.this.sList.remove(n);
                            ProcessPropertiesDialogEx.this.sTable.updateUI();
                            int n2 = ProcessPropertiesDialogEx.this.tbTarget.getSelectedRow();
                            if (n2 != -1) {
                                TargetElement targetElement = (TargetElement)ProcessPropertiesDialogEx.this.targets.get(n2);
                                targetElement.getSources().clear();
                                for (DesignObject designObject : ProcessPropertiesDialogEx.this.sList) {
                                    targetElement.addSource(designObject);
                                }
                            }
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
            }
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.Targets")));
            jPanel.add((Component)jPanel3, "North");
            this.tbTarget = new JTable(new TargetTableModel());
            this.tbTarget.setPreferredScrollableViewportSize(new Dimension(325, 120));
            SelectionListener selectionListener = new SelectionListener(this.tbTarget);
            this.tbTarget.getSelectionModel().addListSelectionListener(selectionListener);
            TableColumn tableColumn = null;
            block6: for (int i = 0; i < 3; ++i) {
                tableColumn = this.tbTarget.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        tableColumn.setPreferredWidth(100);
                        continue block6;
                    }
                    case 1: {
                        tableColumn.setPreferredWidth(50);
                        continue block6;
                    }
                    case 2: {
                        tableColumn.setPreferredWidth(75);
                        continue block6;
                    }
                    case 3: {
                        tableColumn.setPreferredWidth(100);
                    }
                }
            }
            this.cbTransformationTypes = new JComboBox<String>(Transformation.TRANSFORMATION_TYPES_DISPLAY);
            this.tbTarget.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.cbTransformationTypes));
            JScrollPane jScrollPane2 = new JScrollPane(this.tbTarget);
            jPanel3.add(jScrollPane2);
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ProcessPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.sList.size() > 0 && n < ProcessPropertiesDialogEx.this.sList.size()) {
                        DesignObject designObject = (DesignObject)ProcessPropertiesDialogEx.this.sList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            this.enableButtons(false);
            jPanel2.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 130));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.Sources")));
            jPanel4.add((Component)jPanel2, "North");
            jPanel4.add(jScrollPane);
            jPanel.add(jPanel4);
            this.pnSourceTargetMapping.add(jPanel);
        }
        return this.pnSourceTargetMapping;
    }

    private void enableButtons(boolean bl) {
        if (this.isEditable()) {
            this.btnProperties.setEnabled(bl);
            this.btnAdd.setEnabled(bl);
            this.btnRemove.setEnabled(bl);
        }
    }

    private void initSourceTargetMapping() {
        this.process.updateTargetElements();
        List list = this.process.getTargetElements();
        for (TargetElement targetElement : list) {
            TargetElement targetElement2 = new TargetElement(targetElement);
            this.targets.add(targetElement2);
        }
        for (TargetElement targetElement : this.targets) {
            ((DefaultTableModel)this.tbTarget.getModel()).addRow(new Object[]{targetElement.getTarget().getLongName(), targetElement.getTarget().getObjectTypeName(), this.translate(targetElement.getTransformationType(), Transformation.TRANSFORMATION_TYPES, Transformation.TRANSFORMATION_TYPES_DISPLAY), targetElement.getDescription()});
        }
    }

    private void updateSourceElements(TargetElement targetElement) {
        this.sList.clear();
        Iterator iterator = targetElement.getSources().iterator();
        while (iterator.hasNext()) {
            this.sList.add(iterator.next());
        }
        this.sTable.updateUI();
    }

    private void setSourceTargetInfo() {
        for (int i = 0; i < this.tbTarget.getRowCount(); ++i) {
            String string = (String)this.tbTarget.getModel().getValueAt(i, 2);
            String string2 = (String)this.tbTarget.getModel().getValueAt(i, 3);
            TargetElement targetElement = (TargetElement)this.targets.get(i);
            targetElement.setTransformationType(this.translate(string, Transformation.TRANSFORMATION_TYPES_DISPLAY, Transformation.TRANSFORMATION_TYPES));
            targetElement.setDescription(string2);
        }
        this.process.getTargetElements().clear();
        this.process.getTargetElements().addAll(this.targets);
    }

    @Override
    protected int getMinimumHeight() {
        return 460;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 180;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    class TargetTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("ProcessPropertiesDialogEx.TargetElement"), Messages.getString("ProcessPropertiesDialogEx.Type"), Messages.getString("ProcessPropertiesDialogEx.Transformation"), Messages.getString("ProcessPropertiesDialogEx.Description")};

        TargetTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!ProcessPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 > 1;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = this.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ((ListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
            if (n != -1) {
                TargetElement targetElement = (TargetElement)ProcessPropertiesDialogEx.this.targets.get(n);
                ProcessPropertiesDialogEx.this.updateSourceElements(targetElement);
                ProcessPropertiesDialogEx.this.enableButtons(true);
            } else {
                ProcessPropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    private class SourceElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.SourceElements");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)ProcessPropertiesDialogEx.this.sList.get(n);
            if (n2 == 0) {
                return designObject.getLongName();
            }
            if (n2 == 1) {
                return designObject.getObjectTypeName();
            }
            return new Integer(n * n2);
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.entList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Entity");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Create");
            }
            if (n == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Read");
            }
            if (n == 3) {
                return Messages.getString("ProcessPropertiesDialogEx.Update");
            }
            if (n == 4) {
                return Messages.getString("ProcessPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process.ProcessedObject processedObject = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.entList.get(n);
            if (n2 == 0) {
                return processedObject.getObject().getName();
            }
            if (n2 == 1) {
                return processedObject.isOpCreate();
            }
            if (n2 == 2) {
                return processedObject.isOpRead();
            }
            if (n2 == 3) {
                return processedObject.isOpUpdate();
            }
            if (n2 == 4) {
                return processedObject.isOpDelete();
            }
            return new Integer(n * n2);
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.attrList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Attribute");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Create");
            }
            if (n == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Read");
            }
            if (n == 3) {
                return Messages.getString("ProcessPropertiesDialogEx.Update");
            }
            if (n == 4) {
                return Messages.getString("ProcessPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process.ProcessedObject processedObject = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.attrList.get(n);
            if (n2 == 0) {
                return processedObject.getObject().getName();
            }
            if (n2 == 1) {
                return processedObject.isOpCreate();
            }
            if (n2 == 2) {
                return processedObject.isOpRead();
            }
            if (n2 == 3) {
                return processedObject.isOpUpdate();
            }
            if (n2 == 4) {
                return processedObject.isOpDelete();
            }
            return new Integer(n * n2);
        }
    }

    private class OutgoingFlowsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.ofList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.OutgoingFlows");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)ProcessPropertiesDialogEx.this.ofList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            return new Integer(n * n2);
        }
    }

    private class IncomingFlowsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.IncomingFlows");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)ProcessPropertiesDialogEx.this.ifList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            return new Integer(n * n2);
        }
    }

    private class FlowEventModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.feList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Event");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Flow");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Event event = (Event)ProcessPropertiesDialogEx.this.feList.get(n);
            if (n2 == 0) {
                return event.getName();
            }
            if (n2 == 1) {
                return event.getSynonym();
            }
            if (n2 == 2) {
                return event.getFlow().getName();
            }
            return new Integer(n * n2);
        }
    }

    private class EventModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Events");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Event event = (Event)ProcessPropertiesDialogEx.this.eList.get(n);
            if (n2 == 0) {
                return event.getName();
            }
            if (n2 == 1) {
                return event.getSynonym();
            }
            if (n2 == 2) {
                return event.getEventTypeName();
            }
            return new Integer(n * n2);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.InformationStructures");
            }
            if (n == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InfoStructure infoStructure = (InfoStructure)ProcessPropertiesDialogEx.this.isList.get(n);
            if (n2 == 0) {
                return infoStructure.getName();
            }
            if (n2 == 1) {
                return infoStructure.getSynonym();
            }
            return new Integer(n * n2);
        }
    }

    private class CheckboxListener
    implements ItemListener {
        private CheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ProcessPropertiesDialogEx.this.setNoPeaks();
        }
    }

    private class InputParamsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.paramsWrappers.size();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.TaskInputParameters");
            }
            return Messages.getString("ProcessPropertiesDialogEx.Sources");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!ProcessPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process.ParamWrapper paramWrapper = (Process.ParamWrapper)ProcessPropertiesDialogEx.this.paramsWrappers.get(n);
            if (n2 == 0) {
                return paramWrapper.getParam().getName();
            }
            return ((Process.ParamWrapper)ProcessPropertiesDialogEx.this.paramsWrappers.get(n)).getMappedObject();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                Process.ParamWrapper paramWrapper = (Process.ParamWrapper)ProcessPropertiesDialogEx.this.paramsWrappers.get(n);
                paramWrapper.setMappedObject((DesignObject)object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

