/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class InfoStructurePropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private InfoStructure structure;
    private List aList;
    private JTable aTable;
    private JPanel pnAttributes;
    private List eList;
    private JTable eTable;
    private JPanel pnEntity;
    private ArrayList ifList;
    private JPanel pnInformation;
    private JTable iftable;
    private JIntegerField ifVolume;
    private JIntegerField ifPercent;
    private JComboBox cbGrowthRateUnit;
    private JPanel pnVolumeInfo;

    public InfoStructurePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("InfoStructurePropertiesDialogEx.InformationStructureProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof InfoStructure) {
            this.structure = (InfoStructure)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.structure.getSynonym());
            this.aList.addAll(this.structure.getAttributes());
            this.updateEntityList();
            this.ifList.addAll(this.structure.getInfoFlows());
            this.ifVolume.setValue((long)this.structure.getVolume());
            this.ifPercent.setValue((long)this.structure.getGrowthRatePercent());
            this.cbGrowthRateUnit.setSelectedItem(this.translate(this.structure.getGrowthRateUnit(), InfoStructure.GROWTH_RATE_UNITS, InfoStructure.GROWTH_RATE_UNITS_DISPLAY));
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.structure.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.structure.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.structure.setName(this.tfName.getText());
        this.structure.setNotes(this.taNotes.getText());
        this.structure.setComment(this.taComments.getText());
        this.structure.setSynonym(this.tfSynonym.getText());
        this.structure.setVolume(this.ifVolume.getIntValue());
        this.structure.setGrowthRatePercent(this.ifPercent.getIntValue());
        this.structure.setGrowthRateUnit(this.translate((String)this.cbGrowthRateUnit.getSelectedItem(), InfoStructure.GROWTH_RATE_UNITS_DISPLAY, InfoStructure.GROWTH_RATE_UNITS));
        this.structure.getAttributes().clear();
        for (Object object : this.aList) {
            this.structure.addAttribute((Attribute)object);
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        InfoStructurePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.structure.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.structure.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEntityPanel());
        this.addToTree(defaultMutableTreeNode, this.getInformationFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getVolumeInfoPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INFORMATION_STRUCTURE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            JComponent jComponent;
            this.pnAttributes = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.Attributes"));
            this.aList = new ArrayList();
            this.aTable = new JTable(new AttributesModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = InfoStructurePropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && InfoStructurePropertiesDialogEx.this.aList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)InfoStructurePropertiesDialogEx.this.aList.get(n);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.aTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = InfoStructurePropertiesDialogEx.this.aTable.getSelectedRow();
                    if (n > -1 && InfoStructurePropertiesDialogEx.this.aList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)InfoStructurePropertiesDialogEx.this.aList.get(n);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectAttributesDialog selectAttributesDialog = new SelectAttributesDialog(InfoStructurePropertiesDialogEx.this.getAppView(), InfoStructurePropertiesDialogEx.this.aList);
                        selectAttributesDialog.show();
                        InfoStructurePropertiesDialogEx.this.aTable.updateUI();
                        InfoStructurePropertiesDialogEx.this.updateEntityList();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = InfoStructurePropertiesDialogEx.this.aTable.getSelectedRow();
                        if (n != -1 && InfoStructurePropertiesDialogEx.this.aList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.aList.size()) {
                            InfoStructurePropertiesDialogEx.this.aList.remove(n);
                            InfoStructurePropertiesDialogEx.this.aTable.updateUI();
                            InfoStructurePropertiesDialogEx.this.updateEntityList();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 165));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnAttributes.add(jComponent);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.Entities"));
            this.eList = new ArrayList();
            this.eTable = new JTable(new EntityModel());
            this.eTable.setSelectionMode(0);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = InfoStructurePropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && InfoStructurePropertiesDialogEx.this.eList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)InfoStructurePropertiesDialogEx.this.eList.get(n);
                        entity.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.eTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("InfoStructurePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = InfoStructurePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (n != -1 && InfoStructurePropertiesDialogEx.this.eList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)InfoStructurePropertiesDialogEx.this.eList.get(n);
                        entity.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 165));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnEntity.add(jPanel2);
        }
        return this.pnEntity;
    }

    private JPanel getInformationFlowsPanel() {
        if (this.pnInformation == null) {
            this.pnInformation = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.InformationFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new InformationFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = InfoStructurePropertiesDialogEx.this.iftable.getSelectedRow()) != -1 && InfoStructurePropertiesDialogEx.this.ifList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)InfoStructurePropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.iftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("InfoStructurePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = InfoStructurePropertiesDialogEx.this.iftable.getSelectedRow();
                    if (n != -1 && InfoStructurePropertiesDialogEx.this.ifList.size() > 0 && n < InfoStructurePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)InfoStructurePropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 165));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnInformation.add(jPanel2);
        }
        return this.pnInformation;
    }

    private JPanel getVolumeInfoPanel() {
        if (this.pnVolumeInfo == null) {
            this.pnVolumeInfo = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.VolumeInformation"));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            JLabel jLabel = new JLabel(LB_VOLUME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.ifVolume = new JIntegerField();
            this.ifVolume.setPreferredSize(this.getDefaultSize());
            this.ifVolume.setFont(this.ifVolume.getFont().deriveFont(0));
            jPanel.add((Component)this.createRow(jLabel, this.ifVolume), "North");
            JPanel jPanel2 = new JPanel(new BorderLayout(20, 20));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 20, 20));
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("InfoStructurePropertiesDialogEx.GrowthRate")));
            JLabel jLabel2 = new JLabel(LB_PERCENT);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.ifPercent = new JIntegerField();
            this.ifPercent.setPreferredSize(this.getDefaultSize());
            this.ifPercent.setFont(this.ifPercent.getFont().deriveFont(0));
            jPanel3.add(this.createRow(jLabel2, this.ifPercent));
            JLabel jLabel3 = new JLabel(LB_GROWTH_RATE_UNIT);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbGrowthRateUnit = new JComboBox<String>(InfoStructure.GROWTH_RATE_UNITS_DISPLAY);
            this.cbGrowthRateUnit.setFont(this.cbGrowthRateUnit.getFont().deriveFont(0));
            this.cbGrowthRateUnit.setPreferredSize(this.getDefaultSize());
            jPanel3.add(this.createRow(jLabel3, this.cbGrowthRateUnit));
            jPanel2.add((Component)jPanel3, "North");
            jPanel.add((Component)jPanel2, "Center");
            this.pnVolumeInfo.add(jPanel);
        }
        return this.pnVolumeInfo;
    }

    private void updateEntityList() {
        this.eList.clear();
        for (Attribute attribute : this.aList) {
            if (this.eList.contains(attribute.getContainer())) continue;
            this.eList.add(attribute.getContainer());
        }
        this.eTable.updateUI();
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class InformationFlowsModel
    extends AbstractTableModel {
        private InformationFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return InfoStructurePropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("InfoStructurePropertiesDialogEx.InformationFlow");
            }
            if (n == 1) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Diagram");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)InfoStructurePropertiesDialogEx.this.ifList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            if (n2 == 2) {
                return flow.getDesignPart().getName();
            }
            return new Integer(n * n2);
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        private EntityModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return InfoStructurePropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Entities");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Entity entity = (Entity)InfoStructurePropertiesDialogEx.this.eList.get(n);
            if (n2 == 0) {
                return entity.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        private AttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return InfoStructurePropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Attribute attribute = (Attribute)InfoStructurePropertiesDialogEx.this.aList.get(n);
            if (n2 == 0) {
                return attribute.getLongName();
            }
            return new Integer(n * n2);
        }
    }
}

