/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;

public class InOutParamsPropertiesDialogEx
extends AbstractPropertiesDialog {
    private InOutParams inOutParams;
    private JComboBox cbType;
    private List paramsList;
    private JPanel pnParameters;
    private JTable edTable;
    private String DEFAULT_NAME = Messages.getString("InOutParamsPropertiesDialogEx.Param");
    private int paramCounter = 0;

    public InOutParamsPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(Messages.getString("InOutParamsPropertiesDialogEx.Multiplicity"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(InOutParams.MULTIPLICITY_TYPES_DISPLAY);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.cbType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("InOutParamsPropertiesDialogEx.TaskParameters");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof InOutParams) {
            this.inOutParams = (InOutParams)designObject;
            this.tfName.setText(this.inOutParams.getName());
            this.tfName.setEnabled(false);
            this.taComments.setText(this.inOutParams.getComment());
            this.taNotes.setText(this.inOutParams.getNotes());
            this.cbType.setSelectedItem(this.translate(this.inOutParams.getParametersMultiplicity(), InOutParams.MULTIPLICITY_TYPES_INTERNAL, InOutParams.MULTIPLICITY_TYPES_DISPLAY));
            this.paramsList.addAll(this.inOutParams.getParams());
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.inOutParams.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.inOutParams.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private JPanel getParametersPanel() {
        if (this.pnParameters == null) {
            JComponent jComponent;
            this.pnParameters = this.createPage(Messages.getString("InOutParamsPropertiesDialogEx.Parameters"));
            this.paramsList = new ArrayList();
            this.edTable = new JTable(new ParametersModel());
            this.edTable.setSelectionMode(0);
            this.setUpLogicalTypeColumn(this.edTable.getColumnModel().getColumn(1));
            JScrollPane jScrollPane = new JScrollPane(this.edTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ParameterObject parameterObject = new ParameterObject(InOutParamsPropertiesDialogEx.this.inOutParams.getDesignPart());
                        parameterObject.setLogicalDatatype(InOutParamsPropertiesDialogEx.this.inOutParams.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        parameterObject.setName(InOutParamsPropertiesDialogEx.this.generateParamName());
                        InOutParamsPropertiesDialogEx.this.paramsList.add(parameterObject);
                        InOutParamsPropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                JButton jButton = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton.setToolTipText(BTN_REMOVE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = InOutParamsPropertiesDialogEx.this.edTable.getSelectedRow();
                        if (n != -1 && InOutParamsPropertiesDialogEx.this.paramsList.size() > 0 && n < InOutParamsPropertiesDialogEx.this.paramsList.size()) {
                            InOutParamsPropertiesDialogEx.this.paramsList.remove(n);
                            InOutParamsPropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                JToolBar jToolBar = new JToolBar(0);
                jToolBar.setFloatable(false);
                jToolBar.add(jComponent);
                jToolBar.add(jButton);
                jPanel.add(jToolBar);
            }
            jScrollPane.setPreferredSize(new Dimension(325, 200));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnParameters.add(jComponent);
        }
        return this.pnParameters;
    }

    @Override
    protected void setProperties() {
        int n = this.edTable.getEditingColumn();
        int n2 = this.edTable.getEditingRow();
        if (n2 >= 0 && n >= 0) {
            this.edTable.getCellEditor(n2, n).stopCellEditing();
        }
        this.inOutParams.setName(this.tfName.getText());
        this.inOutParams.setComment(this.taComments.getText());
        this.inOutParams.setNotes(this.taNotes.getText());
        this.inOutParams.getParams().clear();
        for (Object object : this.paramsList) {
            this.inOutParams.addParam((ParameterObject)object);
        }
        this.inOutParams.setParametersMultiplicity(this.translate((String)this.cbType.getSelectedItem(), InOutParams.MULTIPLICITY_TYPES_DISPLAY, InOutParams.MULTIPLICITY_TYPES_INTERNAL));
        InOutParamsPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.inOutParams.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.inOutParams.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
        this.inOutParams.getDesignPart().setDirty(true);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getParametersPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void setUpLogicalTypeColumn(TableColumn tableColumn) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(this.getDesignObject().getDesign().getLogicalDatatypeSet().toArray());
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(Messages.getString("InOutParamsPropertiesDialogEx.ClickForLogicalTypes"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    protected String generateParamName() {
        String string = this.inOutParams.getInOutType().equalsIgnoreCase("Input") ? MessageFormat.format(Messages.getString("InOutParamsPropertiesDialogEx.In"), this.DEFAULT_NAME) : MessageFormat.format(Messages.getString("InOutParamsPropertiesDialogEx.Out"), this.DEFAULT_NAME);
        int n = 0;
        int n2 = this.paramsList.size();
        if (n2 != 0) {
            n = this.paramCounter = n2 + 1;
        } else {
            ++this.paramCounter;
            n = this.paramCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.paramExists(string2)) {
            n = ++this.paramCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean paramExists(String string) {
        for (int i = 0; i < this.paramsList.size(); ++i) {
            DesignObject designObject = (DesignObject)this.paramsList.get(i);
            if (!string.equalsIgnoreCase(designObject.getName())) continue;
            return true;
        }
        return false;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ParametersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return InOutParamsPropertiesDialogEx.this.paramsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("InOutParamsPropertiesDialogEx.Parameter");
            }
            return Messages.getString("InOutParamsPropertiesDialogEx.LogicalType");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return InOutParamsPropertiesDialogEx.this.isEditable();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ParameterObject parameterObject = (ParameterObject)InOutParamsPropertiesDialogEx.this.paramsList.get(n);
            if (n2 == 0) {
                return parameterObject.getName();
            }
            return parameterObject.getLogicalDatatype();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ParameterObject parameterObject = (ParameterObject)InOutParamsPropertiesDialogEx.this.paramsList.get(n);
            if (n2 == 0) {
                parameterObject.setName((String)object);
            } else if (n2 == 1) {
                parameterObject.setLogicalDatatype((LogicalDatatype)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

